package com.ejianc.business.promaterial.electronicFence.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.electronicFence.bean.*;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigChangeService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigRecordService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service("electronicFenceConfigChange") 
public class ElectronicFenceConfigChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IElectronicFenceConfigService electronicFenceConfigService;
	@Autowired
	private IElectronicFenceConfigChangeService service;
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IElectronicFenceConfigRecordService electronicFenceConfigRecordService;

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ElectronicFenceConfigChangeEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(e, false);

		return CommonResponse.success("回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ElectronicFenceConfigChangeEntity e = service.selectById(billId);

		ElectronicFenceConfigEntity sourceConfig = electronicFenceConfigService.selectById(e.getSourceConfigId());

		//1、将变更前的电子围栏设置单生成记录
		ElectronicFenceConfigRecordEntity record = generateRecord(sourceConfig);

		//2、将变更后的电子围栏设置单信息更新到原电子围栏设置单中
		updateChangeInfo2SourceConfig(sourceConfig, e);

		//3、更新电子围栏设置单状态
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			e.setCommitDate(new Date());
			e.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			e.setCommitUserName(sessionManager.getUserContext().getUserName());
		}
		e.setEffectiveDate(new Date());

		//4、数据持久化
		electronicFenceConfigRecordService.saveOrUpdate(record, false);
		electronicFenceConfigService.saveOrUpdate(sourceConfig, false);
		service.saveOrUpdate(e, false);

		return CommonResponse.success("操作成功！");
	}

	private void updateChangeInfo2SourceConfig(ElectronicFenceConfigEntity sourceConfig, ElectronicFenceConfigChangeEntity e) {
		sourceConfig.setEnable(e.getEnable());
		//删除原有的子表数据
		sourceConfig.getDetailList().stream().forEach(item -> {
			item.setRowState("del");
		});
		sourceConfig.getDetailList().addAll(BeanMapper.mapList(e.getDetailList(), ElectronicFenceConfigDetailEntity.class));

		//设置变更状态
		sourceConfig.setChangeVersion(e.getChangeVersion());
		sourceConfig.setChangeId(null);
		sourceConfig.setChangeCode(null);
		sourceConfig.setChangeDate(null);
		sourceConfig.setChangeStatus(FenceConfigChangeStatusEnum.已变更.getCode());
	}

	private ElectronicFenceConfigRecordEntity generateRecord(ElectronicFenceConfigEntity sourceConfig) {
		ElectronicFenceConfigRecordEntity record = BeanMapper.map(sourceConfig, ElectronicFenceConfigRecordEntity.class);
		record.setSourceConfigId(record.getId());
		record.setId(IdWorker.getId());
		record.getDetailList().stream().forEach(detail -> {
			detail.setSourcePid(sourceConfig.getId());
			detail.setSourceSubId(detail.getId());
			detail.setId(detail.getId());
			detail.setPid(record.getId());
		});

		return record;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("操作失败，变更已生效！");
	}


}
