package com.ejianc.business.promaterial.order.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.order.bean.ConcreteOrderDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 混凝土-订单实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_concrete_order")
public class ConcreteOrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="commit_id")
    private Long commitId; // 提交人
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="link_id")
    private Long linkId; // 联系人
    @TableField(value="link_name")
    private String linkName; // 联系人名称
    @TableField(value="link_telephone")
    private String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    @TableField(value="order_create_date")
    private Date orderCreateDate; // 订单日期
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @TableField(value="order_expiry_date")
    private Date orderExpiryDate; // 到货日期
    @TableField(value="construction")
    private String construction; // 施工部位
    @TableField(value="order_note")
    private String orderNote; // 送货要求
    @TableField(value="order_address")
    private String orderAddress; // 送货地址
    @TableField(value="receive_state")
    private Integer receiveState; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    @TableField(value="receive_reason")
    private String receiveReason;
    @TableField(value="deliver_state")
    private Integer deliverState; // 发货状态（0-待发货，1-部分送货，2-已送货）
    @TableField(value="order_flag")
    private Integer orderFlag; // 关闭状态（0-正常，1-已关闭）
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;
    @TableField(value="automatic_weigh")
    private Integer automaticWeigh; //自动称重设置（0：自动称重，1非自动称重）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="concreteOrderDetailService",pidName = "orderId")//此处有pid="xxx"，默认值pid="pid"
    private List<ConcreteOrderDetailEntity> concreteOrderDetailList = new ArrayList<>(); // 混凝土-订单明细子实体
    @TableField(exist=false)
    @SubEntity(serviceName="concreteOrderAdmixtureService",pidName = "orderId")//此处有pid="xxx"，默认值pid="pid"
    private List<ConcreteOrderAdmixtureEntity> concreteOrderAdmixtureList = new ArrayList<>(); // 混凝土-验收外加剂子表

    public List<ConcreteOrderAdmixtureEntity> getConcreteOrderAdmixtureList() {
        return concreteOrderAdmixtureList;
    }

    public void setConcreteOrderAdmixtureList(List<ConcreteOrderAdmixtureEntity> concreteOrderAdmixtureList) {
        this.concreteOrderAdmixtureList = concreteOrderAdmixtureList;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getReceiveReason() {
        return receiveReason;
    }

    public void setReceiveReason(String receiveReason) {
        this.receiveReason = receiveReason;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    public Date getOrderCreateDate() {
        return orderCreateDate;
    }

    public void setOrderCreateDate(Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getOrderNote() {
        return orderNote;
    }

    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    public String getOrderAddress() {
        return orderAddress;
    }

    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    public Integer getDeliverState() {
        return deliverState;
    }

    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    public Integer getOrderFlag() {
        return orderFlag;
    }

    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    
    public List<ConcreteOrderDetailEntity> getConcreteOrderDetailList() {
        return concreteOrderDetailList;
    }

    public void setConcreteOrderDetailList(List<ConcreteOrderDetailEntity> concreteOrderDetailList) {
        this.concreteOrderDetailList = concreteOrderDetailList;
    }
}
