package com.ejianc.business.promaterial.order.service;

import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.vo.ConcreteOrderVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.business.promaterial.order.vo.SupConcreteOrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 混凝土-订单实体
 * 
 * @author generator
 * 
 */
public interface IConcreteOrderService extends IBaseService<ConcreteOrderEntity> {
    ConcreteOrderVO queryDetail(Long id);

    ConcreteOrderVO saveOrUpdates(ConcreteOrderVO saveOrUpdateVO);

    CommonResponse<String> updateOrderFlag(ConcreteOrderVO orderVO);

    CommonResponse<OrderVO> updateReceived(SupConcreteOrderVO orderVO);

    CommonResponse<OrderVO> updateDeliverState(SupConcreteOrderVO orderVO);

    /**
     * 单据推送到供方协同服务
     *
     * @param concreteOrderEntity 待推送单据
     * @param billTypeCode 待推送单据的单据类型编码
     * @return
     */
    boolean pushBillToSupCenter(ConcreteOrderEntity concreteOrderEntity, String billTypeCode);

    /**
     * 将推送至供方的单据作废
     *
     * @param concreteOrderEntity
     * @param billTypeCode
     * @return
     */
    CommonResponse<String> updatePushBill(ConcreteOrderEntity concreteOrderEntity, String billTypeCode,String url);
}
