package com.ejianc.business.promaterial.plan.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;

/**
 * 消耗材总计划变更
 *
 * @author generator
 */
@Controller
@RequestMapping("planChange")
@Api(value = "消耗材总计划变更", tags = {"消耗材总计划变更"})
public class MasterPlanChangeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IMasterPlanChangeService service;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailChangeService masterPlanDetailChangeService;
    @Autowired
    private IExecutionApi executionApi;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MasterPlanChangeVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody MasterPlanChangeVO planVo) {
        return service.saveOrUpdateMasterPlan(planVo, false);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MasterPlanChangeVO> queryDetail(@RequestParam Long id) {
        MasterPlanChangeVO vo = null;
        /*MasterPlanChangeEntity dbEntity = service.selectById(id);
        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, MasterPlanChangeVO.class);
        }*/
        vo = service.queryDetail(id, true);
        return CommonResponse.success("查询物资总计划详情成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MasterPlanChangeVO> vos) {
        MasterPlanChangeEntity masterChangeEntity = service.selectById(vos.get(0).getId());
        if (CollectionUtils.isNotEmpty(vos)) {
            //目标成本推送
            //删除数据
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            List<MasterPlanEntity> masterPlanEntityList = new ArrayList<>();
            for (MasterPlanChangeVO masterPlanVO : vos) {
                MasterPlanChangeEntity masterPlanChangeEntity = service.selectById(masterPlanVO.getId());
                String billType;
                if (masterPlanChangeEntity.getPlanType() == 0) {
                    billType = BillTypeEnum.消耗材总计划变更.getCode();
                }
                else {
                    billType = BillTypeEnum.混凝土总计划变更.getCode();
                }
                ExecutionVO executionVO = masterPlanService.targetCost(BeanMapper.map(masterPlanChangeEntity, MasterPlanVO.class), "", billType, masterPlanChangeEntity.getPlanType());
                totalExecutionVOList.add(executionVO.getTotalVO());
                masterPlanEntityList.add(masterPlanService.selectById(masterPlanChangeEntity.getSourcePlanId()));

            }
            logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
//                return CommonResponse.error("目标成本推送失败," + response.getMsg());
            }
            //推送上一版数据
            for (MasterPlanEntity masterPlanEntity : masterPlanEntityList) {
                //目标成本推送
                ExecutionVO executionVO1;
                String linkUrl;
                String billType;
                List<MasterPlanChangeEntity> masterPlanChangeEntityList = service.list(new QueryWrapper<MasterPlanChangeEntity>().eq("source_plan_id", masterPlanEntity.getId()).eq("dr",0).orderByDesc("change_version"));
                String frontendBaseHost="";
                if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                    frontendBaseHost = BASE_HOST_FRONTEND;
                }else{
                    frontendBaseHost = baseHost;
                }

                if (masterPlanChangeEntityList.size() > 1) {
                    if (masterPlanEntity.getPlanType() == 0) {
                        linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + masterPlanEntity.getId();
                        billType = BillTypeEnum.消耗材总计划变更.getCode();
                    }
                    else {
                        linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + masterPlanEntity.getId();
                        billType = BillTypeEnum.混凝土总计划变更.getCode();
                    }
                    executionVO1 = masterPlanService.targetCost(BeanMapper.map(masterPlanChangeEntityList.get(1), MasterPlanVO.class), linkUrl, billType, masterPlanChangeEntityList.get(1).getPlanType());

                }
                else {
                    MasterPlanEntity masterPlan = masterPlanService.selectById(masterChangeEntity.getSourcePlanId());
                    if (masterPlan.getPlanType() == 0) {
                        linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + masterPlan.getId();
                        billType = BillTypeEnum.消耗材总计划.getCode();
                    }
                    else {
                        linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + masterPlan.getId();
                        billType = BillTypeEnum.混凝土总计划.getCode();
                    }
                    executionVO1 = masterPlanService.targetCost(BeanMapper.map(masterPlan, MasterPlanVO.class), linkUrl, billType, masterPlan.getPlanType());
                }
                logger.info("目标成本推送数据" + JSON.toJSONString(executionVO1));
                CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
                if (!response1.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
            service.deleteChangePlan(vos.stream().map(MasterPlanChangeVO::getId).collect(Collectors.toList()));
        }
        return CommonResponse.success("删除成功！");
    }
    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody MasterPlanChangeVO masterPlanVo) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(masterPlanVo));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }

}
