package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.plan.bean.ApplyDetailEntity;
import com.ejianc.business.promaterial.plan.bean.ApplyEntity;
import com.ejianc.business.promaterial.plan.service.IApplyService;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("apply") 
public class ApplyBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IApplyService applyService;

	@Autowired
	private IShareMaterialApi shareMaterialApi;

	private static final String BILL_TYPE = "BT202407000001";

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//推送生成材料档案
		ApplyEntity applyEntity = applyService.selectById(billId);
		List<ApplyDetailEntity> detailList = applyEntity.getDetailList();
		if (CollectionUtils.isNotEmpty(detailList)){
			MaterialInsertArchiveVO materialInsertArchiveVO = new MaterialInsertArchiveVO();
			materialInsertArchiveVO.setSourceBillId(applyEntity.getId());
			materialInsertArchiveVO.setSourceBillCode(applyEntity.getBillCode());
			materialInsertArchiveVO.setSourceBillType("材料新增");
			Map<String, MaterialVO> materialVOMap = new HashMap<>();
			for (ApplyDetailEntity detailEntity : detailList) {
				MaterialVO materialVO = new MaterialVO();
				materialVO.setId(detailEntity.getId());
				materialVO.setCategoryId(detailEntity.getCategoryId());
				materialVO.setCategoryCode(detailEntity.getCategoryCode());
				materialVO.setCategoryName(detailEntity.getCategoryName());
				materialVO.setName(detailEntity.getMaterialName());
				materialVO.setCode(detailEntity.getMaterialCode());
				materialVO.setSpec(detailEntity.getSpec());
				materialVO.setUnitName(detailEntity.getUnit());
				materialVO.setUnitId(detailEntity.getUnitId());
				materialVO.setQuality(detailEntity.getQuality());
				materialVO.setOperativeNorm(detailEntity.getStandard());
				materialVOMap.put(detailEntity.getId().toString(), materialVO);
			}
			materialInsertArchiveVO.setMaterialVOMap(materialVOMap);

			logger.info("推送材料档案数据：{}", JSONObject.toJSONString(materialInsertArchiveVO));
			CommonResponse<Map<String, MaterialVO>> mapCommonResponse = shareMaterialApi.batchInsertArchiveBySourceBill(materialInsertArchiveVO);
			if (!mapCommonResponse.isSuccess()){
				logger.info("生成材料档案失败，原因：{}", mapCommonResponse.getMsg());
				throw new BusinessException("生成材料档案失败，请稍后再试！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
