package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SuplementFlagEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanDetailMapper;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.plan.vo.*;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckCodeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.record.PageBreakRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材总计划
 *
 * @author generator
 *
 */
@Service("masterPlanService")
public class MasterPlanServiceImpl extends BaseServiceImpl<MasterPlanMapper, MasterPlanEntity> implements IMasterPlanService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MasterPlanMapper masterPlanMapper;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private SessionManager sessionManager;

//    private static final String BILL_CODE = "MASTER_PLAN";
    private static final String BILL_CODE_C = "MASTER_PLAN";//消耗材
    private static final String BILL_CODE_H = "HNTZJH";//混凝土


    @Override
    public MasterPlanVO queryByCode(String planCode,Integer planType) {
        MasterPlanVO resp = null;
        QueryWrapper<MasterPlanEntity> query = new QueryWrapper<>();
        query.eq("plan_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("plan_type", planType);
        MasterPlanEntity entity = masterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MasterPlanVO queryByProjectId(Long projectId,Integer planType) {
        MasterPlanVO resp = null;
        QueryWrapper<MasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("plan_type", planType);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MasterPlanEntity entity = masterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public CommonResponse<MasterPlanVO> saveOrUpdateMasterPlan(MasterPlanVO masterPlanVo, Boolean isControl) {
        if (!isControl){
            if(StringUtils.isNotBlank(masterPlanVo.getPlanCode())) {
                //编码重复校验
                MasterPlanVO voByCode = queryByCode(masterPlanVo.getPlanCode(),masterPlanVo.getPlanType());
                if(null != voByCode && (null == masterPlanVo.getId() || !voByCode.getId().equals(masterPlanVo.getId()))) {
                    return CommonResponse.error("保存失败，编码重复！");
                }
            } else {
                String BILL_CODE = "";
                switch (masterPlanVo.getPlanType()){
                    case 0:BILL_CODE = BILL_CODE_C;break;
                    case 1:BILL_CODE = BILL_CODE_H;break;
                }
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),masterPlanVo);
                CommonResponse<String> codeResp = billCodeApi.generateBillCode(billCodeParam);
                if(!codeResp.isSuccess()) {
                    return CommonResponse.error("保存失败，获取自动编码失败！");
                }
                masterPlanVo.setPlanCode(codeResp.getData());
            }
        }

        //校验项目是否已有总计划
        MasterPlanVO voByProject = queryByProjectId(masterPlanVo.getProjectId(),masterPlanVo.getPlanType());
        if(null != voByProject && (null == masterPlanVo.getId() || !voByProject.getId().equals(masterPlanVo.getId()))) {
            String msg = "";
            switch (masterPlanVo.getPlanType()){
                case 0:msg = "保存失败，该项目下已存在消耗材总计划，请勿重复添加！";break;
                case 1:msg = "保存失败，该项目下已存在混凝土总计划，请勿重复添加！";break;
            }
            throw new BusinessException(msg);
        }
        UserContext userContext = sessionManager.getUserContext();
        MasterPlanEntity saveEntity = null;
        if(null == masterPlanVo.getId()) {
            saveEntity = BeanMapper.map(masterPlanVo, MasterPlanEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = BeanMapper.map(masterPlanVo, MasterPlanEntity.class);
//            saveEntity = getById(masterPlanVo.getId());
//            saveEntity.setPlanDate(masterPlanVo.getPlanDate());
//            saveEntity.setProjectId(masterPlanVo.getProjectId());
//            saveEntity.setProjectName(masterPlanVo.getProjectName());
//            saveEntity.setRemark(masterPlanVo.getRemark());
//            saveEntity.setPlanCode(masterPlanVo.getPlanCode());
//            saveEntity.setTotalPlanAmt(masterPlanVo.getTotalPlanAmt());
//            saveEntity.setModifyUserName(userContext.getUserName());
//
//            saveEntity.setMasterPlanDetailList(BeanMapper.mapList(masterPlanVo.getMasterPlanDetailList(), MasterPlanDetailEntity.class));
        }

        if(null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if(!isControl){
            super.saveOrUpdate(saveEntity, false);
            List<MasterPlanDetailEntity> changeDetailEntities = saveEntity.getMasterPlanDetailList();
            if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
                Map<String, Long> idMap = new HashMap<>();
                for (MasterPlanDetailEntity cdEntity : changeDetailEntities) {
                    //变更类型
                    cdEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
                    idMap.put(cdEntity.getTid(), cdEntity.getId());
                }
                for (MasterPlanDetailEntity cdEntity : changeDetailEntities) {
                    if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
                List<Map> resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
                List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);

                List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
                List<MasterPlanDetailEntity> saveEntities = new ArrayList<>();
                treeToList(ListCodeDate, saveEntities);
                if (!isControl){
                    masterPlanDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
                }
            }
        }
        MasterPlanVO masterPlanVO = BeanMapper.map(saveEntity, MasterPlanVO.class);
//        if(!isControl){
//            //更新子表信息
//            if(null != saveEntity.getId()) {
//                masterPlanDetailMapper.delByPlanId(saveEntity.getId());
//            }
//            super.saveOrUpdate(saveEntity, false);
//        }else{
//            List<MasterPlanDetailEntity> detailEntityList = saveEntity.getMasterPlanDetailList();
//            List<MasterPlanDetailEntity> detailEntityListNew = new ArrayList<>();
//            if(CollectionUtils.isNotEmpty(detailEntityList)){
//                for(MasterPlanDetailEntity cdEntity : detailEntityList){
//                    if(null == cdEntity.getId()){
//                        cdEntity.setId(IdWorker.getId());
//                    }
//                    if (!"del".equals(cdEntity.getRowState())) {
//                        detailEntityListNew.add(cdEntity);
//                    }
//                }
//                saveEntity.setMasterPlanDetailList(detailEntityListNew);
//            }
//        }
//        List<MasterPlanDetailEntity> entities = new ArrayList<>();
//        List<MasterPlanDetailEntity> detailEntityList = saveEntity.getMasterPlanDetailList();
//        if(CollectionUtils.isNotEmpty(detailEntityList)){
//            Map<String,Long> idMap=new HashMap<>();
//            for(MasterPlanDetailEntity cdEntity : detailEntityList){
//                idMap.put(cdEntity.getTid(),cdEntity.getId());
//            }
//            for(MasterPlanDetailEntity cdEntity : detailEntityList){
//                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//                //变更类型
//                cdEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
//            }
//            // 生成结构码
//            List<Map> resultMapList = BeanMapper.mapList(detailEntityList, Map.class);
//            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
//            List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
//            treeToList(ListCodeDate, entities);
//        }
//        if(!isControl){
//            if(CollectionUtils.isNotEmpty(entities)){
//                masterPlanDetailService.saveOrUpdateBatch(entities, entities.size(), false);
//            }
//            masterPlanVO = queryDetail(saveEntity.getId(), true);
//        }else{
//            masterPlanVO = BeanMapper.map(saveEntity, MasterPlanVO.class);
//            if(CollectionUtils.isNotEmpty(entities)){
//                masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(entities, MasterPlanDetailVO.class));
//            }
//        }

        if(!isControl) {
            String linkUrl;
            String billType;
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = baseHost;
            }

            if (masterPlanVO.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + masterPlanVO.getId();
                billType = BillTypeEnum.消耗材总计划.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + masterPlanVO.getId();
                billType = BillTypeEnum.混凝土总计划.getCode();
            }
            //目标成本推送
            ExecutionVO executionVO = targetCost(masterPlanVO, linkUrl, billType, masterPlanVO.getPlanType());
            logger.info("目标成本推送数据" + JSONObject.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
//            return CommonResponse.error("目标成本推送失败,"+response.getMsg());
            }
            return CommonResponse.success("保存成功！", queryDetail(saveEntity.getId(),true));
        }
        return CommonResponse.success("保存成功！", masterPlanVO);
    }

    @Override
    public MasterPlanVO queryDetail(Long id, boolean detailHasChildren) {
        MasterPlanEntity masterPlanEntity = super.selectById(id);
        MasterPlanVO masterPlanVO =  BeanMapper.map(masterPlanEntity, MasterPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MasterPlanDetailEntity> detailEntityListDb = masterPlanDetailService.queryList(queryParam, false);
        List<MasterPlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MasterPlanDetailEntity cdEntity : detailEntityList){
                if(cdEntity.getMaterialId()==null){//如果是分类  tid = 分类id pid = null
                    cdEntity.setTid(cdEntity.getMaterialCategoryId().toString());
                    cdEntity.setTpid("999");
                }else {//如果是物资  tid = 物资id pid = 分类id
                    cdEntity.setTid(cdEntity.getMaterialId().toString());
                    cdEntity.setTpid(cdEntity.getMaterialCategoryId().toString());
                }
                cdEntity.setRowState("edit");
            }
            List<MasterPlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class);
            if(detailHasChildren){
                masterPlanVO.setMasterPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                masterPlanVO.setMasterPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class));
        }

        if(null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0){
            //masterPlanVO.setRecordList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
            masterPlanVO.setMasterPlanChangeHisList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;
    }

    @Override
    public List<MasterPlanContrastV0> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId) {
        return  masterPlanMapper.getContrastInfo(materialMasterPlanId,oldMaterialMasterPlanId);
    }

    @Override
    public ExecutionVO targetCost(MasterPlanVO masterPlanVO, String linkUrl, String billType, Integer planType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(masterPlanVO.getId());
        totalVO.setTenantId(masterPlanVO.getTenantId());
        totalVO.setBillCode(masterPlanVO.getPlanCode());
        if (planType==0){
            totalVO.setBussinessType(BussinessTypeEnum.材料总计划.getCode());
        }else {
            totalVO.setBussinessType(BussinessTypeEnum.混凝土总计划.getCode());
        }
        totalVO.setBillType(billType);
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(masterPlanVO.getProjectId());
        totalVO.setOrgId(masterPlanVO.getOrgId());
        totalVO.setMoney(masterPlanVO.getTotalPlanAmt());
        totalVO.setTaxMoney(masterPlanVO.getTotalPlanAmt());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(masterPlanVO.getBillDate()==null?null:masterPlanVO.getBillDate().toString());
        List<MasterPlanDetailVO> masterPlanDetailList = masterPlanVO.getMasterPlanDetailList();;
        if (!(billType.equals(BillTypeEnum.消耗材总计划.getCode()) || billType.equals(BillTypeEnum.混凝土总计划.getCode()))){
            totalVO.setLastSourceId(masterPlanVO.getSourcePlanId());
        }
        List<MasterPlanDetailVO> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)) {
            masterPlanDetailList.forEach(entity -> {
                if (null == entity.getChangeType() || 2 != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        for (MasterPlanDetailVO planDetailVO : detailEntityList) {
            if (planDetailVO.getRowState() != null && planDetailVO.getRowState().equals("del")){
                continue;
            }
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
            detailExecutionVO.setSourceBillId(masterPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialCategoryId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialCategoryName());
            //判断是否是分类
            if (planDetailVO.getMaterialId()==null){
                detailExecutionVO.setCategoryFlag(true);
                detailExecutionVO.setDocId(planDetailVO.getMaterialCategoryId());
            }else {
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(planDetailVO.getMaterialId());
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(false);
            //根据分类ID查询物料分类信息
            MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialCategoryId()).getData();
            if (categoryVO==null){
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            }else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setUnitId(planDetailVO.getUnitId());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getAmount());
            detailExecutionVO.setSpec(planDetailVO.getSpec());
            detailExecutionVO.setTaxMoney(planDetailVO.getAmount());
            detailExecutionVO.setPrice(planDetailVO.getPrice());
            detailExecutionVO.setTaxPrice(planDetailVO.getPrice());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            // 生成内码
            /*if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }*/

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<MasterPlanDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, MasterPlanDetailEntity.class));
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(MasterPlanVO masterPlanVO) {
        CommonResponse<MasterPlanVO> masterPlanVOCommonResponse = saveOrUpdateMasterPlan(masterPlanVO, true);
        MasterPlanVO planVO = masterPlanVOCommonResponse.getData();
        String linkUrl;
        String billType;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        if (masterPlanVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.消耗材总计划.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.混凝土总计划.getCode();
        }
        //目标成本推送
        ExecutionVO executionVO = targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        logger.info("目标成本控制推送数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
//        if(CollectionUtils.isEmpty(data.getDataSource())){
//            data.setWarnType("none");
//        }
        logger.info("目标成本控制返回信息："+JSONObject.toJSONString(response));
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(planVO, response.getData());
        return paramsCheckVO;
    }


    //单据参数控制
    public ParamsCheckVO checkParams(MasterPlanVO masterPlanVO, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        ParamsCheckVO priceParam = this.priceCheckParams(masterPlanVO);
        if(priceParam!=null){//价格库控制
            paramsCheckVOS.add(priceParam);
        }

        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    @Override
    public ParamsCheckVO priceCheckParams(MasterPlanVO masterPlanVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        //招标立项
        if(CollectionUtil.isNotEmpty(masterPlanVO.getMasterPlanDetailList())){
            for (MasterPlanDetailVO detailVO : masterPlanVO.getMasterPlanDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getPrice());
//                        priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                    priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                    priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(masterPlanVO.getOrgId());
        ParamsCheckVO paramsCheckVO = priceCheckParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialPriceHistoryApiVO> detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if(CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        String MAX_CODE = MaterialPriceCheckCodeEnum.材料总计划最高价.getCode();
        String MIN_CODE =MaterialPriceCheckCodeEnum.材料总计划最低价.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询高价比例
//        CommonResponse<BillParamVO> maxParamByCode = paramConfigApi.getBillParamByCode(MAX_CODE);
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史高价控制参数失败");
        }
        //查询高价比例
//        CommonResponse<BillParamVO> minParamByCode = paramConfigApi.getBillParamByCode(MIN_CODE);
        CommonResponse<List<BillParamVO>> minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE,orgId);
        if(!minParamByCode.isSuccess() && null == minParamByCode.getData()){
            logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史低价控制参数失败");
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("材料高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("材料低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.材料价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.材料价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("材料单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("材料单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if(price.compareTo(minPriceParam) < 0){
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("材料单价小于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("材料单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }


    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        MasterPlanVO planVO = queryDetail(id, true);
        String linkUrl;
        String billType;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        if (planVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.消耗材总计划.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.混凝土总计划.getCode();
        }
        //目标成本推送
        ExecutionVO executionVO = targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        logger.info("目标成本控制推送数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }
//同步成本
    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        MasterPlanVO planVO = queryDetail(id, true);
        String linkUrl;
        String billType;
        ExecutionVO executionVO;
        Boolean flag = true;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        QueryWrapper<MasterPlanChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_plan_id", id).eq("dr", 0).orderByDesc("change_version");
        List<MasterPlanChangeEntity> list = masterPlanChangeService.list(wrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size()>0 ) {//是否有变更
            flag =false;
            MasterPlanChangeEntity masterPlanChangeEntity = list.get(0);
            if (masterPlanChangeEntity.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + masterPlanChangeEntity.getId();
                billType = BillTypeEnum.消耗材总计划变更.getCode();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + masterPlanChangeEntity.getId();
                billType = BillTypeEnum.混凝土总计划变更.getCode();
            }
            executionVO = targetCost(BeanMapper.map(masterPlanChangeEntity, MasterPlanVO.class), linkUrl, billType, masterPlanChangeEntity.getPlanType());
        }else {
            flag =true;
            if (planVO.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
                billType = BillTypeEnum.消耗材总计划.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
                billType = BillTypeEnum.混凝土总计划.getCode();
            }
            //目标成本推送
            executionVO = targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        }
        logger.info("目标成本推送数据类型" + (flag ? "原计划" : "变更计划"));
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }
}
