package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.vo.PlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.PlanMapper;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.service.IPlanService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 消耗材-需用计划
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XYPLAN_CODE";//此处需要根据实际修改

    @Autowired
    private IPlanService service;

    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO saveOrUpdateVO) {
        PlanEntity entity = BeanMapper.map(saveOrUpdateVO, PlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<PlanDetailEntity> planDetailList = entity.getPlanDetailList();
        String materialName = "";
        if(CollectionUtils.isNotEmpty(planDetailList)){
            ArrayList<PlanDetailEntity> list = new ArrayList<>();
            for(PlanDetailEntity planDetail :planDetailList ){
                //物资名称集合
                if(!("del".equals(planDetail.getRowState()))){//删除的物资不拼接名称
                    if(StringUtils.isNotBlank(planDetail.getMaterialName())){
                        if(StringUtils.isNotBlank(materialName)){
                            materialName = materialName+","+planDetail.getMaterialName();
                        }else {
                            materialName = planDetail.getMaterialName();
                        }
                    }
                    list.add(planDetail);
                }
                    BigDecimal nums = planDetail.getNums() == null ? BigDecimal.ZERO : planDetail.getNums();
                    BigDecimal occupyNums = planDetail.getOccupyNums() == null ? BigDecimal.ZERO : planDetail.getOccupyNums();
                    BigDecimal surplusNums = nums.subtract(occupyNums);
                    planDetail.setSurplusNums(surplusNums);//剩余
                    planDetail.setOccupyNums(occupyNums);//占用
                    planDetail.setNums(nums);//需用
            }
            Integer planFlag = entity.getPlanFlag()==null?1:entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("最少有一条计划明细！");
            }
        }else{
            throw new BusinessException("最少有一条计划明细！");
        }
        super.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId,queryWrapper);
        return planVOList;
    }


}
