package com.ejianc.business.promaterial.doc.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 废旧物资档案
 * 
 * @author generator
 * 
 */
public interface IWasteItemService extends IBaseService<WasteItemEntity> {

    /**
     * 根据分类ID查询其下物料
     *
     * @param categoryId
     * @return
     */
    List<WasteItemVO> queryListByCategoryId(Long categoryId);


    /**
     * 根据分类ID更改其下物料成本科目
     *
     * @param categoryId
     * @return
     */
    CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName);

    CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode);


    void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId);

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    WasteItemVO queryDetail(Long id);


    /**
     * 查询详情list
     *
     * @param ids
     * @return
     */
    List<WasteItemVO> queryItem(List<Long> ids);


    /**
     * 修改
     *
     * @param uniqueBean
     */
    void update(WasteItemVO uniqueBean);

    /**
     * 绑定科目
     * @param subjectId
     * @param subjectName
     * @param ids
     */
    void updateSubject(Long subjectId,String subjectName,List<Long> ids);

    /**
     * 批量修改
     *
     * @param
     */
    void amend(Long id,Long property,String propertyName);

    /**
     * 保存
     *
     * @param materialVo
     */
    void save(WasteItemVO materialVo);

    /**
     * 批量保存
     *
     * @param materialVo
     */
    void insertBatch(List<WasteItemVO> materialVo);

    /**
     * 删除
     *
     * @param ids
     */
    void delete(List<Long> ids);

    /**
     * 查询翻页
     *
     * @param queryParam
     * @return
     */
    IPage<WasteItemEntity> queryPage(QueryParam queryParam);

    /**
     * 查询是否已经存在
     *
     * @param name
     * @param spec
     * @param unitName
     * @return
     */
    WasteItemVO queryExitFlag(String name, String spec, String unitName, Long categoryId);

    /**
     * 根据code查询物料
     *
     * @param code
     * @return
     */
    WasteItemVO queryByCode(String code);

    /**
     * 查询列表
     *
     * @param queryParam
     * @return
     */
    List<WasteItemEntity> queryList(QueryParam queryParam);

    /**
     * 从平台中拷贝
     */
    void insertMaterialListFromPlatform();

    /**
     * 查询材料参照
     *
     * @param params
     * @return
     */
    IPage<WasteItemVO> queryRefMaterialPage(Map<String, Object> params);

    /**
     * 根据sourceId查询物资详情
     *
     * @param sourceId
     * @return
     */
    WasteItemEntity queryBySourceId(String sourceId);

    /**
     * 根据ids查询物资列表（包括物资来源id，物资分类来源id）
     *
     * @param ids
     * @return
     */
    List<WasteItemEntity> queryMaterialByIds(List<Long> ids);

    IPage<WasteItemEntity> queryZjwjRefMaterialPage(Map<String, Object> params);

    /**
     * 根据物料名称，规格型号，单位，分类名称查询是否存在
     * @param name
     * @param spec
     * @param unitName
     * @param categoryName
     * @return
     */
    List<WasteItemVO> queryExcelFlag(String name, String spec, String unitName, String categoryName);

//    /**
//     * 保存或修改物料和设备分类
//     *
//     * @param categoryParam
//     * @return
//     */
//    YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquipCategory(YnsbjMaterialAndEquipCategoryParam categoryParam);
//
//    /**
//     * 保存或修改物料和设备
//     *
//     * @param ynsbjMaterialAndEquipParam
//     * @return
//     */
//    YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquip(YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam);

    List<WasteItemVO> queryMaterialListByCodes(List<String> codeList);

    /**
     * 批量插入档案
     *
     * @param materialVOMap 材料设备VO
     *
     * @param sourceBillId
     * @param sourceBillCode
     * @param sourceBillType
     * @return {@link CommonResponse}<{@link Map}<{@link String}, {@link WasteItemVO}>>
     *
     */
    CommonResponse<Map<String, WasteItemVO>> batchInsertArchive(Map<String, WasteItemVO> materialVOMap, Long sourceBillId, String sourceBillCode, String sourceBillType);

    void allowIn(List<Long> ids);

    void batchUpdateArchiveSourceInfo(List<Long> materialIds, Long sourceBillId, String sourceBillCode);

    List<Map<String, Object>> queryUnit(Set<String> unitNameList);
}
