/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.doc.service.impl;

import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import com.ejianc.business.promaterial.doc.mapper.WasteCategoryMapper;
import com.ejianc.business.promaterial.doc.service.IWasteCategoryService;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wasteCategoryService")
public class WasteCategoryServiceImpl
implements IWasteCategoryService {
    @Autowired
    private WasteCategoryMapper materialCategoryMapper;
    @Autowired
    private IWasteItemService materialService;

    @Override
    public List<WasteCategoryEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<WasteCategoryEntity> resultList = this.materialCategoryMapper.queryList(condition);
        return resultList;
    }

    @Override
    public WasteCategoryVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WasteCategoryEntity entity = this.materialCategoryMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (WasteCategoryVO)BeanMapper.map((Object)((Object)entity), WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public void update(WasteCategoryEntity entity) {
        this.materialCategoryMapper.update(entity);
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(entity.getId());
        List<WasteCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.materialService.updateByCategoryId(item.getId(), entity.getSubjectId(), entity.getSubjectName());
        });
        this.materialCategoryMapper.updateSubject(tenantId, entity.getSubjectId(), entity.getSubjectName(), ids);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.materialService.updateByCategoryId(item.getId(), subjectId, subjectName);
        });
        this.materialCategoryMapper.updateSubject(tenantId, subjectId, subjectName, ids);
    }

    @Override
    public void save(WasteCategoryEntity entity) {
        this.materialCategoryMapper.insert(entity);
    }

    @Override
    public void insertBatch(List<WasteCategoryEntity> categoryEntityList) {
        if (ListUtil.isNotEmpty(categoryEntityList)) {
            ArrayList<WasteCategoryEntity> toInsert = new ArrayList<WasteCategoryEntity>();
            for (WasteCategoryEntity entity : categoryEntityList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(entity);
            }
            if (toInsert.size() > 0) {
                this.materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public List<WasteCategoryVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByPid(tenantId, id);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryVO> queryListAllByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListAllByPid(tenantId, id);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialCategoryMapper.delete(tenantId, id);
    }

    @Override
    public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
        this.materialCategoryMapper.updateEnabled(enabled, tenantId, innerCode);
    }

    @Override
    public List<WasteCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialCategoryMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<WasteCategoryEntity> queryByName(String name) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialCategoryMapper.queryByName(tenantId, name);
    }

    @Override
    public void insertCategoryListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
    }

    @Override
    public List<WasteCategoryVO> queryListTree(Map<String, Object> params) {
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryEntity> queryListEntityTree(Map<String, Object> params) {
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        return materialCategoryList;
    }

    @Override
    @Transactional
    public void changeCategoryEnableState(Long id, Integer enabled) {
        WasteCategoryEntity entity = this.materialCategoryMapper.queryDetail(InvocationInfoProxy.getTenantid(), id);
        if (entity == null) {
            throw new BusinessException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("innerCode", entity.getInnerCode());
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        List<WasteCategoryEntity> categoryEntities = this.materialCategoryMapper.queryListByInnerCode(params);
        List<Long> categoryIds = categoryEntities.stream().map(WasteCategoryEntity::getId).collect(Collectors.toList());
        this.materialCategoryMapper.updateEnabled(enabled, InvocationInfoProxy.getTenantid(), entity.getInnerCode());
        this.materialService.updateStateByCategoryId(categoryIds, enabled, InvocationInfoProxy.getTenantid());
    }

    @Override
    public WasteCategoryVO queryBySourceId(String sourceId) {
        WasteCategoryEntity entity = this.materialCategoryMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
        if (entity != null && entity.getId() != null) {
            return (WasteCategoryVO)BeanMapper.map((Object)((Object)entity), WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryVO> queryListByInnerCode(Map<String, Object> params) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByInnerCode(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryVO> queryCategoryListByChildren(List<Long> ids) {
        ArrayList<WasteCategoryVO> result = new ArrayList<WasteCategoryVO>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            HashSet<Long> keySet = new HashSet<Long>();
            List materialCategoryVOS = BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(WasteCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (Long id : ids) {
                String[] keyArray;
                WasteCategoryVO categoryVO = (WasteCategoryVO)categoryVOMap.get(id);
                String innerCode = categoryVO.getInnerCode();
                for (String keyStr : keyArray = innerCode.split("\\|")) {
                    Long key = Long.valueOf(keyStr);
                    if (keySet.contains(key)) continue;
                    keySet.add(key);
                    result.add((WasteCategoryVO)categoryVOMap.get(key));
                }
            }
        }
        return result;
    }

    @Override
    public Map<Long, List<WasteCategoryVO>> queryCategoryListByMaterialId(List<Long> ids) {
        List<WasteItemEntity> materialEntityList = this.materialService.queryMaterialByIds(ids);
        HashMap<Long, List<WasteCategoryVO>> resMap = new HashMap<Long, List<WasteCategoryVO>>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListTree(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            List materialCategoryVOS = BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
            Map categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(WasteCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (WasteItemEntity mentity : materialEntityList) {
                Long categoryId = mentity.getCategoryId();
                WasteCategoryVO categoryVO = (WasteCategoryVO)categoryVOMap.get(categoryId);
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                ArrayList result = new ArrayList();
                for (int i = keyArray.length - 1; i >= 0; --i) {
                    Long key = Long.valueOf(keyArray[i]);
                    result.add(categoryVOMap.get(key));
                }
                resMap.put(mentity.getId(), result);
            }
        }
        return resMap;
    }

    @Override
    public List<WasteCategoryVO> queryCategoryListByIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<WasteCategoryEntity> materialCategoryList = this.materialCategoryMapper.queryListByIds(params);
        if (materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialCategoryMapper.delete(tenantId, id);
        }
    }
}

