package com.ejianc.business.promaterial.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.delivery.bean.*;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryAdmixtureService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.*;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderAdmixtureEntity;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderAdmixtureService;
import com.ejianc.business.promaterial.order.service.IConcreteOrderDetailService;
import com.ejianc.business.promaterial.order.service.IConcreteOrderService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.weigh.weighbill.api.IPushThirdDataApi;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.delivery.mapper.ConcreteDeliveryMapper;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 混凝土-发货主表
 * 
 * @author generator
 * 
 */
@Service("concreteDeliveryService")
public class ConcreteDeliveryServiceImpl extends BaseServiceImpl<ConcreteDeliveryMapper, ConcreteDeliveryEntity> implements IConcreteDeliveryService{
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IPushThirdDataApi pushThirdDataApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IConcreteOrderService orderService;
    @Autowired
    private IConcreteOrderDetailService concreteOrderDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IConcreteOrderAdmixtureService concreteOrderAdmixtureService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private static final String BILL_CODE = "HNT-DELIVERY-CODE";//此处需要根据实际修改
    private final String OPERATE = "HNT_DELIVERY_SYNC";
    private static final String BILL_TYPE_CODE = "BT220224000000003";//此处需要根据实际修改
    @Autowired
    private IConcreteDeliveryAdmixtureService concreteDeliveryAdmixtureService;


    @Override
    public ConcreteCheckVO queryDetailToCheck(Long id) {
        ConcreteDeliveryEntity deliveryEntity = super.selectById(id);
        //处理组合验收数据返回
        ConcreteCheckVO checkVO = new ConcreteCheckVO();
        checkVO.setOrderId(deliveryEntity.getOrderId());
        checkVO.setDeliveryId(deliveryEntity.getId());
        checkVO.setCheckState(0);
        checkVO.setContractId(deliveryEntity.getContractId());
        checkVO.setContractName(deliveryEntity.getContractName());
        checkVO.setContractCode(deliveryEntity.getContractCode());
        checkVO.setProjectCode(deliveryEntity.getProjectCode());
        checkVO.setProjectId(deliveryEntity.getProjectId());
        checkVO.setProjectName(deliveryEntity.getProjectName());
        checkVO.setSupplierId(deliveryEntity.getSupplierId());
        checkVO.setSupplierName(deliveryEntity.getSupplierName());
        checkVO.setDepartmentId(deliveryEntity.getDepartmentId());
        checkVO.setDepartmentName(deliveryEntity.getDepartmentName());
        checkVO.setLicensePlate(deliveryEntity.getLicensePlate());
        checkVO.setOrgId(deliveryEntity.getOrgId());
        checkVO.setOrgName(deliveryEntity.getOrgName());
        checkVO.setCheckType(deliveryEntity.getCheckType());
        checkVO.setCheckTypeName(deliveryEntity.getCheckTypeName());
        checkVO.setSourceType(1);
        checkVO.setParentOrgId(deliveryEntity.getParentOrgId());
        checkVO.setParentOrgName(deliveryEntity.getParentOrgName());
        checkVO.setDeliveryCode(deliveryEntity.getBillCode());
        ContractEntity contractEntity = contractService.selectById(deliveryEntity.getContractId());
        checkVO.setPricingType(contractEntity.getPricingType());
        checkVO.setAutomaticWeigh(deliveryEntity.getAutomaticWeigh());
        checkVO.setDeliveryType(deliveryEntity.getDeliveryType());
        //处理子表数据返回
        List<ConcreteDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getConcreteDeliveryDetailList();
        List<ConcreteDeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailList.stream().filter(s -> s.getDeliveryNum().compareTo(s.getCheckNum() == null ? BigDecimal.ZERO : s.getCheckNum()) == 1).collect(Collectors.toList());
        //合同明细
        Map<Long,ContractDetailEntity> contractDetailMap = contractEntity.getContractDetailList().stream().filter(t->null!=t.getMaterialId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        //合同分类
        Map<Long,ContractDetailEntity> contractDetailTypeMap = contractEntity.getContractDetailList().stream().filter(t->null==t.getMaterialId() && null!=t.getMaterialTypeId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        //查询外加剂
        Map<Long,List<ConcreteDeliveryAdmixtureEntity>> deliveryAdmixtureMap = new HashMap<>();
        Map<Long,List<ConcreteOrderAdmixtureEntity>> orderAdmixtureMap = new HashMap<>();
        if(DeliveryTypeEnum.自制送货单.getCode().equals(deliveryEntity.getDeliveryType())){//来源自制送货单（磅单申请），查询磅单申请外加剂
            LambdaQueryWrapper<ConcreteDeliveryAdmixtureEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ConcreteDeliveryAdmixtureEntity::getDeliveryId, deliveryEntity.getId());
            List<ConcreteDeliveryAdmixtureEntity> list = concreteDeliveryAdmixtureService.list(wrapper);
            deliveryAdmixtureMap = list.stream().filter(t->null!=t.getDeliveryDetailId()).collect(Collectors.groupingBy(ConcreteDeliveryAdmixtureEntity::getDeliveryDetailId));
        }else {//来源供方，查询订单外加剂
            LambdaQueryWrapper<ConcreteOrderAdmixtureEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ConcreteOrderAdmixtureEntity::getOrderId, deliveryEntity.getOrderId());
            List<ConcreteOrderAdmixtureEntity> list = concreteOrderAdmixtureService.list(wrapper);
            orderAdmixtureMap = list.stream().filter(t->null!=t.getDetailId()).collect(Collectors.groupingBy(ConcreteOrderAdmixtureEntity::getDetailId));
        }
        if (CollectionUtils.isNotEmpty(deliveryDetailEntityList)){
            List<Long> materialIDS = deliveryDetailEntityList.stream().map(ConcreteDeliveryDetailEntity::getMaterialId)
                    .distinct().collect(Collectors.toList());
            List<MaterialPriceHistoryApiVO> priceHistoryApiVOS = priceHistoryService.getMaterialPriceHistoryApiVOS(materialIDS);
            CommonResponse<List<MaterialVO>> commonResponse = shareMaterialApi.queryMaterialItemByIds(materialIDS);
            logger.info("混凝土验收id：{}，查询成本科目信息：{}", id, JSONObject.toJSONString(commonResponse));
            Map<Long, MaterialVO> materialVOMap = new HashMap<>();
            if (commonResponse.isSuccess()) {
                List<MaterialVO> materialVOList = commonResponse.getData();
                materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            }

            Map<Long, MaterialPriceHistoryApiVO> materialPriceMap = priceHistoryApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity()));
            ArrayList<ConcreteCheckDetailVO> checkDetailVOS = new ArrayList<>();
            for (ConcreteDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                ConcreteCheckDetailVO checkDetailVO = new ConcreteCheckDetailVO();
                checkDetailVO.setDeliveryId(deliveryEntity.getId());
                checkDetailVO.setDeliveryDetailId(deliveryDetailEntity.getId());
                checkDetailVO.setOrderId(deliveryEntity.getOrderId());
                checkDetailVO.setOrderDetailId(deliveryDetailEntity.getOrderDetailId());
                checkDetailVO.setMaterialId(deliveryDetailEntity.getMaterialId());
                checkDetailVO.setMaterialName(deliveryDetailEntity.getMaterialName());
                checkDetailVO.setMaterialTypeId(deliveryDetailEntity.getMaterialTypeId());
                checkDetailVO.setMaterialTypeName(deliveryDetailEntity.getMaterialTypeName());
                checkDetailVO.setMaterialCode(deliveryDetailEntity.getMaterialCode());
                checkDetailVO.setUnit(deliveryDetailEntity.getUnit());
                checkDetailVO.setUnitId(deliveryDetailEntity.getUnitId());
                checkDetailVO.setSpec(deliveryDetailEntity.getSpec());
                checkDetailVO.setDeliverNum(deliveryDetailEntity.getDeliveryNum());
                checkDetailVO.setAdmixtureId(deliveryDetailEntity.getAdmixtureId());
                checkDetailVO.setAdmixtureName(deliveryDetailEntity.getAdmixtureName());
                checkDetailVO.setDetailAutomaticWeigh(deliveryDetailEntity.getDetailAutomaticWeigh());
                checkDetailVO.setCheckNum(deliveryDetailEntity.getDeliveryNum().subtract(deliveryDetailEntity.getCheckNum() == null ? BigDecimal.ZERO : deliveryDetailEntity.getCheckNum()));
                checkDetailVO.setSourceId(deliveryDetailEntity.getSourceDetailId());

                if (deliveryDetailEntity.getMaterialId() !=null && materialPriceMap.containsKey(deliveryDetailEntity.getMaterialId())){
                    checkDetailVO.setHistoryPriceArea(materialPriceMap.get(deliveryDetailEntity.getMaterialId()).getHistoryPriceArea());
                    checkDetailVO.setHistoryTaxPriceArea(materialPriceMap.get(deliveryDetailEntity.getMaterialId()).getHistoryTaxPriceArea());
                }

                if (deliveryDetailEntity.getMaterialId() !=null && materialVOMap.containsKey(checkDetailVO.getMaterialId())) {
                    MaterialVO materialVO = materialVOMap.get(checkDetailVO.getMaterialId());
                    checkDetailVO.setSubjectId(materialVO.getSubjectId());
                    checkDetailVO.setSubjectName(materialVO.getSubjectName());
                }

                BigDecimal admixturePrice = BigDecimal.ZERO;//外加剂价格
                BigDecimal taxPrice =  BigDecimal.ZERO;//含税单价
                BigDecimal price =  BigDecimal.ZERO;//无税单价
//                if(DeliveryTypeEnum.自制送货单.getCode().equals(deliveryEntity.getDeliveryType())){
                    ContractDetailEntity contractDetailEntity = contractDetailMap.get(checkDetailVO.getMaterialId());
                    ContractDetailEntity contractDetailTypeEntity = contractDetailTypeMap.get(checkDetailVO.getMaterialTypeId());
                    if(null!=contractDetailEntity){//是否属于明细
                        //算外加剂价格
                        List<ConcreteDeliveryAdmixtureEntity> concreteDeliveryAdmixtureEntities = deliveryAdmixtureMap.get(checkDetailVO.getDeliveryDetailId());
                        if(CollectionUtils.isNotEmpty(concreteDeliveryAdmixtureEntities)){
                            admixturePrice =  concreteDeliveryAdmixtureEntities.stream().filter(e -> e.getPrice() != null).map(ConcreteDeliveryAdmixtureEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        //用含税算无税
                        BigDecimal rate = ComputeUtil.safeDiv(ComputeUtil.safeAdd(new BigDecimal("100"), contractDetailEntity.getDetailTaxRate()), new BigDecimal("100"));
                        taxPrice = ComputeUtil.safeAdd(contractDetailEntity.getDetailTaxPrice(), admixturePrice);
                        price = ComputeUtil.safeDiv(taxPrice, rate);

                        checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                        checkDetailVO.setCheckPrice(price);
                        checkDetailVO.setCheckTaxPrice(taxPrice);
                        checkDetailVO.setMemo(contractDetailEntity.getMemo());
                        checkDetailVO.setContractFlag(1);
                    }else if(null!=contractDetailTypeEntity){//是否属于属于分类
                        //算外加剂价格
                        List<ConcreteDeliveryAdmixtureEntity> concreteDeliveryAdmixtureEntities = deliveryAdmixtureMap.get(checkDetailVO.getDeliveryDetailId());
                        if(CollectionUtils.isNotEmpty(concreteDeliveryAdmixtureEntities)){
                            admixturePrice =  concreteDeliveryAdmixtureEntities.stream().filter(e -> e.getPrice() != null).map(ConcreteDeliveryAdmixtureEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        //用含税算无税
                        BigDecimal rate = ComputeUtil.safeDiv(ComputeUtil.safeAdd(new BigDecimal("100"), contractDetailTypeEntity.getDetailTaxRate()), new BigDecimal("100"));
                        taxPrice = ComputeUtil.safeAdd(contractDetailTypeEntity.getDetailTaxPrice(), admixturePrice);
                        price = ComputeUtil.safeDiv(taxPrice, rate);

                        checkDetailVO.setTaxRate(contractDetailTypeEntity.getDetailTaxRate());
                        checkDetailVO.setCheckPrice(price);
                        checkDetailVO.setCheckTaxPrice(taxPrice);
                        checkDetailVO.setMemo(contractDetailTypeEntity.getMemo());
                        checkDetailVO.setContractFlag(1);
                    }else {
                        checkDetailVO.setContractFlag(2);
                    }
//                }else {
//                    ConcreteOrderDetailEntity concreteOrderDetailEntity = concreteOrderDetailService.selectById(deliveryDetailEntity.getOrderDetailId());
//                    ContractDetailEntity contractDetailEntity = contractDetailService.selectById(concreteOrderDetailEntity.getSourceDetailId());
//                    if (contractDetailEntity != null){
//                        //算外加剂价格
//                        List<ConcreteOrderAdmixtureEntity> concreteOrderAdmixtureEntities = orderAdmixtureMap.get(checkDetailVO.getOrderDetailId());
//                        if(CollectionUtils.isNotEmpty(concreteOrderAdmixtureEntities)){
//                            admixturePrice =  concreteOrderAdmixtureEntities.stream().filter(e -> e.getPrice() != null).map(ConcreteOrderAdmixtureEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
//                        }
//                        //用含税算无税
//                        BigDecimal rate = ComputeUtil.safeDiv(ComputeUtil.safeAdd(new BigDecimal("100"), contractDetailEntity.getDetailTaxRate()), new BigDecimal("100"));
//                        taxPrice = ComputeUtil.safeAdd(contractDetailEntity.getDetailTaxPrice(), admixturePrice);
//                        price = ComputeUtil.safeDiv(taxPrice, rate);
//
//                        checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
//                        checkDetailVO.setCheckPrice(price);
//                        checkDetailVO.setCheckTaxPrice(taxPrice);
//                        checkDetailVO.setMemo(contractDetailEntity.getMemo());
//                        checkDetailVO.setContractFlag(1);
//                    }else {
//                        checkDetailVO.setContractFlag(2);
//                    }
//                }
                checkDetailVOS.add(checkDetailVO);
            }
            checkVO.setConcreteCheckDetailList(checkDetailVOS);
        }
        return checkVO;
    }

    @Override
    public ConcreteDeliveryVO closeDelivery(Long id) {
        ConcreteDeliveryEntity concreteDeliveryEntity = super.selectById(id);
        concreteDeliveryEntity.setCloseFlag(1);
        super.updateById(concreteDeliveryEntity);
        if(DeliveryTypeEnum.自制送货单.getCode().equals(concreteDeliveryEntity.getDeliveryType())){//自制发货单不推送供方
            return BeanMapper.map(concreteDeliveryEntity, ConcreteDeliveryVO.class);
        }
        //推送供方
        //对单据进行加锁
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("获取当前系统编码失败！");
        }
        Map<String,Object> map = new HashMap<>();
        map.put("sourceId",concreteDeliveryEntity.getSourceId());
        map.put("closeFlag",1);
        map.put("systemId",ejcCloudSystemCode.getData());
        String dataInfo = JSONObject.toJSONString(map);
        Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(concreteDeliveryEntity.getId(),dataInfo,PUSH_BILL_SERVER_URL,RequestMethod.POST,
                concreteDeliveryEntity.getSupplierId().toString(),OPERATE,BILL_TYPE_CODE);
        if (!updateSupplierStatus){
            throw new BusinessException("单据推送失败！");
        }

        return BeanMapper.map(concreteDeliveryEntity, ConcreteDeliveryVO.class);
    }

    @Override
    public ConcreteDeliveryVO saveOrUpdates(ConcreteDeliveryVO saveOrUpdateVO) {
        ConcreteDeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, ConcreteDeliveryEntity.class);
        List<ConcreteDeliveryDetailVO> materialDeliveryDetailList = saveOrUpdateVO.getConcreteDeliveryDetailList();
        List<ConcreteDeliveryDetailEntity> deliveryDetailEntityList = BeanMapper.mapList(materialDeliveryDetailList, ConcreteDeliveryDetailEntity.class);
        entity.setConcreteDeliveryDetailList(deliveryDetailEntityList);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setCloseFlag(0);
        entity.setSourceType(1);
        entity.setDeliveryType(2);//发货类型  供方推送
        super.saveOrUpdate(entity, false);
        /** 推送订单，运单-------------开始 */
        if(null!=entity.getAutomaticWeigh()&&0==entity.getAutomaticWeigh()) {
            //1,获取订单经办人 送货地址     获取合同甲方
            ContractEntity contractEntity = contractService.getById(entity.getContractId());
            ConcreteOrderEntity orderEntity = orderService.getById(entity.getOrderId());
            DeliveryThirdVO thirdVO = BeanMapper.map(entity, DeliveryThirdVO.class);
            thirdVO.setEmployeeName(orderEntity.getEmployeeName()==null?orderEntity.getCreateUserCode():orderEntity.getEmployeeName());
            thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("HNT");
            List<ConcreteDeliveryDetailEntity> detailList = entity.getConcreteDeliveryDetailList();
            if(CollectionUtils.isNotEmpty(detailList)){
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            logger.info("混凝土推送第三方数据参数----：{}", JSONObject.toJSONString(thirdVO));
            CommonResponse<String>  thirdRes = pushThirdDataApi.pushThirdData(thirdVO);
            if(!thirdRes.isSuccess()){
                logger.info("混凝土推送第三方数据----返回异常信息：{}", JSONObject.toJSONString(thirdRes.getMsg()));
                entity.setIsPushThird("unSucPush");
                entity.setUnSucReason(thirdRes.getMsg());
            }else{
                logger.info("混凝土推送第三方数据----返回信息：{}", JSONObject.toJSONString(thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            }
            super.updateById(entity);
        }
        /** 推送订单，运单-------------结束 */
        ConcreteDeliveryVO vo = BeanMapper.map(entity, ConcreteDeliveryVO.class);
        return vo;
    }

    @Override
    public ConcreteDeliveryVO savePushThirdData(Long id) {
        ConcreteDeliveryEntity entity = super.selectById(id);
        /** 推送订单，运单-------------开始 */
        if(null!=entity.getAutomaticWeigh()&&0==entity.getAutomaticWeigh()) {
            //1,获取订单经办人 送货地址     获取合同甲方
            ContractEntity contractEntity = contractService.getById(entity.getContractId());
            DeliveryThirdVO thirdVO = BeanMapper.map(entity, DeliveryThirdVO.class);
            if(DeliveryTypeEnum.自制送货单.getCode().equals(entity.getDeliveryType())){
                thirdVO.setOrderAddress("/");
            }else {
                ConcreteOrderEntity orderEntity = orderService.getById(entity.getOrderId());
                thirdVO.setEmployeeName(orderEntity.getEmployeeName()==null?orderEntity.getCreateUserCode():orderEntity.getEmployeeName());
                thirdVO.setOrderAddress(orderEntity.getOrderAddress());
            }
            thirdVO.setCustomerId(contractEntity.getCustomerId());
            thirdVO.setCustomerName(contractEntity.getCustomerName());
            thirdVO.setDeliverType("HNT");
            List<ConcreteDeliveryDetailEntity> detailList = entity.getConcreteDeliveryDetailList();
            if(CollectionUtils.isNotEmpty(detailList)){
                thirdVO.setDetailList(BeanMapper.mapList(detailList, DeliveryDetailThirdVO.class));
            }
            logger.info("混凝土推送第三方数据参数----：{}", JSONObject.toJSONString(thirdVO));
            CommonResponse<String>  thirdRes = pushThirdDataApi.pushThirdData(thirdVO);
            if(thirdRes.isSuccess()){
                logger.info("混凝土推送第三方数据----返回信息：{}", JSONObject.toJSONString(thirdRes.getMsg()));
                entity.setIsPushThird("sucPushed");
            }else{
                entity.setUnSucReason(thirdRes.getMsg());
            }
            super.updateById(entity);
        }
        /** 推送订单，运单-------------结束 */
        ConcreteDeliveryVO vo = BeanMapper.map(entity, ConcreteDeliveryVO.class);
        return vo;
    }

    @Override
    public ConcreteDeliverySaveVO saveOrUpdate(ConcreteDeliverySaveVO saveOrUpdateVO) {
        if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            saveOrUpdateVO.setId(IdWorker.getId());
        }
        List<ConcreteDeliveryDetailVO> concreteDeliveryDetailList = saveOrUpdateVO.getConcreteDeliveryDetailList();
        List<ConcreteDeliveryAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteDeliveryAdmixtureEntity>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(concreteDeliveryDetailList)){
            for (ConcreteDeliveryDetailVO concreteDeliveryDetailVO : concreteDeliveryDetailList){
                if (concreteDeliveryDetailVO.getId() == null){
                    long id = IdWorker.getId();
                    concreteDeliveryDetailVO.setId(id);
                }
                List<ConcreteDeliveryAdmixtureVO> admixtureVOList = concreteDeliveryDetailVO.getAdmixtureVOList();
                if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(admixtureVOList)){
                    for (ConcreteDeliveryAdmixtureVO concreteDeliveryAdmixtureVO : admixtureVOList){
                        concreteDeliveryAdmixtureVO.setDeliveryDetailId(concreteDeliveryDetailVO.getId());
                        ConcreteDeliveryAdmixtureEntity concreteDeliveryAdmixtureEntity = BeanMapper.map(concreteDeliveryAdmixtureVO, ConcreteDeliveryAdmixtureEntity.class);
                        concreteDeliveryAdmixtureEntity.setId(null);
                        concreteDeliveryAdmixtureEntity.setDeliveryId(saveOrUpdateVO.getId());
                        admixtureArrayList.add(concreteDeliveryAdmixtureEntity);
                    }
                }
            }
        }
        //
        List<Long> ids = concreteDeliveryDetailList.stream().map(ConcreteDeliveryDetailVO::getId).collect(Collectors.toList());
        saveOrUpdateVO.setConcreteDeliveryAdmixtureList(null);
        //先删后增外加剂
        if(CollectionUtils.isNotEmpty(ids)){
            LambdaQueryWrapper<ConcreteDeliveryAdmixtureEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(ConcreteDeliveryAdmixtureEntity::getDeliveryDetailId, ids);
            concreteDeliveryAdmixtureService.remove(wrapper, false);
        }
        if(CollectionUtils.isNotEmpty(admixtureArrayList)){
            concreteDeliveryAdmixtureService.saveBatch(admixtureArrayList);
        }
        ConcreteDeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, ConcreteDeliveryEntity.class);
        super.saveOrUpdate(entity, false);
        ConcreteDeliverySaveVO vo = BeanMapper.map(entity, ConcreteDeliverySaveVO.class);
        return queryDetail(vo.getId());
    }

    @Override
    public ConcreteDeliverySaveVO queryDetail(Long id) {
        ConcreteDeliveryEntity entity = super.selectById(id);
        ConcreteDeliverySaveVO vo = BeanMapper.map(entity, ConcreteDeliverySaveVO.class);
        //处理供应商子表信息
        List<ConcreteDeliveryDetailVO> concreteDeliveryDetailList = vo.getConcreteDeliveryDetailList();
        List<ConcreteDeliveryAdmixtureVO> concreteDeliveryAdmixtureList = vo.getConcreteDeliveryAdmixtureList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(concreteDeliveryAdmixtureList)){
            Map<Long, List<ConcreteDeliveryAdmixtureVO>> bidderMap = concreteDeliveryAdmixtureList.stream().
                    collect(Collectors.groupingBy(ConcreteDeliveryAdmixtureVO::getDeliveryDetailId));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(concreteDeliveryDetailList)){
                for (ConcreteDeliveryDetailVO concreteDeliveryDetailVO : concreteDeliveryDetailList){
                    List<ConcreteDeliveryAdmixtureVO> admixtureVOList = bidderMap.get(concreteDeliveryDetailVO.getId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(admixtureVOList)){
                        concreteDeliveryDetailVO.setAdmixtureVOList(admixtureVOList);
                    }
                }
            }
        }
        return vo;
    }


}
