package com.ejianc.business.promaterial.doc.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.doc.bean.WasteResultDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 废旧物资处置结果
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_waste_material_result")
public class WasteResultEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父组织编码
    @TableField(value="scrap_type")
    private Integer scrapType; // 废旧类型
    @TableField(value="other_reason")
    private String otherReason; // 其他原因
    @TableField(value="main_material_name")
    private String mainMaterialName; // 主要物资名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime; // 申请日期
    @TableField(value="disposal_type")
    private Integer disposalType; // 处置方式
    @TableField(value="disposal_number")
    private Integer disposalNumber; // 处置次数
    @TableField(value="is_need_assess")
    private Integer isNeedAssess; // 是否需要评估
    @TableField(value="disposal_platform")
    private Integer disposalPlatform; // 处置平台
    @TableField(value="pricing_type")
    private Integer pricingType; // 定价方式
    @TableField(value="min_limit_price")
    private BigDecimal minLimitPrice; // 处置最低限价
    @TableField(value="disposal_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disposalDate; // 处置日期
    @TableField(value="supervise_id")
    private String superviseId; // 监督人
    @TableField(value="supervise_name")
    private String superviseName; // 监督人
    @TableField(value="assess_mny")
    private BigDecimal assessMny; // 评估价
    @TableField(value="actual_mny")
    private BigDecimal actualMny; // 实际处置金额
    @TableField(value="deal_flats")
    private String dealFlats; // 成交单位
    @TableField(value="deal_flats_people")
    private String dealFlatsPeople; // 成交单位联系人
    @TableField(value="deal_flats_phone")
    private String dealFlatsPhone; // 联系方式
    @TableField(value="contract_flag")
    private Integer contractFlag; // 是否签订合同
    @TableField(value="invoice_flag")
    private Integer invoiceFlag; // 是否开具发票
    @TableField(value="invoice_number")
    private String invoiceNumber; // 发票号码
    @TableField(value="finance_number")
    private String financeNumber; // 财务收款凭证号
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="wasteResultDetailService")
    private List<WasteResultDetailEntity> wasteResultDetailList = new ArrayList<>(); // 废旧物资处置结果-详情
    @TableField(value="application_id")
    private Long applicationId; // 申请单
    @TableField(value="application_name")
    private String applicationName; // 申请单

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getScrapType() {
        return scrapType;
    }

    public void setScrapType(Integer scrapType) {
        this.scrapType = scrapType;
    }
    public String getOtherReason() {
        return otherReason;
    }

    public void setOtherReason(String otherReason) {
        this.otherReason = otherReason;
    }
    public String getMainMaterialName() {
        return mainMaterialName;
    }

    public void setMainMaterialName(String mainMaterialName) {
        this.mainMaterialName = mainMaterialName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public Integer getDisposalType() {
        return disposalType;
    }

    public void setDisposalType(Integer disposalType) {
        this.disposalType = disposalType;
    }
    public Integer getDisposalNumber() {
        return disposalNumber;
    }

    public void setDisposalNumber(Integer disposalNumber) {
        this.disposalNumber = disposalNumber;
    }
    public Integer getIsNeedAssess() {
        return isNeedAssess;
    }

    public void setIsNeedAssess(Integer isNeedAssess) {
        this.isNeedAssess = isNeedAssess;
    }
    public Integer getDisposalPlatform() {
        return disposalPlatform;
    }

    public void setDisposalPlatform(Integer disposalPlatform) {
        this.disposalPlatform = disposalPlatform;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public BigDecimal getMinLimitPrice() {
        return minLimitPrice;
    }

    public void setMinLimitPrice(BigDecimal minLimitPrice) {
        this.minLimitPrice = minLimitPrice;
    }
    public Date getDisposalDate() {
        return disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }
    public String getSuperviseId() {
        return superviseId;
    }

    public void setSuperviseId(String superviseId) {
        this.superviseId = superviseId;
    }
    public String getSuperviseName() {
        return superviseName;
    }

    public void setSuperviseName(String superviseName) {
        this.superviseName = superviseName;
    }
    public BigDecimal getAssessMny() {
        return assessMny;
    }

    public void setAssessMny(BigDecimal assessMny) {
        this.assessMny = assessMny;
    }
    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }
    public String getDealFlats() {
        return dealFlats;
    }

    public void setDealFlats(String dealFlats) {
        this.dealFlats = dealFlats;
    }
    public String getDealFlatsPeople() {
        return dealFlatsPeople;
    }

    public void setDealFlatsPeople(String dealFlatsPeople) {
        this.dealFlatsPeople = dealFlatsPeople;
    }
    public String getDealFlatsPhone() {
        return dealFlatsPhone;
    }

    public void setDealFlatsPhone(String dealFlatsPhone) {
        this.dealFlatsPhone = dealFlatsPhone;
    }
    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }
    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getFinanceNumber() {
        return financeNumber;
    }

    public void setFinanceNumber(String financeNumber) {
        this.financeNumber = financeNumber;
    }
    

    public List<WasteResultDetailEntity> getWasteResultDetailList() {
        return wasteResultDetailList;
    }

    public void setWasteResultDetailList(List<WasteResultDetailEntity> wasteResultDetailList) {
        this.wasteResultDetailList = wasteResultDetailList;
    }
}
