package com.ejianc.business.promaterial.doc.controller;

import java.io.Serializable;

import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import com.ejianc.business.promaterial.doc.vo.WasteMaterialCategoryImportVO;
import com.ejianc.business.promaterial.utils.WasteMaterialCategoryAsTree;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SyncMaterialCategoryParam;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.service.IWasteCategoryService;
import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 废旧物资档案分类
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("wasteCategory")
public class WasteCategoryController implements Serializable {

    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_CATEGORY_BILL_CODE = "WASTE_MATERIAL_CATEGORY";

    @Value("${oms.tenantid}")
    private String OMS_TENANT;

    @Autowired
    private IWasteCategoryService materialCategoryService;
    @Autowired
    private IWasteItemService materialService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;

    /**
     * 新增或修改
     *
     * @param materialCategoryVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody WasteCategoryVO materialCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();

        if(materialCategoryVo.getId() != null && materialCategoryVo.getId() > 0) {
            if(StringUtils.isNoneBlank(materialCategoryVo.getCode())){
                List<WasteCategoryEntity> codeData = materialCategoryService.queryByCode(materialCategoryVo.getCode());
                if(codeData!=null&&codeData.size()>0){
                    if(!materialCategoryVo.getId().equals(codeData.get(0).getId())){
                        throw new BusinessException("分类编码已存在,请重新填写");
                    }
                }
            }else{
                throw new BusinessException("分类编码不能为空");
            }
            WasteCategoryVO uniqueBean = materialCategoryService.queryDetail(materialCategoryVo.getId());
            //分类编码修改后同步档案中的冗余数据
            if(StringUtils.isNotBlank(materialCategoryVo.getCode()) && !materialCategoryVo.getCode().equals(uniqueBean.getCode())){
                materialService.updateCategoryCodeByCategoryId(materialCategoryVo.getId(), materialCategoryVo.getCode());
            }
            uniqueBean.setCode(materialCategoryVo.getCode());
            uniqueBean.setName(materialCategoryVo.getName());
            uniqueBean.setUnitId(materialCategoryVo.getUnitId());
            uniqueBean.setUnitName(materialCategoryVo.getUnitName());
            uniqueBean.setDescription(materialCategoryVo.getDescription());
            uniqueBean.setSequence(materialCategoryVo.getSequence());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(materialCategoryVo.getUpdateTime());
            uniqueBean.setSubjectId(materialCategoryVo.getSubjectId());
            uniqueBean.setSubjectName(materialCategoryVo.getSubjectName());
            uniqueBean.setSequence(materialCategoryVo.getSequence());
            WasteCategoryEntity entity = BeanMapper.map(uniqueBean, WasteCategoryEntity.class);
            materialCategoryService.update(entity);
            return CommonResponse.success("修改成功");
        } else {
            if(StringUtils.isNoneBlank(materialCategoryVo.getCode())){
                List<WasteCategoryEntity> codeData = materialCategoryService.queryByCode(materialCategoryVo.getCode());
                if(codeData!=null&&codeData.size()>0){
                    throw new BusinessException("分类编码已存在,请重新填写");
                }
            }else{
                CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(MATERIAL_CATEGORY_BILL_CODE, tenantId);
                if(codeBatchByRuleCode.isSuccess()){
                    materialCategoryVo.setCode(codeBatchByRuleCode.getData());
                }
            }
            WasteCategoryEntity entity = BeanMapper.map(materialCategoryVo, WasteCategoryEntity.class);
            entity.setId(IdWorker.getId());
            if(entity.getParentId() != null && entity.getParentId() > 0) {
                WasteCategoryVO uniqueBean = materialCategoryService.queryDetail(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode()+"|"+entity.getId());
            }else{
                entity.setInnerCode(entity.getId().toString());
            }
            entity.setEnabled(1);
            entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            entity.setCreateTime(new Date());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            materialCategoryService.save(entity);
            return CommonResponse.success("保存成功");
        }
    }

    /**
     * 查询列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<WasteCategoryEntity> dataList = materialCategoryService.queryList(queryParam);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("isLeaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success(jsonObject);
    }
    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String) map.get("subjectName");
        materialCategoryService.updateSubject(subjectId,subjectName,ids);
        return CommonResponse.success("绑定成功!");
    }

    /**
     * 根据主键查询物料分类详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteCategoryVO> queryDetail(@RequestParam Long id) {
        WasteCategoryVO materialCategoryVo = materialCategoryService.queryDetail(id);
        return CommonResponse.success(materialCategoryVo);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                WasteCategoryVO materialCategoryVO = materialCategoryService.queryDetail(id);
                //分类下有物料了不允许删除
                List<WasteItemVO> materialList = materialService.queryListByCategoryId(id);
                if(materialList != null && materialList.size() > 0) {
                    return CommonResponse.error("分类【" + materialCategoryVO.getName() + "】下有物料了，不允许删除");
                }
                //如果分类有子节点并且所有子节点也包含在删除项内，允许删除
                List<WasteCategoryVO> children = materialCategoryService.queryListByPid(id);
                if(children != null && children.size() > 0) {
                    for (WasteCategoryVO child : children) {
                        if(!ids.contains(child.getId())){
                            return CommonResponse.error("分类【" + materialCategoryVO.getName() + "】下有子分类不允许删除");
                        }
                    }
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        materialCategoryService.delete(ids);
        return CommonResponse.success("删除成功");
    }

    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @return
     */
    @RequestMapping(value = "/enabled/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody WasteCategoryVO materialCategoryVo) {
        WasteCategoryVO condition = materialCategoryService.queryDetail(materialCategoryVo.getId());
        materialCategoryService.updateEnabled(materialCategoryVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
        return CommonResponse.success("更新成功");
    }

//    /**
//     * 同步平台物料分类
//     *
//     * @return
//     */
//    @RequestMapping(value = "/sync", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> syncMaterialCategoryList() {
//        Long tenantId = InvocationInfoProxy.getTenantid();
//        if(OMS_TENANT.equals(tenantId.toString())) {
//            return CommonResponse.error("平台运营人员不能操作此功能");
//        }
//        materialCategoryService.insertCategoryListFromPlatform();
//        return CommonResponse.success("同步成功");
//    }

    /**
     * 物资分类树
     *
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryMaterialRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<WasteCategoryEntity> queryMaterialRefTree(@RequestParam(required = false) String searchText) {
        List<WasteCategoryEntity> dataList = null;
        long start = System.currentTimeMillis();
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = materialCategoryService.queryListEntityTree(params);
            System.out.println("查询耗时:"+(System.currentTimeMillis()-start));
            if(dataList != null && dataList.size() > 0) {
                List<WasteCategoryEntity> resultList = WasteMaterialCategoryAsTree.createTreeData(dataList);
                System.out.println("总耗时："+(System.currentTimeMillis()-start));
                return resultList;
            }
        } catch (Exception e) {}
        return null;
    }

    /**
     * 参照异步（懒加载）树----物资分类树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/lazyMaterialCategoryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyMaterialCategoryTree(@RequestParam(required=false) String condition,
                                                              @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<WasteCategoryVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                if(StringUtils.isNotBlank(condition)){
                    JSONObject con = JSONObject.parseObject(condition);
                    Object categoryIdObj = con.get("categoryId");
                    if (null != categoryIdObj) {
                        List<Long> asList = new ArrayList<>();
                        String categoryId = ((String) categoryIdObj);
                        if (categoryId.indexOf(",") > 0) {
                            String[] strings = categoryId.split(",");
                            for (String str : strings) {
                                asList.add(Long.valueOf(str));
                            }
                        } else {
                            asList.add(Long.valueOf(categoryId));
                        }
                        List<WasteCategoryVO> categoryList = new ArrayList<>();
                        for(Long parentId : asList){
                            categoryList.addAll(materialCategoryService.queryListByPid(parentId));
                        }
                        asList = categoryList.stream().map(WasteCategoryVO::getId).collect(Collectors.toList());
                        params.put("ids", asList);
                    }
                }
                dataList = materialCategoryService.queryListTree(params);
            }else{
                dataList = materialCategoryService.queryListByPid(pid);
                if(StringUtils.isNotBlank(condition)){
                    /** 处理condition */
                    JSONObject con = JSONObject.parseObject(condition);
                    Object categoryIdObj = con.get("categoryId");
                    if (null != categoryIdObj && pid == null) {
                        List<Long> asList = new ArrayList<>();
                        String categoryId = ((String) categoryIdObj);
                        if(categoryId.indexOf(",") > 0){
                            String[] strings = categoryId.split(",");
                            for(String str : strings){
                                asList.add(Long.valueOf(str));
                            }
                        }else{
                            asList.add(Long.valueOf(categoryId));
                        }
                        dataList = materialCategoryService.queryCategoryListByIds(asList);
                    }
                }
            }
            List<Map> map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-category-import.xlsx", "物料分类导入模板");
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<WasteMaterialCategoryImportVO> successList = new ArrayList<>();
        List<WasteMaterialCategoryImportVO> processList = new ArrayList<>();
        List<WasteMaterialCategoryImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                if(result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }
                Map<String,List<WasteMaterialCategoryImportVO>> mapChildren = new HashMap<>();
                Map<String,WasteMaterialCategoryImportVO> codeToData = new HashMap<>();
                Map<String,String> codeNotExistData = new HashMap<>();
                for(int i = 0;i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    WasteMaterialCategoryImportVO materialVo = new WasteMaterialCategoryImportVO();
                    materialVo.setId(IdWorker.getId());
                    materialVo.setCode(datas.get(0));
                    materialVo.setParentCode(datas.get(1));
                    materialVo.setName(datas.get(2));
                    if(StringUtils.isBlank(datas.get(0))){
                        materialVo.setDescription("分类编码为空！");
                        errorList.add(materialVo);
                        continue;
                    }
                    if(StringUtils.isBlank(datas.get(2))){
                        materialVo.setDescription("分类名称为空！");
                        errorList.add(materialVo);
                        continue;
                    }
                    //通过物料分类Code获取物料分类
                    List<WasteCategoryEntity> list = materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                    if(ListUtil.isEmpty(list)) {
                        //通过物料分类name获取物料分类
                        list = materialCategoryService.queryByName(String.valueOf(datas.get(2)));
                        if(ListUtil.isNotEmpty(list)) {
                            materialVo.setDescription("分类名称重复！");
                            errorList.add(materialVo);
                            continue;
                        }
                        if(StringUtils.isBlank(datas.get(1))){
                            materialVo.setInnerCode(materialVo.getId().toString());
                        }
                        materialVo.setEnabled(1);
                        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        materialVo.setCreateTime(new Date());
                        materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                        processList.add(materialVo);
                        codeToData.put(materialVo.getCode(),materialVo);
                        if(StringUtils.isBlank(materialVo.getParentCode())){
                            List<WasteMaterialCategoryImportVO> list1 = mapChildren.get("null");
                            if(ListUtil.isEmpty(list1)){
                                list1=new ArrayList<>();
                                mapChildren.put("null",list1);
                            }
                            list1.add(materialVo);
                        }else {
                            List<WasteMaterialCategoryImportVO> list1 = mapChildren.get(materialVo.getParentCode());
                            if(ListUtil.isEmpty(list1)){
                                list1=new ArrayList<>();
                                mapChildren.put(materialVo.getParentCode(),list1);
                            }
                            list1.add(materialVo);
                        }
                    }else{
                        materialVo.setDescription("分类编码重复！");
                        errorList.add(materialVo);
                    }
                }
                if(ListUtil.isNotEmpty(processList)){
                    processList.forEach(p->{
                        if(StringUtils.isNotEmpty(p.getParentCode())){
                            WasteMaterialCategoryImportVO parentVo = codeToData.get(p.getParentCode());
                            if(parentVo == null){
                                if(StringUtils.isNotEmpty(codeNotExistData.get(p.getParentCode()))){
                                    p.setDescription("父分类编码不存在");
                                    errorList.add(p);
                                }else {
                                    List<WasteCategoryEntity> list = materialCategoryService.queryByCode(p.getParentCode());
                                    if(ListUtil.isEmpty(list)){
                                        codeNotExistData.put(p.getParentCode(),p.getParentCode());
                                        p.setDescription("父分类编码不存在");
                                        errorList.add(p);
                                    }else {
                                        p.setInnerCode(list.get(0).getInnerCode()+"|"+p.getId());
                                        p.setParentId(list.get(0).getId());
                                        successList.add(p);
                                    }
                                }
                            }else {
                                if(StringUtils.isEmpty(parentVo.getInnerCode())){
                                    setInnerCodeAndParentId(parentVo,codeToData,codeNotExistData);
                                    if(StringUtils.isEmpty(parentVo.getInnerCode())){
                                        p.setDescription("父分类编码不存在");
                                        errorList.add(p);
                                    }else {
                                        p.setInnerCode(parentVo.getInnerCode()+"|"+p.getId());
                                        p.setParentId(parentVo.getId());
                                        successList.add(p);
                                    }
                                }else {
                                    p.setInnerCode(parentVo.getInnerCode()+"|"+p.getId());
                                    p.setParentId(parentVo.getId());
                                    successList.add(p);
                                }
                            }
                        }else {
                            successList.add(p);
                        }
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    private void setInnerCodeAndParentId(WasteMaterialCategoryImportVO vo, Map<String,WasteMaterialCategoryImportVO> codeToData, Map<String,String> codeNotExistData){
        WasteMaterialCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if(parentVo == null ){
            if(StringUtils.isNotEmpty(codeNotExistData.get(vo.getParentCode()))){
                vo.setDescription("父分类编码不存在");
            }else {
                List<WasteCategoryEntity> list = materialCategoryService.queryByCode(vo.getParentCode());
                if(ListUtil.isEmpty(list)){
                    codeNotExistData.put(vo.getParentCode(),vo.getParentCode());
                    vo.setDescription("父分类编码不存在");
                }else {
                    vo.setInnerCode(list.get(0).getInnerCode()+"|"+vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        }else {
            if(StringUtils.isEmpty(parentVo.getInnerCode())){
                setInnerCodeAndParentId(parentVo,codeToData,codeNotExistData);
                if(StringUtils.isEmpty(parentVo.getInnerCode())){
                    vo.setDescription("父分类编码不存在");
                }else {
                    vo.setInnerCode(parentVo.getInnerCode()+"|"+vo.getId());
                    vo.setParentId(parentVo.getId());
                }
            }else {
                vo.setInnerCode(parentVo.getInnerCode()+"|"+vo.getId());
                vo.setParentId(parentVo.getId());
            }

        }
    }

    @RequestMapping(value = "/saveImportExcelMaterialCategory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterialCategory(@RequestBody List<WasteMaterialCategoryImportVO> importVOS){
        if(ListUtil.isEmpty(importVOS)){
            return CommonResponse.error("导入的数据为空！");
        }
        List<WasteCategoryEntity> toSave = new ArrayList<>();
        importVOS.forEach(importVO->toSave.add(BeanMapper.map(importVO,WasteCategoryEntity.class)));
        materialCategoryService.insertBatch(toSave);
        return CommonResponse.success("保存成功！");
    }
    /************************水电八局接口start************************/


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("queryAll", new Parameter(QueryParam.EQ, "true"));
        //生效的
        List<WasteCategoryEntity> resultList = materialCategoryService.queryList(queryParam);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", resultList);
        ExcelExport.getInstance().export("materialCategory-export.xlsx", beans, response);
    }


    /************************水电八局接口end************************/

    /**
     * 更改物资分类启停用状态
     * <p>
     * 需求：
     * 1、物资/设备分类和物资/设备列表档案都增加启停用
     * 2、当分类切换启停用状态时，该分类下的所有档案的启停用状态也同时切换，切换前系统给操作者提示
     * 3、当非末级节点的分类切换启停用状态时，该分类下所有的子孙分类的启停用也同时切换，切换前系统给操作者提示
     * 4、子分类的启停用状态不影响父分类；档案的启停用状态不影响分类的启停用（即便某分类下所有的档案都停用，也不影响该分类的启停用状态）
     */
    @RequestMapping(value = "/changeCategoryEnableState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeCategoryEnableState(@RequestParam("id") Long id, @RequestParam("enabled") Integer enabled) {
        materialCategoryService.changeCategoryEnableState(id, enabled);
        return CommonResponse.success("操作成功！");
    }
}
