package com.ejianc.business.promaterial.doc.controller;

import java.io.IOException;
import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.service.IWasteCategoryService;
import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import com.ejianc.business.promaterial.doc.vo.WasteMaterialImportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SyncMaterialParam;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 废旧物资档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("wasteItem")
public class WasteItemController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_BILL_CODE = "WASTE_MATERIAL_COMM";
    private static final String MATERIAL_CATEGORY_BILL_CODE = "WASTE_MATERIAL_CATEGORY";

    @Value("${oms.tenantid}")
    private String OMS_TENANT;
    @Value("${common.env.base-host}")
    private String ENV_PROFILE;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IWasteItemService materialService;
    @Autowired
    private IWasteCategoryService materialCategoryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;

//    @Autowired
//    private IUnitService unitService;

    private final static Integer QUERY_TIMEOUT = 60;
    private final static String INDEX_NAME = "ejc_wj_org_material_relation_es";


    /**
     * 新增或者修改
     *
     * @param materialVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody WasteItemVO materialVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (materialVo.getId() != null && materialVo.getId() > 0) {
            if(StringUtils.isNotBlank(materialVo.getCode())){
                WasteItemVO codeData = materialService.queryByCode(materialVo.getCode());
                if(codeData!=null&&!codeData.getId().equals(materialVo.getId())){
                    throw new BusinessException("物资编码已存在,请重新填写");
                }
            }else{
                BillCodeParam billCodeParam = new BillCodeParam();
                billCodeParam.setTenantId(tenantId);
                billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                billCodeParam.setBillDetail(JSONObject.parseObject(JSONObject.toJSONString(materialVo)));
                CommonResponse<String> codeBatchByRuleCode = billCodeApi.generateBillCode(billCodeParam);
                if (codeBatchByRuleCode.isSuccess()) {
                    materialVo.setCode(codeBatchByRuleCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            WasteItemVO uniqueBean = materialService.queryDetail(materialVo.getId());
            uniqueBean.setCode(materialVo.getCode());
            uniqueBean.setName(materialVo.getName());
            uniqueBean.setSpec(materialVo.getSpec());
            uniqueBean.setUnitId(materialVo.getUnitId());
            uniqueBean.setUnitName(materialVo.getUnitName());
            uniqueBean.setSubjectId(materialVo.getSubjectId());
            uniqueBean.setSubjectName(materialVo.getSubjectName());
            uniqueBean.setDescription(materialVo.getDescription());
            uniqueBean.setSequence(materialVo.getSequence());
            uniqueBean.setProperty(materialVo.getProperty());
            uniqueBean.setPropertyName(materialVo.getPropertyName());
            uniqueBean.setParentUnitCode(materialVo.getParentUnitCode());
            uniqueBean.setQuality(materialVo.getQuality());
            uniqueBean.setOperativeNorm(materialVo.getOperativeNorm());

            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(new Date());
            uniqueBean.setTenantId(InvocationInfoProxy.getTenantid());
            uniqueBean.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            materialService.update(uniqueBean);

            return CommonResponse.success("修改成功");
        } else {
            if(StringUtils.isNotBlank(materialVo.getCode())){
                WasteItemVO codeData = materialService.queryByCode(materialVo.getCode());
                if(codeData!=null){
                    throw new BusinessException("物资编码已存在,请重新填写");
                }
            }else{
                //查询物料分类树
                WasteCategoryVO category = materialCategoryService.queryDetail(materialVo.getCategoryId());
                materialVo.setCategoryCode(category.getCode());

                BillCodeParam billCodeParam = new BillCodeParam();
                billCodeParam.setTenantId(tenantId);
                billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                billCodeParam.setBillDetail(JSONObject.parseObject(JSONObject.toJSONString(materialVo)));
                CommonResponse<String> codeBatchByRuleCode = billCodeApi.generateBillCode(billCodeParam);
                if (codeBatchByRuleCode.isSuccess()) {
                    materialVo.setCode(codeBatchByRuleCode.getData());
                }
            }
            // 新增子项未绑定成本科目时 自动带入父级的成本科目
            if(null == materialVo.getSubjectId()){
                Long categoryId = materialVo.getCategoryId();
                WasteCategoryVO materialCategoryVO = materialCategoryService.queryDetail(categoryId);
                materialVo.setSubjectId(materialCategoryVO.getSubjectId());
                materialVo.setSubjectName(materialCategoryVO.getSubjectName());
            }

            materialVo.setId(IdWorker.getId());
            materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
            materialVo.setCreateTime(new Date());
            materialVo.setTenantId(InvocationInfoProxy.getTenantid());
            materialVo.setEnabled(1);
            materialVo.setOrgId(InvocationInfoProxy.getOrgId());
            materialVo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            materialService.save(materialVo);

            return CommonResponse.success("保存成功");
        }

    }

    /**
     * 批量修改
     *
     * @param
     * @return
     * @throws
     */
    @RequestMapping(value = "/amend", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> amend(@RequestBody List<WasteItemVO> materialVo) {
        if (ListUtil.isNotEmpty(materialVo)) {
            for (WasteItemVO e : materialVo) {
                materialService.amend(e.getId(), e.getProperty(), e.getPropertyName());
            }
        }
        return CommonResponse.success("修改成功");
    }

    /**
     * 准入
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/allowIn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> allowIn(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            materialService.allowIn(ids);
        }
        return CommonResponse.success("批量准入成功");
    }

    /**
     * 根据主键ID查询物料详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WasteItemVO> queryDetail(@RequestParam Long id) {
        WasteItemVO materialVo = materialService.queryDetail(id);
        return CommonResponse.success(materialVo);
    }
    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String) map.get("subjectName");
        materialService.updateSubject(subjectId,subjectName,ids);
        return CommonResponse.success("绑定成功!");
    }
    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = billTypeApi.checkQuote("BT200422000000025", id);
                if (!response.isSuccess()) {
                    return CommonResponse.error("删除失败：" + response.getMsg());
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        materialService.delete(ids);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询待分页的列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<WasteItemEntity> pageData = materialService.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success(jsonObject);

    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     * 已废弃----2020年6月30日
     *
     * @param request
     * @return
     */
    @Deprecated
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<String> errorList = new ArrayList<String>();
            if (result != null && result.size() > 0) {
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    WasteItemVO materialVo = null;
                    //通过物料分类Code获取物料分类ID
                    List<WasteCategoryEntity> materialCategoryVo = materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                    if (materialCategoryVo != null) {
                        materialVo = new WasteItemVO();
                        materialVo.setId(IdWorker.getId());
                        materialVo.setCategoryId(materialCategoryVo.get(0).getId());

                        if (StringUtils.isBlank(datas.get(1))) {

                            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(MATERIAL_BILL_CODE, tenantId);
                            if(codeBatchByRuleCode.isSuccess()){
                                materialVo.setCode(codeBatchByRuleCode.getData());
                            } else {
                                materialVo.setCode(new Date().getTime() + "");
                            }

                        } else {
                            materialVo.setCode(datas.get(1));
                        }
                        materialVo.setName(datas.get(2));
                        materialVo.setParentUnitCode(datas.get(3)); //上级单位编码
                        materialVo.setSpec(datas.get(4)); //规格型号
                        materialVo.setUnitName(datas.get(5)); //计量单位
                        WasteItemVO materialBean = materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId());
                        if (materialBean != null) {
                            continue;
                        }

                        materialVo.setQuality(datas.get(6)); //材质
                        materialVo.setOperativeNorm(datas.get(7)); //执行标准
                        materialVo.setDescription(datas.get(8)); //备注
                        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        materialVo.setCreateTime(new Date());
                        materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                        materialVo.setEnabled(1);
                        materialService.save(materialVo);
                    } else {
                        errorList.add("第" + i + "行数据：" + datas.toString() + "导入失败，原因：物料分类编号不正确！");
                        continue;
                    }
                }
            }
            if (errorList.size() > 0) {
                errorList.add("导入成功：" + (result.size() - errorList.size() - 1) + "条, 失败：" + errorList.size() + "条");

                return CommonResponse.error("导入失败", errorList);
            } else {
                return CommonResponse.success("导入成功");
            }
        }
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/29 物料详情导入excel校验
     * @Description excelMaterialImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/excelMaterialImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelMaterialImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<WasteMaterialImportVO> successList = new ArrayList<>();
        List<WasteMaterialImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("物料超过10000条，请分批上传！");
                }
                Map<String, List<WasteCategoryEntity>> caListMap = new HashMap<>();
                Map<String, WasteItemVO> materialMap = new HashMap<>();
                Map<String, WasteItemVO> materialBeanMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    WasteMaterialImportVO materialVo = new WasteMaterialImportVO();
                    materialVo.setId(IdWorker.getId());
                    materialVo.setCategoryCode(datas.get(0));
                    materialVo.setCode(datas.get(1));
                    materialVo.setName(datas.get(2));
                    materialVo.setSpec(datas.get(4));
                    materialVo.setUnitName(datas.get(5));
                    materialVo.setBillState(1);
//                    materialVo.setPropertyName(datas.get(6));
                    materialVo.setParentUnitCode(datas.get(3)); //上级单位编码
                    materialVo.setQuality(datas.get(6)); //材质
                    materialVo.setOperativeNorm(datas.get(7)); //执行标准
                    materialVo.setDescription(datas.get(8)); //备注
//                    if (StringUtils.isBlank(datas.get(5))) {
//                        materialVo.setDescription("物料属性为空！");
//                        errorList.add(materialVo);
//                        continue;
//                    } else {
//                        switch (datas.get(5)) {
//                            case "工程材料":
//                                materialVo.setProperty(1L);
//                                break;
//                            case "周转材":
//                                materialVo.setProperty(2L);
//                                break;
//                            case "低值易耗品":
//                                materialVo.setProperty(3L);
//                                break;
//                            case "设备":
//                                materialVo.setProperty(4L);
//                                break;
//                            default:
//                                materialVo.setDescription("物料属性不合法！");
//                                errorList.add(materialVo);
//                                continue;
//                        }
//                    }
                    if (StringUtils.isBlank(datas.get(0))) {
                        materialVo.setDescription("物料分类编号为空！");
                        errorList.add(materialVo);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        materialVo.setDescription("物料名称为空！");
                        errorList.add(materialVo);
                        continue;
                    }
                    //通过物料分类Code获取物料分类ID
                    List<WasteCategoryEntity> materialCategoryVo = caListMap.get(datas.get(0));
                    if (ListUtil.isEmpty(materialCategoryVo)) {
                        materialCategoryVo = materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                        if (ListUtil.isNotEmpty(materialCategoryVo)) {
                            caListMap.put(datas.get(0), materialCategoryVo);
                        }
                    }
                    if (ListUtil.isNotEmpty(materialCategoryVo)) {
                        materialVo.setCategoryId(materialCategoryVo.get(0).getId());

                        if (StringUtils.isBlank(datas.get(1))) {//没有编号，自动生成一个
                            BillCodeParam billCodeParam = new BillCodeParam();
                            billCodeParam.setTenantId(tenantId);
                            billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                            billCodeParam.setBillDetail(JSONObject.parseObject(JSONObject.toJSONString(materialVo)));
                            CommonResponse<String> codeBatchByRuleCode = billCodeApi.generateBillCode(billCodeParam);
                            if(codeBatchByRuleCode.isSuccess()){
                                materialVo.setCode(codeBatchByRuleCode.getData());
                            }else{
                                materialVo.setCode(new Date().getTime() + "");
                            }

                        } else {//有编号，判重
                            WasteItemVO vo = materialMap.get(datas.get(1));
                            if (vo == null) {
                                vo = materialService.queryByCode(datas.get(1));
                                if (vo != null) {
                                    materialMap.put(datas.get(1), vo);
                                }
                            }
                            if (vo != null) {
                                materialVo.setDescription("物料编号重复！");
                                errorList.add(materialVo);
                                continue;
                            }
                        }

                        WasteItemVO materialBean = materialBeanMap.get(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId());
                        if (materialBean == null) {
                            materialBean = materialService.queryExitFlag(materialVo.getName(), materialVo.getSpec(), materialVo.getUnitName(), materialCategoryVo.get(0).getId());
                            if (materialBean != null) {
                                materialBeanMap.put(materialVo.getName() + materialVo.getSpec() + materialVo.getUnitName() + materialCategoryVo.get(0).getId(), materialBean);
                            }
                        }
                        if (materialBean != null) {
                            materialVo.setDescription("重复物料！");
                            errorList.add(materialVo);
                            continue;
                        }
                        materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        materialVo.setCreateTime(new Date());
                        materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                        materialVo.setEnabled(1);
                        successList.add(materialVo);
                    } else {
                        materialVo.setDescription("物料分类编号不存在！");
                        errorList.add(materialVo);
                    }
//                    if (StringUtils.isBlank(datas.get(6))) {
//                        materialVo.setDescription("成本科目为空！");
//                        errorList.add(materialVo);
//                        continue;
//                    }else {
//                        String subjectName = datas.get(6).toString();
//                        QueryWrapper<SubjectOrgEntity> subjectQueryWrapper = new QueryWrapper<>();
//                        subjectQueryWrapper.like("subject_name",subjectName);
//                        List<SubjectOrgEntity> list = subjectOrgService.list(subjectQueryWrapper);
//                        if(CollectionUtils.isNotEmpty(list)){
//                            materialVo.setSubjectId(list.get(0).getId());
//                            materialVo.setSubjectName(list.get(0).getSubjectName());
//                        }
//                    }

                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @RequestMapping(value = "/saveImportExcelMaterial", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterial(@RequestBody List<WasteMaterialImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<WasteItemVO> list = new ArrayList<>();
        Set<String> unitNameList = new HashSet<>();
        importVOS.forEach(importVO->{
            if(StringUtils.isNotEmpty(importVO.getUnitName())){
                unitNameList.add(importVO.getUnitName());
            }
        });
        logger.info("----查询计量信息unitNameList---"+JSONObject.toJSONString(unitNameList));
        List<Map<String,Object>> unitEntities = materialService.queryUnit(unitNameList);
        logger.info("----查询计量信息unitEntities---"+JSONObject.toJSONString(unitEntities));
        Map<String,Long> map = new HashMap<>();
        Map<String, Long> unitDataMap = unitEntities.stream().filter(UnitEntity -> UnitEntity != null && UnitEntity.get("unitName") != null)
                .collect(Collectors.toMap(
                        UnitEntity -> UnitEntity.get("unitName").toString(),
                        UnitEntity -> Long.valueOf(UnitEntity.get("id").toString()),
                        (key1, key2) -> key1
                ));
        map.putAll(unitDataMap);
        importVOS.forEach(importVO -> {
            WasteItemVO  vo = BeanMapper.map(importVO, WasteItemVO.class);
            if (null!=map&&map.containsKey(importVO.getUnitName())){
                vo.setUnitId(map.get(importVO.getUnitName()));
            }
            vo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
            list.add(vo);
        });
        logger.info("----导入list---"+JSONObject.toJSONString(list));
        materialService.insertBatch(list);
        return CommonResponse.success("保存成功！");
    }

    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //生效的
        queryParam.getParams().put("billState", new Parameter(QueryParam.EQ, BillStateEnum.COMMITED_STATE.getBillStateCode()));
        List<WasteItemEntity> resultList = materialService.queryList(queryParam);
        Map<String, Object> beans = new HashMap<String, Object>();
        resultList.stream().forEach(item -> item.setDef10(item.getEnabled() == 1 ? "启用" : "停用"));
        beans.put("records", resultList);
        ExcelExport.getInstance().export("material-export.xlsx", beans, response);
    }

//    /**
//     * 同步平台物料
//     *
//     * @return
//     */
//    @RequestMapping(value = "/sync", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> syncMaterialList() {
//        Long tenantId = InvocationInfoProxy.getTenantid();
//        if (OMS_TENANT.equals(tenantId.toString())) {
//            return CommonResponse.error("平台运营人员不能操作此功能");
//        }
//        materialService.insertMaterialListFromPlatform();
//        return CommonResponse.success("同步成功");
//    }

    /**
     * 材料列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refMaterialPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WasteItemVO>> refMaterialPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                             @RequestParam(required = false) String relyCondition,
                                                             @RequestParam(required = false) String searchText,
                                                             @RequestParam(required = false) String condition,
                                                             @RequestParam(required = false) String searchObject
    ) {
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            WasteCategoryVO materialCategoryVo = materialCategoryService.queryDetail(categoryId);
            if (materialCategoryVo != null) {
                params.put("innerCode", materialCategoryVo.getInnerCode());
            }else{
                return CommonResponse.error("当前分类不存在档案！");
            }
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("categoryCode") != null) {
                params.put("categoryCode", search.get("categoryCode").toString());
            }
            if (search.get("categoryName") != null) {
                params.put("categoryName", search.get("categoryName").toString());
            }
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
            if (search.get("spec") != null) {
                params.put("spec", search.get("spec").toString());
            }
            if (search.get("unitName") != null) {
                params.put("unitName", search.get("unitName").toString());
            }
        }
        if(StringUtils.isNotBlank(condition)) {
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("categoryId")) {
                params.put("categoryId", _con.getLong("categoryId"));
            }
        }
        params.put("billState", 1);
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<WasteItemVO> pageData = materialService.queryRefMaterialPage(params);
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);

        return CommonResponse.success("查询成功！", pageData);
    }



    /**
     * 更改物资 启停用状态
     * <p>
     * 需求：
     * 1、物资/设备分类和物资/设备列表档案都增加启停用
     * 2、当分类切换启停用状态时，该分类下的所有档案的启停用状态也同时切换，切换前系统给操作者提示
     * 3、当非末级节点的分类切换启停用状态时，该分类下所有的子孙分类的启停用也同时切换，切换前系统给操作者提示
     * 4、子分类的启停用状态不影响父分类；档案的启停用状态不影响分类的启停用（即便某分类下所有的档案都停用，也不影响该分类的启停用状态）
     */
    @RequestMapping(value = "/changeMaterialEnableState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeMaterialEnableState(@RequestParam("id") Long id, @RequestParam("enabled") Integer enabled) {
        WasteItemVO vo = materialService.queryDetail(id);
        if (vo == null) {
            return CommonResponse.error("单据不存在！");
        }
        vo.setEnabled(enabled);
        materialService.update(vo);
        return CommonResponse.success("操作成功！");
    }
}
