package com.ejianc.business.promaterial.doc.service;

import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;

import java.util.List;
import java.util.Map;

/**
 * 废旧物资档案分类
 * 
 * @author generator
 * 
 */
public interface IWasteCategoryService {

    /**
     * 查询物料分类列表
     *
     * @param queryParam
     * @return
     */
    List<WasteCategoryEntity> queryList(QueryParam queryParam);

    /**
     * 查询物料分类详情
     *
     * @param id
     * @return
     */
    WasteCategoryVO queryDetail(Long id);

    /**
     * 修改
     *
     * @param entity
     */
    void update(WasteCategoryEntity entity);
    /**
     * 修改
     *
     * @param subjectId 科目id
     * @param subjectName 科目name
     * @param ids		本次变更数据的id
     */
    void updateSubject(Long subjectId,String subjectName,List<Long> ids);
    /**
     * 新增
     *
     * @param entity
     */
    void save(WasteCategoryEntity entity);

    /**
     * 批量新增
     *
     * @param entity
     */
    void insertBatch(List<WasteCategoryEntity> entity);

    /**
     * 根据父ID查询物料分类列表
     *
     * @param id
     * @return
     */
    List<WasteCategoryVO> queryListByPid(Long id);

    /**
     * 根据父ID查询物料分类列表
     *
     * @param id
     * @return
     */
    List<WasteCategoryVO> queryListAllByPid(Long id);
    /**
     * 删除
     *
     * @param id
     */
    void delete(Long id);

    /**
     * 修改物料分类状态
     *
     * @param enabled
     * @param tenantId
     * @param innerCode
     */
    void updateEnabled(Integer enabled, Long tenantId, String innerCode);

    /**
     * 根据分类编号查询分类
     *
     * @param code
     * @return
     */
    List<WasteCategoryEntity> queryByCode(String code);

    /**
     * 根据分类名称查询分类
     *
     * @param name
     * @return
     */
    List<WasteCategoryEntity> queryByName(String name);

    /**
     * 同步平台物料分类到租户下
     */
    void insertCategoryListFromPlatform();

    /**
     * 查询列表tree
     *
     * @param params
     * @return
     */
    List<WasteCategoryVO> queryListTree(Map<String, Object> params);

    WasteCategoryVO queryBySourceId(String sourceId);

    /**
     * 根据innerCode查询子级(包含本级)
     *
     * @param params
     * @return
     */
    List<WasteCategoryVO> queryListByInnerCode(Map<String, Object> params);

    List<WasteCategoryVO> queryCategoryListByChildren(List<Long> ids);

    Map<Long, List<WasteCategoryVO>> queryCategoryListByMaterialId(List<Long> ids);

    List<WasteCategoryVO> queryCategoryListByIds(List<Long> ids);

    void delete(List<Long> ids);

    List<WasteCategoryEntity> queryListEntityTree(Map<String, Object> params);

    void changeCategoryEnableState(Long id, Integer enabled);
}
