package com.ejianc.business.promaterial.doc.service.impl;

import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.doc.mapper.WasteCategoryMapper;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.service.IWasteCategoryService;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 废旧物资档案分类
 * 
 * @author generator
 * 
 */
@Service("wasteCategoryService")
public class WasteCategoryServiceImpl implements IWasteCategoryService{

    @Autowired
    private WasteCategoryMapper materialCategoryMapper;
    @Autowired
    private IWasteItemService materialService;

    @Override
    public List<WasteCategoryEntity> queryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<String, Object>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<WasteCategoryEntity> resultList = materialCategoryMapper.queryList(condition);
        return resultList;
    }

    @Override
    public WasteCategoryVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WasteCategoryEntity entity = materialCategoryMapper.queryDetail(tenantId, id);
        if(entity != null) {
            return BeanMapper.map(entity, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public void update(WasteCategoryEntity entity) {
        materialCategoryMapper.update(entity);
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Long> ids = new ArrayList<>();
        ids.add(entity.getId());
        List<WasteCategoryEntity> materialCategoryEntities = materialCategoryMapper.queryByInnerCodes(tenantId,ids);
        ids.clear();
        materialCategoryEntities.forEach(item->{
            ids.add(item.getId());
            // 更新字表的数据
            materialService.updateByCategoryId(item.getId(),entity.getSubjectId(),entity.getSubjectName());
        });
        materialCategoryMapper.updateSubject(tenantId,entity.getSubjectId(),entity.getSubjectName(),ids);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteCategoryEntity> materialCategoryEntities = materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item->{
            ids.add(item.getId());
            // 更新字表的数据
            materialService.updateByCategoryId(item.getId(),subjectId,subjectName);
        });
        materialCategoryMapper.updateSubject(tenantId,subjectId,subjectName,ids);
    }

    @Override
    public void save(WasteCategoryEntity entity) {
        materialCategoryMapper.insert(entity);
    }

    /**
     * 批量新增
     *
     * @param categoryEntityList
     */
    @Override
    public void insertBatch(List<WasteCategoryEntity> categoryEntityList) {
        if(ListUtil.isNotEmpty(categoryEntityList)){
            List<WasteCategoryEntity> toInsert = new ArrayList<>();
            for (WasteCategoryEntity entity : categoryEntityList){
                if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
                    materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
                    toInsert = new ArrayList<>();
                }
                toInsert.add(entity);
            }
            if(toInsert.size()>0){
                materialCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
            }
        }
    }

    @Override
    public List<WasteCategoryVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByPid(tenantId, id);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryVO> queryListAllByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListAllByPid(tenantId, id);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        materialCategoryMapper.delete(tenantId,id);
    }

    @Override
    public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
        materialCategoryMapper.updateEnabled(enabled,tenantId,innerCode);
    }

    @Override
    public List<WasteCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return materialCategoryMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<WasteCategoryEntity> queryByName(String name) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return materialCategoryMapper.queryByName(tenantId, name);
    }

    @Override
    public void insertCategoryListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        materialCategoryMapper.insertCategoryListFromPlatform(tenantId);
    }

    @Override
    public List<WasteCategoryVO> queryListTree(Map<String, Object> params) {
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryEntity> queryListEntityTree(Map<String, Object> params) {
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
        return materialCategoryList;
    }

    @Override
    @Transactional
    public void changeCategoryEnableState(Long id, Integer enabled) {
        //1、查询出该分类
        WasteCategoryEntity entity = materialCategoryMapper.queryDetail(InvocationInfoProxy.getTenantid(), id);
        if (entity == null) {
            throw new BusinessException("该分类不存在！");
        }
        Map<String, Object> params = new HashMap<>();
        params.put("innerCode", entity.getInnerCode());
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        List<WasteCategoryEntity> categoryEntities = materialCategoryMapper.queryListByInnerCode(params);
        List<Long> categoryIds = categoryEntities.stream().map(WasteCategoryEntity::getId).collect(Collectors.toList());
        materialCategoryMapper.updateEnabled(enabled, InvocationInfoProxy.getTenantid(), entity.getInnerCode());
        materialService.updateStateByCategoryId(categoryIds, enabled, InvocationInfoProxy.getTenantid());
    }

    @Override
    public WasteCategoryVO queryBySourceId(String sourceId) {
        WasteCategoryEntity entity = materialCategoryMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
        if (entity != null && entity.getId() != null) {
            return BeanMapper.map(entity, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryVO> queryListByInnerCode(Map<String, Object> params) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByInnerCode(params);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<WasteCategoryVO> queryCategoryListByChildren(List<Long> ids) {
        List<WasteCategoryVO> result = new ArrayList<>();
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            Set<Long> keySet = new HashSet<>();
            List<WasteCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
            Map<Long, WasteCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(WasteCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for(Long id : ids){
                WasteCategoryVO categoryVO = categoryVOMap.get(id);
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                for(String keyStr : keyArray){
                    Long key = Long.valueOf(keyStr);
                    if(!keySet.contains(key)){
                        keySet.add(key);
                        result.add(categoryVOMap.get(key));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Map<Long, List<WasteCategoryVO>> queryCategoryListByMaterialId(List<Long> ids) {
        List<WasteItemEntity> materialEntityList = materialService.queryMaterialByIds(ids);
        Map<Long, List<WasteCategoryVO>> resMap = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListTree(params);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            List<WasteCategoryVO> materialCategoryVOS =  BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
            Map<Long, WasteCategoryVO> categoryVOMap = materialCategoryVOS.stream().collect(Collectors.toMap(WasteCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for(WasteItemEntity mentity:materialEntityList){
                Long categoryId = mentity.getCategoryId();
                WasteCategoryVO categoryVO = categoryVOMap.get(categoryId);
                String innerCode = categoryVO.getInnerCode();
                String[] keyArray = innerCode.split("\\|");
                List<WasteCategoryVO> result = new ArrayList<>();
                for(int i = keyArray.length - 1; i >= 0; i --){
                    Long key = Long.valueOf(keyArray[i]);
                    result.add(categoryVOMap.get(key));
                }
                resMap.put(mentity.getId(),result);
            }
        }
        return resMap;
    }

    @Override
    public List<WasteCategoryVO> queryCategoryListByIds(List<Long> ids) {
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<WasteCategoryEntity> materialCategoryList = materialCategoryMapper.queryListByIds(params);
        if(materialCategoryList != null && materialCategoryList.size() > 0) {
            return BeanMapper.mapList(materialCategoryList, WasteCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for(Long id:ids) {
            materialCategoryMapper.delete(tenantId, id);
        }
    }
}
