package com.ejianc.business.promaterial.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.mapper.WasteCategoryMapper;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.doc.mapper.WasteItemMapper;
import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 废旧物资档案
 * 
 * @author generator
 * 
 */
@Service("wasteItemService")
public class WasteItemServiceImpl extends BaseServiceImpl<WasteItemMapper, WasteItemEntity> implements IWasteItemService{
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MATERIAL_BILL_CODE = "WASTE_MATERIAL_COMM";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private WasteItemMapper materialMapper;
    @Autowired
    private WasteCategoryMapper materialCategoryMapper;

    @Override
    public List<WasteItemVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemEntity> entities = materialMapper.queryListByCategoryId(tenantId, categoryId);
        if(entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, WasteItemVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = materialMapper.updateByCategoryId(tenantId, categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
        return CommonResponse.success();
    }

    @Override
    public void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId) {
        materialMapper.updateStateByCategoryId(tenantId, categoryIds, state);
    }

    @Override
    public WasteItemVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WasteItemEntity entity = materialMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return BeanMapper.map(entity, WasteItemVO.class);
        }
        return null;
    }


    @Override
    public List<WasteItemVO> queryItem(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemEntity> materialEntities = materialMapper.queryItem(tenantId, ids);
        if(materialEntities != null && materialEntities.size() > 0) {
            return BeanMapper.mapList(materialEntities, WasteItemVO.class);
        }
        return null;
    }

    @Override
    public void update(WasteItemVO uniqueBean) {
        materialMapper.update(uniqueBean);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemEntity> materialEntities = materialMapper.queryMaterialByIds(ids,tenantId);
        List<WasteItemVO> list = new ArrayList<>();
        materialEntities.forEach(entity -> list.add(BeanMapper.map(entity, WasteItemVO.class)));
        list.forEach(vo -> {
            vo.setSubjectId(subjectId);
            vo.setSubjectName(subjectName);
        });
        list.forEach(vo -> {
            materialMapper.update(vo);
        });
    }

    @Override
    public void save(WasteItemVO materialVo) {
        materialMapper.save(materialVo);
    }

    /**
     * 批量保存
     *
     * @param materialVOList
     */
    @Override
    public void insertBatch(List<WasteItemVO> materialVOList) {
        if(ListUtil.isNotEmpty(materialVOList)){
            List<WasteItemVO> toInsert = new ArrayList<>();
            for (WasteItemVO materialVO : materialVOList) {
                if (!toInsert.isEmpty() && toInsert.size() % 500 == 0) {
                    materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
                    toInsert = new ArrayList<>();
                }
                toInsert.add(materialVO);
            }
            if(!toInsert.isEmpty()){
                materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
            }
        }
    }
    @Override
    public void amend(Long id,Long property,String propertyName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        materialMapper.amend(id,property,propertyName,tenantId);
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for(Long id:ids) {
            materialMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<WasteItemEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String, Object> condition = new HashMap<String, Object>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            if("categoryId".equals(entry.getKey())) {
                Parameter parameter = entry.getValue();
                if(StringUtils.isBlank(parameter.getValue()+"")) {
                    continue;
                }
                Object value = parameter.getValue();
                if (value==null){
                    continue;
                }
                WasteCategoryEntity categoryEntity = materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
                if(categoryEntity != null) {
                    condition.put("innerCode", categoryEntity.getInnerCode());
                }
            }else{
                condition.put(entry.getKey(), entry.getValue().getValue());
            }
        }
        condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());

        List<WasteItemEntity> records = materialMapper.queryList(condition);
        Long count = materialMapper.queryCount(condition);

        IPage<WasteItemEntity> page = new Page<>();
        page.setCurrent(queryParam.getPageIndex());
        page.setSize(queryParam.getPageSize());
        page.setTotal(count);
        page.setRecords(records);
        return page;
    }

    @Override
    public WasteItemVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WasteItemVO materialVo = materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return materialVo;
    }

    @Override
    public List<WasteItemVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemVO> list = materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
        return list;
    }

    /**
     * 根据code查询物料
     *
     * @param code
     * @return
     */
    @Override
    public WasteItemVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return materialMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<WasteItemEntity> queryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map<String, Object> condition = new HashMap<String, Object>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            if("categoryId".equals(entry.getKey())) {
                Parameter parameter = entry.getValue();
                if(StringUtils.isBlank(parameter.getValue()+"")) {
                    continue;
                }
                WasteCategoryEntity categoryEntity = materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
                if(categoryEntity != null) {
                    condition.put("innerCode", categoryEntity.getInnerCode());
                }
            }else{
                condition.put(entry.getKey(), entry.getValue().getValue());
            }
        }
        List<WasteItemEntity> records = materialMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertMaterialListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        materialMapper.insertMaterialListFromPlatform(tenantId);
    }

    @Override
    public IPage<WasteItemVO> queryRefMaterialPage(Map<String, Object> params) {
        List<WasteItemEntity> dataList = materialMapper.queryRefMaterialList(params);
        Long dataCount = materialMapper.queryRefMaterialCount(params);
        List<WasteItemVO> materialVOS = BeanMapper.mapList(dataList, WasteItemVO.class);
        IPage<WasteItemVO> page = new Page<>();
        page.setRecords(materialVOS);

        page.setTotal(dataCount);
        return page;
    }

    @Override
    public WasteItemEntity queryBySourceId(String sourceId) {
        return materialMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<WasteItemEntity> queryMaterialByIds(List<Long> ids) {
        return materialMapper.queryMaterialByIds(ids,InvocationInfoProxy.getTenantid());
    }

    @Override
    public IPage<WasteItemEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
        IPage<WasteItemEntity> page = new Page<>();
        if (params.containsKey("sourceOrgId") && null !=params.get("sourceOrgId")) {
            List<WasteItemEntity> dataList = materialMapper.queryZjwjRefMaterialList(params);
            Long dataCount = materialMapper.queryZjwjRefMaterialCount(params);
            page.setRecords(dataList);
            page.setTotal(dataCount);
        }
        return page;
    }


    @Override
    public List<WasteItemVO> queryMaterialListByCodes(List<String> codeList) {
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("codeList", codeList);
        List<WasteItemEntity> materialEntities = materialMapper.queryMaterialListByCodes(params);
        if(materialEntities != null && materialEntities.size() > 0) {
            return BeanMapper.mapList(materialEntities, WasteItemVO.class);
        }
        return null;
    }

    /**
     * 批量插入档案
     *
     * @param materialVOMap 材料设备VO
     *
     * @param sourceBillId
     * @param sourceBillCode
     * @param sourceBillType
     * @return {@link CommonResponse}<{@link Map}<{@link String}, {@link WasteItemVO}>>
     *
     */
    @Override
    public CommonResponse<Map<String, WasteItemVO>> batchInsertArchive(Map<String, WasteItemVO> materialVOMap, Long sourceBillId, String sourceBillCode, String sourceBillType){
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("校验档案是否存在----start"+ JSONObject.toJSONString(materialVOMap));
        Map<String, WasteItemVO> resMap = materialVOMap;
        if (materialVOMap.isEmpty()) {
            throw new BusinessException("批量插入档案，数据不能为空！");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();

        List<WasteItemVO> materialVOS = new ArrayList<>();
        for (Map.Entry<String, WasteItemVO> entry : materialVOMap.entrySet()) {
            WasteItemVO materialVO = entry.getValue();
            WasteCategoryEntity materialCategory = materialCategoryMapper.queryDetail(tenantId,materialVO.getCategoryId());
            logger.info("查询分类----materialCategory："+ JSONObject.toJSONString(materialCategory));
            if (materialCategory == null) {
                return CommonResponse.error("批量插入档案，档案分类:" + materialVO.getCategoryName() + "，不存在！");
            }
            WasteItemVO vo = materialMapper.queryAllByTenantIdAndNameAndTypeAndSpecAndUnitName(tenantId, materialCategory.getId(), materialVO.getName(), 1, materialVO.getSpec(), materialVO.getUnitName(),materialVO.getQuality(),materialVO.getOperativeNorm());
            logger.info("查询count----："+ vo);
            if (null==vo) {
                String billCode = "";
                if (StringUtils.isEmpty(materialVO.getCode())||"".equals(materialVO.getCode())){
                    materialVO.setCategoryCode(materialCategory.getCode());
                    BillCodeParam billCodeParam = new BillCodeParam();
                    billCodeParam.setTenantId(tenantId);
                    billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                    billCodeParam.setBillDetail(JSONObject.parseObject(JSONObject.toJSONString(materialVO)));
                    CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                    if (billCodeRes.isSuccess()) {
                        billCode = billCodeRes.getData();
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }else {
                    billCode = materialVO.getCode();
                    //记录物资编码 和 key
                }
                logger.info("编码billCode----："+ billCode);
                materialVO.setId(IdWorker.getId());
                materialVO.setCategoryId(materialCategory.getId());
                materialVO.setCode(billCode);
                materialVO.setEnabled(1);
                materialVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                materialVO.setCreateTime(new Date());
                materialVO.setTenantId(InvocationInfoProxy.getTenantid());
                materialVO.setSourceId(materialCategory.getSourceId());
                materialVO.setSystemId(materialCategory.getSystemId());
                materialVO.setCategorySourceId(materialCategory.getSourceId());
                materialVO.setCategoryName(materialCategory.getName());
                materialVO.setCategoryCode(materialCategory.getCode());
                // 单据新增的档案默认是未审核
                materialVO.setBillState(Optional.ofNullable(materialVO.getBillState()).orElse(0));
                // 临时档案需要记录来源单据信息
                if (materialVO.getBillState().intValue() == 0) {
                    materialVO.setSourceBillId(sourceBillId);
                    materialVO.setSourceBillCode(sourceBillCode);
                    materialVO.setSourceBillType(sourceBillType);
                }
                materialVOS.add(materialVO);
                // 更新value值
                entry.setValue(materialVO);
                resMap.put(entry.getKey(),materialVO);
            }else{
                resMap.put(entry.getKey(),vo);
            }
        }

        if (CollectionUtils.isNotEmpty(materialVOS)) {
            materialMapper.insertBatch1(tenantId, materialVOS);
        }
        stopwatch.stop();
        logger.info("校验档案是否存在----end：已处理设备档案【{}】条数据，共用时【{}】毫秒", materialVOMap.isEmpty() ? 0 : materialVOMap.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        logger.info("查询结果----resMap："+ JSONObject.toJSONString(resMap));
        return CommonResponse.success(resMap);
    }

    @Override
    public void allowIn(List<Long> ids) {
        materialMapper.allowIn(InvocationInfoProxy.getTenantid(), ids);
    }

    @Override
    public List<Map<String, Object>> queryUnit(Set<String> unitNameList) {
        return materialMapper.queryUnit(InvocationInfoProxy.getTenantid(), unitNameList);
    }

    @Override
    public void batchUpdateArchiveSourceInfo(List<Long> materialIds, Long sourceBillId, String sourceBillCode) {
        List<WasteItemEntity> materialList = materialMapper.queryMaterialByIds(materialIds, InvocationInfoProxy.getTenantid());
        if(CollectionUtils.isNotEmpty(materialList)) {
            materialList.stream().filter(item -> null != item.getSourceBillId()).forEach(item -> {
                item.setSourceBillId(sourceBillId);
                item.setSourceBillCode(sourceBillCode);

                materialMapper.update(BeanMapper.map(item, WasteItemVO.class));
            });
        }
    }
}
