package com.ejianc.business.promaterial.electronicFence.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigDetailEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IAmapService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigDetailService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.electronicFence.vo.DistanceVO;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 电子围栏设置
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("electronicFenceConfig")
public class ElectronicFenceConfigController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ELECTRONIC_FENCE_CONFIG";
    @Autowired
    private IElectronicFenceConfigService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IElectronicFenceConfigDetailService electronicFenceConfigDetailService;

    @Resource
    private IAmapService amapService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<ElectronicFenceConfigVO> saveOrUpdate(@RequestBody ElectronicFenceConfigVO saveOrUpdateVO) {
    	ElectronicFenceConfigEntity entity = BeanMapper.map(saveOrUpdateVO, ElectronicFenceConfigEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            //检查当前项目是否已有围栏设置
            ElectronicFenceConfigEntity dbEntity = service.getOneByProjectId(saveOrUpdateVO.getProjectId(), false);
            if(null != dbEntity) {
                return CommonResponse.error("当前项目已有电子围栏设置单据，请勿重复添加！");
            }

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ElectronicFenceConfigVO vo = BeanMapper.map(entity, ElectronicFenceConfigVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ElectronicFenceConfigVO> queryDetail(Long id) {
    	ElectronicFenceConfigEntity entity = service.selectById(id);
    	ElectronicFenceConfigVO vo = BeanMapper.map(entity, ElectronicFenceConfigVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<ElectronicFenceConfigVO> vos) {
        List<Long> ids = vos.stream().map(ElectronicFenceConfigVO::getId).collect(Collectors.toList());
        QueryWrapper<ElectronicFenceConfigEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                                                    BillStateEnum.PASSED_STATE.getBillStateCode(),
                                                    BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                                                    BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()});

        int num = service.count(query);
        if(num > 0) {
            return CommonResponse.error("操作失败，不能删除非自由态的单据！");
        }

        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ElectronicFenceConfigVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){
            //移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {
            //pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<ElectronicFenceConfigEntity> page = service.queryPage(param,false);
        IPage<ElectronicFenceConfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ElectronicFenceConfigVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        param.setPageIndex(1);
        param.setPageSize(-1);

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){
            //移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {
            //pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }


        List<ElectronicFenceConfigEntity> list = service.queryList(param);

        List<ElectronicFenceConfigVO> vos = BeanMapper.mapList(list, ElectronicFenceConfigVO.class);
        vos.stream().forEach(item -> {
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
            item.setEnableName(Integer.valueOf(1).equals(item.getEnable()) ? "是" : "否");
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().exportWithTrans("ElectronicFenceConfig-export.xlsx", beans, response);
    }

    /**
     * 查看项目电子围栏开启状态：0-未开启，1-已开启
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/checkProjectFenceState")
    public CommonResponse<JSONObject> checkProjectFenceState(@RequestParam Long projectId) {
        ElectronicFenceConfigEntity fence = service.getOneByProjectId(projectId, true);
        JSONObject resp = new JSONObject();
        resp.put("enableState", fence == null ? null : fence.getEnable().toString());
        return CommonResponse.success(resp);
    }

    /**
     * 查看当前
     *
     * @param projectId
     * @param destination
     * @return
     */
    @GetMapping(value = "/checkIsInFenceArea")
    public CommonResponse<JSONObject> checkIsInFenceArea(@RequestParam Long projectId, @RequestParam String destination) {
        JSONObject resp = new JSONObject();
        ElectronicFenceConfigEntity fence = service.getOneByProjectId(projectId, true);
        if(null == fence) {
            resp.put("isInFenceArea", true);
            resp.put("address", "");
            resp.put("permission", true);
            return CommonResponse.success(resp);
        }
        Integer offSiteFlag = fence.getEnable();

        QueryWrapper<ElectronicFenceConfigDetailEntity> detailQuery = new QueryWrapper<>();
        detailQuery.eq("pid", fence.getId());
        List<ElectronicFenceConfigDetailEntity> detailList = electronicFenceConfigDetailService.list(detailQuery);

        String lngLat = detailList.stream().map(ElectronicFenceConfigDetailEntity::getLngLat).collect(Collectors.joining("|"));
        List<DistanceVO> distance = amapService.distance(lngLat, destination, "0");
        logger.info("校验考勤范围--{}", JSON.toJSONString(distance, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        Map<String, DistanceVO> distanceMap = distance.stream().collect(Collectors.toMap(DistanceVO::getDistance, Function.identity(), (key1, key2) -> key2));
        BigDecimal min = distance.stream().map(d -> new BigDecimal(d.getDistance())).min(Comparator.comparing(x -> x)).orElse(null);
        DistanceVO minDistanceVO = distanceMap.get(Objects.requireNonNull(min).toString());
        ElectronicFenceConfigDetailEntity detail = detailList.get(Integer.parseInt(minDistanceVO.getOriginId()) - 1);

        // 判断是否在考勤范围
        if (new BigDecimal(minDistanceVO.getDistance()).compareTo(detail.getEffectiveRange()) < 0) {
            resp.put("isInFenceArea", true);
            resp.put("address", detail.getAddress());
            resp.put("permission", true);
            return CommonResponse.success(resp);
        } else {
            JSONObject regeo = amapService.regeo(destination);
            logger.info("校验考勤范围，逆地理编码--{}", regeo);
            String formattedAddress = regeo.getString("formatted_address");
            // 打卡地点
            resp.put("address", formattedAddress);
            // 是否是异地打卡（1:是 0：否）
            resp.put("isInFenceArea", false);

            if (offSiteFlag == 0) {
                resp.put("permission", true);
                return CommonResponse.success(resp);
            } else {
                resp.put("permission", false);
                return CommonResponse.success(resp);
            }
        }
    }
}
