package com.ejianc.business.promaterial.out.service.impl;

import com.ejianc.business.promaterial.out.vo.MonthSumDetailVO;
import com.ejianc.business.promaterial.out.vo.MonthSumVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementCollectVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.out.mapper.MonthSumMapper;
import com.ejianc.business.promaterial.out.bean.MonthSumEntity;
import com.ejianc.business.promaterial.out.service.IMonthSumService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度消耗汇总
 * 
 * @author generator
 * 
 */
@Service("monthSumService")
public class MonthSumServiceImpl extends BaseServiceImpl<MonthSumMapper, MonthSumEntity> implements IMonthSumService {
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public MonthSumVO queryDetail(Long id) {
        MonthSumEntity entity = super.selectById(id);
        MonthSumVO vo = BeanMapper.map(entity, MonthSumVO.class);
        List<MonthSumDetailVO> detailList = vo.getMonthSumDetailList();
        Map<Long, MaterialCategoryVO> categoryVOMap = new HashMap<>();
        Map<String, MonthSumDetailVO> firstMap = new HashMap<>();
        Map<String, MonthSumDetailVO> secondMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (MonthSumDetailVO detailVO : detailList) {
                MaterialCategoryVO categoryVO = null;
                if (!categoryVOMap.containsKey(detailVO.getMaterialCategoryId())) {
                    CommonResponse<MaterialCategoryVO> response = materialApi.queryCategoryById(detailVO.getMaterialCategoryId());
                    if (response.isSuccess() && null != response.getData()) {
                        categoryVO = response.getData();
                        detailVO.setMaterialCategoryCode(categoryVO.getCode());
                    }
                } else {
                    categoryVO = categoryVOMap.get(detailVO.getMaterialCategoryId());
                    detailVO.setMaterialCategoryCode(categoryVO.getCode());
                }
                categoryVOMap.put(detailVO.getMaterialCategoryId(), categoryVO);
                if (categoryVO != null) {
                    MaterialCategoryVO firstCategoryVO = null;
                    MaterialCategoryVO secondCategoryVO = null;
                    String[] parentIds = categoryVO.getInnerCode().split("\\|");
                    Long first = Long.valueOf(parentIds[0]);
                    Long second = parentIds.length > 1 ? Long.valueOf(parentIds[1]) : Long.valueOf(parentIds[0]);
                    if (!categoryVOMap.containsKey(parentIds[0])) {
                        CommonResponse<MaterialCategoryVO> response = materialApi.queryCategoryById(first);
                        if (response.isSuccess() && null != response.getData()) {
                            firstCategoryVO = response.getData();
                        }
                    } else {
                        firstCategoryVO = categoryVOMap.get(first);
                    }
                    categoryVOMap.put(first, firstCategoryVO);
                    if (!categoryVOMap.containsKey(parentIds[1])) {
                        CommonResponse<MaterialCategoryVO> response = materialApi.queryCategoryById(second);
                        if (response.isSuccess() && null != response.getData()) {
                            secondCategoryVO = response.getData();
                        }
                    } else {
                        secondCategoryVO = categoryVOMap.get(second);
                    }
                    categoryVOMap.put(second, secondCategoryVO);
                    String firstKey = first + "@" + detailVO.getUnit();
                    String secondKey = second + "@" + detailVO.getUnit();
                    if (!firstMap.containsKey(firstKey)) {
                        MonthSumDetailVO detail = new MonthSumDetailVO();
                        detail.setId(IdWorker.getId());
                        detail.setMaterialCategoryCode(firstCategoryVO.getCode());
                        detail.setMaterialCategoryName(firstCategoryVO.getName());
                        detail.setUnit(detailVO.getUnit());
                        detail.setNum(detailVO.getNum());
                        detail.setMoney(detailVO.getMoney());
                        firstMap.put(firstKey, detail);
                    } else {
                        MonthSumDetailVO detail = firstMap.get(firstKey);
                        detail.setNum(ComputeUtil.safeAdd(detail.getNum(), detailVO.getNum()));
                        detail.setMoney(ComputeUtil.safeAdd(detail.getMoney(), detailVO.getMoney()));
                        firstMap.put(firstKey, detail);
                    }
                    if (!secondMap.containsKey(secondKey)) {
                        MonthSumDetailVO detail = new MonthSumDetailVO();
                        detail.setId(IdWorker.getId());
                        detail.setMaterialCategoryCode(firstCategoryVO.getCode());
                        detail.setMaterialCategoryName(firstCategoryVO.getName());
                        detail.setUnit(detailVO.getUnit());
                        detail.setNum(detailVO.getNum());
                        detail.setMoney(detailVO.getMoney());
                        secondMap.put(secondKey, detail);
                    } else {
                        MonthSumDetailVO detail = firstMap.get(firstKey);
                        detail.setNum(ComputeUtil.safeAdd(detail.getNum(), detailVO.getNum()));
                        detail.setMoney(ComputeUtil.safeAdd(detail.getMoney(), detailVO.getMoney()));
                        secondMap.put(secondKey, detail);
                    }
                }
            }
            if (!firstMap.isEmpty()) {
                vo.setFirstCollectList(new ArrayList<>(firstMap.values()));
            }
            if (!secondMap.isEmpty()) {
                vo.setSecondCollectList(new ArrayList<>(secondMap.values()));
            }
        }
        return vo;
    }
}
