package com.ejianc.business.promaterial.utils;


import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WasteMaterialCategoryAsTree {
	
	public static List<WasteCategoryEntity> createTreeData(List<WasteCategoryEntity> list) {
		List<WasteCategoryEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, WasteCategoryEntity> listMap = new HashMap<>();
		for(WasteCategoryEntity WasteCategoryEntity:list) {
			listMap.put(WasteCategoryEntity.getId().toString(), WasteCategoryEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	WasteCategoryEntity WasteCategoryEntity = list.get(i);
        	String parentId = (WasteCategoryEntity.getParentId() != null && WasteCategoryEntity.getParentId() > 0) ? WasteCategoryEntity.getParentId().toString():"";
        	WasteCategoryEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<WasteCategoryEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(WasteCategoryEntity);
        		}else{
        			List<WasteCategoryEntity> children = new ArrayList<WasteCategoryEntity>();
        			children.add(WasteCategoryEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(WasteCategoryEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
