/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.service.impl.ConcreteCheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckImgDetailVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckVO;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"concreteCheck"})
@Api(value="\u6df7\u51dd\u571f-\u9a8c\u6536\u4e3b\u8868", tags={"\u6df7\u51dd\u571f-\u9a8c\u6536\u4e3b\u8868"})
public class ConcreteCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_TYPE = "BT220224000000004";
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/concreteCheck/card";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ConcreteCheckBpmServiceImpl concreteCheckBpmService;
    @Autowired
    private IConcreteCheckService service;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/concreteCheck/saveCheck";
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ConcreteCheckVO saveOrUpdateVO) {
        ElectronicFenceConfigEntity electronicFenceConfig = this.electronicFenceConfigService.getOneByProjectId(saveOrUpdateVO.getProjectId(), true);
        if (null != electronicFenceConfig) {
            saveOrUpdateVO.setElectronicFenceEnableStatus(electronicFenceConfig.getEnable());
            if (Integer.valueOf(0).equals(saveOrUpdateVO.getRecordFlag()) && Integer.valueOf(1).equals(electronicFenceConfig.getEnable()) && CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getConcreteCheckImgList())) {
                for (ConcreteCheckImgDetailVO checkImg : saveOrUpdateVO.getConcreteCheckImgList()) {
                    if (!Integer.valueOf(0).equals(checkImg.getAbnormalImgFlag())) continue;
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5f02\u5e38\u72b6\u6001\u7684\u9a8c\u6536\u56fe\u7247");
                }
            }
        }
        ConcreteCheckVO vo = this.service.saveOrUpdates(saveOrUpdateVO, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6839\u636e\u660e\u7ec6\u4fe1\u606f\u586b\u5145\u6570\u636e,\u8fd4\u56de")
    @RequestMapping(value={"/getDetailListData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> getDetailListData(@RequestBody ConcreteCheckVO checkVO) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.getDetailListData(checkVO));
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> pushCost(@RequestBody ConcreteCheckVO checkVO) {
        return this.service.pushCost(checkVO);
    }

    @ApiOperation(value="\u540c\u6b65\u76ee\u6807\u6210\u63a5\u53e3")
    @RequestMapping(value={"/syncCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        CheckEntity checkEntity = this.service.syncCost(id);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @GetMapping(value={"/allConcreteCheckPushTargetCost"})
    @ResponseBody
    public CommonResponse<String> allConcreteCheckPushTargetCost(@RequestParam(value="projectId", required=false) Long projectId) {
        List concreteCheckEntityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(concreteCheckEntityList = this.service.list((Wrapper)queryWrapper)))) {
            for (ConcreteCheckEntity concreteCheckEntity : concreteCheckEntityList) {
                this.service.syncCost(concreteCheckEntity.getId());
            }
        }
        this.logger.info("\u6df7\u51dd\u571f-\u9a8c\u6536\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e{}\u6761", (Object)concreteCheckEntityList.size());
        return CommonResponse.success((String)"\u6df7\u51dd\u571f-\u9a8c\u6536\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636e\u660e\u7ec6\u4fe1\u606f\u586b\u5145\u6570\u636e,\u8fd4\u56de")
    @RequestMapping(value={"/getConcreteDetailListData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> getConcreteDetailListData(@RequestBody ConcreteCheckVO checkVO) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.getConcreteDetailListData(checkVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryDetail(@RequestParam Long id) {
        ConcreteCheckVO concreteCheckVO = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)concreteCheckVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConcreteCheckVO> vos) {
        this.service.deletes(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        ConcreteCheckEntity entity = (ConcreteCheckEntity)((Object)this.service.selectById(id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u9a8c\u6536\u3002 \u8bf7\u5148\u5230\u4f9b\u5e94\u5546\u5e93\u2014\u751f\u6210\u534f\u540c\u8d26\u53f7\u518d\u8fdb\u884c\u8ba2\u5355\u64cd\u4f5c\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE, (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            SupplierPushCheckVO supplierPushCheckVO = (SupplierPushCheckVO)BeanMapper.map((Object)((Object)entity), SupplierPushCheckVO.class);
            supplierPushCheckVO.setSourceId(entity.getId());
            List<ConcreteCheckDetailEntity> concreteCheckDetailList = entity.getConcreteCheckDetailList();
            List supplierPushCheckDetailVOS = BeanMapper.mapList(concreteCheckDetailList, SupplierPushCheckDetailVO.class);
            supplierPushCheckVO.setCheckDetailList(supplierPushCheckDetailVOS);
            List checkDetailList = supplierPushCheckVO.getConcreteCheckDetailList();
            for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                supplierPushCheckDetailVO.setSourceId(entity.getId());
                supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
                supplierPushCheckDetailVO.setId(null);
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                return CommonResponse.error((String)("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg()));
            }
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            boolean pushResult = this.checkService.pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, (CooperateVO)cooperateResp.getData(), PUSH_SAVE_URL);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proMaterial/concreteCheck/card", null);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConcreteCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConcreteCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List listVo = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            listVo = BeanMapper.mapList((Iterable)list, ConcreteCheckVO.class);
            listVo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setStoreTypeName(vo.getStoreType() == 0 ? "\u6536\u6599\u5165\u5e93" : "\u76f4\u5165\u76f4\u51fa");
                vo.setSourceTypeName(vo.getSourceType() == 0 ? "\u81ea\u5236\u9a8c\u6536" : "\u8ba2\u5355\u9a8c\u6536");
                vo.setAttrFlagName(vo.getSourceType() == 1 ? "\u81ea\u8d2d\u6750" : "\u7532\u4f9b\u6750");
                vo.setRecordFlagName(vo.getSourceType() == 0 ? "\u5426" : "\u662f");
                vo.setSignStatusName(vo.getSourceType() == 0 ? "\u672a\u7b7e\u5b57" : "\u5df2\u7b7e\u5b57");
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("concrete-check-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refConcreteCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConcreteCheckVO>> refConcreteCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConcreteCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ConcreteCheckVO checkVO) {
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a7\u5236\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(checkVO));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a7\u5236\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody ConcreteCheckVO checkVO) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(checkVO, null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/queryDetailWeigh"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryDetailWeigh(@RequestBody ConcreteCheckVO vo) {
        ConcreteCheckVO concreteCheckVO = this.service.queryDetailWeigh(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)concreteCheckVO);
    }
}

