/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.plan.bean.ApplyDetailEntity;
import com.ejianc.business.promaterial.plan.bean.ApplyEntity;
import com.ejianc.business.promaterial.plan.service.IApplyService;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="apply")
public class ApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApplyService applyService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    private static final String BILL_TYPE = "BT202407000001";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(billId));
        List<ApplyDetailEntity> detailList = applyEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            MaterialInsertArchiveVO materialInsertArchiveVO = new MaterialInsertArchiveVO();
            materialInsertArchiveVO.setSourceBillId(applyEntity.getId());
            materialInsertArchiveVO.setSourceBillCode(applyEntity.getBillCode());
            materialInsertArchiveVO.setSourceBillType("\u6750\u6599\u65b0\u589e");
            HashMap<String, MaterialVO> materialVOMap = new HashMap<String, MaterialVO>();
            for (ApplyDetailEntity detailEntity : detailList) {
                MaterialVO materialVO = new MaterialVO();
                materialVO.setId(detailEntity.getId());
                materialVO.setCategoryId(detailEntity.getCategoryId());
                materialVO.setCategoryCode(detailEntity.getCategoryCode());
                materialVO.setCategoryName(detailEntity.getCategoryName());
                materialVO.setName(detailEntity.getMaterialName());
                materialVO.setCode(detailEntity.getMaterialCode());
                materialVO.setSpec(detailEntity.getSpec());
                materialVO.setUnitName(detailEntity.getUnit());
                materialVO.setUnitId(detailEntity.getUnitId());
                materialVO.setQuality(detailEntity.getQuality());
                materialVO.setOperativeNorm(detailEntity.getStandard());
                materialVOMap.put(detailEntity.getId().toString(), materialVO);
            }
            materialInsertArchiveVO.setMaterialVOMap(materialVOMap);
            this.logger.info("\u63a8\u9001\u6750\u6599\u6863\u6848\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)materialInsertArchiveVO));
            CommonResponse mapCommonResponse = this.shareMaterialApi.batchInsertArchiveBySourceBill(materialInsertArchiveVO);
            if (!mapCommonResponse.isSuccess()) {
                this.logger.info("\u751f\u6210\u6750\u6599\u6863\u6848\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)mapCommonResponse.getMsg());
                throw new BusinessException("\u751f\u6210\u6750\u6599\u6863\u6848\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

