/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.doc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import com.ejianc.business.promaterial.doc.mapper.WasteCategoryMapper;
import com.ejianc.business.promaterial.doc.mapper.WasteItemMapper;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wasteItemService")
public class WasteItemServiceImpl
extends BaseServiceImpl<WasteItemMapper, WasteItemEntity>
implements IWasteItemService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MATERIAL_BILL_CODE = "WASTE_MATERIAL_COMM";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private WasteItemMapper materialMapper;
    @Autowired
    private WasteCategoryMapper materialCategoryMapper;

    @Override
    public List<WasteItemVO> queryListByCategoryId(Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemEntity> entities = this.materialMapper.queryListByCategoryId(tenantId, categoryId);
        if (entities != null && entities.size() > 0) {
            return BeanMapper.mapList(entities, WasteItemVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.materialMapper.updateByCategoryId(tenantId, categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int i = this.materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode);
        return CommonResponse.success();
    }

    @Override
    public void updateStateByCategoryId(List<Long> categoryIds, Integer state, Long tenantId) {
        this.materialMapper.updateStateByCategoryId(tenantId, categoryIds, state);
    }

    @Override
    public WasteItemVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WasteItemEntity entity = this.materialMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (WasteItemVO)BeanMapper.map((Object)((Object)entity), WasteItemVO.class);
        }
        return null;
    }

    @Override
    public List<WasteItemVO> queryItem(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemEntity> materialEntities = this.materialMapper.queryItem(tenantId, ids);
        if (materialEntities != null && materialEntities.size() > 0) {
            return BeanMapper.mapList(materialEntities, WasteItemVO.class);
        }
        return null;
    }

    @Override
    public void update(WasteItemVO uniqueBean) {
        this.materialMapper.update(uniqueBean);
    }

    @Override
    public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemEntity> materialEntities = this.materialMapper.queryMaterialByIds(ids, tenantId);
        ArrayList list = new ArrayList();
        materialEntities.forEach(entity -> list.add(BeanMapper.map((Object)entity, WasteItemVO.class)));
        list.forEach(vo -> {
            vo.setSubjectId(subjectId);
            vo.setSubjectName(subjectName);
        });
        list.forEach(vo -> this.materialMapper.update((WasteItemVO)vo));
    }

    @Override
    public void save(WasteItemVO materialVo) {
        this.materialMapper.save(materialVo);
    }

    @Override
    public void insertBatch(List<WasteItemVO> materialVOList) {
        if (ListUtil.isNotEmpty(materialVOList)) {
            ArrayList<Object> toInsert = new ArrayList<WasteItemVO>();
            for (WasteItemVO materialVO : materialVOList) {
                if (!toInsert.isEmpty() && toInsert.size() % 500 == 0) {
                    this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(materialVO);
            }
            if (!toInsert.isEmpty()) {
                this.materialMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public void amend(Long id, Long property, String propertyName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.amend(id, property, propertyName, tenantId);
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.materialMapper.delete(tenantId, id);
        }
    }

    @Override
    public IPage<WasteItemEntity> queryPage(QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                WasteCategoryEntity categoryEntity;
                Object value;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (value = parameter.getValue()) == null || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<WasteItemEntity> records = this.materialMapper.queryList(condition);
        Long count = this.materialMapper.queryCount(condition);
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public WasteItemVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WasteItemVO materialVo = this.materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
        return materialVo;
    }

    @Override
    public List<WasteItemVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<WasteItemVO> list = this.materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
        return list;
    }

    @Override
    public WasteItemVO queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.materialMapper.queryByCode(tenantId, code);
    }

    @Override
    public List<WasteItemEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        Long tenantId = InvocationInfoProxy.getTenantid();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                WasteCategoryEntity categoryEntity;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (categoryEntity = this.materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<WasteItemEntity> records = this.materialMapper.queryExportList(condition);
        return records;
    }

    @Override
    public void insertMaterialListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.materialMapper.insertMaterialListFromPlatform(tenantId);
    }

    @Override
    public IPage<WasteItemVO> queryRefMaterialPage(Map<String, Object> params) {
        List<WasteItemEntity> dataList = this.materialMapper.queryRefMaterialList(params);
        Long dataCount = this.materialMapper.queryRefMaterialCount(params);
        List materialVOS = BeanMapper.mapList(dataList, WasteItemVO.class);
        Page page = new Page();
        page.setRecords(materialVOS);
        page.setTotal(dataCount.longValue());
        return page;
    }

    @Override
    public WasteItemEntity queryBySourceId(String sourceId) {
        return this.materialMapper.queryBySourceId(sourceId, InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<WasteItemEntity> queryMaterialByIds(List<Long> ids) {
        return this.materialMapper.queryMaterialByIds(ids, InvocationInfoProxy.getTenantid());
    }

    @Override
    public IPage<WasteItemEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
        Page page = new Page();
        if (params.containsKey("sourceOrgId") && null != params.get("sourceOrgId")) {
            List<WasteItemEntity> dataList = this.materialMapper.queryZjwjRefMaterialList(params);
            Long dataCount = this.materialMapper.queryZjwjRefMaterialCount(params);
            page.setRecords(dataList);
            page.setTotal(dataCount.longValue());
        }
        return page;
    }

    @Override
    public List<WasteItemVO> queryMaterialListByCodes(List<String> codeList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("codeList", codeList);
        List<WasteItemEntity> materialEntities = this.materialMapper.queryMaterialListByCodes(params);
        if (materialEntities != null && materialEntities.size() > 0) {
            return BeanMapper.mapList(materialEntities, WasteItemVO.class);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<Map<String, WasteItemVO>> batchInsertArchive(Map<String, WasteItemVO> materialVOMap, Long sourceBillId, String sourceBillCode, String sourceBillType) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----start" + JSONObject.toJSONString(materialVOMap));
        Map<String, WasteItemVO> resMap = materialVOMap;
        if (materialVOMap.isEmpty()) {
            throw new BusinessException("\u6279\u91cf\u63d2\u5165\u6863\u6848\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<WasteItemVO> materialVOS = new ArrayList<WasteItemVO>();
        for (Map.Entry<String, WasteItemVO> entry : materialVOMap.entrySet()) {
            WasteItemVO materialVO = entry.getValue();
            WasteCategoryEntity materialCategory = this.materialCategoryMapper.queryDetail(tenantId, materialVO.getCategoryId());
            this.logger.info("\u67e5\u8be2\u5206\u7c7b----materialCategory\uff1a" + JSONObject.toJSONString((Object)((Object)materialCategory)));
            if (materialCategory == null) {
                return CommonResponse.error((String)("\u6279\u91cf\u63d2\u5165\u6863\u6848\uff0c\u6863\u6848\u5206\u7c7b:" + materialVO.getCategoryName() + "\uff0c\u4e0d\u5b58\u5728\uff01"));
            }
            WasteItemVO vo = this.materialMapper.queryAllByTenantIdAndNameAndTypeAndSpecAndUnitName(tenantId, materialCategory.getId(), materialVO.getName(), 1, materialVO.getSpec(), materialVO.getUnitName(), materialVO.getQuality(), materialVO.getOperativeNorm());
            this.logger.info("\u67e5\u8be2count----\uff1a" + vo);
            if (null == vo) {
                String billCode = "";
                if (StringUtils.isEmpty((CharSequence)materialVO.getCode()) || "".equals(materialVO.getCode())) {
                    materialVO.setCategoryCode(materialCategory.getCode());
                    BillCodeParam billCodeParam = new BillCodeParam();
                    billCodeParam.setTenantId(tenantId);
                    billCodeParam.setRuleCode(MATERIAL_BILL_CODE);
                    billCodeParam.setBillDetail(JSONObject.parseObject((String)JSONObject.toJSONString((Object)materialVO)));
                    CommonResponse billCodeRes = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCodeRes.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    billCode = (String)billCodeRes.getData();
                } else {
                    billCode = materialVO.getCode();
                }
                this.logger.info("\u7f16\u7801billCode----\uff1a" + billCode);
                materialVO.setId(Long.valueOf(IdWorker.getId()));
                materialVO.setCategoryId(materialCategory.getId());
                materialVO.setCode(billCode);
                materialVO.setEnabled(Integer.valueOf(1));
                materialVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                materialVO.setCreateTime(new Date());
                materialVO.setTenantId(InvocationInfoProxy.getTenantid());
                materialVO.setSourceId(materialCategory.getSourceId());
                materialVO.setSystemId(materialCategory.getSystemId());
                materialVO.setCategorySourceId(materialCategory.getSourceId());
                materialVO.setCategoryName(materialCategory.getName());
                materialVO.setCategoryCode(materialCategory.getCode());
                materialVO.setBillState(Optional.ofNullable(materialVO.getBillState()).orElse(0));
                if (materialVO.getBillState() == 0) {
                    materialVO.setSourceBillId(sourceBillId);
                    materialVO.setSourceBillCode(sourceBillCode);
                    materialVO.setSourceBillType(sourceBillType);
                }
                materialVOS.add(materialVO);
                entry.setValue(materialVO);
                resMap.put(entry.getKey(), materialVO);
                continue;
            }
            resMap.put(entry.getKey(), vo);
        }
        if (CollectionUtils.isNotEmpty(materialVOS)) {
            this.materialMapper.insertBatch1(tenantId, materialVOS);
        }
        stopwatch.stop();
        this.logger.info("\u6821\u9a8c\u6863\u6848\u662f\u5426\u5b58\u5728----end\uff1a\u5df2\u5904\u7406\u8bbe\u5907\u6863\u6848\u3010{}\u3011\u6761\u6570\u636e\uff0c\u5171\u7528\u65f6\u3010{}\u3011\u6beb\u79d2", (Object)(materialVOMap.isEmpty() ? 0 : materialVOMap.size()), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.logger.info("\u67e5\u8be2\u7ed3\u679c----resMap\uff1a" + JSONObject.toJSONString(resMap));
        return CommonResponse.success(resMap);
    }

    @Override
    public void allowIn(List<Long> ids) {
        this.materialMapper.allowIn(InvocationInfoProxy.getTenantid(), ids);
    }

    @Override
    public List<Map<String, Object>> queryUnit(Set<String> unitNameList) {
        return this.materialMapper.queryUnit(InvocationInfoProxy.getTenantid(), unitNameList);
    }

    @Override
    public void batchUpdateArchiveSourceInfo(List<Long> materialIds, Long sourceBillId, String sourceBillCode) {
        List<WasteItemEntity> materialList = this.materialMapper.queryMaterialByIds(materialIds, InvocationInfoProxy.getTenantid());
        if (CollectionUtils.isNotEmpty(materialList)) {
            materialList.stream().filter(item -> null != item.getSourceBillId()).forEach(item -> {
                item.setSourceBillId(sourceBillId);
                item.setSourceBillCode(sourceBillCode);
                this.materialMapper.update((WasteItemVO)BeanMapper.map((Object)item, WasteItemVO.class));
            });
        }
    }
}

