/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.scrap.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.scrap.bean.ScrapMaterialApplicationEntity;
import com.ejianc.business.promaterial.scrap.bean.ScrapMaterialApplicationManifestContentEntity;
import com.ejianc.business.promaterial.scrap.service.IScrapMaterialApplicationService;
import com.ejianc.business.promaterial.scrap.vo.ScrapMaterialApplicationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scrapMaterialApplication"})
public class ScrapMaterialApplicationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCRAP_MATERIAL_APPLICATION";
    @Autowired
    private IScrapMaterialApplicationService service;
    @Autowired
    private SessionManager sessionManager;
    private BigDecimal estimatedAmount;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ScrapMaterialApplicationVO> saveOrUpdate(@RequestBody ScrapMaterialApplicationVO saveOrUpdateVO) {
        ScrapMaterialApplicationEntity entity = (ScrapMaterialApplicationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ScrapMaterialApplicationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<ScrapMaterialApplicationManifestContentEntity> scrapMaterialApplicationManifestContentList = entity.getScrapMaterialApplicationManifestContentList();
        this.estimatedAmount = BigDecimal.ZERO;
        scrapMaterialApplicationManifestContentList.forEach(item -> {
            this.estimatedAmount = this.estimatedAmount.add(item.getEstimateMny());
        });
        entity.setEstimatedAmount(this.estimatedAmount);
        if (!(entity.getPricingType() != 3 && entity.getPricingType() != 4 || entity.getScrapMaterialApplicationInviteContentList() != null && entity.getScrapMaterialApplicationInviteContentList().size() >= 3)) {
            throw new BusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e09\u4e2a\u62df\u9080\u8bf7\u5355\u4f4d");
        }
        if (entity.getIsUsed() == null) {
            entity.setIsUsed(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ScrapMaterialApplicationVO vo = (ScrapMaterialApplicationVO)BeanMapper.map((Object)((Object)entity), ScrapMaterialApplicationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ScrapMaterialApplicationVO> queryDetail(Long id) {
        ScrapMaterialApplicationEntity entity = (ScrapMaterialApplicationEntity)((Object)this.service.selectById(id));
        ScrapMaterialApplicationVO vo = (ScrapMaterialApplicationVO)BeanMapper.map((Object)((Object)entity), ScrapMaterialApplicationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScrapMaterialApplicationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ScrapMaterialApplicationVO scrapMaterialApplicationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ScrapMaterialApplicationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("mainMaterialName");
        fuzzyFields.add("compiler");
        fuzzyFields.add("applyTime");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScrapMaterialApplicationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("mainMaterialName");
        fuzzyFields.add("scrapTypeName");
        fuzzyFields.add("compiler");
        fuzzyFields.add("applyTime");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ScrapMaterialApplicationVO.class);
            list.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                if (e.getScrapType() == 0) {
                    e.setScrapTypeName("\u6bc1\u635f\u65e0\u6cd5\u4f7f\u7528\u6750\u6599");
                } else if (e.getScrapType() == 1) {
                    e.setScrapTypeName("\u62c6\u9664\u4fee\u7406\u65e7\u6750\u6599\u914d\u4ef6");
                } else if (e.getScrapType() == 2) {
                    e.setScrapTypeName("\u5404\u7c7b\u5305\u88c5\u7269\u54c1");
                } else if (e.getScrapType() == 3) {
                    e.setScrapTypeName("\u95f2\u7f6e\u65e0\u6cd5\u8c03\u5242\u7269\u8d44");
                } else if (e.getScrapType() == 4) {
                    e.setScrapTypeName("\u5176\u4ed6\u5e9f\u65e7\u7269\u8d44");
                }
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("ScrapMaterialApplication-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refScrapMaterialApplicationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ScrapMaterialApplicationVO>> refScrapMaterialApplicationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("isUsed", new Parameter("ne", (Object)99));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ScrapMaterialApplicationVO.class));
        pageData.getRecords().forEach(e -> {
            if (e.getIsUsed() == 1) {
                e.setIsUsedName("\u5df2\u4f7f\u7528");
            } else {
                e.setIsUsedName("\u672a\u4f7f\u7528");
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

