/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.BatPlanMapper;
import com.ejianc.business.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckCodeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="batPlanService")
public class BatPlanServiceImpl
extends BaseServiceImpl<BatPlanMapper, BatPlanEntity>
implements IBatPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONDITION_TRUSTEES_ID = "employeeId";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    private static final String BILL_CODE = "PARCEL_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IBatPlanDetailService batPlanDetailService;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PLAN_MNY_PARAM_CODE = "P-3n03G60227";
    private static final String PLAN_NUM_PARAM_CODE = "P-IT32wl0228";

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public BatPlanVO saveOrUpdateByVo(BatPlanVO batPlanVO) {
        BatPlanEntity entity;
        CommonResponse orgResponse;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)batPlanVO.getParentOrgCode()) && batPlanVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(batPlanVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            batPlanVO.setParentOrgCode(orgVO.getCode());
        }
        if ((entity = (BatPlanEntity)((Object)BeanMapper.map((Object)batPlanVO, BatPlanEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)batPlanVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getPlanState() == null) {
            entity.setPlanState(BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
        }
        super.saveOrUpdate((Object)entity, false);
        return this.copyVoByEntity(entity);
    }

    @Override
    public BatPlanVO queryBatPlanDetailById(Long id) {
        BatPlanEntity entity = (BatPlanEntity)((Object)super.selectById((Serializable)id));
        return this.copyVoByEntity(entity);
    }

    @Override
    public IPage<BatPlanVO> queryBatPlanPage(QueryParam param) {
        this.setDefaultParam(param);
        return this.queryBatPlanVO(param);
    }

    @Override
    public List<BatPlanVO> excelExportBatPlan(QueryParam param) {
        this.setDefaultParam(param);
        param.setPageIndex(1);
        param.setPageSize(10000);
        List entityList = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            List list = BeanMapper.mapList((Iterable)entityList, BatPlanVO.class);
            for (BatPlanVO vo : list) {
                vo.setBillStateName(this.getBillStateName(vo.getBillState()));
                vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
            }
            return list;
        }
        return new ArrayList<BatPlanVO>();
    }

    @Override
    public IPage<BatPlanVO> refBatPlanData(QueryParam param, String condition, String searchObject) {
        IPage<BatPlanVO> pageData;
        this.setDefaultParam(param);
        param.getParams().put("planState", new Parameter("eq", (Object)BatPlanEnum.PLAN_STATE_WAIT.getPlanState()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)searchObject)) {
            param.setSearchObject(null);
            JSONObject searchJson = JSONObject.parseObject((String)searchObject);
            this.logger.info("\u53c2\u7167\u67e5\u8be2searchObject\uff1a\u3010{}\u3011", (Object)searchJson);
            if (searchJson != null && !searchJson.isEmpty()) {
                for (Map.Entry entry : searchJson.entrySet()) {
                    param.getParams().put(entry.getKey(), new Parameter("like", entry.getValue()));
                }
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("\u53c2\u7167\u67e5\u8be2condition\uff1a\u3010{}\u3011", (Object)_con);
            if (_con.containsKey((Object)CONDITION_TRUSTEES_ID)) {
                param.getParams().put("trusteesId", new Parameter("eq", _con.get((Object)CONDITION_TRUSTEES_ID)));
            }
            if (_con.containsKey((Object)CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get((Object)CONDITION_PROJECT_ID).toString());
                CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put(CONDITION_PROJECT_ID, new Parameter("in", projectResponse.getData()));
            }
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageData = this.queryBatPlanVO(param)).getRecords())) {
            List batPlanVOList = pageData.getRecords();
            List idList = batPlanVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter("in", idList));
            List detailEntityList = this.batPlanDetailService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, BatPlanDetailVO.class);
            HashMap detailMap = new HashMap();
            for (BatPlanDetailVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPlanId())) {
                    ((List)detailMap.get(vo.getPlanId())).add(vo);
                    continue;
                }
                ArrayList<BatPlanDetailVO> mapList = new ArrayList<BatPlanDetailVO>();
                mapList.add(vo);
                detailMap.put(vo.getPlanId(), mapList);
            }
            batPlanVOList.forEach(batPlanVO -> batPlanVO.setBatPlanDetailList((List)detailMap.get(batPlanVO.getId())));
        }
        return pageData;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)BatPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (BatPlanEntity entity : entityList) {
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }

    @Override
    public List<DefdocDetailVO> refPurchaseDate() {
        CommonResponse zzcRes;
        String wzDefCode = "pro-supply-material-supply-content";
        String zzcDefCode = "pro-supply-revolving-materials-supply-content";
        ArrayList<DefdocDetailVO> list = new ArrayList<DefdocDetailVO>();
        CommonResponse wzRes = this.defdocApi.getDefDocByDefCode(wzDefCode);
        if (wzRes.isSuccess()) {
            list.addAll((Collection)wzRes.getData());
        }
        if ((zzcRes = this.defdocApi.getDefDocByDefCode(zzcDefCode)).isSuccess()) {
            list.addAll((Collection)zzcRes.getData());
        }
        return list;
    }

    @Override
    public ParamsCheckVO checkParams(BatPlanVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMasterPlanMny(vo));
        paramsCheckVOS.addAll(this.checkParamsByMasterPlanNum(vo));
        ParamsCheckVO priceParam = this.priceCheckParams(vo);
        if (priceParam != null) {
            paramsCheckVOS.add(priceParam);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO priceCheckParams(BatPlanVO batPlanVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)batPlanVO.getBatPlanDetailList())) {
            for (BatPlanDetailVO detailVO : batPlanVO.getBatPlanDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(batPlanVO.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        String MAX_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u6279\u6b21\u8ba1\u5212\u6700\u9ad8\u4ef7.getCode();
        String MIN_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u6279\u6b21\u8ba1\u5212\u6700\u4f4e\u4ef7.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        CommonResponse minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE, orgId);
        if (!minParamByCode.isSuccess() && null == minParamByCode.getData()) {
            this.logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u6750\u6599\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u6750\u6599\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode()));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6750\u6599\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5355\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6750\u6599\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public List<ParamsCheckVO> checkParamsByMasterPlanMny(BatPlanVO vo) {
        CommonResponse billParamByCode;
        BigDecimal temporaryMoney;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        BigDecimal totalMoney = temporaryMoney = vo.getTemporaryMoney() == null ? BigDecimal.ZERO : vo.getTemporaryMoney();
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(MasterPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        List planList = this.masterPlanService.list((Wrapper)planLambda);
        if (!CollectionUtils.isNotEmpty((Collection)planList)) {
            return paramsCheckVOS;
        }
        BigDecimal planTaxMny = planList.stream().filter(e -> e.getTotalPlanAmt() != null).map(MasterPlanEntity::getTotalPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(BatPlanEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.in(BatPlanEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)Lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            totalMoney = list.stream().filter(e -> e.getTemporaryMoney() != null).map(BatPlanEntity::getTemporaryMoney).reduce(totalMoney, BigDecimal::add);
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PLAN_MNY_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u91d1\u989d\u63a7\u5236\u6279\u6b21\u8ba1\u5212\u91d1\u989d\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6279\u6b21\u8ba1\u5212\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u91d1\u989d\u5927\u4e8e\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u6279\u6b21\u8ba1\u5212\u91d1\u989d\uff1a").append(temporaryMoney.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    public List<ParamsCheckVO> checkParamsByMasterPlanNum(BatPlanVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(MasterPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        List planList = this.masterPlanService.list((Wrapper)planLambda);
        if (CollectionUtils.isEmpty((Collection)planList)) {
            return paramsCheckVOS;
        }
        List<MasterPlanDetailEntity> masterPlanDetailList = ((MasterPlanEntity)((Object)this.masterPlanService.selectById(((MasterPlanEntity)((Object)planList.get(0))).getId()))).getMasterPlanDetailList();
        List<BatPlanDetailEntity> detailEntityList = ((BatPlanMapper)this.baseMapper).getBatPlanDetailNumByProjectId(vo.getProjectId());
        Map<Object, Object> batPlanTypeMap = new HashMap();
        Map<Object, Object> batPlanDocMap = new HashMap();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            batPlanDocMap = detailEntityList.stream().filter(e -> null != e.getMaterialId()).collect(Collectors.toMap(BatPlanDetailEntity::getMaterialId, BatPlanDetailEntity::getNum, (key1, key2) -> key2));
            batPlanTypeMap = detailEntityList.stream().filter(e -> null == e.getMaterialId()).collect(Collectors.toMap(BatPlanDetailEntity::getMaterialTypeId, BatPlanDetailEntity::getNum, (key1, key2) -> key2));
        }
        Map<Long, BigDecimal> masterPlanTypeMap = masterPlanDetailList.stream().filter(t -> null == t.getMaterialId() && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialCategoryId, MasterPlanDetailEntity::getNum, (key1, key2) -> key2));
        Map<Long, BigDecimal> masterPlanDocMny = masterPlanDetailList.stream().filter(t -> null != t.getMaterialId() && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, MasterPlanDetailEntity::getNum, (key1, key2) -> key2));
        List detailList = vo.getBatPlanDetailList();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PLAN_NUM_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u6e05\u5355\u91cf\u63a7\u5236\u6279\u6b21\u8ba1\u5212\u6e05\u5355\u91cf\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                        for (BatPlanDetailVO detailVO : detailList) {
                            BigDecimal comNum = BigDecimal.ZERO;
                            BigDecimal totalNum = BigDecimal.ZERO;
                            if (masterPlanDocMny.containsKey(detailVO.getMaterialId())) {
                                comNum = masterPlanDocMny.get(detailVO.getMaterialId());
                                totalNum = ComputeUtil.safeAdd((BigDecimal)(batPlanDocMap.containsKey(detailVO.getMaterialId()) ? (BigDecimal)batPlanDocMap.get(detailVO.getMaterialId()) : BigDecimal.ZERO), (BigDecimal)detailVO.getNum());
                            } else {
                                if (!masterPlanTypeMap.containsKey(detailVO.getMaterialTypeId())) continue;
                                comNum = masterPlanDocMny.get(detailVO.getMaterialTypeId());
                                totalNum = ComputeUtil.safeAdd((BigDecimal)(batPlanTypeMap.containsKey(detailVO.getMaterialTypeId()) ? (BigDecimal)batPlanTypeMap.get(detailVO.getMaterialTypeId()) : BigDecimal.ZERO), (BigDecimal)detailVO.getNum());
                            }
                            comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)comNum, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            this.logger.info("materialName-{}\uff0cmaterialTypeName-{}\uff0ccomNum-{},totalNum-{}", new Object[]{detailVO.getMaterialName(), detailVO.getMaterialTypeName(), comNum, totalNum});
                            if (totalNum.compareTo(comNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailVO.getMaterialName()) ? detailVO.getMaterialName() : detailVO.getMaterialTypeName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnName("\u6279\u6b21\u8ba1\u5212\u6e05\u5355\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6e05\u5355\u6570\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailVO.getMaterialName()) ? detailVO.getMaterialName() : detailVO.getMaterialTypeName()).append(detailVO.getSpec() == null ? "" : " " + detailVO.getSpec()).append(" ").append("\u672c\u6b21\u6279\u6b21\u8ba1\u5212\u6570\u91cf\uff1a").append(detailVO.getNum().setScale(4, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u6279\u6b21\u8ba1\u5212\u6570\u91cf\uff1a").append(totalNum.setScale(4, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%:").append(comNum.setScale(4, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalNum, (BigDecimal)comNum).setScale(4, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                            this.logger.info("checkDsVOS-{}", (Object)JSONObject.toJSONString(checkDsVOS));
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    private IPage<BatPlanVO> queryBatPlanVO(QueryParam param) {
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List batPlanVOList = BeanMapper.mapList((Iterable)page.getRecords(), BatPlanVO.class);
        for (BatPlanVO vo : batPlanVOList) {
            vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
        }
        pageData.setRecords(batPlanVOList);
        return pageData;
    }

    private void setDefaultParam(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("trusteesName");
        fuzzyFields.add("purchaseName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResponse = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgResponse.getData();
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(CONDITION_ORG_ID, new Parameter("in", departmentIds));
        }
    }

    private BatPlanVO copyVoByEntity(BatPlanEntity entity) {
        BatPlanVO vo = (BatPlanVO)BeanMapper.map((Object)((Object)entity), BatPlanVO.class);
        vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
        return vo;
    }

    private String getBillStateName(Integer billState) {
        String billStateName = null;
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u81ea\u7531\u6001";
        } else if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5df2\u63d0\u4ea4";
        } else if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6838\u4e2d";
        } else if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6279\u901a\u8fc7";
        } else if (BillStateEnum.UNAPPROVED.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6279\u9a73\u56de";
        } else if (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6838\u4e2d";
        }
        return billStateName;
    }
}

