package com.ejianc.business.promaterial.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckAdmixtureEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckAdmixtureVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryAdmixtureEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryAdmixtureService;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.*;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 混凝土-发货主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("concreteDelivery")
@Api(value = "混凝土-发货主表", tags = {"混凝土-发货主表"})
public class ConcreteDeliveryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "HNT-DELIVERY-CODE";//此处需要根据实际修改

    @Autowired
    private IConcreteDeliveryService service;
    @Autowired
    private IConcreteDeliveryAdmixtureService concreteDeliveryAdmixtureService;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteDeliverySaveVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ConcreteDeliverySaveVO saveOrUpdateVO) {
        ConcreteDeliverySaveVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("供方推送发货单接口")
    @RequestMapping(value = "/supplierPushDelivery", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteDeliveryVO> supplierPushDelivery(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ConcreteDeliveryVO saveOrUpdateVO) {
        String dataInfo = JSONObject.toJSONString(saveOrUpdateVO);
        logger.info("混凝土供方推送的数据:"+dataInfo);
        ConcreteDeliveryVO vo= service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("重新推送第三方失败数据接口")
    @RequestMapping(value = "/PushThirdData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConcreteDeliveryVO> savePushThirdData(@RequestParam Long id) {
        ConcreteDeliveryVO vo= service.savePushThirdData(id);
        return CommonResponse.success(vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConcreteDeliverySaveVO> queryDetail(@RequestParam Long id) {
        ConcreteDeliverySaveVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("查询详情(验收用)")
    @RequestMapping(value = "/queryDetailToCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryDetailToCheck(@RequestParam Long id) {
        ConcreteCheckVO vo = service.queryDetailToCheck(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("发货单关闭接口")
    @RequestMapping(value = "/closeDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConcreteDeliveryVO> closeDelivery(@RequestParam Long id) {
        ConcreteDeliveryVO vo = service.closeDelivery(id);
        return CommonResponse.success("发货单关闭成功！",vo);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConcreteDeliverySaveVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ConcreteDeliverySaveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ConcreteDeliverySaveVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConcreteDeliveryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> checkStatusList = new ArrayList<>();
        checkStatusList.add(0);
        checkStatusList.add(1);
        param.getParams().put("checkStatus", new Parameter(QueryParam.IN,checkStatusList));
//        param.getParams().put("closeFlag", new Parameter(QueryParam.EQ,0));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ConcreteDeliveryEntity> page = service.queryPage(param,false);
        IPage<ConcreteDeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ConcreteDeliveryVO> deliveryVOS = BeanMapper.mapList(page.getRecords(), ConcreteDeliveryVO.class);
        List<Long> collect = deliveryVOS.stream().map(ConcreteDeliveryVO::getId).collect(Collectors.toList());
        Map<Long, WeighbillVO> weighbillVOMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(collect)){
            CommonResponse<List<WeighbillVO>> listCommonResponse = weighbillApi.queryWeighBydeliveryId(collect);
            if(listCommonResponse.isSuccess()){
                List<WeighbillVO> data = listCommonResponse.getData();
                logger.info("查询磅单数量结果：{}",JSONObject.toJSONString(data));
                if(CollectionUtils.isNotEmpty(data)){
                    weighbillVOMap = data.stream().collect(Collectors.toMap(WeighbillVO::getDeliveryId, Function.identity()));
                }
                for (ConcreteDeliveryVO deliveryVO : deliveryVOS) {
                    WeighbillVO weighbillVOS = weighbillVOMap.get(deliveryVO.getId());
                    if(null!=weighbillVOS){
                        deliveryVO.setCheckWeighNum(weighbillVOS.getWeightCheckNum());
                        deliveryVO.setWeighNum(weighbillVOS.getWeightNum());
                    }else {
                        deliveryVO.setCheckWeighNum(0);
                        deliveryVO.setWeighNum(0);
                    }
                }
            }
        }
  		pageData.setRecords(deliveryVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConcreteDeliveryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConcreteDelivery-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refConcreteDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConcreteDeliveryVO>> refConcreteDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConcreteDeliveryEntity> page = service.queryPage(param,false);
        IPage<ConcreteDeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConcreteDeliveryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
