/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.plan.vo.MasterPlanContrastV0;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckCodeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="masterPlanService")
public class MasterPlanServiceImpl
extends BaseServiceImpl<MasterPlanMapper, MasterPlanEntity>
implements IMasterPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MasterPlanMapper masterPlanMapper;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE_C = "MASTER_PLAN";
    private static final String BILL_CODE_H = "HNTZJH";

    @Override
    public MasterPlanVO queryByCode(String planCode, Integer planType) {
        MasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plan_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"plan_type", (Object)planType);
        MasterPlanEntity entity = (MasterPlanEntity)((Object)this.masterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MasterPlanVO)BeanMapper.map((Object)((Object)entity), MasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MasterPlanVO queryByProjectId(Long projectId, Integer planType) {
        MasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"plan_type", (Object)planType);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MasterPlanEntity entity = (MasterPlanEntity)((Object)this.masterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MasterPlanVO)BeanMapper.map((Object)((Object)entity), MasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public CommonResponse<MasterPlanVO> saveOrUpdateMasterPlan(MasterPlanVO masterPlanVo, Boolean isControl) {
        MasterPlanVO voByProject;
        if (!isControl.booleanValue()) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)masterPlanVo.getPlanCode())) {
                MasterPlanVO voByCode = this.queryByCode(masterPlanVo.getPlanCode(), masterPlanVo.getPlanType());
                if (!(null == voByCode || null != masterPlanVo.getId() && voByCode.getId().equals(masterPlanVo.getId()))) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
                }
            } else {
                String BILL_CODE = "";
                switch (masterPlanVo.getPlanType()) {
                    case 0: {
                        BILL_CODE = BILL_CODE_C;
                        break;
                    }
                    case 1: {
                        BILL_CODE = BILL_CODE_H;
                    }
                }
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)masterPlanVo);
                CommonResponse codeResp = this.billCodeApi.generateBillCode(billCodeParam);
                if (!codeResp.isSuccess()) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
                }
                masterPlanVo.setPlanCode((String)codeResp.getData());
            }
        }
        if (!(null == (voByProject = this.queryByProjectId(masterPlanVo.getProjectId(), masterPlanVo.getPlanType())) || null != masterPlanVo.getId() && voByProject.getId().equals(masterPlanVo.getId()))) {
            String msg = "";
            switch (masterPlanVo.getPlanType()) {
                case 0: {
                    msg = "\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u6d88\u8017\u6750\u603b\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01";
                    break;
                }
                case 1: {
                    msg = "\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u6df7\u51dd\u571f\u603b\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01";
                }
            }
            throw new BusinessException(msg);
        }
        UserContext userContext = this.sessionManager.getUserContext();
        MasterPlanEntity saveEntity = null;
        if (null == masterPlanVo.getId()) {
            saveEntity = (MasterPlanEntity)((Object)BeanMapper.map((Object)masterPlanVo, MasterPlanEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setChangeState(0);
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(1);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (MasterPlanEntity)((Object)BeanMapper.map((Object)masterPlanVo, MasterPlanEntity.class));
        }
        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)saveEntity, false);
            List<MasterPlanDetailEntity> changeDetailEntities = saveEntity.getMasterPlanDetailList();
            if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
                HashMap<String, Long> idMap = new HashMap<String, Long>();
                for (MasterPlanDetailEntity cdEntity : changeDetailEntities) {
                    cdEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
                    idMap.put(cdEntity.getTid(), cdEntity.getId());
                }
                for (MasterPlanDetailEntity cdEntity : changeDetailEntities) {
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
                }
                List resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
                List treeData = ResultAsTree.createTreeData((List)resultMapList);
                List<Map<String, Object>> ListCodeDate = this.creatInnerCode(treeData, null);
                ArrayList<MasterPlanDetailEntity> saveEntities = new ArrayList<MasterPlanDetailEntity>();
                this.treeToList(ListCodeDate, saveEntities);
                if (!isControl.booleanValue()) {
                    this.masterPlanDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
                }
            }
        }
        MasterPlanVO masterPlanVO = (MasterPlanVO)BeanMapper.map((Object)((Object)saveEntity), MasterPlanVO.class);
        if (!isControl.booleanValue()) {
            String billType;
            String linkUrl;
            String frontendBaseHost = "";
            frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
            if (masterPlanVO.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + masterPlanVO.getId();
                billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + masterPlanVO.getId();
                billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
            }
            ExecutionVO executionVO = this.targetCost(masterPlanVO, linkUrl, billType, masterPlanVO.getPlanType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSONObject.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)this.queryDetail(saveEntity.getId(), true));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)masterPlanVO);
    }

    @Override
    public MasterPlanVO queryDetail(Long id, boolean detailHasChildren) {
        MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)super.selectById((Serializable)id));
        MasterPlanVO masterPlanVO = (MasterPlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), MasterPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.masterPlanDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62\u9879.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (MasterPlanDetailEntity cdEntity : detailEntityList) {
                if (cdEntity.getMaterialId() == null) {
                    cdEntity.setTid(cdEntity.getMaterialCategoryId().toString());
                    cdEntity.setTpid("999");
                } else {
                    cdEntity.setTid(cdEntity.getMaterialId().toString());
                    cdEntity.setTpid(cdEntity.getMaterialCategoryId().toString());
                }
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class);
            if (detailHasChildren) {
                masterPlanVO.setMasterPlanDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                masterPlanVO.setMasterPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class));
        }
        if (null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0) {
            masterPlanVO.setMasterPlanChangeHisList(this.masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;
    }

    @Override
    public List<MasterPlanContrastV0> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId) {
        return this.masterPlanMapper.getContrastInfo(materialMasterPlanId, oldMaterialMasterPlanId);
    }

    @Override
    public ExecutionVO targetCost(MasterPlanVO masterPlanVO, String linkUrl, String billType, Integer planType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(masterPlanVO.getId());
        totalVO.setTenantId(masterPlanVO.getTenantId());
        totalVO.setBillCode(masterPlanVO.getPlanCode());
        if (planType == 0) {
            totalVO.setBussinessType(BussinessTypeEnum.\u6750\u6599\u603b\u8ba1\u5212.getCode());
        } else {
            totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode());
        }
        totalVO.setBillType(billType);
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(masterPlanVO.getProjectId());
        totalVO.setOrgId(masterPlanVO.getOrgId());
        totalVO.setMoney(masterPlanVO.getTotalPlanAmt());
        totalVO.setTaxMoney(masterPlanVO.getTotalPlanAmt());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(masterPlanVO.getBillDate() == null ? null : masterPlanVO.getBillDate().toString());
        List masterPlanDetailList = masterPlanVO.getMasterPlanDetailList();
        if (!billType.equals(BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode()) && !billType.equals(BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode())) {
            totalVO.setLastSourceId(masterPlanVO.getSourcePlanId());
        }
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailList)) {
            masterPlanDetailList.forEach(entity -> {
                if (null == entity.getChangeType() || 2 != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        for (MasterPlanDetailVO planDetailVO : detailEntityList) {
            if (planDetailVO.getRowState() != null && planDetailVO.getRowState().equals("del")) continue;
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
            detailExecutionVO.setSourceBillId(masterPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialCategoryId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialCategoryName());
            if (planDetailVO.getMaterialId() == null) {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                detailExecutionVO.setDocId(planDetailVO.getMaterialCategoryId());
            } else {
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(planDetailVO.getMaterialId());
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialCategoryId()).getData();
            if (categoryVO == null) {
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            } else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setUnitId(planDetailVO.getUnitId());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getAmount());
            detailExecutionVO.setSpec(planDetailVO.getSpec());
            detailExecutionVO.setTaxMoney(planDetailVO.getAmount());
            detailExecutionVO.setPrice(planDetailVO.getPrice());
            detailExecutionVO.setTaxPrice(planDetailVO.getPrice());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = this.creatInnerCode((List)ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
                continue;
            }
            ypd.put("leafFlag", true);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<MasterPlanDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((MasterPlanDetailEntity)((Object)BeanMapper.map(ypd, MasterPlanDetailEntity.class)));
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(MasterPlanVO masterPlanVO) {
        String billType;
        String linkUrl;
        CommonResponse<MasterPlanVO> masterPlanVOCommonResponse = this.saveOrUpdateMasterPlan(masterPlanVO, true);
        MasterPlanVO planVO = (MasterPlanVO)masterPlanVOCommonResponse.getData();
        String frontendBaseHost = "";
        frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        if (masterPlanVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
        }
        ExecutionVO executionVO = this.targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u6570\u636e" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.checkParams(planVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    public ParamsCheckVO checkParams(MasterPlanVO masterPlanVO, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        ParamsCheckVO priceParam = this.priceCheckParams(masterPlanVO);
        if (priceParam != null) {
            paramsCheckVOS.add(priceParam);
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO priceCheckParams(MasterPlanVO masterPlanVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)masterPlanVO.getMasterPlanDetailList())) {
            for (MasterPlanDetailVO detailVO : masterPlanVO.getMasterPlanDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(masterPlanVO.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        String MAX_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u603b\u8ba1\u5212\u6700\u9ad8\u4ef7.getCode();
        String MIN_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u603b\u8ba1\u5212\u6700\u4f4e\u4ef7.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        CommonResponse minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE, orgId);
        if (!minParamByCode.isSuccess() && null == minParamByCode.getData()) {
            this.logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u6750\u6599\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u6750\u6599\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode()));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        Integer priorityFlag = ((PriceDepotParamSetDTO)data.get(0)).getPriorityFlag();
        if (null != priorityFlag && 2 == priorityFlag) {
            flag = false;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6750\u6599\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = "";
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName("\u6750\u6599\u5355\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u6750\u6599\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        String billType;
        String linkUrl;
        MasterPlanVO planVO = this.queryDetail(id, true);
        String frontendBaseHost = "";
        frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        if (planVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
        }
        ExecutionVO executionVO = this.targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u6570\u636e" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = (ParamsCheckVO)response.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        ExecutionVO executionVO;
        MasterPlanVO planVO = this.queryDetail(id, true);
        Boolean flag = true;
        String frontendBaseHost = "";
        frontendBaseHost = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"source_plan_id", (Object)id)).eq((Object)"dr", (Object)0)).orderByDesc((Object)"change_version");
        List list = this.masterPlanChangeService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            String billType;
            String linkUrl;
            flag = false;
            MasterPlanChangeEntity masterPlanChangeEntity = (MasterPlanChangeEntity)((Object)list.get(0));
            if (masterPlanChangeEntity.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + masterPlanChangeEntity.getId();
                billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + masterPlanChangeEntity.getId();
                billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
            }
            executionVO = this.targetCost((MasterPlanVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), MasterPlanVO.class), linkUrl, billType, masterPlanChangeEntity.getPlanType());
        } else {
            String billType;
            String linkUrl;
            flag = true;
            if (planVO.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
                billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
                billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
            }
            executionVO = this.targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\u7c7b\u578b" + (flag != false ? "\u539f\u8ba1\u5212" : "\u53d8\u66f4\u8ba1\u5212"));
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }
}

