package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeHisEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailChangeHisService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeHisVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailChangeHisVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.MasterPlanChangeHisMapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeHisEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeHisService;

import java.util.ArrayList;
import java.util.List;

/**
 * 消耗材总计划变更记录
 * 
 * @author generator
 * 
 */
@Service("masterPlanChangeHisService")
public class MasterPlanChangeHisServiceImpl extends BaseServiceImpl<MasterPlanChangeHisMapper, MasterPlanChangeHisEntity> implements IMasterPlanChangeHisService{

    @Autowired
    private IMasterPlanDetailChangeHisService planDetailChangeHisService;

    @Override
    public MasterPlanChangeHisVO queryDetail(Long id, boolean detailHasChildren) {
        LambdaQueryWrapper<MasterPlanChangeHisEntity> lambda = Wrappers.<MasterPlanChangeHisEntity>lambdaQuery();
        lambda.eq(MasterPlanChangeHisEntity::getChangePlanId, id);
        MasterPlanChangeHisEntity one = this.getOne(lambda);
        MasterPlanChangeHisVO planChangeHisVO = BeanMapper.map(one, MasterPlanChangeHisVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, one.getId()));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MasterPlanDetailChangeHisEntity> detailEntityListDb = planDetailChangeHisService.queryList(queryParam, false);
        List<MasterPlanDetailChangeHisEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MasterPlanDetailChangeHisEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("add");
            }
            List<MasterPlanDetailChangeHisVO> resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailChangeHisVO.class);
            if(detailHasChildren){
                planChangeHisVO.setMasterPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                planChangeHisVO.setMasterPlanDetailList(resultMapList);
            }
        } else {
            planChangeHisVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailChangeHisVO.class));
        }
        return planChangeHisVO;
    }
}
