package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.service.impl.ConcreteCheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckImgDetailVO;
import com.ejianc.business.promaterial.check.vo.ConcreteCheckVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckVO;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 混凝土-验收主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("concreteCheck")
@Api(value = "混凝土-验收主表", tags = {"混凝土-验收主表"})
public class ConcreteCheckController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final String BILL_TYPE = "BT220224000000004";//此处需要根据实际修改
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/concreteCheck/card";


    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ConcreteCheckBpmServiceImpl concreteCheckBpmService;


    @Autowired
    private IConcreteCheckService service;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/concreteCheck/saveCheck";
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody ConcreteCheckVO saveOrUpdateVO) {
        //获取项目电子开启状态
        ElectronicFenceConfigEntity electronicFenceConfig = electronicFenceConfigService.getOneByProjectId(saveOrUpdateVO.getProjectId(), true);
        if(null != electronicFenceConfig) {
            saveOrUpdateVO.setElectronicFenceEnableStatus(electronicFenceConfig.getEnable());
            if(Integer.valueOf(0).equals(saveOrUpdateVO.getRecordFlag()) && Integer.valueOf(1).equals(electronicFenceConfig.getEnable()) && CollectionUtils.isNotEmpty(saveOrUpdateVO.getConcreteCheckImgList())) {
                //若电子围栏，开启则判断是否存在异常验收图片，存在则无法进行保存操作
                for(ConcreteCheckImgDetailVO checkImg : saveOrUpdateVO.getConcreteCheckImgList()) {
                    if(Integer.valueOf(0).equals(checkImg.getAbnormalImgFlag())) {
                        return CommonResponse.error("操作失败，存在异常状态的验收图片");
                    }
                }
            }
        }

        ConcreteCheckVO vo = service.saveOrUpdates(saveOrUpdateVO,false);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
    @ApiOperation("根据明细信息填充数据,返回")
    @RequestMapping(value = "/getDetailListData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> getDetailListData(@RequestBody ConcreteCheckVO checkVO) {
        return CommonResponse.success("查询成功",service.getDetailListData(checkVO));
    }
    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> pushCost(@RequestBody ConcreteCheckVO checkVO) {
        return service.pushCost(checkVO);
    }
    @ApiOperation("同步目标成接口")
    @RequestMapping(value = "/syncCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        CheckEntity checkEntity = service.syncCost(id);
        return CommonResponse.success("同步成功");
    }

    /**
     * 混凝土-验收推送目标成本数据
     *
     * @param projectId 项目id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/allConcreteCheckPushTargetCost")
    @ResponseBody
    public CommonResponse<String> allConcreteCheckPushTargetCost(@RequestParam(value = "projectId", required = false) Long projectId) {
        QueryWrapper<ConcreteCheckEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id");
        if (null != projectId){
            queryWrapper.eq("project_id", projectId);
        }
        List<ConcreteCheckEntity> concreteCheckEntityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(concreteCheckEntityList)){
            for (ConcreteCheckEntity concreteCheckEntity : concreteCheckEntityList) {
                service.syncCost(concreteCheckEntity.getId());
            }
        }
        logger.info("混凝土-验收推送目标成本数据{}条", concreteCheckEntityList.size());
        return CommonResponse.success("混凝土-验收推送目标成本数据成功！");
    }


    @ApiOperation("根据明细信息填充数据,返回")
    @RequestMapping(value = "/getConcreteDetailListData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> getConcreteDetailListData(@RequestBody ConcreteCheckVO checkVO) {
        return CommonResponse.success("查询成功",service.getConcreteDetailListData(checkVO));
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryDetail(@RequestParam Long id) {
        ConcreteCheckVO concreteCheckVO = service.queryDetail(id);

        return CommonResponse.success("查询详情数据成功！",concreteCheckVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConcreteCheckVO> vos) {
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }
    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        ConcreteCheckEntity entity = service.selectById(id);
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同验收。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        // 没有推送成功，则需要重新推送数据
        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
            else {
                //未曾成功推送单据，则先向供方推送单据
                //推送供方处理
                SupplierPushCheckVO supplierPushCheckVO = BeanMapper.map(entity, SupplierPushCheckVO.class);

                supplierPushCheckVO.setSourceId(entity.getId());
                List<ConcreteCheckDetailEntity> concreteCheckDetailList = entity.getConcreteCheckDetailList();
                List<SupplierPushCheckDetailVO> supplierPushCheckDetailVOS = BeanMapper
                        .mapList(concreteCheckDetailList, SupplierPushCheckDetailVO.class);
                supplierPushCheckVO.setCheckDetailList(supplierPushCheckDetailVOS);
                List<SupplierPushCheckDetailVO> checkDetailList = supplierPushCheckVO.getConcreteCheckDetailList();
                for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                    supplierPushCheckDetailVO.setSourceId(entity.getId());
                    supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
                    supplierPushCheckDetailVO.setId(null);
                }

                //设置单据当前系统信息
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    return CommonResponse.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                }
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean pushResult = checkService.pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(),
                        BILL_TYPE, cooperateResp.getData(), PUSH_SAVE_URL);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
                else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi.getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConcreteCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<ConcreteCheckEntity> page = service.queryPage(param,false);
        IPage<ConcreteCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConcreteCheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<ConcreteCheckEntity> list = service.queryList(param);
        List<ConcreteCheckVO> listVo = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            listVo = BeanMapper.mapList(list, ConcreteCheckVO.class);
            listVo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
//                入库方式，0-收料入库，1-直入直出
                vo.setStoreTypeName(vo.getStoreType() == 0 ? "收料入库" : "直入直出") ;
                //验收来源，0-自制验收,1-发货验收
                vo.setSourceTypeName(vo.getSourceType() == 0 ? "自制验收" : "订单验收");
                //仓库属性 1-自购材；2-甲供材
                vo.setAttrFlagName(vo.getSourceType() == 1 ? "自购材" : "甲供材");
                //是否补录，0-否，1-是
                vo.setRecordFlagName(vo.getSourceType() == 0 ? "否" : "是");
                // 签字状态：0-未签字,1-已签字
                vo.setSignStatusName(vo.getSourceType() == 0 ? "未签字" : "已签字");
            });

        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("concrete-check-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refConcreteCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConcreteCheckVO>> refConcreteCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConcreteCheckEntity> page = service.queryPage(param,false);
        IPage<ConcreteCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConcreteCheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ConcreteCheckVO checkVO) {
        return CommonResponse.success("目标成本控制成功！", service.targetCostCtrl(checkVO));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("目标成本控制成功！", service.viewTargetCostCtrlInfo(id));
    }
    /**
     * 单据管控-
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody ConcreteCheckVO checkVO) {
        ParamsCheckVO paramsCheckVO = service.checkParams(checkVO,null);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
    /**
     * 磅单验收
     * @return
     */
    @RequestMapping(value = "/queryDetailWeigh", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteCheckVO> queryDetailWeigh(@RequestBody ConcreteCheckVO vo) {
        ConcreteCheckVO concreteCheckVO = service.queryDetailWeigh(vo);
        return CommonResponse.success("参数校验成功！",concreteCheckVO );
    }
}
