/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementCollectEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementFeeEntity;
import com.ejianc.business.promaterial.settlement.mapper.SettlementMapper;
import com.ejianc.business.promaterial.settlement.service.ISettlementCollectService;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementFeeService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.ContractFlagEnum;
import com.ejianc.business.promaterial.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.PrintSettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.PrintSettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementRecordVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementCollectVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementDetailVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementFeeVO;
import com.ejianc.business.promaterial.settlement.vo.SupSettlementVO;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.settlement.api.ITemporarySettlementApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="settlementService")
public class SettlementServiceImpl
extends BaseServiceImpl<SettlementMapper, SettlementEntity>
implements ISettlementService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE_C = "JS_CODE";
    private static final String BILL_CODE_H = "SHAHUN";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettlementCollectService settlementCollectService;
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ISettlementFeeService settlementFeeService;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private ISettlementDetailService settlementDetailService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String OPERATE = "SETTLMENT_JS";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporarySettlementApi temporarySettlementApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IConcreteCheckService concreteCheckService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/saveSettlement";
    private static final String MBILL_TYPE = "BT220309000000003";
    private static final String CBILL_TYPE = "BT220316000000005";
    private static final String M_PARAM_CODE_GC = "P-261sG051";
    private static final String M_PARAM_CODE_ZZ = "P-g9oJ340151";
    private static final String C_PARAM_CODE_GC = "P-p52jnO52";
    private static final String C_PARAM_CODE_ZZ = "P-4472DH0153";
    private static final String MN_PARAM_CODE_GC = "P-o0ydgH53";
    private static final String MN_PARAM_CODE_ZZ = "P-Zvb6nF0152";
    private static final String CN_PARAM_CODE_GC = "P-6lY70054";
    private static final String CN_PARAM_CODE_ZZ = "P-7Fq3830154";
    private static final String NO_CONTRACT_PARAM_CODE = "P-0w8vi00147";
    private static final String NO_CONTRACT_SUPPLIER_PARAM_CODE = "P-r958420148";
    private static final String CHECK_MNY_CON_CODE = "P-5E2vV80145";

    @Override
    public SettlementRecordVO querySettleRecord(Long contractId) {
        SettlementRecordVO vo = new SettlementRecordVO();
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        vo.setContractId(contractId);
        vo.setContractTaxMny(contractEntity.getContractTaxMny());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.orderByAsc(BaseEntity::getCreateTime);
        List list = super.list((Wrapper)wrapper);
        List vos = BeanMapper.mapList((Iterable)list, SettlementVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            BigDecimal totalSettlementTaxMny = vos.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalSettlementTaxMny(totalSettlementTaxMny);
        } else {
            vo.setTotalSettlementTaxMny(BigDecimal.ZERO);
        }
        if (vo.getContractTaxMny() == null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.eq(SettlementEntity::getSignatureType, (Object)1);
        List list2 = super.list((Wrapper)wrapper2);
        vo.setFlag(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list2)));
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper3.eq(BaseEntity::getDr, (Object)0);
        wrapper3.notIn(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper3.eq(SettlementEntity::getSignatureType, (Object)0);
        List list3 = super.list((Wrapper)wrapper3);
        vo.setFlagTwo(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list3)));
        return vo;
    }

    @Override
    public CommonResponse<SettlementVO> saveOrUpdate(SettlementVO saveOrUpdateVO) {
        if (CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getSettlementDetailList())) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5f53\u524d\u7ed3\u7b97\u5355\u7684\u6750\u6599\u660e\u7ec6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01");
        }
        SettlementEntity entity = (SettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String BILL_CODE = "";
            switch (entity.getSettlementType()) {
                case 0: {
                    BILL_CODE = BILL_CODE_C;
                    break;
                }
                case 1: {
                    BILL_CODE = BILL_CODE_H;
                }
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null != entity.getContractId() && this.queryExist(entity.getContractId())) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
            }
        } else {
            this.delCollect(entity.getId());
            ArrayList<SettlementDetailEntity> detailDel = new ArrayList<SettlementDetailEntity>();
            if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if (!"del".equals(detail.getRowState())) continue;
                    detailDel.add(detail);
                }
            }
            this.deleteAccount(detailDel, entity.getContractId());
        }
        entity.setSignStatus(0);
        entity.setSignatureStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        if (entity.getContractId() != null && CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            if (CollectionUtils.isEmpty(contractDetailList)) {
                throw new BusinessException("\u7ed3\u7b97\u660e\u7ec6\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u7ed3\u7b97");
            }
            List materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialId().toString()).collect(Collectors.toList());
            List materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialTypeId().toString()).collect(Collectors.toList());
            for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                String materialId;
                if ("del".equals(detail.getRowState())) continue;
                boolean flag = true;
                String materialTypeId = detail.getMaterialTypeId() == null ? "" : detail.getMaterialTypeId().toString();
                String string = materialId = detail.getMaterialId() == null ? "" : detail.getMaterialId().toString();
                if (materialTypeIds.contains(materialTypeId)) {
                    flag = false;
                }
                if (materialIds.contains(materialId)) {
                    flag = false;
                }
                if (!flag) continue;
                throw new BusinessException("\u6750\u6599\u3010" + detail.getMaterialName() + "\u3011\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u7ed3\u7b97");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushTargetCost2(entity.getId());
        this.updateAccount(entity);
        this.saveCost(entity, 0);
        SettlementVO vo = (SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public boolean queryExist(Long contractId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(SettlementEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    public void delCollect(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementCollectEntity::getSettlementId, (Object)id);
        List list = this.settlementCollectService.list((Wrapper)wrapper);
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            this.settlementCollectService.removeByIds(ids);
        }
    }

    private void uapdeRD(List ids, Integer flag) {
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            this.logger.info("\u5b50\u8868\u952e\u503c:" + JSONObject.toJSONString((Object)ids));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BaseEntity::getId, (Collection)ids);
            List list = this.reconciliationDetailService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.info("\u5bf9\u8d26\u5b50\u8868\u6570\u636e:" + JSONObject.toJSONString((Object)list));
                list.forEach(item -> item.setReconciliationState(flag));
                this.reconciliationDetailService.saveOrUpdateBatch(list, list.size(), false);
                this.logger.info("\u4fee\u6539\u72b6\u6001\u6210\u529f--" + JSONObject.toJSONString((Object)list));
            }
        }
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(SettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(SettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            SettlementEntity settlementEntity = (SettlementEntity)((Object)list.get(0));
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        map.put("settlementNum", list.size());
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u3001\u7ed3\u7b97\u6b21\u6570\u6210\u529f,\uff01", map);
    }

    public void updateAccount(SettlementEntity entity) {
        boolean flag = true;
        StoreApiVO storeApiVO = new StoreApiVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        HashSet<Long> checkId = new HashSet<Long>();
        storeApiVO.setSettleFlag(Integer.valueOf(1));
        storeApiVO.setSettleId(entity.getId());
        storeApiVO.setSettleDate(entity.getSettlementDate());
        storeApiVO.setSettleCode(entity.getBillCode());
        storeApiVO.setPurchaseContractId(entity.getContractId());
        storeApiVO.setPurchaseContractName(entity.getContractName());
        ArrayList<Long> idsAdd = new ArrayList<Long>();
        for (SettlementDetailEntity detailEntity : entity.getSettlementDetailList()) {
            if ("del".equals(detailEntity.getRowState())) continue;
            FlowVO flowVO = new FlowVO();
            if (null != entity.getContractId() && ContractFlagEnum.\u65e0\u5408\u540c.getCode().equals(detailEntity.getContractFlag())) {
                checkId.add(detailEntity.getSourceId());
                flowVO.setCusDef1("NoContract");
            }
            flowVO.setSettleDetailId(detailEntity.getId());
            flowVO.setSourceId(detailEntity.getSourceId());
            flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
            flowVOS.add(flowVO);
            if (detailEntity.getReconciliationDetailId() == null) continue;
            idsAdd.add(detailEntity.getReconciliationDetailId());
        }
        storeApiVO.setDetail(flowVOS);
        this.logger.info("\u4fdd\u5b58\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f--" + JSONObject.toJSONString((Object)storeApiVO));
        CommonResponse response2 = this.accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response2.isSuccess()) {
            this.logger.info("\u5e93\u5b58\u8fd4\u56de\u4fe1\u606f--" + JSONObject.toJSONString((Object)response2));
            throw new BusinessException("\u4fdd\u5b58\u7ed3\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        this.logger.info("\u4fdd\u5b58\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f\u5b8c\u6210--" + JSONObject.toJSONString((Object)response2));
        this.uapdeRD(idsAdd, 1);
        this.updateContractId(new ArrayList<Long>(checkId), entity.getContractId(), entity.getContractName());
    }

    public void updateContractId(List<Long> ids, Long contractId, String contractName) {
        List concreteCheckEntities;
        this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u66f4\u65b0ids:{}--\u5408\u540cid:{}", (Object)JSONObject.toJSONString(ids), (Object)contractId);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List checkEntities = this.checkService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)checkEntities)) {
            List collect = checkEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            this.checkService.updateBatchById(collect);
            this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u6750\u6599\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(collect));
        }
        if (CollectionUtils.isNotEmpty((Collection)(concreteCheckEntities = this.concreteCheckService.queryList(queryParam)))) {
            List collect2 = concreteCheckEntities.stream().map(item -> {
                item.setContractId(contractId);
                item.setCheckerName(contractName);
                return item;
            }).collect(Collectors.toList());
            this.concreteCheckService.updateBatchById(collect2);
            this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u6df7\u51dd\u571f\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(collect2));
        }
    }

    @Override
    public CommonResponse<String> delete(List<SettlementVO> vos) {
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        for (SettlementVO vo : vos) {
            SettlementEntity settlementEntity = (SettlementEntity)((Object)super.selectById((Serializable)vo.getId()));
            this.deleteAccount(settlementEntity.getSettlementDetailList(), settlementEntity.getContractId());
            ExecutionVO executionVO = this.targetCost2((SettlementVO)BeanMapper.map((Object)((Object)settlementEntity), SettlementVO.class), "", settlementEntity.getSettlementType());
            totalExecutionVOList.add(executionVO.getTotalVO());
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(vo.getId());
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (stringCommonResponse.isSuccess()) continue;
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        if (CollectionUtils.isNotEmpty(totalExecutionVOList)) {
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void deleteAccount(List<SettlementDetailEntity> settlementDetail, Long contractId) {
        StoreApiVO storeApiVO = new StoreApiVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        storeApiVO.setSettleFlag(Integer.valueOf(0));
        HashSet<Long> checkId = new HashSet<Long>();
        ArrayList<Long> idsDel = new ArrayList<Long>();
        for (SettlementDetailEntity detailEntity : settlementDetail) {
            FlowVO flowVO = new FlowVO();
            if (null != contractId && ContractFlagEnum.\u65e0\u5408\u540c.getCode().equals(detailEntity.getContractFlag())) {
                checkId.add(detailEntity.getSourceId());
                flowVO.setCusDef1("NoContract");
            }
            if (detailEntity.getReconciliationDetailId() != null) {
                idsDel.add(detailEntity.getReconciliationDetailId());
            }
            flowVO.setSourceId(detailEntity.getSourceId());
            flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
            flowVOS.add(flowVO);
        }
        storeApiVO.setDetail(flowVOS);
        this.logger.info("\u5220\u9664\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f--" + JSONObject.toJSONString((Object)storeApiVO));
        CommonResponse response = this.accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u7ed3\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        this.uapdeRD(idsDel, 0);
        this.updateContractId(new ArrayList<Long>(checkId), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(SettlementEntity entity, String billTypeCode) {
        String BILL_TYPE = entity.getSettlementType() == 1 ? CBILL_TYPE : MBILL_TYPE;
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupSettlementVO supSettlementVO = (SupSettlementVO)BeanMapper.map((Object)((Object)entity), SupSettlementVO.class);
            List supSettlementDetailVOS = BeanMapper.mapList(entity.getSettlementDetailList(), SupSettlementDetailVO.class);
            List supSettlementFeeVOS = BeanMapper.mapList(entity.getSettlementFeeList(), SupSettlementFeeVO.class);
            List supSettlementCollectVOS = BeanMapper.mapList(entity.getSettlementCollectList(), SupSettlementCollectVO.class);
            supSettlementVO.setSettlementDetailList(supSettlementDetailVOS);
            supSettlementVO.setSettlementFeeList(supSettlementFeeVOS);
            supSettlementVO.setSettlementCollectList(supSettlementCollectVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supSettlementVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "settlementProjectFile", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/settlement/saveSettlement", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(SettlementEntity entity, String billTypeCode, String url) {
        if (entity.getSettlementType() == 1) {
            BILL_TYPE = "BT220316000000005";
        } else {
            BILL_TYPE = "BT220309000000003";
        }
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((SettlementMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                var9_10 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var9_10;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl40
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var12_15 = supHandleResp;
                return var12_15;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl40:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        SettlementEntity settlementEntity = (SettlementEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String BILL_TYPE = settlementEntity.getSettlementType() == 0 ? MBILL_TYPE : CBILL_TYPE;
        settlementEntity.setSupOperateTime(supOperateTime);
        settlementEntity.setSupOperatorName(supOperatorName);
        settlementEntity.setSupOperatorPhone(supOperatorPhone);
        settlementEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = BILL_TYPE + "::" + settlementEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)settlementEntity.getId());
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, settlementEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            settlementEntity.setAttachIds(attchIdsList);
            settlementEntity.setSignStatus(1);
            super.saveOrUpdate((Object)settlementEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)settlementEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            throw e;
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public boolean pushSettleToPool(SettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            if (vo.getContractId() == null) {
                if (vo.getSettlementType() == 1) {
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getId());
                } else {
                    spv.setBillCodeUrl("/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getId());
                }
            } else if (vo.getSettlementType() == 1) {
                spv.setBillCodeUrl("/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getId());
            } else {
                spv.setBillCodeUrl("/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getId());
            }
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(SettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        switch (vo.getSettlementType()) {
            case 0: {
                if (vo.getContractId() != null) {
                    spv.setSourceType(SettleSourceTypeEnum.\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97.getCode());
                    break;
                }
                spv.setSourceType(SettleSourceTypeEnum.\u96f6\u661f\u6750\u6599\u7ed3\u7b97.getCode());
                break;
            }
            case 1: {
                spv.setSourceType(SettleSourceTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getCode());
            }
        }
        spv.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setContractFlag(Integer.valueOf(0));
        spv.setHandleType(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            spv.setContractFlag(Integer.valueOf(1));
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            switch (contractEntity.getContractType()) {
                case 0: {
                    spv.setContractType(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                    break;
                }
                case 1: {
                    spv.setContractType(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                }
            }
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setSignDate(contractEntity.getSignDate());
            spv.setLastTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny()));
            spv.setLastMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny()));
            spv.setLastTax(ComputeUtil.safeSub((BigDecimal)spv.getLastTaxMny(), (BigDecimal)spv.getLastMny()));
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettlementVO settlementVO, String linkUrl, Integer settlementType) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getContractId, (Object)settlementVO.getContractId());
        wrapper.in(SettlementEntity::getBillState, Arrays.asList(1, 3));
        wrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.settlementService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u7ed3\u7b97\u6570\u636e\u4e0d\u5b58\u5728");
        }
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ContractVO contractVO = this.contractService.queryDetail(settlementVO.getContractId());
        List contractDetailList = contractVO.getContractDetailList();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(settlementVO.getId());
        totalVO.setTenantId(settlementVO.getTenantId());
        totalVO.setBillCode(settlementVO.getBillCode());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO.getSettlementDate()));
        if (settlementType == 0) {
            totalVO.setBillType(MBILL_TYPE);
        } else {
            totalVO.setBillType(CBILL_TYPE);
        }
        switch (contractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(settlementVO.getProjectId());
        totalVO.setOrgId(settlementVO.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractVO.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractVO.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        List settleIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.in(SettlementDetailEntity::getSettlementId, settleIdList);
        List settleDetailList = this.settlementDetailService.list((Wrapper)detailWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            Map<Long, List<SettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
            Map<Long, List<ContractDetailVO>> contractDetailMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(ContractDetailVO::getMaterialId));
            if (!contractDetailMap.isEmpty()) {
                for (Long materialId : detailMaterialMap.keySet()) {
                    List<SettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
                    List<ContractDetailVO> contractDetailList1 = contractDetailMap.get(materialId);
                    BigDecimal contractSumNum = contractDetailList1.stream().filter(e -> e.getNum() != null).map(ContractDetailVO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumMny = contractDetailList1.stream().filter(e -> e.getMoney() != null).map(ContractDetailVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDetailList1.stream().filter(e -> e.getDetailTaxMny() != null).map(ContractDetailVO::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.getNum() != null).map(SettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(SettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(SettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    SettlementDetailEntity planDetailVO = detailMaterialList.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                    detailExecutionVO.setSourceBillId(planDetailVO.getSettlementId());
                    detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                    if (planDetailVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                        detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                        detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                    detailExecutionVO.setName(planDetailVO.getMaterialName());
                    detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                    detailExecutionVO.setUnitName(planDetailVO.getUnit());
                    detailExecutionVO.setPrice(planDetailVO.getPrice());
                    detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                    detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)sumNum, (BigDecimal)contractSumNum));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractSumMny));
                    detailExecutionVO.setSpec(planDetailVO.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractSumTaxMny));
                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ExecutionVO targetCost2(SettlementVO settlementVO, String linkUrl, Integer settlementType) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        BigDecimal totalSettleTaxMny = settlementVO.getSettlementTaxMny();
        BigDecimal totalSettleMny = settlementVO.getSettlementMny();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setContractId(settlementVO.getContractId());
        totalVO.setSourceId(settlementVO.getId());
        totalVO.setTenantId(settlementVO.getTenantId());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO.getSettlementDate()));
        totalVO.setBillCode(settlementVO.getBillCode());
        if (settlementType == 0) {
            totalVO.setBillType(MBILL_TYPE);
        } else {
            totalVO.setBillType(CBILL_TYPE);
        }
        switch (settlementVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u7ed3\u7b97\u5355.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u7ed3\u7b97.getCode());
        totalVO.setProjectId(settlementVO.getProjectId());
        totalVO.setOrgId(settlementVO.getOrgId());
        totalVO.setMoney(totalSettleMny);
        totalVO.setTaxMoney(totalSettleTaxMny);
        totalVO.setLinkUrl(linkUrl);
        List settleDetailList = settlementVO.getSettlementDetailList();
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            for (SettlementDetailVO planDetailVO : settleDetailList) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(settlementVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMny());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getTaxMny());
                detailExecutionVO.setContractId(settlementVO.getContractId());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public CostCtrlVO sjCost(SettlementVO vo) {
        List feeList = vo.getSettlementFeeList();
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (SettlementFeeVO settlementFeeVO : feeList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal feeTaxMny;
                if (null == settlementFeeVO.getSubjectIdFee() || "del".equals(settlementFeeVO.getRowState())) continue;
                BigDecimal feeMny = settlementFeeVO.getFeeMny() == null ? BigDecimal.ZERO : settlementFeeVO.getFeeMny();
                BigDecimal bigDecimal = feeTaxMny = settlementFeeVO.getFeeTaxMny() == null ? BigDecimal.ZERO : settlementFeeVO.getFeeTaxMny();
                if (map.containsKey(settlementFeeVO.getSubjectIdFee())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(settlementFeeVO.getSubjectIdFee());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(feeMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(settlementFeeVO.getSubjectIdFee());
                costCtrlDetailVO.setMny(feeMny);
                costCtrlDetailVO.setTaxMny(feeTaxMny);
                map.put(settlementFeeVO.getSubjectIdFee(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    @Override
    public ParamsCheckVO checkParams(SettlementVO vo) {
        CostCtrlVO costCtrlVO;
        ParamsCheckVO costParams;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != vo.getContractId()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            paramsCheckVOS.addAll(this.checkParamsMnyList(contractEntity, vo));
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)vo.getSettlementType());
            Boolean flag = true;
            if (vo.getSettlementType() == 0 && !"proMaterial-1".equals(vo.getContractPropertyCode())) {
                flag = false;
            }
            if (flag.booleanValue()) {
                paramsCheckVOS.addAll(this.checkParamsNum(contractEntity, vo));
            }
        } else {
            if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
                paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
            }
            paramsCheckVOS.addAll(this.checkParamsMny(vo));
            paramsCheckVOS.addAll(this.checkParamsMnyBySupplier(vo));
        }
        ParamsCheckVO priceParam = this.priceCheckParams(vo);
        if (priceParam != null) {
            paramsCheckVOS.add(priceParam);
        }
        if (!"proMaterial-3".equals(vo.getContractPropertyCode()) && (costParams = this.costPriceCheckParams(vo)) != null) {
            paramsCheckVOS.add(costParams);
        }
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
        String linkUrl = vo.getSettlementType() == 0 ? (null == vo.getContractId() || 0L == vo.getContractId() ? frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getId()) : (null == vo.getContractId() || 0L == vo.getContractId() ? frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getId());
        if (null == vo.getId()) {
            vo.setId(Long.valueOf(IdWorker.getId()));
        }
        List settlementFeeList = vo.getSettlementFeeList();
        ArrayList<SettlementFeeVO> settlementFeeListNew = new ArrayList<SettlementFeeVO>();
        if (CollectionUtils.isNotEmpty((Collection)settlementFeeList)) {
            for (SettlementFeeVO cdEntity : settlementFeeList) {
                if (null == cdEntity.getId()) {
                    cdEntity.setId(Long.valueOf(IdWorker.getId()));
                    cdEntity.setSettlementId(vo.getId());
                }
                if ("del".equals(cdEntity.getRowState())) continue;
                settlementFeeListNew.add(cdEntity);
            }
            vo.setSettlementFeeList(settlementFeeListNew);
        }
        ExecutionVO executionVO = this.targetCost2(vo, linkUrl, vo.getSettlementType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u63a8\u9001\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a7\u5236\u5931\u8d25," + response.getMsg());
        }
        ParamsCheckVO tarRes = (ParamsCheckVO)response.getData();
        if (null != tarRes) {
            paramsCheckVOS.add(tarRes);
        }
        if (null != (costCtrlVO = this.sjCost(vo))) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO priceCheckParams(SettlementVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        switch (vo.getSettlementType()) {
            case 0: {
                materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6d88\u8017\u6750\u7ed3\u7b97.getCode());
                break;
            }
            case 1: {
                materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6df7\u51dd\u571f\u7ed3\u7b97.getCode());
            }
        }
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(SettlementVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        if (vo.getSettlementType() == 0) {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6d88\u8017\u6750\u7ed3\u7b97.getCode());
        } else {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6df7\u51dd\u571f\u7ed3\u7b97.getCode());
        }
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialCostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.contractService.costPriceParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyList(ContractEntity contractEntity, SettlementVO vo) {
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        String purchaseType = contractEntity.getPurchaseType();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        String CHECK_PARAM_CODE = "";
        if (vo.getSettlementType() == 0) {
            switch (vo.getSignatureType()) {
                case 0: {
                    CHECK_PARAM_CODE = M_PARAM_CODE_GC;
                    break;
                }
                case 1: {
                    CHECK_PARAM_CODE = M_PARAM_CODE_ZZ;
                }
            }
        } else {
            switch (vo.getSignatureType()) {
                case 0: {
                    CHECK_PARAM_CODE = C_PARAM_CODE_GC;
                    break;
                }
                case 1: {
                    CHECK_PARAM_CODE = C_PARAM_CODE_ZZ;
                }
            }
        }
        CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List data = (List)billParamByCodeAndOrgId.getData();
            this.logger.info("\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO billParamByCode : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    Long orgId = billParamByCode.getOrgId();
                    String orgName = billParamByCode.getOrgName();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BillParamVO billParamVO = billParamByCode;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    if ("2".equals(purchaseType)) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        continue;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (vo.getCurrentSettlementTaxMny().compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(vo.getSettlementTaxMny().toString()).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff1a").append(vo.getCurrentSettlementTaxMny()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)comMny)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, SettlementVO vo) {
        CommonResponse billParamByCode;
        String purchaseType = contractEntity.getPurchaseType();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (null != purchaseType && "2".equals(purchaseType)) {
            return paramsCheckVOS;
        }
        String CHECK_PARAM_CODE = "";
        if (vo.getSettlementType() == 0) {
            switch (vo.getSignatureType()) {
                case 0: {
                    CHECK_PARAM_CODE = MN_PARAM_CODE_GC;
                    break;
                }
                case 1: {
                    CHECK_PARAM_CODE = MN_PARAM_CODE_ZZ;
                }
            }
        } else {
            switch (vo.getSignatureType()) {
                case 0: {
                    CHECK_PARAM_CODE = CN_PARAM_CODE_GC;
                    break;
                }
                case 1: {
                    CHECK_PARAM_CODE = CN_PARAM_CODE_ZZ;
                }
            }
        }
        List<SettlementDetailVO> detail = ((SettlementMapper)this.baseMapper).getDetail(contractEntity.getId(), vo.getId());
        Map<Long, SettlementDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(SettlementDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        HashMap<Long, SettlementDetailVO> detailMap = new HashMap<Long, SettlementDetailVO>();
        HashMap<Long, BigDecimal> detailTypeMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(detail)) {
            for (SettlementDetailVO detailVO : detail) {
                if (map.containsKey(detailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {
                    detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getNum()));
                    continue;
                }
                detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getNum());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getSettlementDetailList())) {
            for (SettlementDetailVO detailVO : vo.getSettlementDetailList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                SettlementDetailVO mapVO = (SettlementDetailVO)detailMap.get(detailVO.getMaterialId());
                if (Objects.nonNull(mapVO)) {
                    detailVO.setNum(ComputeUtil.safeAdd((BigDecimal)mapVO.getNum(), (BigDecimal)detailVO.getNum()));
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                } else {
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                }
                if (map.containsKey(detailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {
                    detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getNum()));
                    continue;
                }
                detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getNum());
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7ed3\u7b97\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty(detailMap.values())) {
                        for (SettlementDetailVO detailVO : detailMap.values()) {
                            ContractDetailEntity detailEntity;
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId()) ? detailSettleMap.get(detailVO.getMaterialId()).getNum() : BigDecimal.ZERO;
                            BigDecimal totalNum = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getNum()).setScale(4, 4);
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId()) ? (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId()) : BigDecimal.ZERO;
                            BigDecimal comNum = BigDecimal.ZERO;
                            if (map.containsKey(detailVO.getMaterialId())) {
                                detailEntity = map.get(detailVO.getMaterialId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            } else if (typeMap.containsKey(detailVO.getMaterialTypeId())) {
                                detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                                totalNum = numType;
                            } else {
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)BigDecimal.ZERO, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            }
                            if (totalNum.compareTo(comNum) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(detailVO.getMaterialName()).append(detailVO.getSpec() == null ? "" : " " + detailVO.getSpec()).append(" ").append("\u672c\u6b21\u7ed3\u7b97\u6570\u91cf\uff1a").append(detailVO.getNum().setScale(4, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u6570\u91cf\uff1a").append(totalNum.setScale(4, 4)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%:").append(comNum.setScale(4, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalNum, (BigDecimal)comNum).setScale(4, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(SettlementVO vo) {
        CommonResponse billParamByCode;
        List list;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettlementEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.isNull(SettlementEntity::getContractId);
        if (null != vo.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)))) {
            BigDecimal totalSettleMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalSettleMny);
        }
        CommonResponse response = this.temporarySettlementApi.queryTemporarySettlementMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee\uff1a{}-\u4e0b\u6240\u6709\u72b6\u6001\u7684\u3010\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u91d1\u989d\u3011\u91d1\u989d\u7ed3\u679c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal settleTaxMny = ((JSONObject)response.getData()).getBigDecimal("settleTaxMny");
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)settleTaxMny);
        }
        CommonResponse commonResponse = this.proincomeContrantApi.queryContranctMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee:{}-\u4e0b\u751f\u6548\u7684\u6700\u65b0\u6b63\u5f0f\u65bd\u5de5\u5408\u540c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)commonResponse));
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            BigDecimal bigDecimal = contractTaxMny = null == ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny() ? BigDecimal.ZERO : ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u96f6\u661f\u673a\u68b0\u91d1\u989d\u3011\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u4e34\u673a\u8d39\u7528\u8d85\u65bd\u5de5\u5408\u540c\u989d");
                        paramsCheckDsVO.setWarnName("\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u4e34\u673a\u8d39\u7528\u7d2f\u8ba1\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u96f6\u6750\u3001\u96f6\u673a\u53d1\u751f\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)id));
        if (entity.getSignatureType() != null && entity.getSignatureType() == 1) {
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
            String linkUrl = entity.getSettlementType() == 0 ? (null == entity.getContractId() || 0L == entity.getContractId() ? frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId()) : (null == entity.getContractId() || 0L == entity.getContractId() ? frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId());
            ExecutionVO executionVO = this.targetCost((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), linkUrl, entity.getSettlementType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public CommonResponse<String> pushTargetCost2(Long id) {
        SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)id));
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
        String linkUrl = entity.getSettlementType() == 0 ? (null == entity.getContractId() || 0L == entity.getContractId() ? frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId()) : (null == entity.getContractId() || 0L == entity.getContractId() ? frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId());
        ExecutionVO executionVO = this.targetCost2((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), linkUrl, entity.getSettlementType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"settlement_date");
        List list = super.list((Wrapper)listQuery);
        List rentSettlementVOS = BeanMapper.mapList((Iterable)list, SettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractSettleMny = list.stream().map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);
        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    @Override
    public void updateContractPoolSettle(SettlementVO vo, Boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type != false ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSignatureType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            if (type.booleanValue()) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            } else {
                totalSettleTaxMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSignatureType()) {
                if (type.booleanValue()) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }

    @Override
    public CommonResponse<SettlementVO> pushCost(SettlementVO vo) {
        SettlementEntity entity = (SettlementEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)vo.getSettlementDetailList(), SettlementDetailEntity.class);
            entity.setSettlementDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(entity.getSettlementFeeList())) {
            List feeEntityList = BeanMapper.mapList((Iterable)vo.getSettlementFeeList(), SettlementFeeEntity.class);
            entity.setSettlementFeeList(feeEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SettlementVO.class));
    }

    @Override
    public void costPush(SettlementEntity entity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<SettlementFeeEntity> feeList = entity.getSettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (SettlementFeeEntity feeEntity : feeList) {
                if (null != feeEntity.getSubjectIdFee() && null != feeEntity.getWbsIdFee()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(feeList)) {
            newRelationFlag = "0";
        }
        this.saveCost(entity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(SettlementEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        entity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(SettlementEntity entity, Integer effectiveStatus) {
        String linkUrl = "";
        String billName = "";
        String sourceType = "";
        if (entity.getSettlementType() == 0) {
            linkUrl = null == entity.getContractId() ? "/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : "/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId();
            billName = SourceTypeEnum.\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97.getTypeName();
            sourceType = "MATERIAL";
        } else {
            linkUrl = null == entity.getContractId() ? "/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : "/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId();
            billName = SourceTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getTypeName();
            sourceType = "CONCRETE";
        }
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SettlementFeeEntity> feeList = entity.getSettlementFeeList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (SettlementFeeEntity feeEntity : feeList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectCode(feeEntity.getSubjectCodeFee());
                costDetailVO.setSubjectName(feeEntity.getSubjectNameFee());
                costDetailVO.setNum(feeEntity.getFeeNum());
                costDetailVO.setWbsId(feeEntity.getWbsIdFee());
                costDetailVO.setWbsCode(feeEntity.getWbsCodeFee());
                costDetailVO.setWbsName(feeEntity.getWbsNameFee());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(feeEntity.getId());
                costDetailVO.setHappenTaxMny(feeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(feeEntity.getFeeMny());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType + "_SETTLE");
                costDetailVO.setSourceTabType(sourceType + "_SETTLE_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public List<SettlementVO> querySettlementByContractId(SettlementVO settlementVO) {
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        List<Object> rtnList = new ArrayList<SettlementVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, SettlementVO.class);
            for (SettlementVO settlementVO2 : rtnList) {
                settlementVO2.setSettlementDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settlementVO2.getSettlementDate()));
                settlementVO2.setBillCodeLink(settlementVO2.getBillCode());
                settlementVO2.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)settlementVO2.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(SettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId(NO_CONTRACT_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List data = (List)billParamByCodeAndOrgId.getData();
            this.logger.info("\u5355\u6b21\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5355\u6b21\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u8d85\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyBySupplier(SettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId(NO_CONTRACT_SUPPLIER_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List data = (List)billParamByCodeAndOrgId.getData();
            this.logger.info("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            BigDecimal mny = this.getNoContractSupplierMny(vo);
            BigDecimal thisMny = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(thisMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d").append(mny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    private BigDecimal getNoContractSupplierMny(SettlementVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)vo.getSupplierId()));
        queryParam.getParams().put("contractId", new Parameter("eq", null));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        List entityList = super.queryList(queryParam, false);
        BigDecimal sum = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return sum;
        }
        for (SettlementEntity entity : entityList) {
            sum = sum.add(CommonUtils.setBigDecimalDefaultValue(entity.getSettlementTaxMny()));
        }
        return sum;
    }

    @Override
    public List<PrintSettlementDetailVO> queryPrintSettlementDetail(SettlementVO settlementVO) {
        ArrayList<Object> rtnList = new ArrayList<PrintSettlementDetailVO>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter("in", idList));
        List detailEntityList = this.settlementDetailService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)detailEntityList)) {
            return rtnList;
        }
        Map<Object, Object> thisMap = new HashMap();
        if (settlementVO.getId() != null) {
            List thisDetailList = detailEntityList.stream().filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
        }
        HashMap<String, PrintSettlementDetailVO> map = new HashMap<String, PrintSettlementDetailVO>();
        for (SettlementDetailEntity detailEntity : detailEntityList) {
            PrintSettlementDetailVO printVo;
            String key = "" + detailEntity.getMaterialId() + detailEntity.getStoreTaxPrice() + detailEntity.getTaxPrice();
            if (map.containsKey(key)) {
                printVo = (PrintSettlementDetailVO)map.get(key);
                BigDecimal storeSum = CommonUtils.addBigDecimal(printVo.getStoreNum(), detailEntity.getStoreNum());
                BigDecimal sum = CommonUtils.addBigDecimal(printVo.getNum(), detailEntity.getNum());
                BigDecimal storeTaxMny = CommonUtils.addBigDecimal(printVo.getStoreTaxMny(), detailEntity.getStoreTaxMny());
                BigDecimal taxMny = CommonUtils.addBigDecimal(printVo.getTaxMny(), detailEntity.getTaxMny());
                printVo.setStoreNum(storeSum);
                printVo.setNum(sum);
                printVo.setStoreTaxMny(storeTaxMny);
                printVo.setTaxMny(taxMny);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
                continue;
            }
            printVo = (PrintSettlementDetailVO)BeanMapper.map((Object)((Object)detailEntity), PrintSettlementDetailVO.class);
            List thisMaterialList = (List)thisMap.get(detailEntity.getMaterialId());
            BigDecimal thisSettleNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)thisMaterialList)) {
                for (SettlementDetailEntity settlementDetailEntity : thisMaterialList) {
                    thisSettleNum = thisSettleNum.add(CommonUtils.setBigDecimalDefaultValue(settlementDetailEntity.getNum()));
                }
            }
            printVo.setThisSettleNum(thisSettleNum);
            printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
            map.put(key, printVo);
        }
        rtnList = new ArrayList(map.values());
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PrintSettlementDetailVO::getThisSettleNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed().thenComparing(PrintSettlementDetailVO::getNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    @Override
    public List<PrintSettlementFeeVO> queryPrintSettlementFee(SettlementVO settlementVO) {
        ArrayList<PrintSettlementFeeVO> rtnList = new ArrayList<PrintSettlementFeeVO>();
        List<SettlementEntity> list = this.queryListByContractId(settlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter("in", idList));
        List feeEntityList = this.settlementFeeService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)feeEntityList)) {
            return rtnList;
        }
        Map<Object, Object> thisMap = new HashMap();
        Map<Object, Object> thisNoContractMap = new HashMap();
        if (settlementVO.getId() != null) {
            List thisDetailList = feeEntityList.stream().filter(t -> t.getSettlementId().equals(settlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().filter(t -> t.getSourceId() != null).collect(Collectors.groupingBy(SettlementFeeEntity::getSourceDetailId));
            thisNoContractMap = thisDetailList.stream().filter(t -> t.getSourceId() == null).collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
        }
        HashMap<String, PrintSettlementFeeVO> map = new HashMap<String, PrintSettlementFeeVO>();
        for (SettlementFeeEntity feeEntity : feeEntityList) {
            PrintSettlementFeeVO printFeeVo;
            if (feeEntity.getSourceId() == null) {
                printFeeVo = (PrintSettlementFeeVO)BeanMapper.map((Object)((Object)feeEntity), PrintSettlementFeeVO.class);
                SettlementFeeEntity thisFeeEntity = (SettlementFeeEntity)((Object)thisNoContractMap.get(feeEntity.getId()));
                if (thisFeeEntity != null) {
                    printFeeVo.setThisFeeNum(CommonUtils.setBigDecimalDefaultValue(thisFeeEntity.getFeeNum()));
                }
                rtnList.add(printFeeVo);
                continue;
            }
            String key = "" + feeEntity.getSourceId() + feeEntity.getSourceDetailId();
            if (map.containsKey(key)) {
                printFeeVo = (PrintSettlementFeeVO)map.get(key);
                BigDecimal feeNum = CommonUtils.addBigDecimal(printFeeVo.getFeeNum(), feeEntity.getFeeNum());
                BigDecimal feeTaxMny = CommonUtils.addBigDecimal(printFeeVo.getFeeTaxMny(), feeEntity.getFeeTaxMny());
                printFeeVo.setFeeNum(feeNum);
                printFeeVo.setFeeTaxMny(feeTaxMny);
                continue;
            }
            printFeeVo = (PrintSettlementFeeVO)BeanMapper.map((Object)((Object)feeEntity), PrintSettlementFeeVO.class);
            List thisFeeList = (List)thisMap.get(feeEntity.getSourceDetailId());
            BigDecimal thisNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)thisFeeList)) {
                for (SettlementFeeEntity feeEntity1 : thisFeeList) {
                    thisNum = thisNum.add(CommonUtils.setBigDecimalDefaultValue(feeEntity1.getFeeNum()));
                }
            }
            printFeeVo.setThisFeeNum(thisNum);
            map.put(key, printFeeVo);
        }
        rtnList.addAll(new ArrayList(map.values()));
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PrintSettlementFeeVO::getThisFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed().thenComparing(PrintSettlementFeeVO::getFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    private List<SettlementEntity> queryListByContractId(SettlementVO settlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)settlementVO.getContractId()));
        queryParam.getParams().put("settlementType", new Parameter("eq", (Object)settlementVO.getSettlementType()));
        queryParam.getOrderMap().put("settlementDate", "desc");
        return super.queryList(queryParam, false);
    }
}

