package com.ejianc.business.promaterial.plan.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 材料批次采购计划主表
 *
 * @author generator
 */
@Mapper
public interface BatPlanMapper extends BaseCrudMapper<BatPlanEntity> {

    /**
     * 查询批次计划数据模型
     *
     * @param projectId    项目id
     * @param queryWrapper 查询条件
     * @return 查询结果
     */
    List<MaterialDataModelVO> queryBatPlanMaterialDataList(@Param("projectId") Long projectId,
                                                       @Param(Constants.WRAPPER) QueryWrapper queryWrapper);


    /**
     * 根据项目id查询批次计划明细数量
     *
     * @param projectId    项目id
     * @return 查询结果
     */
    List<BatPlanDetailEntity> getBatPlanDetailNumByProjectId(@Param("projectId") Long projectId);


}
