package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.bean.*;
import com.ejianc.business.promaterial.check.mapper.ConcreteCheckMapper;
import com.ejianc.business.promaterial.check.service.*;
import com.ejianc.business.promaterial.check.vo.*;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IConcreteDeliveryService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 混凝土-验收主表
 * 
 * @author generator
 * 
 */
@Service("concreteCheckService")
public class ConcreteCheckServiceImpl extends BaseServiceImpl<ConcreteCheckMapper, ConcreteCheckEntity> implements IConcreteCheckService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;

    private static final String BILL_CODE = "HNT-CHECK";//此处需要根据实际修改
    private final String OPERATE = "HNT_CHECK_SYNC";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IConcreteDeliveryDetailService concreteDeliveryDetailService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IConcreteCheckDetailService concreteCheckDetailService;
    @Autowired
    private IConcreteDeliveryService concreteDeliveryService;
    @Autowired
    private IConcreteCheckAdmixtureService concreteCheckAdmixtureService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteDelivery/saveConcreteDeliveryState";
    private static final String BILL_TYPE = "BT220224000000004";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${common.env.base-host}")
    private String baseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IConcreteCheckWeighService concreteCheckWeighService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporaryUseRecordApi temporaryUseRecordApi;
    @Autowired
    private IConcreteCheckImgDetailService concreteCheckImgDetailService;

   //参数控制编码
    private static final String CHECK_PARAM_CODE = "P-68U82Z74";//数量控制
    private static final String CHECK_MNY_CON_CODE = "P-n01oAU0146";//【施工合同金额】控【无合同验收、零星机械金额】

    private static final String CHECK_MNY_CODE = "P-2dnh8V0139";
    private static final String CHECK_SUB_MNY_CODE = "P-Tl9Zyr0141";
    @Override
    public ConcreteCheckVO saveOrUpdates(ConcreteCheckVO saveOrUpdateVO, Boolean isControl) {
        //判断是否是新增保存

        if(!isControl && saveOrUpdateVO.getId() != null){
            //查询上一版本数据
            ConcreteCheckEntity concreteCheckEntity = super.selectById(saveOrUpdateVO.getId());
//            仓库属性 1-自购材；2-甲供材
            Integer attrFlag = concreteCheckEntity.getAttrFlag();
            if (attrFlag == 1 && saveOrUpdateVO.getAttrFlag() == 2){
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionDelVO = targetCost(concreteCheckEntity);
                totalExecutionVOList.add(executionDelVO.getTotalVO());
                CommonResponse<String> responses = executionApi.aggDel(totalExecutionVOList);
                if (!responses.isSuccess()){
                    throw new BusinessException("目标成本推送失败" + responses.getMsg());
                }
            }
        }

        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
            }
        }
        if(!isControl){
            if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                if(null==saveOrUpdateVO.getCheckWeighType()){
                    saveOrUpdateVO.setCheckWeighType(CheckWeighTypeEnum.否磅单验收.getCode());
                }
                if(null==saveOrUpdateVO.getAutomaticWeigh()){// 自动称重设置（0：自动称重，1非自动称重）
                    saveOrUpdateVO.setAutomaticWeigh(1);
                }
            }
        }
        if (saveOrUpdateVO.getId() == null){
            long id = IdWorker.getId();
            saveOrUpdateVO.setId(id);
        }
        List<ConcreteCheckDetailVO> concreteCheckDetailList = saveOrUpdateVO.getConcreteCheckDetailList();
        List<ConcreteCheckAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteCheckAdmixtureEntity>();
        if (CollectionUtils.isNotEmpty(concreteCheckDetailList)){
            for (ConcreteCheckDetailVO concreteCheckDetailVO : concreteCheckDetailList){
                if (concreteCheckDetailVO.getId() == null){
                    long id = IdWorker.getId();
                    concreteCheckDetailVO.setId(id);
                }
                List<ConcreteCheckAdmixtureVO> admixtureVOList = concreteCheckDetailVO.getAdmixtureVOList();
                if(CollectionUtils.isNotEmpty(admixtureVOList)){
                    for (ConcreteCheckAdmixtureVO concreteCheckAdmixtureVO : admixtureVOList){
                        concreteCheckAdmixtureVO.setDetailId(concreteCheckDetailVO.getId());
                        ConcreteCheckAdmixtureEntity concreteCheckAdmixtureEntity = BeanMapper.map(concreteCheckAdmixtureVO, ConcreteCheckAdmixtureEntity.class);
                        concreteCheckAdmixtureEntity.setId(null);
                        concreteCheckAdmixtureEntity.setCheckId(saveOrUpdateVO.getId());
                        admixtureArrayList.add(concreteCheckAdmixtureEntity);
                    }
                }
            }
        }
        //
        List<Long> ids = concreteCheckDetailList.stream().map(ConcreteCheckDetailVO::getId).collect(Collectors.toList());
        ConcreteCheckEntity entity = BeanMapper.map(saveOrUpdateVO, ConcreteCheckEntity.class);
        entity.setConcreteCheckAdmixtureList(null);
        //先删后增外加剂
        LambdaQueryWrapper<ConcreteCheckAdmixtureEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(ConcreteCheckAdmixtureEntity::getDetailId, ids);
        if (!isControl){
            concreteCheckAdmixtureService.remove(wrapper, false);
            concreteCheckAdmixtureService.saveBatch(admixtureArrayList);
        }



        entity.setStoreType(1);
        entity.setSignStatus(0);
        entity.setRelationFlag("0");//关联状态初始化
        entity.setProportionFlag("0");//分摊状态初始化
        entity.setCheckType("contractConcrete-1");
        entity.setCheckTypeName(" 混凝土合同");
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        if (!isControl){
            //删除图片信息
            if(null != entity.getId()) {
                concreteCheckImgDetailService.deleteByPid(entity.getId());
            }

            //磅单验收回显磅单数据信息
            if(CheckWeighTypeEnum.是磅单验收.getCode().equals(entity.getCheckWeighType())) {
                List<ConcreteCheckWeighEntity> checkWeighListDel = new ArrayList<>();
                for (ConcreteCheckWeighEntity checkWeighEntity : entity.getConcreteCheckWeighList()) {
                    if("del".equals(checkWeighEntity.getRowState())){
                        checkWeighListDel.add(checkWeighEntity);
                    }
                }
                this.delWeighBill(checkWeighListDel);
            }
            super.saveOrUpdate(entity, false);
            //磅单验收回显磅单数据信息
            if(CheckWeighTypeEnum.是磅单验收.getCode().equals(entity.getCheckWeighType())) {
                this.addOrUpdateWeighBill(entity.getConcreteCheckDetailList(),entity.getConcreteCheckWeighList());
            }
        }
        Integer checkStatus = 0;
        ConcreteDeliveryEntity concreteDeliveryEntity = concreteDeliveryService.selectById(entity.getDeliveryId());
        //回写发货单数据
        if (entity.getSourceType() == 1 && !isControl) {
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<ConcreteCheckDetailEntity> lambdaConcreteCheckDetail = Wrappers.<ConcreteCheckDetailEntity>lambdaQuery();
            lambdaConcreteCheckDetail.eq(ConcreteCheckDetailEntity::getDeliveryId,entity.getDeliveryId());
            List<ConcreteCheckDetailEntity> ConcreteCheckDetailEntityList = concreteCheckDetailService.list(lambdaConcreteCheckDetail);
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(ConcreteCheckDetailEntityList)){
                Map<Long, List<ConcreteCheckDetailEntity>> checkMap = ConcreteCheckDetailEntityList.stream().collect(Collectors.groupingBy(ConcreteCheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper<ConcreteDeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<ConcreteDeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(ConcreteDeliveryDetailEntity::getDeliveryId,entity.getDeliveryId());
                List<ConcreteDeliveryDetailEntity> deliveryDetailEntityList = concreteDeliveryDetailService.list(lambdaDeliveryDetail);
                for (ConcreteDeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                    List<ConcreteCheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)){
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(ConcreteCheckDetailEntity::getCheckNum)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null == deliveryDetailEntity.getCheckNum()){
                        deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                    }
                }

                //判断发货单的验收状态
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));

                if (allCheck){
                    checkStatus = 2;
                }
                if (anyCheck){
                    checkStatus = 1;
                }
                //更新发货验收状态和验收数量

                concreteDeliveryEntity.setCheckStatus(checkStatus);
                    concreteDeliveryService.updateById(concreteDeliveryEntity);
                    concreteDeliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }

            //推送供方
            //对单据进行加锁
            if(!DeliveryTypeEnum.自制送货单.getCode().equals(concreteDeliveryEntity.getDeliveryType())) {//自制发货单不推送供方
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("获取当前系统编码失败！");
                }
                Map<String, Object> map = new HashMap<>();
                map.put("sourceId", concreteDeliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(concreteDeliveryEntity.getId(), dataInfo, PUSH_BILL_SERVER_URL, RequestMethod.POST,
                        concreteDeliveryEntity.getSupplierId().toString(), OPERATE, BILL_TYPE);
                if (!updateSupplierStatus) {
                    throw new BusinessException("单据推送失败！");
                }
            }
        }

        if (!isControl){
            //先删除目标成本, 仓库属性 1-自购材；2-甲供材
//            if (isNewSave && entity.getId() != null && entity.getAttrFlag()==2) {
//                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//                ExecutionVO executionDelVO = targetCost(entity);
//                totalExecutionVOList.add(executionDelVO.getTotalVO());
//                CommonResponse<String> responses = executionApi.aggDel(totalExecutionVOList);
//                if (!responses.isSuccess()){
//                    throw new BusinessException("目标成本推送失败" + responses.getMsg());
//                }
//            }

            if (entity.getAttrFlag()==1){
                //目标成本推送
                ExecutionVO executionVO = targetCost(entity);
                logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败:" + response.getMsg());
                }
            }

        }

        //推送实际成本
        //仓库属性是甲供材的不推送实际成本
        if (saveOrUpdateVO.getAttrFlag().equals(1) &&!isControl){
            saveCost(entity,0);
        }

        if (!isControl){
            return queryDetail(entity.getId());
        }
        return BeanMapper.map(entity, ConcreteCheckVO.class);
    }

    //保存删除回显磅单
    private void delWeighBill(List<ConcreteCheckWeighEntity> concreteCheckWeighList) {
        List<WeighbillVO> upDateWeighBill = new ArrayList<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(concreteCheckWeighList)){//验收删除磅单明细组合数据
            for (ConcreteCheckWeighEntity concreteCheckWeighEntity : concreteCheckWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(concreteCheckWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(concreteCheckWeighEntity.getId());
                weighbillVO.setId(concreteCheckWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(0);//("验收状态，0-未验收,1-已验收")
                upDateWeighBill.add(weighbillVO);
            }
        }
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(upDateWeighBill)){
            logger.info("保存删除回显磅单，数据信息：{}",JSONObject.toJSONString(upDateWeighBill));
            weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }
    //新增修改回显磅单
    private void addOrUpdateWeighBill(List<ConcreteCheckDetailEntity> concreteCheckDetailList,List<ConcreteCheckWeighEntity> concreteCheckWeighList) {
        List<WeighbillVO> upDateWeighBill = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(concreteCheckWeighList)){//循环验收明细和验收磅单明细组合数据
            for (ConcreteCheckWeighEntity concreteCheckWeighEntity : concreteCheckWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if(CollectionUtils.isNotEmpty(concreteCheckDetailList)){
                    for (ConcreteCheckDetailEntity concreteCheckDetailEntity : concreteCheckDetailList) {
                        if(null!=concreteCheckWeighEntity.getDeliveryDetailId() && concreteCheckWeighEntity.getDeliveryDetailId().equals(concreteCheckDetailEntity.getDeliveryDetailId())){
                            weighbillVO.setCheckId(concreteCheckDetailEntity.getCheckId());
                            weighbillVO.setCheckDetailId(concreteCheckDetailEntity.getId());
                            //更新验收磅单信息
                            concreteCheckWeighEntity.setCheckDetailId(concreteCheckDetailEntity.getId());
                            concreteCheckWeighEntity.setCheckStatus(1);
                        }
                    }
                }
                weighbillVO.setId(concreteCheckWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(1);//("验收状态，0-未验收,1-已验收")
                upDateWeighBill.add(weighbillVO);
            }
        }
        if(CollectionUtils.isNotEmpty(concreteCheckWeighList)){
            logger.info("新增修改更新验收磅单，数据信息：{}",JSONObject.toJSONString(concreteCheckWeighList));
            concreteCheckWeighService.updateBatchById(concreteCheckWeighList);
        }
        if(CollectionUtils.isNotEmpty(upDateWeighBill)){
            logger.info("新增修改回显磅单，数据信息：{}",JSONObject.toJSONString(upDateWeighBill));
            weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }
    private ExecutionVO targetCost(ConcreteCheckEntity checkEntity) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(checkEntity.getId());
        totalVO.setTenantId(checkEntity.getTenantId());
        totalVO.setBillCode(checkEntity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.混凝土验收单.getCode());
        totalVO.setBillCategory(BillCategoryEnum.入库.getCode());
        totalVO.setProjectId(checkEntity.getProjectId());
        totalVO.setOrgId(checkEntity.getOrgId());
        String url = null;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        if(checkEntity.getContractId() == null){
            url = frontendBaseHost  +"ejc-promaterial-frontend/#/concreteCheck/card?id="+checkEntity.getId();
        }
        if(checkEntity.getContractId() !=null){
            url = frontendBaseHost  +"ejc-promaterial-frontend/#/concreteCheck/contractCard?id="+checkEntity.getId();
        }
        totalVO.setLinkUrl(url);
        totalVO.setBillDate(checkEntity.getCheckDate()==null?null:checkEntity.getCheckDate().toString());
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (ConcreteCheckDetailEntity checkDetailEntity : checkEntity.getConcreteCheckDetailList()) {
            if (checkDetailEntity.getRowState() != null && checkDetailEntity.getRowState().equals("del")){
                continue;
            }
            checkMoney = checkMoney.add(checkDetailEntity.getCheckMny());
            checkTaxMoney = checkTaxMoney.add(checkDetailEntity.getCheckTaxMny());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(checkDetailEntity.getId() == null ? IdWorker.getId() : checkDetailEntity.getId());
            detailExecutionVO.setSourceBillId(checkEntity.getId());
            detailExecutionVO.setCategoryId(checkDetailEntity.getMaterialTypeId());
            detailExecutionVO.setCategoryName(checkDetailEntity.getMaterialTypeName());
            detailExecutionVO.setCategoryFlag(false);
            detailExecutionVO.setCode(checkDetailEntity.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(false);
            //根据分类ID查询物料分类信息
            MaterialCategoryVO categoryVO = materialApi.queryCategoryById(checkDetailEntity.getMaterialTypeId()).getData();
            if (categoryVO==null){
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            }else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(checkDetailEntity.getMaterialId());
            detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
            detailExecutionVO.setName(checkDetailEntity.getMaterialName());
            detailExecutionVO.setUnitId(checkDetailEntity.getUnitId());
            detailExecutionVO.setUnitName(checkDetailEntity.getUnit());
            detailExecutionVO.setNum(checkDetailEntity.getCheckNum());
            detailExecutionVO.setMoney(checkDetailEntity.getCheckMny());
            detailExecutionVO.setTaxMoney(checkDetailEntity.getCheckTaxMny());
            detailExecutionVO.setPrice(checkDetailEntity.getCheckPrice());
            detailExecutionVO.setTaxPrice(checkDetailEntity.getCheckTaxPrice());
            detailExecutionVO.setTaxRate(checkDetailEntity.getTaxRate());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void deletes(List<ConcreteCheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1){
            throw new BusinessException("验收单不允许批量删除!");
        }
        ConcreteCheckVO concreteCheckVO = vos.get(0);
        ConcreteCheckEntity concreteCheckEntity = super.selectById(concreteCheckVO.getId());
        List<ConcreteCheckDetailEntity> checkDetailList = concreteCheckEntity.getConcreteCheckDetailList();
        List<ConcreteCheckWeighEntity> concreteCheckWeighList = concreteCheckEntity.getConcreteCheckWeighList();
        ConcreteDeliveryEntity deliveryEntity = concreteDeliveryService.selectById(concreteCheckEntity.getDeliveryId());
        if (deliveryEntity != null){
            List<ConcreteDeliveryDetailEntity> deliveryDetailList = deliveryEntity.getConcreteDeliveryDetailList();
            Map<Long, ConcreteCheckDetailEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(ConcreteCheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (ConcreteDeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
                if(checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())){
                    ConcreteCheckDetailEntity checkDetailEntity = checkDetailEntityMap.get(deliveryDetailEntity.getId());
                    deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
                }
            }

            //判断发货单的验收状态
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> (e.getCheckNum().compareTo(BigDecimal.ZERO) == 1) &&
                    (e.getCheckNum().compareTo(e.getDeliveryNum()) == -1));
            Integer checkStatus = 0;
            if (allCheck){
                checkStatus = 2;
            }
            if (anyCheck){
                checkStatus = 1;
            }
            //更新发货验收状态和验收数量
            deliveryEntity.setCheckStatus(checkStatus);
            concreteDeliveryService.updateById(deliveryEntity);
            concreteDeliveryDetailService.updateBatchById(deliveryDetailList);

            //推送供方
            //对单据进行加锁
            if(!DeliveryTypeEnum.自制送货单.getCode().equals(deliveryEntity.getDeliveryType())) {//自制发货单不推送供方
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("获取当前系统编码失败！");
                }
                Map<String, Object> map = new HashMap<>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, PUSH_BILL_SERVER_URL, RequestMethod.POST,
                        deliveryEntity.getSupplierId().toString(), OPERATE, BILL_TYPE);
                if (!updateSupplierStatus) {
                    throw new BusinessException("单据推送失败！");
                }
            }
        }

        //目标成本推送
        if(CollectionUtils.isNotEmpty(vos)) {
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (ConcreteCheckVO checkVO1 : vos) {
                ConcreteCheckEntity checkEntity1 = super.selectById(checkVO1.getId());
                ExecutionVO executionVO = targetCost(checkEntity1);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
            if (concreteCheckEntity.getAttrFlag() == 1){
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败" + response.getMsg());
                }
            }
        }

        //删除实际成本
        //仓库属性是甲供材的不推送实际成本
        if (concreteCheckEntity.getAttrFlag().equals(1)){
            CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(concreteCheckEntity.getId());
            logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
            if(!stringCommonResponse.isSuccess()){
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        this.delWeighBill(concreteCheckWeighList);
        super.removeByIds(vos.stream().map(ConcreteCheckVO::getId).collect(Collectors.toList()),true);
        return ;
    }
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        ConcreteCheckEntity checkEntity = super.selectById(billId);
        //设置供方签字信息
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = BILL_TYPE + "::" + checkEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", checkEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }
            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, checkEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            checkEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            // 乙方已签字状态即待甲方签字
            checkEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(checkEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", checkEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    @Override
    public CommonResponse<ConcreteCheckVO> pushCost(ConcreteCheckVO checkVO) {
        ConcreteCheckEntity checkEntity = baseMapper.selectById(checkVO.getId());
        if (CollectionUtils.isNotEmpty(checkVO.getConcreteCheckDetailList())) {
            List<ConcreteCheckDetailEntity> checkDetailEntityList = BeanMapper.mapList(checkVO.getConcreteCheckDetailList(), ConcreteCheckDetailEntity.class);
            checkEntity.setConcreteCheckDetailList(checkDetailEntityList);
        }
        super.saveOrUpdate(checkEntity, false);

        if (checkEntity.getAttrFlag().equals(1)){
            //推送数据
            costPush(checkEntity);
        }

        return CommonResponse.success(BeanMapper.map(checkEntity, ConcreteCheckVO.class));
    }

    @Override
    public void costPush(ConcreteCheckEntity checkEntity) {
        logger.info("开始costPush");
        List<ConcreteCheckDetailEntity> checkDetailList = checkEntity.getConcreteCheckDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(checkDetailList)) {
            for (ConcreteCheckDetailEntity checkDetailEntity : checkDetailList) {
                if (null == checkDetailEntity.getSubjectId() || null == checkDetailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(checkDetailList)) {
            newRelationFlag = "0";
        }

        //更新是否关联
        LambdaUpdateWrapper<ConcreteCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(ConcreteCheckEntity::getId, checkEntity.getId());
        updateWrapper.set(ConcreteCheckEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        saveCost(checkEntity,1);
    }

    @Override
    public ConcreteCheckVO getConcreteDetailListData(ConcreteCheckVO checkVO) {

        ContractEntity contractEntity = contractService.selectById(checkVO.getContractId());
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        List<ConcreteCheckDetailVO> checkDetailListPC = checkVO.getConcreteCheckDetailList();
        Map<Long, ContractDetailEntity> contractDetailEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));

        for (ConcreteCheckDetailVO checkDetailVO : checkDetailListPC){
            if (contractDetailEntityMap.containsKey(checkDetailVO.getMaterialId())){
                ContractDetailEntity contractDetailEntity = contractDetailEntityMap.get(checkDetailVO.getMaterialId());
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            checkDetailVO.setTaxRate(contractEntity.getTaxRate());

        }
        return checkVO;
    }

    @Override
    public ConcreteCheckVO queryDetail(Long id) {
        ConcreteCheckEntity entity = super.selectById(id);
        ConcreteCheckVO vo = BeanMapper.map(entity, ConcreteCheckVO.class);
        //处理供应商子表信息
        List<ConcreteCheckDetailVO> concreteCheckDetailList = vo.getConcreteCheckDetailList();
        List<ConcreteCheckAdmixtureVO> concreteCheckAdmixtureList = vo.getConcreteCheckAdmixtureList();
        if (CollectionUtils.isNotEmpty(concreteCheckAdmixtureList)){
            Map<Long, List<ConcreteCheckAdmixtureVO>> bidderMap = concreteCheckAdmixtureList.stream().
                    collect(Collectors.groupingBy(ConcreteCheckAdmixtureVO::getDetailId));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(concreteCheckDetailList)){
                for (ConcreteCheckDetailVO concreteCheckDetailVO : concreteCheckDetailList){
                    List<ConcreteCheckAdmixtureVO> admixtureVOList = bidderMap.get(concreteCheckDetailVO.getId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(admixtureVOList)){
                        concreteCheckDetailVO.setAdmixtureVOList(admixtureVOList);
                    }
                }
            }
        }
        return vo;
    }

    private void saveCost(ConcreteCheckEntity checkEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<ConcreteCheckDetailEntity> checkDetailList = checkEntity.getConcreteCheckDetailList();
        if (CollectionUtils.isNotEmpty(checkDetailList)) {
            for (ConcreteCheckDetailEntity checkDetailEntity : checkDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(checkDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(checkDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(checkDetailEntity.getSubjectName());
                costDetailVO.setWbsId(checkDetailEntity.getWbsId());
                costDetailVO.setWbsCode(checkDetailEntity.getWbsCode());
                costDetailVO.setWbsName(checkDetailEntity.getWbsName());
                costDetailVO.setSourceId(checkEntity.getId());
                costDetailVO.setSourceDetailId(checkDetailEntity.getId());
                costDetailVO.setHappenTaxMny(checkDetailEntity.getCheckTaxMny());
                costDetailVO.setHappenMny(checkDetailEntity.getCheckMny());
                costDetailVO.setNum(checkDetailEntity.getCheckNum());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("CONCRETE_CHECK");
                costDetailVO.setSourceTabType("CONCRETE_CHECK_DETAIL");
                costDetailVO.setProjectId(checkEntity.getProjectId());
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.混凝土验收单.getTypeName());
                costDetailVO.setMaterialId(checkDetailEntity.getMaterialId());
                costDetailVO.setMaterialName(checkDetailEntity.getMaterialName());
                costDetailVO.setMaterialCode(checkDetailEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(checkDetailEntity.getMaterialTypeId());
                costDetailVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
                costDetailVO.setUnit(checkDetailEntity.getUnit());
                costDetailVO.setUnitId(checkDetailEntity.getUnitId());
                costDetailVO.setSpec(checkDetailEntity.getSpec());
                String url = null;
                if (checkEntity.getContractId() ==null){
                    url = "/ejc-promaterial-frontend/#/concreteCheck/card?id=" + checkEntity.getId();
                }
                if (checkEntity.getContractId() !=null){
                    url = "/ejc-promaterial-frontend/#/concreteCheck/contractCard?id=" + checkEntity.getId();
                }
                costDetailVO.setSourceBillUrl(url);
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        //目标成本推送 甲供材不控制
        ConcreteCheckEntity concreteCheckEntity = super.selectById(id);
        ConcreteCheckVO  concreteCheckVO = BeanMapper.map(concreteCheckEntity,ConcreteCheckVO.class);
        CommonResponse<ParamsCheckVO> response = new CommonResponse<>();
        if(concreteCheckVO.getAttrFlag()!=null && concreteCheckVO.getAttrFlag()==1){//仓库属性 1-自购材；2-甲供材
            ExecutionVO executionVO = targetCost(concreteCheckEntity);
            logger.error("ss" + JSONObject.toJSONString(executionVO));
            response = executionApi.ctrlCheckVO(executionVO);
        }
        //单据参数控制
        ParamsCheckVO paramsCheckVO = this.checkParams(concreteCheckVO,response.getData());
        return paramsCheckVO;
    }
    /*
     * 材料验收、混凝土验收—无合同验收-单次无合同验收金额控制*/
    @Override
    public  List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE,orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("消耗材-单次无合同验收金额控制控制："+JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("本次验收金额超过限定金额");
                        paramsCheckDsVO.setWarnName("单次无合同材料验收金额超限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(checkTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(checkTaxMny, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /*
     * 材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
     */
    @Override
    public  List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUB_MNY_CODE,orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("消耗材-单个供应商无合同验收金额控制："+JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMnyAll.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("供应商无合同验收金额超过限定金额");
                        paramsCheckDsVO.setWarnName("供应商无合同验收金额超过限定金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(currentMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计验收金额：").append(checkTaxMnyAll.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，限定金额：").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(checkTaxMnyAll, roleValue).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ConcreteCheckVO checkVO) {
        CommonResponse<ParamsCheckVO> response = new CommonResponse<>();
        if(checkVO.getAttrFlag()!=null && checkVO.getAttrFlag()==1) {//仓库属性 1-自购材；2-甲供材
            ConcreteCheckVO vo = saveOrUpdates(checkVO, true);
            //目标成本推送
            ExecutionVO executionVO = targetCost(BeanMapper.map(vo, ConcreteCheckEntity.class));
            logger.error("ss" + JSONObject.toJSONString(executionVO));
            response = executionApi.ctrlCheckVO(executionVO);
        }
        //单据参数控制
        ParamsCheckVO paramsCheckVO = this.checkParams(checkVO,response.getData());
        return paramsCheckVO;
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(ConcreteCheckVO vo,ParamsCheckVO paramsCheckVO2){

        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*预警添加域*/
        if(null!=vo.getContractId()) {//有合同预警域
            ContractEntity contractEntity = contractService.selectById(vo.getContractId());
            paramsCheckVOS.addAll(this.checkParamsNum(contractEntity,vo));//数量
        }else {//无合同预警域
            if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
                paramsCheckVOS.addAll(this.checkParamsConstruction( vo));//【施工合同金额】控【无合同验收、零星机械金额】
            }
        }
        //材料验收、混凝土验收—无合同验收-单次无合同验收金额控制
        if(vo.getContractId()==null){
            //获取验收金额
            List<ConcreteCheckDetailVO> checkDetailList = vo.getConcreteCheckDetailList();
            if (CollectionUtils.isNotEmpty(checkDetailList)){
                BigDecimal checkTaxMny = checkDetailList.stream().map(ConcreteCheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal oldTaxMny = checkService.getSupplierNoContractMny(vo.getProjectId(), vo.getSupplierId());
//                BigDecimal taxMny = ComputeUtil.safeAdd(checkTaxMny,oldTaxMny); // 本期+以往
                paramsCheckVOS.addAll(this.checkParamsCheckNum(checkTaxMny,vo.getOrgId()));
            }
        }
        //材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
        if(vo.getContractId()==null){
//            2、单个供应商无合同验收金额：根据项目+供应商查询所有状态的无合同材料验收+无合同混凝土验收金额+本期金额】
            List<ConcreteCheckDetailVO> checkDetailList = vo.getConcreteCheckDetailList();
            BigDecimal currentMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(checkDetailList)){
                currentMny = checkDetailList.stream().map(ConcreteCheckDetailVO::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            LambdaQueryWrapper<ConcreteCheckEntity> checkLambda = Wrappers.<ConcreteCheckEntity>lambdaQuery();
            checkLambda.eq(ConcreteCheckEntity::getProjectId,vo.getProjectId());
//            checkLambda.eq(ConcreteCheckEntity::getContractId,null);
            checkLambda.isNull(ConcreteCheckEntity::getContractId);
            checkLambda.eq(ConcreteCheckEntity::getSupplierId,vo.getSupplierId());
            List<ConcreteCheckEntity> checkEntityList = super.list(checkLambda);
            BigDecimal checkAll = currentMny;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(checkEntityList)){
                List<Long> checkIds = checkEntityList.stream().map(ConcreteCheckEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<ConcreteCheckDetailEntity> checkDetailLambda = Wrappers.<ConcreteCheckDetailEntity>lambdaQuery();
                checkDetailLambda.in(ConcreteCheckDetailEntity::getCheckId,checkIds);
                List<ConcreteCheckDetailEntity> checkDetailEntityList = concreteCheckDetailService.list(checkDetailLambda);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(checkDetailEntityList)){
                    BigDecimal checkTaxMny = checkDetailEntityList.stream().map(ConcreteCheckDetailEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    checkAll = currentMny.add(checkTaxMny);
                }

            }
            paramsCheckVOS.addAll(this.checkParamsCheckSubNum(currentMny,checkAll,vo.getOrgId()));//数量
        }
        //成本参数
        if(paramsCheckVO2!=null){
            paramsCheckVOS.add(paramsCheckVO2);
        }
        //成本科目控制
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }

        ParamsCheckVO priceParams = this.priceCheckParams(vo);
        if(priceParams!=null){//价格库控制
            paramsCheckVOS.add(priceParams);
        }
        if(!"proMaterial-3".equals(vo.getCheckType())) {//零星材料，不控制
            ParamsCheckVO costParams = this.costPriceCheckParams(vo);
            if (costParams != null) {//目标成本价格库控制
                paramsCheckVOS.add(costParams);
            }
        }

        /*预警添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(ConcreteCheckVO vo){
        List<ConcreteCheckDetailVO> concreteCheckDetailList = vo.getConcreteCheckDetailList();
        if(CollectionUtils.isNotEmpty(concreteCheckDetailList)){
            Map<Long,CostCtrlDetailVO> map = new HashMap<>();
            for(ConcreteCheckDetailVO checkDetailVO:concreteCheckDetailList){
                if(null!=checkDetailVO.getSubjectId()&&!"del".equals(checkDetailVO.getRowState())){
                    BigDecimal checkMny = checkDetailVO.getCheckMny()==null?BigDecimal.ZERO:checkDetailVO.getCheckMny();
                    BigDecimal checkTaxMny = checkDetailVO.getCheckTaxMny()==null?BigDecimal.ZERO:checkDetailVO.getCheckTaxMny();
                    if(map.containsKey(checkDetailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(checkDetailVO.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(checkMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(checkTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(checkDetailVO.getSubjectId());
                        costCtrlDetailVO.setMny(checkMny);
                        costCtrlDetailVO.setTaxMny(checkTaxMny);
                        map.put(checkDetailVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }
            if(null!=map){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if(null!=vo.getId()){
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }
    /*
     * 【施工合同金额】控【无合同验收、零星机械金额】*/
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ConcreteCheckVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;//施工合同金额
        BigDecimal mny = null==vo.getCheckAllTaxMny()?BigDecimal.ZERO:vo.getCheckAllTaxMny();//本次验收金额
        BigDecimal totalMny = mny;//无合同验收金额+临时设备记录使用金额   默认赋值本次结算金额
        //根据项目查询该项目下所有状态的 物资/混凝土验收金额累计
        LambdaQueryWrapper<CheckEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CheckEntity::getProjectId, vo.getProjectId());
        wrapper.isNull(CheckEntity::getContractId);
        List<CheckEntity> list = checkService.list(wrapper);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list)){
            BigDecimal totalTaxMny = list.stream().filter(e -> null!=e.getCheckAllTaxMny()).map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny,totalTaxMny);//累加消耗材无合同验收金额
        }
        LambdaQueryWrapper<ConcreteCheckEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(ConcreteCheckEntity::getProjectId, vo.getProjectId());
        wrapper2.isNull(ConcreteCheckEntity::getContractId);
        if(null!=vo.getId()){
            wrapper2.ne(ConcreteCheckEntity::getId, vo.getId());
        }
        List<ConcreteCheckEntity> list2 = super.list(wrapper2);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list2)){
            BigDecimal totalTaxMny = list2.stream().filter(e -> null!=e.getCheckAllTaxMny()).map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd(totalMny,totalTaxMny);//累加混凝土无合同验收金额
        }
        //根据项目查询该项目下所有状态的【临时设备使用记录金额】
        CommonResponse<JSONObject> response = temporaryUseRecordApi.queryProTemporaryUseRecordMny(vo.getProjectId());
        logger.info("该项目：{}-下所有状态的【临时设备使用记录金额】金额结果:{}",vo.getProjectId(),JSONObject.toJSONString(response));
        if(response.isSuccess() && null!=response.getData()){
            BigDecimal useMny = response.getData().getBigDecimal("useMny");
            totalMny = ComputeUtil.safeAdd(totalMny,useMny);//累加 临时设备使用记录金额
        }
        //根据项目查询施工合同金额
        CommonResponse<ContractRegisterVO> commonResponse = proincomeContrantApi.queryContranctMny(vo.getProjectId());
        logger.info("该项目:{}-下生效的最新正式施工合同:{}",vo.getProjectId(),JSONObject.toJSONString(commonResponse));
        if(commonResponse.isSuccess() && null!=commonResponse.getData()){
            contractTaxMny = null==commonResponse.getData().getContractTaxMny() ? BigDecimal.ZERO : commonResponse.getData().getContractTaxMny();
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【施工合同金额】控【无合同验收、零星机械金额】信息返回："+JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();//参数值
                    //施工合同百分比 后的金额
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("无合同验收、临机费用超施工合同额");
                        paramsCheckDsVO.setWarnName("无合同验收、临机费用累计金额超施工合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次金额：").append(mny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次零材、零机发生金额：").append(totalMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }
    //价格库合同参数控制
    @Override
    public ParamsCheckVO priceCheckParams(ConcreteCheckVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
//        switch (vo.getSettlementType()){
//            case 0: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.消耗材结算.getCode());break;
//            case 1: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.混凝土结算.getCode());break;
//        }
        materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.混凝土验收.getCode());
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getConcreteCheckDetailList())){
            for (ConcreteCheckDetailVO detailVO : vo.getConcreteCheckDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(ConcreteCheckVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.混凝土验收.getCode());
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getConcreteCheckDetailList())){
            for (ConcreteCheckDetailVO detailVO : vo.getConcreteCheckDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = contractService.costPriceParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }


    /**
     * 单据管控-累计入库数量大于合同数量
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity,ConcreteCheckVO vo) {
        String purchaseType = contractEntity.getPurchaseType();//采购类型 1-自采，2-集采
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        if (PurchaseTypeEnum.公司集采.getCode().equals(purchaseType)) {
            // 集采合同直接赋值为不控制
            return paramsCheckVOS;
        }
        //查询结算累计子表
        List<ConcreteCheckDetailVO> detail = baseMapper.getDetail(contractEntity.getId(),vo.getId());
        Map<Long, ConcreteCheckDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(ConcreteCheckDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        //合同分类
        Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        //合同明细
        Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        //结算分类数量 分类数量 = 累计结算+本次 都不在的合同明细的明细数量累加
        Map<Long, BigDecimal> detailTypeMap = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detail)){
            for (ConcreteCheckDetailVO detailVO : detail) {
                if(!map.containsKey(detailVO.getMaterialId())){//不属于明细
                    BigDecimal num = detailTypeMap.get(detailVO.getMaterialTypeId());
                    if(detailTypeMap.containsKey(detailVO.getMaterialTypeId())){//存在累加更新
                        detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd(num, detailVO.getCheckNum()));
                    }else {//不存在，添加
                        detailTypeMap.put(detailVO.getMaterialTypeId(),detailVO.getCheckNum());
                    }
                }
            }
        }
        //当前单据吗明细 去重过累加过的的
        Map<Long, ConcreteCheckDetailVO> detailMap = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(vo.getConcreteCheckDetailList())) {
            for (ConcreteCheckDetailVO detailVO : vo.getConcreteCheckDetailList()) {
                if (!"del".equals(detailVO.getRowState())) {
                    ConcreteCheckDetailVO mapVO = detailMap.get(detailVO.getMaterialId());
                    if (Objects.nonNull(mapVO)) {
                        detailVO.setCheckNum(ComputeUtil.safeAdd(mapVO.getCheckNum(), detailVO.getCheckNum()));
                        detailMap.put(detailVO.getMaterialId(), detailVO);
                    } else {
                        detailMap.put(detailVO.getMaterialId(), detailVO);
                    }
                    if (!map.containsKey(detailVO.getMaterialId())) {//不属于明细
                        BigDecimal num = detailTypeMap.get(detailVO.getMaterialTypeId());
                        if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {//存在累加更新
                            detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd(num, detailVO.getCheckNum()));
                        } else {//不存在，添加
                            detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getCheckNum());
                        }
                    }
                }
            }
        }
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("入库数量控制信息返回："+JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailMap.values())){
                        for (ConcreteCheckDetailVO detailVO : detailMap.values()) {
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId())?detailSettleMap.get(detailVO.getMaterialId()).getCheckNum():BigDecimal.ZERO;
                            //含本次结算数量
                            BigDecimal totalNum = ComputeUtil.safeAdd(num, detailVO.getCheckNum()).setScale(4, BigDecimal.ROUND_HALF_UP);
                            //含本次结算分类明细
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId())?detailTypeMap.get(detailVO.getMaterialTypeId()):BigDecimal.ZERO;
                            //合同数量
                            BigDecimal comNum = BigDecimal.ZERO;
                            //是否属于合同明细
                            if(map.containsKey(detailVO.getMaterialId())){
                                ContractDetailEntity detailEntity = map.get(detailVO.getMaterialId());
                                //合同数量
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailEntity.getNum(), roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                                //是否属于合同分类
                            }else if(typeMap.containsKey(detailVO.getMaterialTypeId())){
                                ContractDetailEntity detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                //合同数量
                                totalNum = numType;
                                comNum = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(detailEntity.getNum(), roleValue), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                                //都不属于
                            }else {
                                continue;
                            }
                            if (totalNum.compareTo(comNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(datum.getOrgName());
                                paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+ (detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                                paramsCheckDsVO.setWarnName("入库数量大于合同数量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("本次入库数量：").append(detailVO.getCheckNum().setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计入库数量：").append(totalNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("，合同数量*").append(roleValue).append("%:").append(comNum.setScale(4, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(totalNum, comNum).setScale(4, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOS;
    }

    @Override
    public CheckEntity syncCost(Long id) {
        ConcreteCheckEntity checkEntity = super.selectById(id);
        //甲供材不推送目标成本
        //目标成本推送
        ExecutionVO executionVO = targetCost(checkEntity);
        logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本推送失败:" + response.getMsg());
        }
        return null;
    }

    @Override
    public ConcreteCheckVO getDetailListData(ConcreteCheckVO checkVO) {
        //
        ContractEntity contractEntity = contractService.selectById(checkVO.getContractId());
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        List<ConcreteCheckDetailVO> checkDetailListPC = checkVO.getConcreteCheckDetailList();
//        Map<Long, ContractDetailEntity> contractDetailEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
//        Map<Long, ContractDetailEntity> contractDetailTypeEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
        List<Long> materialIds = checkDetailListPC.stream().map(ConcreteCheckDetailVO::getMaterialId).collect(Collectors.toList());

//        for (CheckDetailVO checkDetailVO : checkDetailListPC){
//            if (contractDetailEntityMap.containsKey(checkDetailVO.getMaterialId())){
//                ContractDetailEntity contractDetailEntity = contractDetailEntityMap.get(checkDetailVO.getMaterialId());
//                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
//                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
//                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
//                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
//                continue;
//            }
//            if (contractDetailTypeEntityMap.containsKey(checkDetailVO.getMaterialTypeId())){
//                ContractDetailEntity contractDetailEntity = contractDetailTypeEntityMap.get(checkDetailVO.getMaterialTypeId());
//                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
//                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
//                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
//                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
//                continue;
//            }
//            checkDetailVO.setTaxRate(contractEntity.getTaxRate());
//        }

        CommonResponse<List<MaterialVO>> commonResponse = materialApi.queryMaterialItemByIds(materialIds);
        if (commonResponse.isSuccess()) {
            List<MaterialVO> materialVOList = commonResponse.getData();
            Map<Long, MaterialVO> materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));

            for (ConcreteCheckDetailVO checkDetailVO : checkDetailListPC){
                if (materialVOMap.containsKey(checkDetailVO.getMaterialId())){
                    MaterialVO materialVO = materialVOMap.get(checkDetailVO.getMaterialId());
                    checkDetailVO.setSubjectId(materialVO.getSubjectId());
                    checkDetailVO.setSubjectName(materialVO.getSubjectName());
                }
            }
        }
        return checkVO;
    }

    @Override
    public ConcreteCheckVO queryDetailWeigh(ConcreteCheckVO vo) {
        ConcreteCheckVO ConcreteCheckVO = concreteDeliveryService.queryDetailToCheck(vo.getDeliveryId());
        logger.info("----磅单验收原数据 ：{}",JSONObject.toJSONString(ConcreteCheckVO));
        List<ConcreteCheckDetailVO> concreteCheckDetailList = ConcreteCheckVO.getConcreteCheckDetailList();
        List<ConcreteCheckWeighVO> concreteCheckWeighList = vo.getConcreteCheckWeighList();
        List<ConcreteCheckWeighVO> checkWeighVOS = new ArrayList<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(concreteCheckWeighList)){
            List<Long> collect = concreteCheckWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse<List<WeighbillVO>> listCommonResponse = weighbillApi.queryWeighbills(ConcreteCheckVO.getProjectId(), collect);
            if(!listCommonResponse.isSuccess()){
                throw new BusinessException("查询磅单失败！错误信息："+listCommonResponse.getMsg());
            }
            List<WeighbillVO> data = listCommonResponse.getData();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (WeighbillVO weighbillVO : data) {
                    ConcreteCheckWeighVO checkWeighVO = BeanMapper.map(weighbillVO, ConcreteCheckWeighVO.class);
                    BigDecimal netWeight = weighbillVO.getNetWeight();//净重
                    BigDecimal coefficient = weighbillVO.getCoefficient();//换算系数
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<ConcreteCheckWeighVO>> weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(ConcreteCheckWeighVO::getDeliveryDetailId));
                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(concreteCheckDetailList)){
                    for (ConcreteCheckDetailVO checkDetailVO : concreteCheckDetailList) {
                        List<ConcreteCheckWeighVO> checkWeighS = weighMap.get(checkDetailVO.getDeliveryDetailId());
                        if(null!=checkWeighS && org.apache.commons.collections.CollectionUtils.isNotEmpty(checkWeighS)){
                            BigDecimal checkNum = checkWeighS.stream().map(ConcreteCheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(ConcreteCheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(ConcreteCheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv(detailNetWeightCoefficient,checkNum));
                            checkDetailVO.setCheckNum(checkNum);
                        }else {
                            checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                            checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                            checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                            checkDetailVO.setCheckNum(BigDecimal.ZERO);
                        }
                    }
                }
            }
        }
        ConcreteCheckVO.setCheckWeighType(CheckWeighTypeEnum.是磅单验收.getCode());
        ConcreteCheckVO.setConcreteCheckDetailList(concreteCheckDetailList);
        ConcreteCheckVO.setConcreteCheckWeighList(checkWeighVOS);
        return ConcreteCheckVO;
    }

    public Map<String,BigDecimal> getCheckNum(String weighUnit,BigDecimal netWeight,BigDecimal coefficient){
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        Map<String,BigDecimal>  map = new HashMap<>();
        if(null==coefficient){
            coefficient = BigDecimal.ZERO;
        }
        if(null==netWeight){
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if(StringUtils.isNotEmpty(weighUnit)){
            billStateCode = WeighUnitEnum.getEnumByStateCode(weighUnit).getBillStateCode();
        }
        switch (billStateCode){
            case 0:
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient,coefficient); break;
            case 1:
                detailNetWeightCoefficient = ComputeUtil.safeMultiply(netWeight,new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient,coefficient);;break;
        }
        map.put("checkNum",checkNum);
        map.put("detailNetWeightCoefficient",detailNetWeightCoefficient);
        return map;
    }

}
