package com.ejianc.business.promaterial.plan.service.impl;

import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("batPlan")
public class BatPlanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String SIGN = "plan";

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IBatPlanService batPlanService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		logger.info("------------撤回前回调------------");
		logger.info("billId:{},state:{},billTypeCode:{}",billId,state,billTypeCode);
		BatPlanEntity batPlanEntity = batPlanService.selectById(billId);
		// 如果是待采购，则不判断是否引用
		if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
			return CommonResponse.success();
		}
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("检查结果：{}",resp);
		if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
			return CommonResponse.error("单据被引用不能撤回！");
		}
		return CommonResponse.success();
	}

	;

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		logger.info("-------------------审批前回调------------------------");
		logger.info("sign-->>{}", sign);
		if (SIGN.equals(sign)) {
			BatPlanEntity batPlanEntity = batPlanService.selectById(billId);
			// 招标经办人不能为空
			if (batPlanEntity == null || batPlanEntity.getTrusteesId() == null){
				return CommonResponse.error("请先选择招标经办人！");
			}
		}
		return CommonResponse.success();
	}

	;

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("-------------------终审审核前回调------------------------");
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		logger.info("------------弃审前事件回调------------");
		logger.info("弃审前事件回调===billId:{},state:{},billTypeCode:{}",billId,state,billTypeCode);
		BatPlanEntity batPlanEntity = batPlanService.selectById(billId);
		// 如果是待采购，则不判断是否引用
		if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
			return CommonResponse.success();
		}
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("检查结果：{}",resp);
		if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
			return CommonResponse.error("单据被引用不能撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
