/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.electronicFence.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.electronicFence.service.IAmapService;
import com.ejianc.business.promaterial.electronicFence.vo.DistanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="amapService")
public class AmapServiceImpl
implements IAmapService {
    private static final String DISTANCE = "https://restapi.amap.com/v3/distance?parameters";
    private static final String REGEO = "https://restapi.amap.com/v3/geocode/regeo?parameters";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${amap.key}")
    private String key;

    @Override
    public List<DistanceVO> distance(String origins, String destination, String type) {
        Assert.hasText((String)origins, (String)"\u51fa\u53d1\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u76ee\u7684\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)type, (String)"\u8def\u5f84\u8ba1\u7b97\u7684\u65b9\u5f0f\u548c\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u8ddd\u79bb\u6d4b\u91cf\uff0c\u5165\u53c2\uff1aorigins--{}\uff0cdestination--{}\uff0ctype--{}", new Object[]{origins, destination, type});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("key", this.key);
        paramMap.put("origins", origins);
        paramMap.put("destination", destination);
        paramMap.put("type", type);
        HttpResponse response = HttpUtil.createGet((String)DISTANCE).form(paramMap).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u8bf7\u6c42\u9ad8\u5fb7\u5730\u56fe\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)response.body());
        String status = jsonObject.getString("status");
        if ("0".equals(status)) {
            throw new BusinessException("\u8ddd\u79bb\u6d4b\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jsonObject.getString("info"));
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"results")), DistanceVO.class);
    }

    @Override
    public JSONObject regeo(String location) {
        Assert.hasText((String)location, (String)"\u7ecf\u7eac\u5ea6\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u9006\u5730\u7406\u7f16\u7801\uff0c\u5165\u53c2\uff1alocation--{}", (Object)location);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("key", this.key);
        paramMap.put("location", location);
        HttpResponse response = HttpUtil.createGet((String)REGEO).form(paramMap).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u8bf7\u6c42\u9ad8\u5fb7\u5730\u56fe\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)response.body());
        String status = jsonObject.getString("status");
        if ("0".equals(status)) {
            throw new BusinessException("\u9006\u5730\u7406\u7f16\u7801\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jsonObject.getString("info"));
        }
        return (JSONObject)jsonObject.get((Object)"regeocode");
    }
}

