/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="order")
public class OrderBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrderService service;
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/deleteOrder";
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ICheckDetailService checkDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(billId));
        if (StringUtils.isNotEmpty((CharSequence)entity.getStopState())) {
            throw new BusinessException("\u8be5\u914d\u9001\u8ba1\u5212\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        List ids = entity.getOrderDetailList().stream().map(x -> x.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryParam param = new QueryParam();
            param.getParams().put("orderDetailId", new Parameter("in", ids));
            List list = this.checkDetailService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List pIds = list.stream().map(x -> x.getCheckId()).distinct().collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter("in", pIds));
                List pList = this.checkService.queryList(queryParam);
                List pIds2 = pList.stream().map(x -> x.getId()).collect(Collectors.toList());
                list = list.stream().filter(x -> pIds2.contains(x.getCheckId())).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                throw new BusinessException("\u4e0b\u6e38\u5355\u636e\u5df2\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        orderEntity.setReceiveState(null);
        this.service.updateById((Object)orderEntity);
        return CommonResponse.success((String)"");
    }
}

