/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MonthPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanService;
import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthPlanService")
public class MonthPlanServiceImpl
extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity>
implements IMonthPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE_C = "MONTH_PLAN_CODE";
    private static final String BILL_CODE_H = "HNTYJH01";
    private static final String MASTER_PLAN_NUM_CTRL_PARAM_CODE = "P-2d6J670187";
    private static final String MASTER_PLAN_PRICE_CTRL_PARAM_CODE = "P-tK1XUi0188";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private MonthPlanMapper mapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private OrgUtil orgUtil;

    @Override
    public IPage<MonthPlanVO> queryConcreteList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthPlanVO.class));
        return pageData;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public void excelConcreteExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = super.queryList(param);
        HashMap beans = new HashMap();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, MonthPlanVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteMonthPlan-export.xlsx", beans, response);
    }

    @Override
    public boolean monthQueryPlan(Long projectId, Date planMonth, Integer planType, Long id) {
        try {
            String monthDate = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)planMonth);
            List<MonthPlanVO> list = ((MonthPlanMapper)this.baseMapper).monthQueryPlan(projectId, monthDate, planType, id);
            if (CollectionUtils.isNotEmpty(list)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8be5\u9879\u76ee\u672c\u6708\u5df2\u662f\u5426\u5b58\u5728\u6708\u8ba1\u5212\u6821\u9a8c\u5931\u8d25\uff01");
        }
        return false;
    }

    @Override
    public CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveorUpdateVO) {
        List list = saveorUpdateVO.getMonthPlanDetailEntities();
        Integer size = (int)list.stream().filter(x -> !"del".equals(x.getRowState()) && null != x.getMatchStatus() && 1 != x.getMatchStatus()).count();
        if (size > 0) {
            throw new BusinessException("\u5b58\u5728\u672a\u5b8c\u5168\u5339\u914d\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
        }
        MonthPlanEntity entity = (MonthPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, MonthPlanEntity.class));
        if (null == entity.getPlanType()) {
            entity.setPlanType(0);
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            MonthPlanVO voByCode = this.queryByCode(entity.getBillCode(), entity.getPlanType());
            if (!(null == voByCode || null != entity.getId() && voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            String BILL_CODE = "";
            switch (entity.getPlanType()) {
                case 0: {
                    BILL_CODE = BILL_CODE_C;
                    break;
                }
                case 1: {
                    BILL_CODE = BILL_CODE_H;
                }
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse codeResp = this.billCodeApi.generateBillCode(billCodeParam);
            if (!codeResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            String code = this.orgUtil.getBillCodeByCorp(entity.getOrgId(), entity.getProjectId(), (String)codeResp.getData());
            entity.setBillCode(code);
        }
        entity.setName(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getPlanMonth()) + " " + entity.getBillCode());
        List<MonthPlanDetailEntity> monthPlanDetailEntities = entity.getMonthPlanDetailEntities();
        ArrayList masterDetailList = new ArrayList();
        for (MonthPlanDetailEntity monthPlanDetailEntitie : monthPlanDetailEntities) {
            monthPlanDetailEntitie.setSurplusNums(monthPlanDetailEntitie.getMonthPlanNum());
            monthPlanDetailEntitie.setName(entity.getBillCode());
        }
        super.saveOrUpdate((Object)entity, false);
        MonthPlanVO vo = (MonthPlanVO)BeanMapper.map((Object)((Object)entity), MonthPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public MonthPlanVO queryByCode(String planCode, Integer planType) {
        MonthPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MonthPlanEntity entity = (MonthPlanEntity)((Object)this.mapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MonthPlanVO)BeanMapper.map((Object)((Object)entity), MonthPlanVO.class);
        }
        return resp;
    }

    @Override
    public List<ParamsCheckVO> masterPlanNumCtrl(MonthPlanVO monthPlanVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MASTER_PLAN_NUM_CTRL_PARAM_CODE, monthPlanVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List checkParamData = (List)billParamByCode.getData();
        List detailList = monthPlanVO.getMonthPlanDetailEntities().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(MonthPlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, MonthPlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(MonthPlanDetailVO::getMaterialId, item -> item));
        if (CollectionUtils.isEmpty(detailIds)) {
            this.logger.info("\u5f85\u6392\u67e5\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return paramsCheckVOList;
        }
        List<Map<String, Object>> detailTotalNumInfo = this.monthPlanDetailService.countDetailTotalNum(monthPlanVO.getId(), detailIds, monthPlanVO.getProjectId());
        HashMap detailNumMap = new HashMap();
        Map detailCountMap = null;
        for (Map<String, Object> item2 : detailTotalNumInfo) {
            if (!detailVONumMap.containsKey(Long.valueOf(item2.get("materialId").toString()))) continue;
            detailCountMap = new HashMap<String, BigDecimal>();
            detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd((BigDecimal)detailVONumMap.get(Long.valueOf(item2.get("materialId").toString())).getMonthPlanNum(), (BigDecimal)(null != item2.get("totalMonthPlanNum") ? new BigDecimal(item2.get("totalMonthPlanNum").toString()) : BigDecimal.ZERO)));
            detailCountMap.put("masterPlanNum", new BigDecimal(item2.get("masterPlanNum").toString()));
            detailNumMap.put(Long.valueOf(item2.get("materialId").toString()), detailCountMap);
        }
        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        MonthPlanDetailVO tempDetail = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = ComputeUtil.safeDiv((BigDecimal)billParamVO.getRoleValue(), (BigDecimal)new BigDecimal("100"));
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    tempDetail = detailVONumMap.get(materialId);
                    detailCountMap = (Map)detailNumMap.get(materialId);
                    if (((BigDecimal)detailCountMap.get("masterPlanNum")).compareTo(new BigDecimal("-1")) == 0) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u603b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{tempDetail.getMaterialCategoryName(), tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId()});
                    }
                    if (((BigDecimal)detailCountMap.get("totalPlanNum")).compareTo(ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                    paramsCheckDsVO.setWarnName("\u6d88\u8017\u6750\u6708\u8ba1\u5212\u91cf\u8d85\u8fc7\u603b\u8ba1\u5212\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u6708\u8ba1\u5212\u91cf\uff1a").append(tempDetail.getMonthPlanNum().setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u6708\u8ba1\u5212\u91cf\uff1a").append(((BigDecimal)detailCountMap.get("totalPlanNum")).setScale(2, RoundingMode.DOWN)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%\uff1a").append(((BigDecimal)detailCountMap.get("masterPlanNum")).setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)((BigDecimal)detailCountMap.get("totalPlanNum")), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue)).setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> masterPlanPriceCtrl(MonthPlanVO monthPlanVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MASTER_PLAN_PRICE_CTRL_PARAM_CODE, monthPlanVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List checkParamData = (List)billParamByCode.getData();
        List detailList = monthPlanVO.getMonthPlanDetailEntities().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailList)) {
            this.logger.info("\u5f85\u6392\u67e5\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return paramsCheckVOList;
        }
        List<MasterPlanDetailEntity> masterPlanDetailList = this.masterPlanDetailService.getByProjectId(monthPlanVO.getProjectId(), 0);
        Map<Long, BigDecimal> masterDetailPriceNum = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, MasterPlanDetailEntity::getPrice));
        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        BigDecimal tmpPrice = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (MonthPlanDetailVO detail : detailList) {
                    tmpPrice = masterDetailPriceNum.get(detail.getMaterialId());
                    if (null == tmpPrice) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u603b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId()});
                        continue;
                    }
                    if (null == detail.getMonthPlanPrice()) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5355\u4ef7\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId()});
                        continue;
                    }
                    if (detail.getMonthPlanPrice().compareTo(ComputeUtil.safeMultiply((BigDecimal)tmpPrice, (BigDecimal)roleValue)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(detail.getMaterialName() + detail.getSpec());
                    paramsCheckDsVO.setWarnName("\u6d88\u8017\u6750\u6708\u8ba1\u5212\u5355\u4ef7\u8d85\u8fc7\u603b\u8ba1\u5212\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u6708\u8ba1\u5212\u5355\u4ef7\uff1a").append(detail.getMonthPlanNum().setScale(2, RoundingMode.DOWN)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*X%\uff1a").append(ComputeUtil.safeMultiply((BigDecimal)tmpPrice, (BigDecimal)roleValue).setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)detail.getMonthPlanPrice(), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)tmpPrice, (BigDecimal)roleValue)).setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }
}

