package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.promaterial.contract.bean.*;
import com.ejianc.business.promaterial.contract.enums.*;
import com.ejianc.business.promaterial.contract.service.*;
import com.ejianc.business.promaterial.contract.vo.*;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.pricelib.api.IMaterialPriceHistoryApi;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.*;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.promaterial.sync.bean.SyncContractEntity;
import com.ejianc.business.promaterial.sync.service.ISyncContractService;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.*;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.contract.mapper.ContractMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 物资合同 */
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";
    /** 混凝土合同 */
    private static final String PURCHASE_CONTRACT_CONCRETE_BILL_CODE = "CONTRACT_CONCRETE";

    private static final String PURCHASE_CONTRACT_YNJT = "CONTRACT_MATERIAL_YNJT";

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

//    /** 合同类型（0-物资采购合同，1-混凝土合同） */
//    private static final Integer CONTRACT_TYPE_0 = 0;
//    /** 合同类型（0-物资采购合同，1-混凝土合同） */
//    private static final Integer CONTRACT_TYPE_1 = 1;

    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService service;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITenderRmatApi tenderRmatApi;

    @Autowired
    private IParamCheckApi paramCheckApi;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private ITenderApi tenderApi;
    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IMasterPlanService masterPlanService;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IDutyApi iDutyApi;
    @Autowired
    private ICommonSNAPI commonSNAPI;

    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IDutyApi dutyApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    private final String MAIN_CONTRACT_REFCODE = "contractMaterial";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_SUP_CODE = "P-CO2iY888";//消耗材补充金额控制
    private static final String C_SUP_CODE = "P-K496W490";//混凝补充金额控制
    private static final String M_PLAN_CODE = "P-CcZ6rO87";//消耗材总计划金额控制
    private static final String C_PLAN_CODE = "P-00g5A089";//混凝总计划金额控制

    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134"; //合同归档控制

    private static final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182"; // 合同更新签订日期控制

    @Autowired
    private IBatPlanDetailService planDetailService;
    @Autowired
    private ISyncContractService syncContractService;

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        // parentOrgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(contractVo.getParentOrgCode()) && contractVo.getParentOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getParentOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                contractVo.setParentOrgCode(orgVO.getCode());
//            }
//        }
//        if (StringUtils.isEmpty(contractVo.getOrgCode()) && contractVo.getOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                contractVo.setOrgCode(orgVO.getCode());
//            }
//        }
        if (contractVo.getId() != null&&!isControl) {
            // 先删除原来的数据
            ContractVO delVo = this.queryDetail(contractVo.getId());
            if(PurchaseTypeEnum.项目自采.getCode().equals(delVo.getPurchaseType())){
                // 只有合同采购类型变更，才删除原来的目标成本
                if (!delVo.getContractPropertyCode().equals(contractVo.getContractPropertyCode())) {
                    //目标成本推送
                    List<TotalExecutionVO> totalExecutionVODelList = new ArrayList<>();
                    ExecutionVO executionVODel = service.targetCost(delVo,"",0,delVo.getContractType());
                    totalExecutionVODelList.add(executionVODel.getTotalVO());
                    logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVODelList));
                    CommonResponse<String> response = executionApi.aggDel(totalExecutionVODelList);
                    if (!response.isSuccess()){
                        throw new BusinessException("目标成本推送失败,"+response.getMsg());
//                    return CommonResponse.error("目标成本推送失败,"+response.getMsg());
                    }
                }
            }
        }


        if (contractVo.getOrgId() != null && (StringUtils.isEmpty(contractVo.getOrgCode())
                || StringUtils.isEmpty(contractVo.getParentOrgCode()) || StringUtils.isEmpty(contractVo.getOrgName()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                contractVo.setOrgCode(orgVO.getCode());
                if(StringUtils.isEmpty(contractVo.getOrgName())){
                    contractVo.setOrgName(orgVO.getName());
                }
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        contractVo.setParentOrgId(parentOrgVO.getId());
                        contractVo.setParentOrgCode(parentOrgVO.getCode());
                        contractVo.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    contractVo.setParentOrgId(contractVo.getOrgId());
                    contractVo.setParentOrgCode(contractVo.getOrgCode());
                    contractVo.setParentOrgName(contractVo.getOrgName());
                }
            }
        }
        // 参照定标结果新增、编辑合同，需要给初始签订数量赋值
        if(contractVo.getTargetResultId() != null && CollectionUtils.isNotEmpty(contractVo.getContractDetailList())){
            for (ContractDetailVO detailVO:contractVo.getContractDetailList()) {
                detailVO.setInitNum(detailVO.getNum());
            }
        }
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        if (!isControl){
            if (StringUtils.isEmpty(contractVo.getBillCode())) {
                // 合同编码生成
                entity.setBillCode(this.getContractBillCode(contractVo));
            }
        }
        if (entity.getId() == null) {
            //设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setId(IdWorker.getId());

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());

        // 原合同变更删除附件逻辑，修改为下面这种方式
//        if (entity.getContractFileId() != null) {
//            if (entity.getId() != null) {
//                ContractEntity contract = super.getById(entity.getId());
//                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
//                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    if (!isControl) {
//                        delContractFile(entity.getContractFileId(), authority);
//                    }
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            } else {
//                //如果是新建合同，且起草方式为线上起草则删除附件
//                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    if (!isControl) {
//                        delContractFile(entity.getContractFileId(), authority);
//                    }
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            }
//        }

        // 1、合同保存方法增加逻辑
        if (entity.getContractFileId() != null) {
            //合同旧数据
            ContractEntity contract = service.getById(entity.getId());
            if (contract != null && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractCategoryId().equals(entity.getContractCategoryId())
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            || !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType())
                            || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            ) && (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }

        if (!isControl) {
            //定标回写占用
            //占用状态0-未占用,1-已占用,2-已完成
            // 校验数量
            this.checkDetailTenderNum(contractVo.getContractDetailList(), contractVo.getId(),
                    contractVo.getTargetResultId());

            // 回写占用量
            this.writeBackOccupyNum(entity);

            boolean saveFlag = super.saveOrUpdate(entity, false);
            if (!saveFlag) {
                throw new BusinessException("合同保存失败！");
            }
            if (contractVo.getId() == null && contractVo.getTargetResultId() != null) {
//                tenderApi.updateById(contractVo.getTargetResultId(), 1);
                this.updateTargetResult(contractVo, 0);
            }
            if (contractVo.getId() != null && contractVo.getTargetResultId() != null) {
                ContractEntity contractEntity = super.selectById(contractVo.getId());
//                CommonResponse<String> stringCommonResponse = tenderApi
//                        .updateById(contractEntity.getTargetResultId(), 0);
//                tenderApi.updateById(contractVo.getTargetResultId(), 1);
                // 如果是合同修改，先对修改前合同做反向操作，再进行占用
                this.updateTargetResult(BeanMapper.map(contractEntity, ContractVO.class), 1);
                this.updateTargetResult(contractVo, 0);
            }

            //起草方式为使用合同模板时，将合同文件同步标识置为未同步
            if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())
                    || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }
            //集采时不推成本执行数据
            if (entity.getPurchaseType().equals("1")) {
                //目标成本推送
                String linkUrl;
                String frontendBaseHost="";
                if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                    frontendBaseHost = BASE_HOST_FRONTEND;
                }else{
                    frontendBaseHost = BaseHost;
                }

                if (entity.getContractType() == 0) {
                    linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + entity.getId();
                }
                else {
                    linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + entity.getId();
                }
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class),linkUrl,0,entity.getContractType());
                logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
        }

        return CommonResponse.success(BeanMapper.map(entity, ContractVO.class));
    }

    @Override
    public Boolean delete(List<ContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (ContractVO contractVO : vos) {
                ContractEntity contractEntity = service.selectById(contractVO.getId());
                if (contractEntity.getPurchaseType().equals("1")){
                    ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, ContractVO.class),"",0,contractEntity.getContractType());
                    totalExecutionVOList.add(executionVO.getTotalVO());
                }
                logger.info("目标成本删除数据"+ JSON.toJSONString(totalExecutionVOList));
                if(CollectionUtils.isNotEmpty(totalExecutionVOList)) {
                    CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                    if (!response.isSuccess()){
                        throw new BusinessException("目标成本推送失败,"+response.getMsg());
//                    return CommonResponse.error("目标成本推送失败,"+response.getMsg());
                    }
                }

                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                //解除定标结果占用
//                ContractVO contractVO = vos.stream().findFirst().get();
//                Long id = contractVO.getId();
//                ContractEntity contractEntity = service.selectById(id);
                //定标回写占用
                //占用状态0-未占用,1-已占用,2-已完成
                if (contractEntity.getId() != null && contractEntity.getTargetResultId() != null) {
//                    CommonResponse<String> stringCommonResponse = tenderApi.updateById(contractEntity
//                    .getTargetResultId(), 0);
////                    tenderApi.updateById(contractEntity.getTargetResultId(), 1);
//                    if(!stringCommonResponse.isSuccess()) {
//                        throw new BusinessException("释放定标结果失败,"+response.getMsg());
//                    }
                    service.updateTargetResult(BeanMapper.map(contractEntity, ContractVO.class), 1);
                }
            }
        }
        List<Long> ids = vos.stream().map(x->x.getId()).collect(Collectors.toList());
        // 回写占用量
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.IN, ids));
        List<ContractDetailEntity> detailList = contractDetailService.queryList(param);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        for (ContractDetailEntity detail : detailList) {
            if(StringUtils.isEmpty(detail.getSourceId())){
                continue;
            }
            Long sourceId = Long.valueOf(detail.getSourceId());
            numMap.put(sourceId, ComputeUtil.safeSub(numMap.get(sourceId), detail.getNum()));
        }
        super.removeByIds(ids, true);
        if(MapUtils.isNotEmpty(numMap)){
            planDetailService.writeBackOccupyNum(numMap);
        }
        return true;
    }

    /**
     * 回写占用量
     * @param entity
     */
    @Override
    public void writeBackOccupyNum(ContractEntity entity) {
        ContractEntity data = new ContractEntity();
        if(null != entity.getId()){
            data = super.selectById(entity.getId());
        }
        Map<Long, ContractDetailEntity> dataMap = new HashMap<>();
        if(null != data){
            dataMap = data.getContractDetailList().stream().collect(Collectors.toMap(x->x.getId(), x->x));
        }
        Map<Long, BigDecimal> numMap = new HashMap<>();
        for (ContractDetailEntity detail : entity.getContractDetailList()) {
            if(StringUtils.isEmpty(detail.getSourceId())){
                continue;
            }
            Long sourceId = Long.valueOf(detail.getSourceId());
            if("del".equals(detail.getRowState())){
                numMap.put(sourceId, ComputeUtil.safeSub(numMap.get(sourceId), detail.getNum()));
            } else {
                BigDecimal num = detail.getNum();
                if(dataMap.containsKey(detail.getId())){
                    num = ComputeUtil.safeSub(detail.getNum(), dataMap.get(detail.getId()).getNum());
                }
                numMap.put(sourceId, ComputeUtil.safeAdd(numMap.get(sourceId), num));
            }
        }
        if(MapUtils.isNotEmpty(numMap)){
            planDetailService.writeBackOccupyNum(numMap);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImportProMaterial(HttpServletRequest request, HttpServletResponse response,Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
//        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, ContractEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();

        Map<String, SyncContractEntity> syncContractEntityMap = new HashMap<>();
//        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储从员工查询到的数据，key为 当前行的 经办人，value为查询到的经办人数据
        Map<String, EmployeeVO> employeeVOMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractVO> successList = new ArrayList<>();
            List<ImportContractVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 21) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                // 从自定义档案接口查询计价方式并封装成map
                Map<String, String> defMap = new HashMap<>();
                Map<String, Object> defParamMap = new HashMap<>();
                defParamMap.put("tenantId", tenantid);
                String defCondition = JSONObject.toJSONString(defParamMap);
                CommonResponse<List<Map<String, Object>>> defRes = defdocApi.queryDetailListByDefdocCode("tax-invoice-type", defCondition);
                if (defRes.isSuccess() && defRes.getData() != null) {
                    List<Map<String, Object>> defList = defRes.getData();
                    defMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }
                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportContractVO detailVO = new ImportContractVO();
                    // 从Excel拿到的数据
//                    String parentOrgNameEx = datas.get(0);// 所属组织，必填项，与【组织管理】“组织名称”进行匹配
//                    detailVO.setParentOrgName(parentOrgNameEx);
                    String contractCodeEx = datas.get(0);// 合同编码，非必填
                    detailVO.setBillCode(contractCodeEx);
                    String syncContractName = datas.get(1); //招采平台合同
                    detailVO.setSyncContractName(syncContractName);

                    String contractNameEx = datas.get(2);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String projectNameEx = datas.get(3);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String contractCategoryName = datas.get(4);// 合同类别，必填项，合同类别与合同大类必须匹配
                    detailVO.setContractCategoryName(contractCategoryName);
                    String partyaNameEx = datas.get(5);// 合同甲方，必填项，与【客户库】的“客户名称”进行匹配，如果匹配多了，就提示
                    detailVO.setCustomerName(partyaNameEx);
                    String partyaEmploee = datas.get(6); //甲方经办人,必填
                    detailVO.setCustomerEmployeeName(partyaEmploee);
                    String partyaEmploeePhone = datas.get(7); //甲方电话,必填
                    detailVO.setCustomerEmployeeMobile(partyaEmploeePhone);
                    String partybNameEx = datas.get(8);// 合同乙方，必填项，与【供应商库】的“供应商名称”进行匹配，如果匹配多了，就提示
                    detailVO.setSupplierEmployeeName(partybNameEx);
                    String partybEmploee = datas.get(9);// 乙方经办人,必填
                    detailVO.setSupplierEmployeeName(partybEmploee);
                    String partybEmploeePhone = datas.get(10);// 乙方电话,必填
                    detailVO.setSupplierEmployeeMobile(partybEmploeePhone);
                    String signDateStrEx = datas.get(11);// 签订日期，必填项，日期
                    String signPlaceEx = datas.get(12);// 签订地点，非必填
                    detailVO.setSignPlace(signPlaceEx);
                    String priceTypeName = datas.get(13);//计租方式,必填
                    detailVO.setPricingType(priceTypeName);
                    String projectPlace = datas.get(14); //项目地点 必填
                    detailVO.setProjectPlace(projectPlace);
                    String taxRateEx = datas.get(15);// 税率，数值，必填项，大于等于0，保留2位小数
                    String contractStatus = datas.get(16); //合同履约状态,当计租方式为月租时必填
                    detailVO.setPerformanceStatus(contractStatus);
                    String invoiceType = datas.get(17); //发票类型,非必填
                    detailVO.setInvoiceTypeName(invoiceType);
                    String priceFloatType = datas.get(18); //单价浮动方式
                    detailVO.setPriceFloatType(priceFloatType);
                    String settlementPayment = datas.get(19); //结算付款
                    detailVO.setSettlementPayment(settlementPayment);
                    String memoEx = datas.get(20);// 备注，非必填
                    detailVO.setMemo(memoEx);

//                    // 所属组织
//                    if (org.apache.commons.lang3.StringUtils.isBlank(parentOrgNameEx)) {
//                        detailVO.setErrorMessage("所属组织不可为空");
//                    } else {
//                        // 与【组织管理】“组织名称”进行匹配
//                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
//                        if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgNameEx) == null) {
//                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(parentOrgNameEx, tenantid);
//                            if (orgVORes.isSuccess()) {
//                                OrgVO orgVO = orgVORes.getData();
//                                if (orgVO == null) {
//                                    detailVO.setErrorMessage("根据所属组织查询数据失败");
//                                } else {
//                                    // 将查询到的数据缓存到map中
//                                    orgVOMap.put(parentOrgNameEx, orgVO);
//                                    // 封装数据
//                                    orgIdP = orgVO.getId();
//                                    detailVO.setParentOrgId(orgVO.getId());
//                                    detailVO.setParentOrgCode(orgVO.getCode());
//                                    detailVO.setParentOrgName(orgVO.getName());
//                                }
//                            } else {
//                                detailVO.setErrorMessage("根据所属组织查询数据失败");
//                            }
//                        } else {
//                            OrgVO orgVO = orgVOMap.get(parentOrgNameEx);
//                            detailVO.setParentOrgId(orgVO.getId());
//                            detailVO.setParentOrgCode(orgVO.getCode());
//                            detailVO.setParentOrgName(orgVO.getName());
//                        }
//                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(contractCodeEx)){
                        LambdaQueryWrapper<ContractEntity> queryWrapper = new LambdaQueryWrapper<>();
                        queryWrapper.eq(ContractEntity::getBillCode, contractCodeEx);
                        queryWrapper.eq(ContractEntity::getDr, 0);
                        queryWrapper.eq(ContractEntity::getTenantId, tenantid);
                        if (!list(queryWrapper).isEmpty()) {
                            detailVO.setErrorMessage("合同编码已存在");
                        }
                    }
                    // 合同名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }
                    detailVO.setBillCode(contractCodeEx);
                    //招采平台合同
                    if (StringUtils.isNotBlank(syncContractName)){
                        if (MapUtils.isEmpty(syncContractEntityMap) || syncContractEntityMap.get(syncContractName) == null){
                            LambdaQueryWrapper<SyncContractEntity> queryWrapper = new LambdaQueryWrapper<>();
                            queryWrapper.eq(SyncContractEntity::getContractName,syncContractName);
                            queryWrapper.eq(SyncContractEntity::getDr,0);
                            queryWrapper.eq(SyncContractEntity::getTenantId,tenantid);
                            List<SyncContractEntity> list = syncContractService.list(queryWrapper);
                            if (CollectionUtils.isNotEmpty(list)){
                                SyncContractEntity syncContractEntity = list.get(0);
                                syncContractEntityMap.put(syncContractName,syncContractEntity);
                                detailVO.setSyncContractId(syncContractEntity.getId());
                                detailVO.setSyncContractName(syncContractName);
                            }else{
                                detailVO.setErrorMessage("根据招采平台合同名称查询不到数据");
                            }
                        }else{
                            SyncContractEntity syncContractEntity = syncContractEntityMap.get(syncContractName);
                            detailVO.setSyncContractId(syncContractEntity.getId());
                            detailVO.setSyncContractName(syncContractName);
                        }

                    }
                    // 项目名称
                    if (org.apache.commons.lang3.StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    }else{
                        ProjectPoolSetVO projectPoolSetVOFlag=null;
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                }else{
                                    if (projectVOList.size() == 1) {
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        projectPoolSetVOFlag=projectPoolSetVO;
                                        Long orgId = projectPoolSetVO.getOrgId();
                                        String orgCode = projectPoolSetVO.getOrgCode();
                                        String orgName = projectPoolSetVO.getOrgName();
                                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                                        detailVO.setOrgId(projectDepartmentId1);
                                        detailVO.setOrgCode(projectDepartmentCode);
                                        detailVO.setOrgName(projectDepartmentName);
                                        detailVO.setParentOrgId(orgId);
                                        detailVO.setParentOrgCode(orgCode);
                                        detailVO.setParentOrgName(orgName);
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                    }else{
                                        detailVO.setErrorMessage("根据项目名称查询到多个项目信息");
                                    }
//
                                }
                            }else{
                                detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                            }
                        }else{
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            projectPoolSetVOFlag=projectPoolSetVO;
                            Long orgId = projectPoolSetVO.getOrgId();
                            String orgCode = projectPoolSetVO.getOrgCode();
                            String orgName = projectPoolSetVO.getOrgName();
                            Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
                            String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
                            String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
                            detailVO.setOrgId(projectDepartmentId1);
                            detailVO.setOrgCode(projectDepartmentCode);
                            detailVO.setOrgName(projectDepartmentName);
                            detailVO.setParentOrgId(orgId);
                            detailVO.setParentOrgCode(orgCode);
                            detailVO.setParentOrgName(orgName);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                        }
                        //组织id获取code
                        if (projectPoolSetVOFlag!=null){
                            Long orgId = projectPoolSetVOFlag.getOrgId();
                            Long projectDepartmentId1 = projectPoolSetVOFlag.getProjectDepartmentId();

                            if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(orgId)) == null){
                                CommonResponse<OrgVO> orgVO = orgApi.detailById(orgId);
                                if (orgVO.isSuccess()){
                                    OrgVO data = orgVO.getData();
                                    projectOrgVoMap.put(String.valueOf(orgId),data);
                                    if(data==null){
                                        detailVO.setErrorMessage("根据组织id查询不到组织信息");
                                    }else{
                                        detailVO.setParentOrgCode(data.getCode());
                                    }
                                }else{
                                    detailVO.setErrorMessage(orgVO.getMsg());
                                }

                            }else{
                                detailVO.setParentOrgCode(projectOrgVoMap.get(String.valueOf(orgId)).getCode());
                            }
                            if (projectOrgVoMap.isEmpty() || projectOrgVoMap.get(String.valueOf(projectDepartmentId1)) == null){
                                CommonResponse<OrgVO> orgVO = orgApi.detailById(projectDepartmentId1);
                                if (orgVO.isSuccess()){
                                    OrgVO data = orgVO.getData();
                                    projectOrgVoMap.put(String.valueOf(projectDepartmentId1),data);
                                    if(data==null){
                                        detailVO.setErrorMessage("根据组织id查询不到组织信息");
                                    }else{
                                        detailVO.setOrgCode(data.getCode());
                                    }
                                }
                            }else{
                                detailVO.setOrgCode(projectOrgVoMap.get(String.valueOf(projectDepartmentId1)).getCode());
                            }
                        }
                        else{
                            detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                        }

                    }
//                    else {
//                        // 优先查询缓存map
//                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
//                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
//                            if (projectVOListRes.isSuccess()) {
//                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
//                                if (CollectionUtils.isEmpty(projectVOList)) {
//                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
//                                } else {
//                                    if (projectVOList.size() == 1) {
//                                        // 存储到缓存map
//                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
//                                        Long orgId = projectPoolSetVO.getOrgId();
//                                        String orgCode = projectPoolSetVO.getOrgCode();
//                                        String orgName = projectPoolSetVO.getOrgName();
//                                        Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
//                                        String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
//                                        String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
//                                        detailVO.setOrgId(projectDepartmentId1);
//                                        detailVO.setOrgCode(projectDepartmentCode);
//                                        detailVO.setOrgName(projectDepartmentName);
//                                        detailVO.setParentOrgId(orgId);
//                                        detailVO.setParentOrgCode(orgCode);
//                                        detailVO.setParentOrgName(orgName);
//                                        detailVO.setProjectId(projectPoolSetVO.getId());
//                                        detailVO.setProjectName(projectPoolSetVO.getName());
//                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
//                                    }else {
//                                        detailVO.setErrorMessage("根据项目名称查询不到项目信息");
//                                    }
//                                }
//                            } else {
//                                detailVO.setErrorMessage("根据项目名称查询项目失败");
//                            }
//                        } else {
//                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
//                            Long orgId = projectPoolSetVO.getOrgId();
//                            String orgCode = projectPoolSetVO.getOrgCode();
//                            String orgName = projectPoolSetVO.getOrgName();
//                            Long projectDepartmentId1 = projectPoolSetVO.getProjectDepartmentId();
//                            String projectDepartmentName = projectPoolSetVO.getProjectDepartmentName();
//                            String projectDepartmentCode = projectPoolSetVO.getProjectDepartmentCode();
//                            detailVO.setOrgId(projectDepartmentId1);
//                            detailVO.setOrgCode(projectDepartmentCode);
//                            detailVO.setOrgName(projectDepartmentName);
//                            detailVO.setParentOrgId(orgId);
//                            detailVO.setParentOrgCode(orgCode);
//                            detailVO.setParentOrgName(orgName);
//                            detailVO.setProjectId(projectPoolSetVO.getId());
//                            detailVO.setProjectName(projectPoolSetVO.getName());
//
//                        }

                    //合同类别
                    if (org.apache.commons.lang3.StringUtils.isBlank(contractCategoryName)) {
                        detailVO.setErrorMessage("合同类别不能为空");
                    } else if (flag.equals(0)) {
                        if ("钢材".equals(contractCategoryName)) {
                            detailVO.setContractCategoryId(1871172364104896513L);
                            detailVO.setContractCategoryName(contractCategoryName);
                        } else if ("通用物资".equals(contractCategoryName)) {
                            detailVO.setContractCategoryId(1871172853848608769L);
                            detailVO.setContractCategoryName(contractCategoryName);
                        } else if ("零星材料".equals(contractCategoryName)) {
                            detailVO.setContractCategoryId(1871173050095898626L);
                            detailVO.setContractCategoryName(contractCategoryName);
                        } else {
                            detailVO.setErrorMessage("合同类别错误");
                        }
                    }else if (flag.equals(1)){
                        if ("混凝土".equals(contractCategoryName)){
                            detailVO.setContractCategoryId(1871189679529791490L);
                            detailVO.setContractCategoryName(contractCategoryName);
                        }else{
                            detailVO.setErrorMessage("合同类别错误");
                        }
                    }

                    // 合同甲方
                    if (org.apache.commons.lang3.StringUtils.isBlank(partyaNameEx)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partyaNameEx) == null) {
                            CommonResponse<SupplierVO> orgVORes = shareSupplierApi.findOneByName(partyaNameEx,tenantid);

                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
//                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                SupplierVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partyaNameEx, orgVO);
                                    // 封装数据
                                    detailVO.setCustomerId(orgVO.getId());
                                    detailVO.setCustomerName(orgVO.getName());

                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            SupplierVO orgVO = supplierVOMap.get(partyaNameEx);
                            detailVO.setCustomerId(orgVO.getId());
                            detailVO.setCustomerName(orgVO.getName());

                        }
                    }
                    //甲方经办人
                    if (org.apache.commons.lang3.StringUtils.isBlank(partyaEmploee)) {
                        detailVO.setErrorMessage("合同甲方经办人不能为空");
                    } else {
                        if (MapUtils.isEmpty(employeeVOMap) || employeeVOMap.get(partyaEmploee) == null) {
                            CommonResponse<Map<String, EmployeeVO>> map = employeeApi.getEmployeeMapByNames(Collections.singletonList(partyaEmploee));
                            if (map.isSuccess()) {
                                Map<String, EmployeeVO> data = map.getData();
                                if (data == null) {
                                    detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                                } else {
                                    EmployeeVO employeeVO = data.get(partyaEmploee);
                                    employeeVOMap.put(partyaEmploee, employeeVO);
                                    detailVO.setCustomerEmployeeId(employeeVO.getId());
                                    detailVO.setCustomerEmployeeName(employeeVO.getName());
                                }

                            } else {
                                detailVO.setErrorMessage("根据甲方经办人查询数据失败");
                            }
                        } else {
                            EmployeeVO employeeVO = employeeVOMap.get(partyaEmploee);
                            detailVO.setCustomerEmployeeId(employeeVO.getId());
                            detailVO.setCustomerEmployeeName(employeeVO.getName());
                        }

                    }
                    //甲方电话
                    if (org.apache.commons.lang3.StringUtils.isBlank(partyaEmploeePhone)) {
                        detailVO.setErrorMessage("合同甲方电话不能为空");
                    } else {
                        detailVO.setCustomerEmployeeMobile(partyaEmploeePhone);
                    }
                    // 合同乙方
                    if (org.apache.commons.lang3.StringUtils.isBlank(partybNameEx)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【供应商库】的“供应商名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<SupplierVO> supplierVORes = shareSupplierApi.findOneByName(partybNameEx, tenantid);
                            if (supplierVORes.isSuccess()) {
                                SupplierVO supplierVO = supplierVORes.getData();
                                if (supplierVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partybNameEx, supplierVO);
                                    // 封装数据

                                    detailVO.setSupplierId(supplierVO.getId());
                                    detailVO.setSupplierName(supplierVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO supplierVO = supplierVOMap.get(partybNameEx);

                            detailVO.setSupplierId(supplierVO.getId());
                            detailVO.setSupplierName(supplierVO.getName());
                        }
                    }
                    //乙方经办人
                    if (org.apache.commons.lang3.StringUtils.isBlank(partybEmploee)) {
                        detailVO.setErrorMessage("合同乙方经办人不能为空");
                    } else {
                        detailVO.setSupplierEmployeeName(partybEmploee);
                    }
                    //乙方电话
                    if (org.apache.commons.lang3.StringUtils.isBlank(partybEmploeePhone)) {
                        detailVO.setErrorMessage("合同乙方电话不能为空");
                    } else {
                        detailVO.setSupplierEmployeeMobile(partybEmploeePhone);
                    }
                    // 签订日期
                    if (org.apache.commons.lang3.StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    // 签订地点
                    detailVO.setSignPlace(signPlaceEx);
                    //计价方式
                    if (StringUtils.isBlank(priceTypeName)){
                        detailVO.setErrorMessage("计价方式不可为空");
                    }else{
                        if (priceTypeName.equals("固定单价")){
                            detailVO.setPricingType("1");
                        }else if (priceTypeName.equals("浮动单价")){
                            detailVO.setPricingType("2");
                        }else if (priceTypeName.equals("固定总价")){
                            detailVO.setPricingType("3");
                        }else{
                            detailVO.setErrorMessage("计价方式填写不正确");
                        }
                    }

                    //项目地点
                    if (org.apache.commons.lang3.StringUtils.isBlank(projectPlace)) {
                        detailVO.setErrorMessage("项目地点不可为空");
                    } else {
                        detailVO.setProjectPlace(projectPlace);
                    }

                    // 税率
                    if (org.apache.commons.lang3.StringUtils.isBlank(taxRateEx)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate = new BigDecimal(taxRateEx);
                            if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setTaxRate(taxRate);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }

                    //合同履约状态
                    if (StringUtils.isBlank(contractStatus)) {
                        detailVO.setErrorMessage("合同履约状态不可为空");
                    } else{
                        if (org.apache.commons.lang3.StringUtils.isBlank(contractStatus)){
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                            detailVO.setPerformanceStatusName(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getDescription());
                        }
                        if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getCode());
                            detailVO.setPerformanceStatusName(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.未签订.getDescription());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getCode());
                            detailVO.setPerformanceStatusName(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.履约中.getDescription());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getCode());
                            detailVO.setPerformanceStatusName(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已终止.getDescription());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getCode());
                            detailVO.setPerformanceStatusName(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已作废.getDescription());
                        } else if (com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getDescription().equals(contractStatus)) {
                            detailVO.setPerformanceStatus(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getCode());
                            detailVO.setPerformanceStatusName(com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum.已冻结.getDescription());
                        } else {
                            detailVO.setErrorMessage("合同履约状态填写不正确");
                        }
                    }
                    //发票类型
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(invoiceType)) {
                        String invoiceTypeIdStr = defMap.get(invoiceType);
                        Long invoiceTypeId = null;
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(invoiceTypeIdStr)) {
                            invoiceTypeId = Long.parseLong(invoiceTypeIdStr);
                            detailVO.setInvoiceTypeId(invoiceTypeId);
                            detailVO.setInvoiceTypeName(invoiceType);
                        } else {
                            detailVO.setErrorMessage("发票类型填写不正确");
                        }
                    }
                    //单价浮动方式
                    detailVO.setPriceFloatType(priceFloatType);
                    //结算付款
                    detailVO.setSettlementPayment(settlementPayment);
                    // 备注
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(memoEx) && memoEx.length() > 100) {
                        detailVO.setErrorMessage("备注长度不可大于100");
                    } else {
                        detailVO.setMemo(memoEx);
                    }
                    // 封装返回的数据
                    if (org.apache.commons.lang3.StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
//                        detailVO.setHandleType(1);
//                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                    //归档状态
                    detailVO.setSupplementFlag(0);
//                    detailVO.setSupplementFlagName("否");
                    detailVO.setFilingStatus(0);
                    detailVO.setContractType(flag);
                    detailVO.setSignatureStatus("1");
                    detailVO.setDraftType("3");
                    detailVO.setPurchaseType("1");
                    if (flag.equals(0)){
                        detailVO.setContractPropertyCode("proMaterial-1");
                        detailVO.setContractPropertyName("大宗材");
                    }else{
                        detailVO.setContractPropertyCode("contractConcrete-1");
                        detailVO.setContractPropertyName("混凝土");
                    }

                }


            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            errorList.forEach(detailVO -> {
                detailVO.setId(IdWorker.getId());
            });
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            Date createTime = new Date();
            UserContext userContext = sessionManager.getUserContext();
            String userCode = "";
            if (userContext != null) {
                userCode = userContext.getUserCode();
            }
            List<ContractVO> sucVoList = BeanMapper.mapList(successList, ContractVO.class);
            if (CollectionUtils.isNotEmpty(sucVoList)) {
                for (ContractVO vo : sucVoList) {
                    vo.setCreateTime(createTime);
                    vo.setCreateUserCode(userCode);
                    long contractId = IdWorker.getId();
                    vo.setContractId(contractId);
//                    vo.setSourceId(contractId);
                    if (org.apache.commons.lang3.StringUtils.isBlank(vo.getBillCode())) {
                        String contractBillCode = getContractBillCode(vo);
                        vo.setBillCode(contractBillCode);
//                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, tenantid, vo);
//                        CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
//                        if(billCodeRes.isSuccess()) {
//                            vo.setBillCode(billCodeRes.getData());
//                        }else{
//                            throw new BusinessException("网络异常，编码生成失败，请稍后再试");
//                        }
                    }
                }
                List<ContractEntity> sucEntityList = BeanMapper.mapList(sucVoList, ContractEntity.class);
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }

    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        logger.info("生成编码规则，GenerateBillCodeType=：{}", GenerateBillCodeType);
        switch (GenerateBillCodeType) {
            case "common":
                String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
                if (MaterialContractTypeEnum.混凝土.getCode().equals(contractVo.getContractType())) {
                    billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
                }
                BillCodeParam billCodeParam = BillCodeParam
                        .build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    contractBillCode = billCode.getData();
                }
                else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                break;
            case "ynjt":
                BillCodeParam billCodeParamYnjt = BillCodeParam
                        .build(PURCHASE_CONTRACT_YNJT, InvocationInfoProxy.getTenantid(), contractVo);
                CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(billCodeParamYnjt);
                if (!billCodeFirstPart.isSuccess()) {
                    logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                //根据合同基层单位后三位查询查询流水号
                String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                CommonSNVO commonSNVO = new CommonSNVO();
                commonSNVO.setSnLength(4);
                commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                commonSNVO.setDimension(orgSub);
                commonSNVO.setSourceType("YNJTCLCG");
                CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                if (!snResp.isSuccess()) {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                contractBillCode = billCodeFirstPart.getData() + orgSub + snResp.getData();
                break;
            default:
                throw new BusinessException("编码生成失败！");
        }
        return contractBillCode;
    }


    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        //主合同
        ContractEntity mainContract = service.selectById(contractVo.getMainContractId());
        if(null == mainContract) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }
        if (!isControl) {
            if (StringUtils.isEmpty(contractVo.getBillCode())) {
//                String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
//                if (MaterialContractTypeEnum.混凝土.getCode().equals(contractVo.getContractType())) {
//                    billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
//                }
//                BillCodeParam billCodeParam = BillCodeParam.build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if (billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//                } else {
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }
                QueryParam billCodeParam = new QueryParam();
                billCodeParam.getParams().put("main_contract_id", new Parameter("eq", contractVo.getMainContractId()));
                List<Integer> billStateList = new ArrayList<>();
                billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                billCodeParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
                List<ContractEntity> billCOdeSupplementList = service.queryList(billCodeParam, false);
                String supplementNum = "";
                if (billCOdeSupplementList.size() < 9) {
                    supplementNum += "0" + (billCOdeSupplementList.size() + 1);
                }else {
                    supplementNum += (billCOdeSupplementList.size() + 1);
                }
                //设置补充协议编码
                entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {

            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", contractVo.getMainContractId()));
            List<ContractEntity> supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
//            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        // 校验其他单据
        this.checkContract(contractVo.getMainContractId(), contractVo.getId());
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (FilingStatusEnum.已归档.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = super.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl){
                        delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl){
                        delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }
        }
        if (!isControl){
            // 回写占用量
            this.writeBackOccupyNum(entity);

            super.saveOrUpdate(entity, false);

            //集采时不推成本执行数据
            if (entity.getPurchaseType().equals("1")) {
                //目标成本推送
                String linkUrl;
                String frontendBaseHost="";
                if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                    frontendBaseHost = BASE_HOST_FRONTEND;
                }else{
                    frontendBaseHost = BaseHost;
                }

                if (entity.getContractType() == 0) {
                    linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/supplement/card?id=" + entity.getId();
                }
                else {
                    linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/supplementConcrete/card?id=" + entity.getId();
                }
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class),linkUrl,0,entity.getContractType());
                logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败,"+response.getMsg());
                }
            }

        }
        return BeanMapper.map(entity, ContractVO.class);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();


        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());

//        supplementVO.setTargetResultId(contractVO.getTargetResultId());
//        supplementVO.setTargetResultName(contractVO.getTargetResultName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setContractCategoryName(contractVO.getContractCategoryName());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(1);
        supplementVO.setSignatureStatus(SignatureStatusEnum.未签章.getCode().toString());
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
        supplementVO.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setContractPropertyCode(contractVO.getContractPropertyCode());
        supplementVO.setContractPropertyName(contractVO.getContractPropertyName());
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());

        return supplementVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = super.selectById(id);
        entity.setContractDetailList(null);
        ContractVO contractVo = BeanMapper.map(entity, ContractVO.class);
        List<ContractDetailEntity> details = null;
        LambdaQueryWrapper<ContractDetailEntity> lambda = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, id);
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.中止项);
        details = contractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setContractDetailList(BeanMapper.mapList(details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
//
        return resp;
    }

    /**
     * 查询当前合同下补充协议列表
     *
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO recordVO = new ContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());

        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("signature_status", SignatureStatusEnum.已签章.getCode());
        query.orderByDesc("create_time");
        List<ContractEntity> supplementEntities = super.list(query);

        recordVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        recordVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        //设置补充金额比例
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        logger.info("进入主合同签章状态修改方法，修改参数：billId:{},status:{},refCode:{}", billId, status, refCode);
        ContractEntity contract = super.selectById(billId);
        if (contract != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                contract.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
                contract.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
                contract.setFilingStatus(FilingStatusEnum.已归档.getTypeCode());
                contract.setFilingRef(0);
                contract.setEffectiveDate(new Date());

                //查询参数判断是否需要更新合同签订日期，
                CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                if (!response.isSuccess()) {
                    logger.error("查询电中签章合同-【id-{}】是否更新合同签订日期参数失败，暂不更新合同签订日期: {}", billId,
                            JSONObject.toJSONString(response));
                }
                if (null != response.getData() && "1".equals(response.getData().getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    //更新合同签订日期
                    logger.info("合同【id-{}，原签订日期：{}, 根据电子签章合同更新合同签订日期参数:{}，将合同签订日期改为当前签章完成日期:{}】", billId,
                            sdf.format(contract.getSignDate()), JSONObject.toJSONString(response.getData()),
                            sdf.format(new Date()));
                    contract.setSignDate(new Date());
                }
            } else {
                contract.setSignatureStatus(String.valueOf(status));
            }
            super.saveOrUpdate(contract, false);
            this.pushContract(BeanMapper.map(contract, ContractVO.class));
            logger.info("主合同签章状态已修改，修改后签章状态:{}---------------->",contract.getSignatureStatus());
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增补充协议
        if(!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())){
            return false;
        }
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, 1);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl,Integer type,Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillDate(DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE,contractVO.getSignDate()));
        List contractDetailList;
        if (contractType==0){
            if (type==0){
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.消耗材合同.getCode());
            }else {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setLastSourceId(contractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.消耗材合同变更.getCode());
            }
        }else {
            if (type==0){
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.混凝土合同.getCode());
            }else {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setLastSourceId(contractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.混凝土变更合同.getCode());
            }
        }
        switch (contractVO.getContractPropertyCode()){
            case "proMaterial-1": totalVO.setBussinessType(BussinessTypeEnum.大宗材物资采购合同.getCode());break;
            case "proMaterial-2": totalVO.setBussinessType(BussinessTypeEnum.周转材物资采购合同.getCode());break;
            case "proMaterial-3": totalVO.setBussinessType(BussinessTypeEnum.零星材料物资采购合同.getCode());break;
            case "contractConcrete-1": totalVO.setBussinessType(BussinessTypeEnum.混凝土采购合同.getCode());break;
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (contractDetailList !=null){
            for (ContractDetailVO planDetailVO : contractVO.getContractDetailList()) {
                if ("del".equals(planDetailVO.getRowState())){
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                //判断是否是分类
                if (planDetailVO.getMaterialId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO==null){
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMoney());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getDetailTaxMny());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    /**
     * 推送合同项目池
     *
     * @param contractVO 需要推送的合同数据
     */
    @Override
    public Boolean pushContract(ContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setPurchaseType(Integer.valueOf(contractVO.getPurchaseType()));
            data.setSourceType(ContractTypeEnum.物资采购合同.getTypeCode());
            int targetType = contractVO.getTargetResultId() == null ? 1: 0;
            data.setPcCardUrl("/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id="
                    + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag()
                    + "&targetType=" + targetType + "&performanceStatus="
                    + contractVO.getPerformanceStatus());
            if (MaterialContractTypeEnum.混凝土.getCode().equals(contractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.混凝土合同.getTypeCode());
                data.setPcCardUrl("/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id="
                        + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag()
                        + "&targetType=" + targetType + "&performanceStatus="
                        + contractVO.getPerformanceStatus());
            }
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            logger.info("开始推送合同池>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            logger.info("推送合同池结束，推送结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
            return false;
        }
        return true;
    }

    /**
     * 将合同重新推送合同池
     *
     * @param id 合同id
     * @return 推送结果
     */
    @Override
    public ContractVO syncPushContract(Long id) {
        ContractEntity entity = super.selectById(id);
        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        this.pushContract(vo);
        return vo;
    }

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    @Override
    public void pushDelContract(ContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.物资采购合同.getTypeCode());
            if (MaterialContractTypeEnum.混凝土.getCode().equals(contractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.混凝土合同.getTypeCode());
            }
            logger.info("开始删除合同池合同>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<String> transDataResp = contractPoolApi.deleteContract(data);
            logger.info("删除合同池合同结束，删除结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    /**
     * 是否可以添加合同解除
     *
     * @param id 合同id
     * @return true:可以添加合同解除单据
     */
    @Override
    public boolean addRelieveFlag(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增
        if(!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())){
            return false;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        List<ContractRelieveEntity> relieveEntityList = relieveService.queryList(queryParam, false);
        return CollectionUtils.isEmpty(relieveEntityList);
    }

    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 集采合同只能本机做合同变更、补充协议等操作
        ContractEntity contractEntity = super.selectById(id);
        if (PurchaseTypeEnum.公司集采.getCode().equals(contractEntity.getPurchaseType())) {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (!orgId.equals(contractEntity.getOrgId())) {
                throw new BusinessException("当前组织无法对该合同进行操作！");
            }
        }
        // 校验补充协议
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
//        queryParam.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 1));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        List<ContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<ContractChangeEntity> contractChangeEntityList = contractChangeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }

        // 查询合同解除
        List<ContractRelieveEntity> relieveEntityList = relieveService.queryList(queryParam, false);
        // 存在未生效的合同解除，则抛出异常
        if (CollectionUtils.isNotEmpty(relieveEntityList)) {
            throw new BusinessException("存在未生效的合同解除单据！");
        }
        // 查询合同冻结、解冻
        // 清除签章条件
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<ContractFreezeEntity> freezeEntityList = freezeService.queryList(queryParam, false);
        // 存在未生效的合同冻结、解冻，则抛出异常
        if (CollectionUtils.isNotEmpty(freezeEntityList)) {
            throw new BusinessException("存在未生效的合同冻结或合同解冻单据！");
        }
        return true;
    }
    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO,String authority) {
        CommonResponse<ContractVO> masterPlanVOCommonResponse = saveOrUpdate(contractVO,authority, true);
        ContractVO contractVO1 = masterPlanVOCommonResponse.getData();
        String linkUrl;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BaseHost;
        }

        if (contractVO1.getContractType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO1.getId();
        }
        else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO1.getId();
        }
        //目标成本推送
        logger.error("目标成本控制合同信息：" + JSONObject.toJSONString(contractVO1));
        ExecutionVO executionVO = service.targetCost(contractVO1,linkUrl,0,contractVO1.getContractType());
        logger.error("保存推送目标成本控制数据：" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        logger.info("目标成本控制返回信息："+JSONObject.toJSONString(response));
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO1, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ContractVO contractVO = queryDetail(id);
        String linkUrl;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BaseHost;
        }

        if (contractVO.getContractType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO.getId();
        }
        else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO.getId();
        }
        //目标成本推送
        ExecutionVO executionVO = service.targetCost(contractVO,linkUrl,0,contractVO.getContractType());
        logger.error("详情推送目标成本控制数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        //参数控制
        logger.info("目标成本控制返回信息："+JSONObject.toJSONString(response));
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    /**
     * 推送目标成本
     *
     * @param id 合同id
     * @return 推送结果
     */
    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        //目标成本推送
        ContractVO contractVO = service.queryDetail(id);
        if (PurchaseTypeEnum.公司集采.getCode().equals(contractVO.getPurchaseType())) {
            return CommonResponse.error("公司集采不支持目标成本推送！");
        }
        // 合同作废推送作废信息
        if (PerformanceStatusEnum.已解除.getCode().equals(contractVO.getPerformanceStatus())) {
            QueryWrapper<ContractRelieveEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", id);
            ContractRelieveEntity contractRelieveEntity = relieveService.getOne(queryWrapper);
            //目标成本推送
            String linkUrl;
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = BaseHost;
            }

            if (contractVO.getContractType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractRelieve/card?id=" + contractRelieveEntity.getId();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractRelieve/card?id=" + contractRelieveEntity.getId();
            }
            ExecutionVO executionVO = relieveService.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class),
                    linkUrl, contractVO.getContractType());
            logger.info("目标成本推送合同解除数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
        // 查询变更合同信息
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<ContractChangeEntity> changeEntityList = contractChangeService.queryList(queryParam, false);
        String linkUrl;
        ExecutionVO executionVO;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BaseHost;
        }

        if (CollectionUtils.isNotEmpty(changeEntityList)) {
            ContractChangeEntity changeEntity = changeEntityList.get(0);
            ContractChangeVO changeVO = contractChangeService.queryDetail(changeEntity.getId());
            if (changeEntity.getContractType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractChange/card?id=" + changeEntity.getId();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractChange/card?id=" + changeEntity.getId();
            }
            executionVO= service.targetCost(BeanMapper.map(changeVO, ContractVO.class), linkUrl, 1, changeEntity.getContractType());
        }
        else {
            if (contractVO.getContractType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO.getId();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO.getId();
            }
            executionVO= service.targetCost(contractVO, linkUrl, 0, contractVO.getContractType());
        }
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        if(!("proMaterial-2".equals(vo.getContractPropertyCode())&&MaterialContractTypeEnum.消耗材.getCode().equals(vo.getContractType()))){//proMaterial-1 - 大众(主要)   proMaterial-2-周转  proMaterial-3-零星
            paramsCheckVOS.addAll(this.checkParamsMnyPlan( vo));//总计划控制补充、主合同金额
        }
        if(vo.getSupplementFlag()!=null && Objects.equals(vo.getSupplementFlag(), SuplementFlagEnum.是补充协议.getCode())){
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));//合同金额控制补充协同金额
        }
        ParamsCheckVO priceParam = this.priceCheckParams(vo);
        if(priceParam!=null){//价格库控制
            paramsCheckVOS.add(priceParam);
        }

        if(!"proMaterial-3".equals(vo.getContractPropertyCode())){//零星材料，不控制
            ParamsCheckVO costParams = this.costPriceCheckParams(vo);
            if(costParams!=null){//目标成本价格库控制
                paramsCheckVOS.add(costParams);
            }
        }


        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    /**
     * 单据管控-补充协议金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnySup(ContractVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        if (PurchaseTypeEnum.公司集采.getCode().equals(vo.getPurchaseType())) {
            // 集采合同直接赋值为不控制
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMnySup = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次补充协议金额
        ContractEntity contractEntity = super.selectById(vo.getMainContractId());
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny()==null?BigDecimal.ZERO:contractEntity.getContractTaxMny();//初始合同金额
        BigDecimal totalSupMoney =  contractTaxMnySup;//累计补充金额  默认赋值本次
        //查询累计补充金额
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        List<ContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementContractList)){
            for (ContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd(entity.getContractTaxMny(),totalSupMoney);//累加变更金额
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()){//类型（0-物资采购，1-混凝土）
            case 0:CHECK_PARAM_CODE= M_SUP_CODE;break;
            case 1:CHECK_PARAM_CODE= C_SUP_CODE;break;
        }
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次补充协议金额：").append(contractTaxMnySup.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次补充协议金额：").append(totalSupMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSupMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
    /**
     * 单据管控-合同金额大于总计划金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(ContractVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO>  paramsCheckVOS = new ArrayList<>();
        if (PurchaseTypeEnum.公司集采.getCode().equals(vo.getPurchaseType())) {
            // 集采合同直接赋值为不控制
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次合同金额
        BigDecimal planTaxMny = BigDecimal.ZERO;//总计划金额
        BigDecimal totalMoney =  contractTaxMny;//累计合同金额  默认赋值本次
        //查询总计划
        LambdaQueryWrapper<MasterPlanEntity> planLambda = new LambdaQueryWrapper<>();
        planLambda.eq(MasterPlanEntity::getProjectId, vo.getProjectId());
        planLambda.in(MasterPlanEntity::getBillState,1,3);
        planLambda.eq(MasterPlanEntity::getDr,0);
        planLambda.eq(MasterPlanEntity::getPlanType,vo.getContractType());// // 计划类型（0-消耗材，1-混泥土） // 合同类型（0-物资采购合同，1-混凝土合同）
        List<MasterPlanEntity> planList = masterPlanService.list(planLambda);
        if(CollectionUtils.isNotEmpty(planList)){
            planTaxMny = planList.stream().filter(e -> e.getTotalPlanAmt() != null).map(MasterPlanEntity::getTotalPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }else {
            return paramsCheckVOS;
        }
        //查询合同
        LambdaQueryWrapper<ContractEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(ContractEntity::getProjectId, vo.getProjectId());
        Lambda.orderByDesc(ContractEntity::getCreateTime);
        Lambda.eq(ContractEntity::getContractType,vo.getContractType()); // 计划类型（0-消耗材，1-混泥土） // 合同类型（0-物资采购合同，1-混凝土合同）
        if(MaterialContractTypeEnum.消耗材.getCode().equals(vo.getContractType())){
            Lambda.ne(ContractEntity::getContractPropertyCode, "proMaterial-2");//主要材料、辅助材料、零星材料 proMaterial-1 - 大众(主要)   proMaterial-2-周转  proMaterial-3-零星   混凝土不走
        }
        if (vo.getId() != null) {
            Lambda.ne(ContractEntity::getId, vo.getId());//除本次
        }
        List<ContractEntity> list = super.list(Lambda);//查询项目下所有合同
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> collect = list.stream().map(ContractEntity::getId).collect(Collectors.toList());
            List<ContractChangeVO> contractChangeList = baseMapper.getContractChangeList(collect);//查询未生效的变更单
            Map<Long, ContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(ContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<SettlementVO> settlementList = baseMapper.getSettlementList(collect);//查询最后一个结算单
            Map<Long, SettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(SettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (ContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;//要累加的金额
                if (PerformanceStatusEnum.已封账.getCode().equals(entity.getPerformanceStatus()) ||PerformanceStatusEnum.已解除.getCode().equals(entity.getPerformanceStatus())){
                    //合同已终止、已结束、已解除：取合同结算金额）  即最终结算或 最后一次结算  累计结算金额
                    if(mapSettle.containsKey(entity.getId())){
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }// 校验变更合同
                }else if(mapChange.containsKey(entity.getId())){//有为生效的变更单  取最新变更单金额
                    zero = mapChange.get(entity.getId()).getContractTaxMny();
                }else {//没有未生效的变更单   合同状态为 未签订、履约中、已冻结取签订金额
                    zero = entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd(zero,totalMoney);//累加变更金额
            }
        }

        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()){//类型（0-物资采购，1-混凝土）
            case 0:CHECK_PARAM_CODE= M_PLAN_CODE;break;
            case 1:CHECK_PARAM_CODE= C_PLAN_CODE;break;
        }
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("采购金额超总计划金额");
                        paramsCheckDsVO.setWarnName("采购金额超总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计合同金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ContractVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }
    //价格库合同参数控制
    @Override
    public ParamsCheckVO priceCheckParams(ContractVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        switch (vo.getContractType()){
            case 0: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.消耗材合同.getCode());break;
            case 1: materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.混凝土合同.getCode());break;
        }
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getContractDetailList())){
            for (ContractDetailVO detailVO : vo.getContractDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getDetailTaxPrice());
                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(ContractVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        if (vo.getContractType() == 0) {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.消耗材合同.getCode());
        }else{
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.混凝土合同.getCode());
        }
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getContractDetailList())){
            for (ContractDetailVO detailVO : vo.getContractDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getPrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getDetailTaxPrice());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    /**
     * 查询合同付款申请列表
     *
     * @param id 合同id
     * @return 查询结果
     */
    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse<List<PaymentApplyVO>> resultData = paymentApplyApi.queryListByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (resultData != null) {
            List<PaymentApplyVO> paymentApplyVOList = resultData.getData();
            if (CollectionUtils.isNotEmpty(paymentApplyVOList)) {
                resultVO.setTotalApplyMny(paymentApplyVOList.stream().filter(p -> p.getApplyMny() != null)
                        .map(PaymentApplyVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                resultVO.setTotalActualMny(paymentApplyVOList.stream().filter(p -> p.getActualMny() != null)
                        .map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                resultVO.setTotalApprovalMny(paymentApplyVOList.stream().filter(p -> p.getApprovalMny() != null)
                        .map(PaymentApplyVO::getApprovalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                paymentApplyVOList.forEach(item -> {
                    item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                    item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                    item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
                });
                resultVO.setPaymentApplyList(paymentApplyVOList);
            }
        }
        ContractEntity contractEntity = service.selectById(id);
        if (null != contractEntity) {
            resultVO.setContractId(id);
            resultVO.setAddType(contractEntity.getTargetResultId() == null ? 1 : 0);
            resultVO.setContractFlag(contractEntity.getSupplementFlag());
            resultVO.setContractMny(contractEntity.getContractTaxMny());
            if (null != resultVO.getTotalActualMny()) {
                resultVO.setPaymentRate((resultVO.getTotalActualMny()
                        .divide(resultVO.getContractMny(), 8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100)));
            }
            else {
                resultVO.setPaymentRate(BigDecimal.ZERO);
            }
            resultVO.setTotalApplyMny(null != resultVO.getTotalApplyMny() ? resultVO.getTotalApplyMny() : BigDecimal.ZERO);
            resultVO.setTotalActualMny(null != resultVO.getTotalActualMny() ? resultVO.getTotalActualMny() : BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(null != resultVO.getTotalApprovalMny() ? resultVO.getTotalApprovalMny() : BigDecimal.ZERO);
        }
        CommonResponse<String> addFlagData = paymentApplyApi.queryAddFlagContractId(id);
        if (addFlagData != null && addFlagData.getData() != null) {
            if (addFlagData.getData().equals("1")) {
                resultVO.setAddFlag(true);
            }
        }
        return resultVO;
    }
    @Override
    public List<MaterialReportVO> quueryMaterialByProject(Page pages, QueryWrapper queryWrapper, Long projectId) {
        List<MaterialReportVO> list = baseMapper.quueryMaterialByProject(pages, queryWrapper,projectId);
        CommonResponse<Map<Long, BigDecimal>> resDate = iDutyApi.queryDoc(projectId);
        if(!resDate.isSuccess()) {
            throw new BusinessException("获取成本数量信息失败,请刷新后重试!");
        }
        Map<Long, BigDecimal> map= resDate.getData();
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                if(null!=map&&map.containsKey(e.getMaterialId())){
                  e.setMbNum(map.get(e.getMaterialId())==null?BigDecimal.ZERO:map.get(e.getMaterialId()));
                }
            });
        }
        return list;
    }

    @Override
    public List<ContractMaterialReportVO> quueryMaterialByOrg(Page page, QueryWrapper wrapper) {
        List<ContractMaterialReportVO> contractMaterialReportVOList = baseMapper.quueryMaterialByOrg(page, wrapper);
        //计算税率等
//        合同单价  合同量汇总,合同金额汇总,合同单价= 合同金额汇总/合同量汇总  合同税率=合同金额汇总/合同金额汇总（无税）-1,
        if (CollectionUtils.isNotEmpty(contractMaterialReportVOList)){
            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList){
                //计算单价
                if (contractMaterialReportVO.getContractNum() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractNum()) == 0){
                    contractMaterialReportVO.setContractTaxPrice(BigDecimal.ZERO);
                }else {
                    contractMaterialReportVO.setContractTaxPrice(contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractNum(), 8, ROUND_HALF_DOWN));
                }
                //计算税率
//                bb.compareTo(BigDecimal.ZERO)!=0
                if ((contractMaterialReportVO.getContractMny() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractMny()) == 0)){
                    contractMaterialReportVO.setContractTaxRate(BigDecimal.ZERO);
                }else {
//                    BigDecimal contractTaxRate = contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractMny(), 8, ROUND_HALF_DOWN).subtract(new BigDecimal(1));
                    BigDecimal contractTaxRate = contractMaterialReportVO.getContractTaxMny().subtract(contractMaterialReportVO.getContractMny()).divide(contractMaterialReportVO.getContractMny(),BigDecimal.ROUND_HALF_UP);
                    contractMaterialReportVO.setContractTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }
            //取所有合同主键
            List<Long> contractIds = contractMaterialReportVOList.stream().map(ContractMaterialReportVO::getContractId).collect(Collectors.toList());
            //订单量
            List<ContractMaterialReportVO> orderList = baseMapper.getOrderNum(contractIds);
            //验收量
            List<ContractMaterialReportVO> checkList = baseMapper.getCheckNum(contractIds);
            //结算量
            List<ContractMaterialReportVO> settleList = baseMapper.getSettleNum(contractIds);
            if (CollectionUtils.isNotEmpty(settleList)) {
                for (ContractMaterialReportVO contractMaterialReportVO : settleList){

                //计算结算单价
                if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementNum()) == 0){
                    contractMaterialReportVO.setSettlementTaxPrice(BigDecimal.ZERO);
                }else {
                    contractMaterialReportVO.setSettlementTaxPrice(contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementNum(), 8, ROUND_HALF_DOWN));
                }
                //计算税率
                if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementMny()) == 0){
                    contractMaterialReportVO.setSettlementTaxRate(BigDecimal.ZERO);
                }else {
//                    BigDecimal contractTaxRate = contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementMny(), 8, ROUND_HALF_DOWN).subtract(new BigDecimal(1));
                    BigDecimal contractTaxRate =contractMaterialReportVO.getSettlementTaxMny().subtract(contractMaterialReportVO.getSettlementMny()).divide(contractMaterialReportVO.getSettlementMny(),BigDecimal.ROUND_HALF_UP);
                    contractMaterialReportVO.setSettlementTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }

            }

            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList){
                //orderList
                for (ContractMaterialReportVO order : orderList){
                    if (contractMaterialReportVO.getContractId().equals(order.getContractId()) &&
                            contractMaterialReportVO.getMaterialId().equals(order.getMaterialId())){
                        contractMaterialReportVO.setOrderNum(order.getOrderNum());
                    }
                }
                for (ContractMaterialReportVO check : checkList){
                    if (contractMaterialReportVO.getContractId().equals(check.getContractId()) &&
                            contractMaterialReportVO.getMaterialId().equals(check.getMaterialId())){
                        contractMaterialReportVO.setCheckNum(check.getCheckNum());
                        contractMaterialReportVO.setCheckTaxMny(check.getCheckTaxMny());
                        contractMaterialReportVO.setCheckMny(check.getCheckMny());
                        //计算税率
                        if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getCheckMny()) == 0){
                            contractMaterialReportVO.setCheckTaxRate(BigDecimal.ZERO);
                        }else {
                            BigDecimal contractTaxRate = contractMaterialReportVO.getCheckTaxMny().subtract(contractMaterialReportVO.getCheckMny()).divide(contractMaterialReportVO.getCheckMny(),BigDecimal.ROUND_HALF_UP);
                            contractMaterialReportVO.setCheckTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                        }
                        //计算单价
                        if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getCheckMny()) == 0){
                            contractMaterialReportVO.setCheckTaxTaxPrice(BigDecimal.ZERO);
                        }else {
                            contractMaterialReportVO.setCheckTaxTaxPrice(contractMaterialReportVO.getCheckTaxMny().divide(contractMaterialReportVO.getCheckNum(), 8, ROUND_HALF_DOWN));
                        }
                    }
                }
                for (ContractMaterialReportVO settle : settleList){
                    if (contractMaterialReportVO.getContractId().equals(settle.getContractId()) &&
                            contractMaterialReportVO.getMaterialId().equals(settle.getMaterialId())){
                        contractMaterialReportVO.setSettlementNum(settle.getSettlementNum());
                        contractMaterialReportVO.setSettlementTaxRate(settle.getSettlementTaxRate());
                        contractMaterialReportVO.setSettlementTaxPrice(settle.getSettlementTaxPrice());
                        contractMaterialReportVO.setSettlementTaxMny(settle.getSettlementTaxMny());
                    }
                }

            }

        }

        return contractMaterialReportVOList;
    }

    /**
     * 占用/释放 定标结果
     *
     * @param vo   合同vo
     * @param type 0占用，1释放
     */
    @Override
    public void updateTargetResult(ContractVO vo, Integer type) {
        if (vo.getTargetResultId() == null) return;
        if (CollectionUtils.isEmpty(vo.getContractDetailList())) return;
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId()); // 定标参照id
        picketageVO.setContractMoneyTax(vo.getContractTaxMny()); // 合同金额（含税）
        picketageVO.setContractMoney(vo.getContractMny()); // 合同金额
        List<TenderPicketageDetailVO> list = new ArrayList<>();
        for (ContractDetailVO detailVO : vo.getContractDetailList()) {
            // 删除的不做占用处理
            if ("del".equals(detailVO.getRowState())) continue;
            TenderPicketageDetailVO tenderDetailVo = new TenderPicketageDetailVO();
            tenderDetailVo.setId(Long.valueOf(detailVO.getSourceId()));
            tenderDetailVo.setSignNum(detailVO.getNum());
            list.add(tenderDetailVo);
        }
        picketageVO.setTenderPicketageDetailList(list);
        CommonResponse<String> response;
        String typeStr = 0 == type ? "占用" : "释放";
        logger.info("{}定标结果请求参数：{}", typeStr, JSONObject.toJSONString(picketageVO));
        // 占用
        if (0 == type) {
            response = tenderApi.updateStatus(picketageVO);
        }
        // 释放
        else {
            response = tenderApi.delUpdateStatus(picketageVO);
        }
        logger.info("{}定标结果请求结果：{}", typeStr, JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "定标结果失败！");
        }
    }

    /**
     * 根据定标结果id查询对应合同
     *
     * @param targetResultIdList 定标结果id
     * @return 查询结果
     */
    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        List<SignContractVo> rtnList = new ArrayList<>();
        if (CollectionUtils.isEmpty(targetResultIdList)) return rtnList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter(QueryParam.IN, targetResultIdList));
        queryParam.getOrderMap().put("signDate", QueryParam.DESC);
        List<ContractEntity> entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(entityList)) return rtnList;
        for (ContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(this.getContractLinkUrl(entity.getTargetResultId(), entity.getId(),
                    entity.getSupplementFlag(), entity.getPerformanceStatus(), entity.getContractType()));
            rtnList.add(vo);
        }

        return rtnList;
    }

    /**
     * 获取合同跳转路径（不包含baseHost）
     *
     * @param targetResultId    定标结果id
     * @param contractId        合同id
     * @param supplementFlag    是否补充协议
     * @param performanceStatus 履约状态
     * @param contractType      合同类型
     * @return 合同路径
     */
    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag,
                                      String performanceStatus, Integer contractType) {
        int targetType = targetResultId == null ? 1 : 0;
        String url = "/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id="
                + contractId + "&supplementFlag=" + supplementFlag
                + "&targetType=" + targetType + "&performanceStatus="
                + performanceStatus;
        if (MaterialContractTypeEnum.混凝土.getCode().equals(contractType)) {
            url = "/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id="
                    + contractId + "&supplementFlag=" + supplementFlag
                    + "&targetType=" + targetType + "&performanceStatus="
                    + performanceStatus;
        }
        return url;
    }

    /**
     * 校验明细数量
     *
     * @param detailList     需要校验明细
     * @param contractId     合同id
     * @param targetResultId 定标结果id
     */
    private void checkDetailTenderNum(List<ContractDetailVO> detailList, Long contractId, Long targetResultId) {
        if (targetResultId == null) return;
        if (CollectionUtils.isEmpty(detailList)) return;
        // 先校验传入数据签订数量是否大于可签订数量
        for (ContractDetailVO vo : detailList) {
            if(vo.getSignNum() == null || vo.getSignNum().compareTo(vo.getNum()) < 0){
                throw new BusinessException("签订数量不能大于可签订数量");
            }
        }
        List<String> sourceIdList = detailList.stream().map(ContractDetailVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter(QueryParam.NE, contractId));
        }
        List<ContractDetailEntity> detailEntityList = contractDetailService.queryList(detailParam, false);
        // 没有查询出结果则不校验
        if (CollectionUtils.isEmpty(detailEntityList)) return;
        Map<String, List<ContractDetailEntity>> queryMap = detailEntityList.stream()
                .collect(Collectors.groupingBy(ContractDetailEntity::getSourceId));
        for (ContractDetailVO detail : detailList) {
            List<ContractDetailEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            // 列表为空则说明改材料未签订过合同，跳过验证
            if (CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO; // 已签订总数量
            for (ContractDetailEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum); // 剩余总数量
            // 剩余数量小于列表传入的数量，则抛出异常
            if (sy.compareTo(detail.getNum()) < 0) {
                throw new BusinessException(detail.getMaterialName() + "采购数量不能超过" + sy);
            }
        }
    }

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            String billType = "BT211227000000003";
            String sourceType = "mContractFile";
            if (MaterialContractTypeEnum.混凝土.getCode().equals(contractEntity.getContractType())) {
                billType = "BT220215000000001";
                sourceType ="mContractFile";
            }
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(),
                    contractEntity.getBillCode(), billType, sourceType);
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    @Override
    public String getContractFilingCode() {
        // 合同归档参数控制
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        logger.info("合同归档控制参数查询结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取合同归档控制参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
//        Assert.hasText(valueData, "获取的合同归档控制参数不能为空!");
        return StringUtils.isNotEmpty(valueData) ? valueData : "0";
    }

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        ContractEntity contractEntity = super.selectById(contractId);
        // 不限制
        if("0".equals(valueData)){
            return true;
        }
        // 部分限制、全部限制，合同未归档，都不能新增合同变更、补充协议
        else {
            return FilingStatusEnum.已归档.getTypeCode().equals(contractEntity.getFilingStatus());
        }
    }

    @Override
    public ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialCostPriceApiVO> detailList = materialPriceHistoryApiVO.getMaterialCostPriceApiVOList();
        Integer priceCheckType = materialPriceHistoryApiVO.getPriceCheckType();
        if(priceCheckType==null){
            logger.info("priceCheckType为空直接返回结果");
            return paramsCheckVO;
        }
        if(CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        List<Long> materialIds = detailList.stream().map(MaterialCostPriceApiVO::getMaterialId).collect(Collectors.toList());
        String MAX_CODE ="";
        String name  = MaterialCostPriceCheckTypeEnum.getEnumByCode(priceCheckType).getDescription();
        switch (priceCheckType){
            case 1:MAX_CODE= MaterialCostPriceCheckCodeEnum.材料采购合同.getCode();break;
            case 2:MAX_CODE= MaterialCostPriceCheckCodeEnum.材料采购验收.getCode();break;
            case 3:MAX_CODE= MaterialCostPriceCheckCodeEnum.材料采购结算.getCode();break;
            case 4:MAX_CODE= MaterialCostPriceCheckCodeEnum.混凝土采购合同.getCode();break;
            case 5:MAX_CODE= MaterialCostPriceCheckCodeEnum.混凝土采购验收.getCode();break;
            case 6:MAX_CODE= MaterialCostPriceCheckCodeEnum.混凝土采购结算.getCode();break;
        }
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询比例
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        logger.info(name+"价格控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(materialPriceHistoryApiVO.getProjectId(),DocTypeEnum.物料档案.getCode(),materialIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVO;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();
        if(null==dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVO;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialCostPriceApiVO  detailVO: detailList) {//遍历明细
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId())==null?BigDecimal.ZERO:dutyMap.get(detailVO.getMaterialId()).setScale(4, BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                    BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                    if (price.compareTo(maxPriceParam) >0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                        paramsCheckDsVO.setWarnName(name+"单价大于目标成本单价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(name+"单价：").append(price)
                                .append("，目标成本单价:(").append(maxPrice)
                                .append("),目标成本单价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                .append("，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOSMax.add(paramsCheckDsVO);
                    }
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        List<ContractDetailVO> successList = new ArrayList<>();
        List<ContractDetailVO> errorList = new ArrayList<>();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(1));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
                if(!materialRes.isSuccess()){
                    return CommonResponse.error("获取档案异常!");
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ContractDetailVO vo = new ContractDetailVO();
                    String warnType = "";
//                    vo.setId(IdWorker.getId());
                    vo.setMaterialTypeName(datas.get(0));
                    vo.setMaterialCode(datas.get(1));
                    vo.setMaterialName(datas.get(2));
                    vo.setSpec(datas.get(3));
                    vo.setUnitName(datas.get(4));

                    String materialCode = datas.get(1);
                    if(map.containsKey(materialCode)){
                        MaterialVO material = map.get(materialCode);
                        vo.setMaterialTypeId(material.getCategoryId());
                        vo.setMaterialTypeName(material.getCategoryName());
                        vo.setMaterialId(material.getId());
                        vo.setMaterialCode(material.getCode());
                        vo.setMaterialName(material.getName());
                        vo.setSpec(material.getSpec());
                        vo.setUnitId(material.getUnitId());
                        vo.setUnitName(material.getUnitName());
                        vo.setTexture(material.getDef1());
                        vo.setSourceId(material.getId().toString());
                        vo.setSourceType("1");// 来源于物资档案
                    }else{
                        warnType =  warnType+"[物资编码不匹配]";
                    }

                    vo.setBrand(datas.get(5));// 品牌

                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setNum(null);
                        warnType = warnType+"[采购数量为空]";
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType+"[采购数量只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setDetailTaxPrice(null);
                        warnType = warnType+"[单价为空]";
                    } else {
                        try {
                            vo.setDetailTaxPrice(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setDetailTaxPrice(null);
                            warnType = warnType+"[单价只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setDetailTaxRate(null);
                        warnType = warnType+"[税率为空]";
                    } else {
                        try {
                            vo.setDetailTaxRate(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setDetailTaxRate(null);
                            warnType = warnType+"[税率只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setDetailTaxMny(null);
                    } else {
                        try {
                            vo.setDetailTaxMny(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setDetailTaxMny(null);
                            warnType = warnType+"[金额只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        vo.setPrice(null);
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType+"[单价(无税)只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(11))) {
                        vo.setMoney(null);
                    } else {
                        try {
                            vo.setMoney(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            vo.setMoney(null);
                            warnType = warnType+"[金额(无税)只能为数字或小数]";
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(12))) {
                        vo.setDetailTax(null);
                    } else {
                        try {
                            vo.setDetailTax(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            vo.setDetailTax(null);
                            warnType = warnType+"[税额只能为数字或小数]";
                        }
                    }

                    vo.setPlace(datas.get(13));// 产地
                    vo.setMemo(datas.get(14));// 备注

                    vo.setWarnType(warnType);
                    vo.setChangeType("0");
                    vo.setRowState("add");
                    if(StringUtils.isEmpty(vo.getWarnType())){
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
