package com.ejianc.business.promaterial.electronicFence.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.electronicFence.mapper.ElectronicFenceConfigMapper;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;

/**
 * 电子围栏设置
 * 
 * @author generator
 * 
 */
@Service("electronicFenceConfigService")
public class ElectronicFenceConfigServiceImpl extends BaseServiceImpl<ElectronicFenceConfigMapper, ElectronicFenceConfigEntity> implements IElectronicFenceConfigService{

    @Override
    public ElectronicFenceConfigEntity getOneByProjectId(Long projectId, boolean isValid) {
        QueryWrapper<ElectronicFenceConfigEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        if(isValid) {
            query.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        }

        return super.getOne(query);
    }
}
