package com.ejianc.business.promaterial.plan.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料批次采购计划主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_bat_plan")
public class BatPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人名称
    @TableField(value="unit_id")
    private Long unitId; // 采购单位ID
    @TableField(value="unit_name")
    private String unitName; // 采购单位名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="plan_name")
    private String planName; // 计划名称
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    @TableField(value="create_date")
    private java.util.Date createDate; // 编制日期          --提制日期
    @TableField(value="purchase_id")
    private String purchaseId; // 采购类别ID
    @TableField(value="purchase_name")
    private String purchaseName; // 采购类别名称
    @TableField(value="temporary_money")
    private BigDecimal temporaryMoney; // 暂估金额
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="supply_start_time")
    private java.util.Date supplyStartTime; // 供货开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="supply_end_time")
    private java.util.Date supplyEndTime; // 供货结束时间
    @TableField(value="payment_id")
    private String paymentId; // 付款方式ID
    @TableField(value="payment_name")
    private String paymentName; // 付款方式名称
    @TableField(value="trailer_id")
    private Long trailerId; // 拖车是否可进ID
    @TableField(value="trailer_name")
    private String trailerName; // 拖车是否可进名称
    @TableField(value="take_address")
    private String takeAddress; // 收货地址
    @TableField(value="settlement_clause")
    private String settlementClause; // 结算条款
    @TableField(value="plan_standard")
    private String planStandard; // 质量验收标准
    @TableField(value="plan_state")
    private Integer planState; // 采购计划状态（0-待采购,1-采购中,2-采购完成）
    @TableField(value="trustees_id")
    private Long trusteesId; // 招标经办人ID
    @TableField(value="trustees_name")
    private String trusteesName; // 招标经办人名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="purchase_type")
    private String purchaseType; // 采购类型 1-自采，2-集采
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 集采/自采

    @TableField(value="approve_output_mny")
    private BigDecimal approveOutputMny;

    @TableField(value="plan_date")
    private Date planDate; // 需用日期
    @TableField(value="dept_name")
    private String deptName;// 需用部门
    @TableField(value="urgent_state")
    private Integer urgentState; // 紧急采购（0-否，1-是）
    @TableField(value="sporadic_state")
    private Integer sporadicState; // 是否零星采购（0-否，1-是）
    @TableField(value="sign_state")
    private Integer signState; // 是否签订合同（0-否，1-是）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="batPlanDetailService",pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
    private List<BatPlanDetailEntity> batPlanDetailList = new ArrayList<>(); // 材料批次采购计划字表（采购清单）

    public BigDecimal getApproveOutputMny() {
        return approveOutputMny;
    }

    public void setApproveOutputMny(BigDecimal approveOutputMny) {
        this.approveOutputMny = approveOutputMny;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 采购单位ID
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 采购单位ID
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 采购单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 采购单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
     */
    public Integer getContractType() {
        return contractType;
    }

    /**
     * 合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
     */
    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    /**
     * 采购类别名称
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购类别名称
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    /**
     * 暂估金额
     */
    public BigDecimal getTemporaryMoney() {
        return temporaryMoney;
    }

    /**
     * 暂估金额
     */
    public void setTemporaryMoney(BigDecimal temporaryMoney) {
        this.temporaryMoney = temporaryMoney;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 供货开始时间
     */
    public java.util.Date getSupplyStartTime() {
        return supplyStartTime;
    }

    /**
     * 供货开始时间
     */
    public void setSupplyStartTime(java.util.Date supplyStartTime) {
        this.supplyStartTime = supplyStartTime;
    }
    /**
     * 供货结束时间
     */
    public java.util.Date getSupplyEndTime() {
        return supplyEndTime;
    }

    /**
     * 供货结束时间
     */
    public void setSupplyEndTime(java.util.Date supplyEndTime) {
        this.supplyEndTime = supplyEndTime;
    }
    /**
     * 付款方式ID
     */
    public String getPaymentId() {
        return paymentId;
    }

    /**
     * 付款方式ID
     */
    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }
    /**
     * 付款方式名称
     */
    public String getPaymentName() {
        return paymentName;
    }

    /**
     * 付款方式名称
     */
    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }
    /**
     * 拖车是否可进ID
     */
    public Long getTrailerId() {
        return trailerId;
    }

    /**
     * 拖车是否可进ID
     */
    public void setTrailerId(Long trailerId) {
        this.trailerId = trailerId;
    }
    /**
     * 拖车是否可进名称
     */
    public String getTrailerName() {
        return trailerName;
    }

    /**
     * 拖车是否可进名称
     */
    public void setTrailerName(String trailerName) {
        this.trailerName = trailerName;
    }
    /**
     * 收货地址
     */
    public String getTakeAddress() {
        return takeAddress;
    }

    /**
     * 收货地址
     */
    public void setTakeAddress(String takeAddress) {
        this.takeAddress = takeAddress;
    }
    /**
     * 结算条款
     */
    public String getSettlementClause() {
        return settlementClause;
    }

    /**
     * 结算条款
     */
    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }
    /**
     * 质量验收标准
     */
    public String getPlanStandard() {
        return planStandard;
    }

    /**
     * 质量验收标准
     */
    public void setPlanStandard(String planStandard) {
        this.planStandard = planStandard;
    }
    /**
     * 采购计划状态（0-待采购,1-采购中,2-采购完成）
     */
    public Integer getPlanState() {
        return planState;
    }

    /**
     * 采购计划状态（0-待采购,1-采购中,2-采购完成）
     */
    public void setPlanState(Integer planState) {
        this.planState = planState;
    }
    /**
     * 招标经办人ID
     */
    public Long getTrusteesId() {
        return trusteesId;
    }

    /**
     * 招标经办人ID
     */
    public void setTrusteesId(Long trusteesId) {
        this.trusteesId = trusteesId;
    }
    /**
     * 招标经办人名称
     */
    public String getTrusteesName() {
        return trusteesName;
    }

    /**
     * 招标经办人名称
     */
    public void setTrusteesName(String trusteesName) {
        this.trusteesName = trusteesName;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Integer getUrgentState() {
        return urgentState;
    }

    public void setUrgentState(Integer urgentState) {
        this.urgentState = urgentState;
    }

    public Integer getSporadicState() {
        return sporadicState;
    }

    public void setSporadicState(Integer sporadicState) {
        this.sporadicState = sporadicState;
    }

    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }

    /**
     * 材料批次采购计划字表（采购清单）
     */
    public List<BatPlanDetailEntity> getBatPlanDetailList() {
        return batPlanDetailList;
    }

    /**
     * 材料批次采购计划字表（采购清单）
     */
    public void setBatPlanDetailList(List<BatPlanDetailEntity> batPlanDetailList) {
        this.batPlanDetailList = batPlanDetailList;
    }
}
