package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanService;
import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.business.promaterial.utils.ArchivesUtil;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.business.promaterial.utils.JSONUtils;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资月计划
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("monthPlan")
public class MonthPlanController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MONTH_PLAN_CODE";//此处需要根据实际修改
    
    @Autowired
    private IMonthPlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;

    @Autowired
    private ArchivesUtil archivesUtil;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IShareProjectWbsApi wbsApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthPlanVO> saveOrUpdate(@RequestBody MonthPlanVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthPlanVO> queryDetail(Long id) {
    	MonthPlanEntity entity = service.selectById(id);
    	MonthPlanVO vo = BeanMapper.map(entity, MonthPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthPlanVO> vos) {
        service.removeByIds(vos.stream().map(MonthPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("deptName");
        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.消耗材.getCode()));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MonthPlanEntity> page = service.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthPlanVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @ApiOperation("混泥土查询列表")
    @RequestMapping(value = "/queryConcreteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryConcreteList(@RequestBody QueryParam param) {
        IPage<MonthPlanVO> pageData = service.queryConcreteList(param);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.消耗材.getCode()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MonthPlanVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, MonthPlanVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("MonthPlan-export.xlsx", beans, response);
    }

    @ApiOperation("月计划参数控制")
    @RequestMapping(value = "/paramCheck", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> paramCheck(@RequestBody MonthPlanVO monthPlanVO) {
        List<ParamsCheckVO> allCheck = new ArrayList<>();
        ParamsCheckVO resp = new ParamsCheckVO();

        logger.info("【消耗材总计划量】控制【消耗材月计划量】 start");
        allCheck.addAll(service.masterPlanNumCtrl(monthPlanVO));
        logger.info("【消耗材总计划量】控制【消耗材月计划量】 end");

        logger.info("【消耗材总计划单价】控制【消耗材月计划单价 start");
        allCheck.addAll(service.masterPlanPriceCtrl(monthPlanVO));
        logger.info("【消耗材总计划单价】控制【消耗材月计划单价 end");

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }

        for(ParamsCheckVO p : result) {
            resp.getDataSource().addAll(p.getDataSource());
        }

        return CommonResponse.success("参数校验成功！", resp);
    }

    @ApiOperation("混泥土导出")
    @RequestMapping(value = "/excelConcreteExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelConcreteExport(@RequestBody QueryParam param, HttpServletResponse response) {
        service.excelConcreteExport(param,response);
    }

    /**
     * @Description pc参照
//     * @param param
     * @Return void
     */
    @ApiOperation("pc参照")
    @RequestMapping(value = "/refMonthPlanData", method = RequestMethod.GET)
    @ResponseBody
    public List<MonthPlanVO> refMonthPlanData(String condition, @RequestParam(required = false) String searchText) {
        QueryParam param = new QueryParam();
        //搜索
        if(StringUtils.isNotBlank(searchText)){
            param.getParams().put("name",new Parameter(QueryParam.LIKE,searchText));
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isBlank(condition)) {
            throw new BusinessException("查询失败，参数condition中缺少项projectId！");
        }

        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            throw new BusinessException("查询失败，参数condition中缺少项projectId！");
        }
        if(null == conditionMap.get("planType")) {
            throw new BusinessException("查询失败，参数condition中缺少项planType！");
        }
        //审批通过
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN,billStates));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, conditionMap.get("projectId")));
        param.getParams().put("planType", new Parameter(QueryParam.EQ, conditionMap.get("planType")));

        List<MonthPlanEntity> monthPlanEntities = service.queryList(param, false);
        List<MonthPlanVO> monthPlanVOS = BeanMapper.mapList(monthPlanEntities, MonthPlanVO.class);
        return monthPlanVOS;
     }
    /**
     * @Description app参照
//     * @param param
     * @Return void
     */
    @ApiOperation("app参照")
    @RequestMapping(value = "/refMonthPlanAppData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthPlanDetailVO>> refMonthPlanAppData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //搜索
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("material_category_name");
        param.getFuzzyFields().add("material_name");
        param.getFuzzyFields().add("spec");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 传参判断 */
        if(StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        if(null == conditionMap.get("planType")) {
            return CommonResponse.error("查询失败，参数condition中缺少项planType！");
        }
        /** 查询主表 */
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, conditionMap.get("projectId")));
        queryParam.getParams().put("plan_type", new Parameter(QueryParam.EQ, conditionMap.get("planType")));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<MonthPlanEntity> list = service.queryList(queryParam);
        if(CollectionUtils.isEmpty(list)){
            return CommonResponse.success("查询列表数据成功！", new Page<>());
        }
        Map<Long, MonthPlanEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        /** 查询子表 */
        List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
        param.getParams().put("materialMonthPlanId", new Parameter(QueryParam.IN, ids));
        param.getParams().put("surplusNums", new Parameter(QueryParam.SQL,"IFNULL(surplus_nums,0)>0"));
        IPage<MonthPlanDetailEntity> page = monthPlanDetailService.queryPage(param, false);
        IPage<MonthPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MonthPlanDetailVO> records = BeanMapper.mapList(page.getRecords(), MonthPlanDetailVO.class);
        records.forEach(vo->{
            vo.setPlanCode(map.get(vo.getMaterialMonthPlanId()).getBillCode());
        });
        pageData.setRecords(records);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载（支持模糊导入）
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMatch")
    @ResponseBody
    public void downloadMatch(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入（支持模糊导入）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportMatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportMatch(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<MonthPlanDetailVO> successList = new ArrayList<>();
            List<MonthPlanDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 10) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                Map<String, Integer> codeMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    int rowNum = ++i;
                    List<String> datas = result.get(i);
                    MonthPlanDetailVO vo = new MonthPlanDetailVO();

                    if (StringUtils.isBlank(datas.get(0))) {
                        vo.setErrorMessage("物料分类为必填项");
                    } else {
                        vo.setMaterialCategoryName(datas.get(0).trim());
                    }

                    if (StringUtils.isNotBlank(datas.get(1)) && datas.get(1).length() > 64) {
                        vo.setErrorMessage("物资编码填写长度为0~64字");
                    } else {
                        vo.setMaterialCode(datas.get(1).trim());
                    }
                    String materialCode = datas.get(1).trim();
                    if (StringUtils.isNotEmpty(materialCode)) {
                        if (!codeMap.containsKey(materialCode)) {
                            codeMap.put(materialCode, rowNum);
                        } else {
                            vo.setErrorMessage("第" + codeMap.get(materialCode) + "、" + rowNum + "行物资编码重复`");
                        }
                    }

                    if (StringUtils.isBlank(datas.get(2))) {
                        vo.setErrorMessage("材料名称为必填项");
                    } else if (datas.get(2).length() > 30) {
                        vo.setErrorMessage("材料名称填写长度为0~30字");
                    } else {
                        vo.setMaterialName(datas.get(2).trim());
                    }

                    if (StringUtils.isNotBlank(datas.get(3))){
                        vo.setSpec(datas.get(3).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(4))){
                        vo.setUnit(datas.get(4).trim());
                    }

                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            vo.setMonthPlanNum(new BigDecimal(datas.get(5)));
                            if (vo.getMonthPlanNum().longValue() < 0) {
                                vo.setErrorMessage("数量必须大于0");
                            }
                        } catch (Exception e) {
                            vo.setErrorMessage("数量必须为数字");
                        }
                    } else {
                        vo.setErrorMessage("数量为必填项");
                    }
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            String date = DateUtils.formatExcelDate(datas.get(6));
                            vo.setPlanDate(DateUtils.createDate(date));
                        } catch (Exception e) {
                            vo.setErrorMessage("需用日期非日期格式");
                        }
                    }

                    if (StringUtils.isNotBlank(datas.get(7))){
                        vo.setConstruction(datas.get(7).trim());
                    }

                    if (StringUtils.isNotBlank(datas.get(8))){
                        Integer firstState = "是".equals(datas.get(8)) ? 1 : 0;
                        vo.setFirstState(firstState);
                    }

                    if (StringUtils.isNotBlank(datas.get(9)) && datas.get(9).length() > 50) {
                        vo.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        vo.setRemark(datas.get(9));
                    }

                    vo.setSourceType(2);

                    if (StringUtils.isBlank(vo.getErrorMessage())) {
                        String onlykey = vo.getMaterialCategoryName() + vo.getMaterialName() + vo.getUnit() + vo.getSpec();
                        vo.setOnlyKey(onlykey);
                        successList.add(vo);
                        vo.setId(IdWorker.getId());
                    } else {
                        errorList.add(vo);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(successList)) {
                JSONObject match = archivesUtil.findMatch(successList, "materialCategoryId", "materialId",
                        "materialCategoryName", "materialName", "materialCode", "unitId","unit", "spec", "errorMessage");
                successList = JSONUtils.json2List(match.getString("sourceList"), MonthPlanDetailVO.class);
                List<MonthPlanDetailVO> errorList1 = JSONUtils.json2List(match.getString("errorList"), MonthPlanDetailVO.class);
                errorList.addAll(errorList1);
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "month-plan-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<MonthPlanDetailVO> successList = new ArrayList<>();
            List<MonthPlanDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 10) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(1));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
                if(!materialRes.isSuccess()){
                    return CommonResponse.error("获取档案异常!");
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    MonthPlanDetailVO vo = new MonthPlanDetailVO();
                    vo.setId(IdWorker.getId());
                    vo.setMaterialCategoryName(datas.get(0));

                    if (StringUtils.isBlank(datas.get(1))) {
                        vo.setErrorMessage("物料编码为必填项");
                    } else {
                        vo.setMaterialCode(datas.get(1).trim());
                    }

                    vo.setMaterialName(datas.get(2));
                    vo.setSpec(datas.get(3));
                    vo.setUnit(datas.get(4));
                    String materialCode = datas.get(1);
                    if(map.containsKey(materialCode)){
                        MaterialVO material = map.get(materialCode);
                        vo.setMaterialCategoryId(material.getCategoryId());
                        vo.setMaterialCategoryName(material.getCategoryName());
                        vo.setMaterialId(material.getId());
                        vo.setMaterialCode(material.getCode());
                        vo.setMaterialName(material.getName());
                        vo.setSpec(material.getSpec());
                        vo.setUnitId(material.getUnitId());
                        vo.setUnit(material.getUnitName());
                        vo.setTexture(material.getDef1());
                        vo.setSourceId(material.getId());
                        vo.setSourceType(2);// 来源于物资档案
                    }else{
                        vo.setErrorMessage("物资编码不匹配");
                    }

                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            vo.setMonthPlanNum(new BigDecimal(datas.get(5)));
                            if (vo.getMonthPlanNum().longValue() < 0) {
                                vo.setErrorMessage("数量必须大于0");
                            }
                        } catch (Exception e) {
                            vo.setErrorMessage("数量必须为数字");
                        }
                    } else {
                        vo.setErrorMessage("数量为必填项");
                    }
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            String date = DateUtils.formatExcelDate(datas.get(6));
                            vo.setPlanDate(DateUtils.createDate(date));
                        } catch (Exception e) {
                            vo.setErrorMessage("需用日期非日期格式");
                        }
                    }

                    if (StringUtils.isNotBlank(datas.get(7))){
                        vo.setConstruction(datas.get(7).trim());
                    }

                    if (StringUtils.isNotBlank(datas.get(8))){
                        Integer firstState = "是".equals(datas.get(8)) ? 1 : 0;
                        vo.setFirstState(firstState);
                    }

                    if (StringUtils.isNotBlank(datas.get(9)) && datas.get(9).length() > 50) {
                        vo.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        vo.setRemark(datas.get(9));
                    }

                    vo.setSourceType(2);
                    if (StringUtils.isBlank(vo.getErrorMessage())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
