package com.ejianc.business.promaterial.plan.service;

import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeHisVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;

import java.util.List;

/**
 * 消耗材总计划变更
 * 
 * @author generator
 * 
 */
public interface IMasterPlanChangeService extends IBaseService<MasterPlanChangeEntity> {

    /**
     * 查询指定计划对应的未完成的变更
     *
     * @param sourcePlanId
     * @return
     */
    MasterPlanChangeEntity getUnFinishedChange(Long sourcePlanId);

    /**
     * 保存更新总计划变更
     *
     * @param saveEntity
     * @return
     */
    MasterPlanChangeEntity saveOrUpdatePlanChange(MasterPlanChangeEntity saveEntity);

    /**
     * 根据Id删除对应的变更单据，并恢复计划单据的变更信息
     *
     * @param changeIds
     */
    void deleteChangePlan(List<Long> changeIds);

    List<MasterPlanChangeHisVO> queryDetailRecord(Long id);

    MasterPlanChangeVO queryDetail(Long id, boolean detailHasChildren);

    CommonResponse<MasterPlanChangeVO> saveOrUpdateMasterPlan(MasterPlanChangeVO planVo, Boolean isControl);

    ParamsCheckVO targetCostCtrl(MasterPlanChangeVO masterPlanVo);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);
}
