package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.SinglePlanEntity;
import com.ejianc.business.promaterial.plan.service.*;
import com.ejianc.business.promaterial.plan.vo.*;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.SinglePlanMapper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 单项采购计划
 * 
 * @author generator
 * 
 */
@Service("singlePlanService")
public class SinglePlanServiceImpl extends BaseServiceImpl<SinglePlanMapper, SinglePlanEntity> implements ISinglePlanService{
    
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DX_PLAN_CODE";//此处需要根据实际修改

    private static final String PLAN_NUM_CTRL_PARAM_CODE = "P-6b51900004";
    private static final String MASTER_PLAN_PRICE_CTRL_PARAM_CODE = "P-17X9z80191";
    private static final String CONTRACT_NUM_CTRL_PARAM_CODE = "P-7r6T9V0005";

    @Autowired
    private ISinglePlanService service;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ISinglePlanDetailService detailService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private OrgUtil orgUtil;

    @Override
    public CommonResponse<SinglePlanVO> saveOrUpdate(SinglePlanVO saveOrUpdateVO) {
        SinglePlanEntity entity = BeanMapper.map(saveOrUpdateVO, SinglePlanEntity.class);
        if(StringUtils.isNotBlank(entity.getBillCode())) {
            //编码重复校验
            SinglePlanVO voByCode = this.queryByCode(entity.getBillCode());
            if(null != voByCode && (null == entity.getId() || !voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("保存失败，编码重复！");
            }
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                String code = orgUtil.getBillCodeByCorp(entity.getOrgId(), entity.getProjectId(), billCode.getData());
                entity.setBillCode(code);//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<SinglePlanDetailEntity> detailList = entity.getPlanDetailList();
        String materialName = "";
        if(CollectionUtils.isNotEmpty(detailList)){
            ArrayList<SinglePlanDetailEntity> list = new ArrayList<>();
            for(SinglePlanDetailEntity detail :detailList ){
                //物资名称集合
                if(!("del".equals(detail.getRowState()))){//删除的物资不拼接名称
                    if(StringUtils.isNotBlank(detail.getMaterialName())){
                        if(StringUtils.isNotBlank(materialName)){
                            materialName = materialName+","+detail.getMaterialName();
                        }else {
                            materialName = detail.getMaterialName();
                        }
                    }
                    list.add(detail);
                }
                BigDecimal nums = detail.getNums() == null ? BigDecimal.ZERO : detail.getNums();
                BigDecimal occupyNums = detail.getOccupyNums() == null ? BigDecimal.ZERO : detail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                detail.setSurplusNums(surplusNums);//剩余
                detail.setOccupyNums(occupyNums);//占用
                detail.setNums(nums);//需用
                detail.setActualNums(nums);// 实际
            }
            Integer planFlag = entity.getPlanFlag()==null?1:entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if(CollectionUtils.isEmpty(list)){
                throw new BusinessException("最少有一条计划明细！");
            }
        }else{
            throw new BusinessException("最少有一条计划明细！");
        }

        // 回写占用量
        this.writeBackOccupyNum(entity);

        super.saveOrUpdate(entity, false);
        SinglePlanVO vo = BeanMapper.map(entity, SinglePlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 回写占用量
     * @param entity
     * @return
     */
    private void writeBackOccupyNum(SinglePlanEntity entity) {
        SinglePlanEntity data = new SinglePlanEntity();
        if(null != entity.getId()){
            data = super.selectById(entity.getId());
        }
        Map<Long, SinglePlanDetailEntity> dataMap = data.getPlanDetailList().stream().collect(Collectors.toMap(x->x.getId(), x->x));
        Map<Long, BigDecimal> numMap = new HashMap<>();
        for (SinglePlanDetailEntity detail : entity.getPlanDetailList()) {
            detail.setActualNums(detail.getNums());
            detail.setSurplusNums(ComputeUtil.safeSub(detail.getActualNums(), detail.getOccupyNums()));
            if("del".equals(detail.getRowState())){
                numMap.put(detail.getSourceId(), ComputeUtil.safeSub(numMap.get(detail.getSourceId()), detail.getNums()));
            } else {
                BigDecimal num = detail.getNums();
                if(dataMap.containsKey(detail.getId())){
                    num = ComputeUtil.safeSub(detail.getNums(), dataMap.get(detail.getId()).getNums());
                }
                numMap.put(detail.getSourceId(), ComputeUtil.safeAdd(numMap.get(detail.getSourceId()), num));
            }
        }
        if(MapUtils.isNotEmpty(numMap)){
            planDetailService.writeBackOccupyNum(numMap);
        }
    }

    @Override
    public Boolean delete(List<SinglePlanVO> vos) {
        List<Long> ids = vos.stream().map(x->x.getId()).collect(Collectors.toList());
        // 回写占用量
        QueryParam param = new QueryParam();
        param.getParams().put("planId", new Parameter(QueryParam.IN, ids));
        List<SinglePlanDetailEntity> detailList = detailService.queryList(param);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        for (SinglePlanDetailEntity detail : detailList) {
            numMap.put(detail.getSourceId(), ComputeUtil.safeSub(numMap.get(detail.getSourceId()), detail.getNums()));
        }
        super.removeByIds(ids, true);
        if(MapUtils.isNotEmpty(numMap)){
            planDetailService.writeBackOccupyNum(numMap);
        }
        return true;
    }

    private SinglePlanVO queryByCode(String planCode) {
        SinglePlanVO resp = null;
        QueryWrapper<SinglePlanEntity> query = new QueryWrapper<>();
        query.eq("bill_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        SinglePlanEntity entity = super.getOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, SinglePlanVO.class);
        }
        return resp;
    }

    @Override
    public List<SinglePlanDetailVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper) {
        List<SinglePlanDetailVO> planVOList = baseMapper.getPlanByMaterialId(materialListId,queryWrapper);
        return planVOList;
    }

    @Override
    public List<ParamsCheckVO> planNumCtrl(SinglePlanVO planVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PLAN_NUM_CTRL_PARAM_CODE, planVO.getOrgId());

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }

        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> checkParamData = billParamByCode.getData();

        List<SinglePlanDetailVO> detailList = planVO.getPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(SinglePlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, SinglePlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(SinglePlanDetailVO::getMaterialId, item -> item));

        //获取当前月计划每个明细除自己外累计的月计划量
        List<Map<String, Object>> detailTotalNumInfo = detailService.countDetailTotalNum(planVO.getId(), detailIds, planVO.getProjectId());
        Map<Long, Map<String, BigDecimal>>  detailNumMap = new HashMap<>();
        Map<String, BigDecimal> detailCountMap = null;

        for(Map<String, Object> item : detailTotalNumInfo) {
            if(detailVONumMap.containsKey(Long.valueOf(item.get("materialId").toString()))) {
                detailCountMap = new HashMap<>();
                //计算得到当前明细总的量
                detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd(detailVONumMap.get(Long.valueOf(item.get("materialId").toString())).getNums(), null != item.get("totalPlanNum") ? new BigDecimal(item.get("totalPlanNum").toString()) : BigDecimal.ZERO));
                //总计划量
                detailCountMap.put("masterPlanNum", new BigDecimal(item.get("masterPlanNum").toString()));
                detailNumMap.put(Long.valueOf(item.get("materialId").toString()), detailCountMap);
            }
        }

        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        List<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        SinglePlanDetailVO tempDetail= null;
        for (BillParamVO billParamVO : checkParamData){
            dataSource = new ArrayList<>();
            paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            roleValue = ComputeUtil.safeDiv(billParamVO.getRoleValue(), new BigDecimal("100"));
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    detailCountMap = detailNumMap.get(materialId);
                    tempDetail = detailVONumMap.get(materialId);
                    if(detailCountMap.get("masterPlanNum").compareTo(new BigDecimal("-1")) == 0) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}在总计划不存在，不进行价控！",
                                tempDetail.getMaterialCategoryName(), tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId());
                    }
                    BigDecimal value = ComputeUtil.safeMultiply(detailCountMap.get("masterPlanNum"), roleValue);
                    if(detailCountMap.get("totalPlanNum").compareTo(value) > 0) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                        paramsCheckDsVO.setWarnName("单项采购计划量超过分项需用计划量");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次单项采购计划量：").append(tempDetail.getNums().setScale(2, RoundingMode.DOWN))
                                .append("，含本次累计单项采购计划量：").append(detailCountMap.get("totalPlanNum").setScale(2, RoundingMode.DOWN))
                                .append("，分项需用计划量*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%：").append(value.setScale(2, RoundingMode.DOWN))
                                .append("。超出数量：").append(ComputeUtil.safeSub(detailCountMap.get("totalPlanNum"), value).setScale(2, RoundingMode.DOWN));
                        paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
            }

            paramsCheckVOList.add(paramsCheckVO);
        }

        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> masterPlanPriceCtrl(SinglePlanVO planVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MASTER_PLAN_PRICE_CTRL_PARAM_CODE, planVO.getOrgId());

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }

        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> checkParamData = billParamByCode.getData();

        List<SinglePlanDetailVO> detailList = planVO.getPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());

        //查询总计划物料单价
        List<MasterPlanDetailEntity> masterPlanDetailList = masterPlanDetailService.getByProjectId(planVO.getProjectId(), 0);
        Map<Long, BigDecimal> masterDetailPriceNum = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, MasterPlanDetailEntity::getPrice));

        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        List<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        BigDecimal tmpPrice = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<>();
            paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for(SinglePlanDetailVO detail : detailList) {
                    tmpPrice = masterDetailPriceNum.get(detail.getMaterialId());
                    if(null == tmpPrice) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}在总计划不存在，不进行价控！",
                                detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId());
                        continue;
                    }
                    if(null == detail.getPrice()) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}单价为空，不进行价控！",
                                detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId());
                        continue;
                    }
                    if(detail.getPrice().compareTo(ComputeUtil.safeMultiply(tmpPrice, roleValue)) > 0) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem(detail.getMaterialName() + detail.getSpec());
                        paramsCheckDsVO.setWarnName("消耗材需用计划单价超过总计划单价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次需用计划单价：").append(detail.getNums().setScale(2, RoundingMode.DOWN))
                                .append("，总计划单价*X%：").append(ComputeUtil.safeMultiply(tmpPrice, roleValue).setScale(2, RoundingMode.DOWN))
                                .append("。超出：").append(ComputeUtil.safeSub(detail.getPrice(), ComputeUtil.safeMultiply(tmpPrice, roleValue)).setScale(2, RoundingMode.DOWN));
                        paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
            }

            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> contractNumCtrl(SinglePlanVO planVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTRACT_NUM_CTRL_PARAM_CODE, planVO.getOrgId());

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }

        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> checkParamData = billParamByCode.getData();

        List<SinglePlanDetailVO> detailList = planVO.getPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(SinglePlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, SinglePlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(SinglePlanDetailVO::getMaterialId, item -> item));

        //获取当前月计划每个明细除自己外累计的月计划量
        List<Map<String, Object>> detailTotalNumInfo = detailService.contractNumCtrl(planVO.getId(), detailIds, planVO.getContractId());
        Map<Long, Map<String, BigDecimal>>  detailNumMap = new HashMap<>();
        Map<String, BigDecimal> detailCountMap = null;

        for(Map<String, Object> item : detailTotalNumInfo) {
            if(detailVONumMap.containsKey(Long.valueOf(item.get("materialId").toString()))) {
                detailCountMap = new HashMap<>();
                //计算得到当前明细总的量
                detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd(detailVONumMap.get(Long.valueOf(item.get("materialId").toString())).getNums(), null != item.get("totalPlanNum") ? new BigDecimal(item.get("totalPlanNum").toString()) : BigDecimal.ZERO));
                //总计划量
                detailCountMap.put("masterPlanNum", new BigDecimal(item.get("masterPlanNum").toString()));
                detailNumMap.put(Long.valueOf(item.get("materialId").toString()), detailCountMap);
            }
        }

        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        List<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        SinglePlanDetailVO tempDetail= null;
        for (BillParamVO billParamVO : checkParamData){
            dataSource = new ArrayList<>();
            paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            roleValue = ComputeUtil.safeDiv(billParamVO.getRoleValue(), new BigDecimal("100"));
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    detailCountMap = detailNumMap.get(materialId);
                    tempDetail = detailVONumMap.get(materialId);
                    if(detailCountMap.get("masterPlanNum").compareTo(new BigDecimal("-1")) == 0) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}在月计划不存在，不进行价控！",
                                tempDetail.getMaterialCategoryName(), tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId());
                    }
                    BigDecimal value = ComputeUtil.safeMultiply(detailCountMap.get("masterPlanNum"), roleValue);
                    if(detailCountMap.get("totalPlanNum").compareTo(value) > 0) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                        paramsCheckDsVO.setWarnName("单项采购计划量超过合同量");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次单项采购计划量：").append(tempDetail.getNums().setScale(2, RoundingMode.DOWN))
                                .append("，含本次累计单项采购计划量：").append(detailCountMap.get("totalPlanNum").setScale(2, RoundingMode.DOWN))
                                .append("，合同量*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%：").append(value.setScale(2, RoundingMode.DOWN))
                                .append("。超出数量：").append(ComputeUtil.safeSub(detailCountMap.get("totalPlanNum"),value).setScale(2, RoundingMode.DOWN));
                        paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }
}
