package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckStoreDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckStoreEntity;
import com.ejianc.business.promaterial.check.mapper.CheckStoreMapper;
import com.ejianc.business.promaterial.check.service.ICheckStoreService;
import com.ejianc.business.promaterial.check.vo.CheckStoreVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料入库
 *
 * @author generator
 */
@Service("checkStoreService")
public class CheckStoreServiceImpl extends BaseServiceImpl<CheckStoreMapper, CheckStoreEntity> implements ICheckStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CheckStoreVO saveOrUpdate(CheckStoreVO saveOrUpdateVO) {
        CheckStoreEntity entity = BeanMapper.map(saveOrUpdateVO, CheckStoreEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(saveOrUpdateVO.getProjectShortName() + billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        CheckStoreVO vo = BeanMapper.map(entity, CheckStoreVO.class);
        return vo;
    }

    @Override
    public CheckStoreVO pushToCheckStore(CheckEntity check) {
        CheckStoreEntity entity = BeanMapper.map(check, CheckStoreEntity.class);
        entity.setBillCode(check.getBillCode() + "-入库");
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());// 自由态
        super.saveOrUpdate(entity, false);

//        logger.info("同步附件");
//        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
//                String.valueOf(check.getId()), "BT220215000000006", null,
//                String.valueOf(entity.getId()), "EJCBT202501000003", null);
//        logger.info("同步附件::::::::::::结果::" + JSONObject.toJSONString(response));

        return BeanMapper.map(entity, CheckStoreVO.class);
    }

    @Override
    public Boolean delete(List<CheckStoreVO> vos) {
        List<Long> ids = vos.stream().map(x->x.getId()).collect(Collectors.toList());
//        super.removeByIds(ids,true);
        // 物理删除主子表
        baseMapper.deleteByIds(ids);
        baseMapper.deleteDetailList(ids);
        return true;
    }

    @Override
    public void inStore(CheckStoreEntity checkEntity) {
        ContractEntity contractEntity = null;
        if (checkEntity.getContractId() != null){
            contractEntity = contractService.selectById(checkEntity.getContractId());
        }
        //调用库存逻辑
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
        storeManageVO.setStoreId(checkEntity.getStoreId());
        storeManageVO.setOutEffectiveON(true);
        storeManageVO.setSourceId(checkEntity.getId());
        ArrayList<FlowVO> flowVOS = new ArrayList<>();
        for(int i=0;i<checkEntity.getCheckDetailList().size();i++){
            FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.收料入库, 0);
            this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
            flowVOS.add(flowVO);
        }
        storeManageVO.setFlowVOList(flowVOS);
        String stringInfo = JSONObject.toJSONString(storeManageVO);
        logger.info("消耗材验收入库参数：" +stringInfo);
        CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
        if(!response.isSuccess()) {
            logger.info("测试报错01");
            throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
        }
    }

    /**
     * 组装数据
     * @param checkEntity
     * @param t
     * @param flowVO
     * @param contractEntity
     */
    private void getFlow(CheckStoreEntity checkEntity, CheckStoreDetailEntity t, FlowVO flowVO, ContractEntity contractEntity) {
        flowVO.setConsumableFlag(t.getConsumableFlag());
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        flowVO.setStoreId(checkEntity.getStoreId());
        flowVO.setStoreName(checkEntity.getStoreName());
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialType(checkEntity.getCheckType());
        flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
        flowVO.setSupplierId(checkEntity.getSupplierId());
        flowVO.setSupplierName(checkEntity.getSupplierName());
        flowVO.setPurchaseContractId(checkEntity.getContractId());
        flowVO.setPurchaseContractName(checkEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setCusDef8(null != t.getDeliveryDate() ? DateFormatUtil.formatDate("yyyy-MM-dd", t.getDeliveryDate()) : null);
        flowVO.setTaxPrice(t.getCheckTaxPrice());
        flowVO.setPrice(t.getCheckPrice());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(checkEntity.getSubSupplierId());
        flowVO.setPickUnitName(checkEntity.getSubSupplierName());
        flowVO.setPickContractId(checkEntity.getSubContractId());
        flowVO.setPickContractName(checkEntity.getSubContractName());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setSourceBillTypeName("材料验收");
        flowVO.setSourceBillTypeCode("BT220215000000006");
        flowVO.setSourceType(checkEntity.getSourceType());
        flowVO.setPickType(checkEntity.getSubOutType());
        flowVO.setLicensePlate(checkEntity.getLicensePlate());
        flowVO.setFinanceId(t.getFinanceId());
        flowVO.setFinanceName(t.getFinanceName());
        flowVO.setNetPrice(t.getNetPrice());
        flowVO.setUseType(t.getUseType());
        if (null!=checkEntity.getContractId()&&null!=contractEntity){
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            Map<Long, ContractDetailEntity> sourceIdMap = contractDetailList.stream().collect(Collectors.toMap(ContractDetailEntity::getId, Function.identity()));
            Map<Long, ContractDetailEntity> DetailMaterialIdMap = contractDetailList.stream().filter(e -> e.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
            Map<Long, ContractDetailEntity> DetailMaterialIdTypeMap = contractDetailList.stream().filter(e -> e.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
            //处理子表数据返回
            //1 先根据sourceId取合同明细行对应的单价  取到--返回  否则  到第2步
            ContractDetailEntity contractDetailEntity = sourceIdMap.get(t.getSourceId());
            if(null!=contractDetailEntity){
                flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                flowVO.setContractPrice(contractDetailEntity.getPrice());
            }else{
                //2  根据物料id取合同明细行对应的单价  取到--返回  否则  到第3步
                contractDetailEntity = DetailMaterialIdMap.get(t.getMaterialId());
                if(null!=contractDetailEntity){
                    flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    flowVO.setContractPrice(contractDetailEntity.getPrice());
                }else{
                    //3  根据材料分类Id 取合同明细行对应的单价  取到--返回  否则  单价设置为0
                    contractDetailEntity = DetailMaterialIdTypeMap.get(t.getMaterialTypeId());
                    if(null!=contractDetailEntity){
                        flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        flowVO.setContractPrice(contractDetailEntity.getPrice());
                    }else{
                        flowVO.setContractTaxPrice(BigDecimal.ZERO);
                        flowVO.setContractPrice(BigDecimal.ZERO);
                    }
                }
            }
        }
        flowVO.setRowState(t.getRowState());
    }
}
