package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractRelieveVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementCollectService;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.contract.mapper.ContractRelieveMapper;
import com.ejianc.business.promaterial.contract.bean.ContractRelieveEntity;
import com.ejianc.business.promaterial.contract.service.IContractRelieveService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 合同解除表
 *
 * @author generator
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 物资采购合同
     */
    private static final String MATERIAL_BILL_CODE = "CONTRACT_RELIEVE";
    /**
     * 混凝土采购合同
     */
    private static final String CONCRETE_BILL_CODE = "CONTRACT_CONCRETE_RELIEVE";


    @Autowired
    private IBillCodeApi billCodeApi;
    /**
     * 主合同信息
     */
    @Autowired
    private IContractService contractService;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private ISettlementService settlementService;

    @Autowired
    private ISettlementDetailService settlementDetailService;


    @Value("${common.env.base-host}")
    private String BaseHost;
    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;


    /**
     * 保存合同解除
     *
     * @param saveOrUpdateVO 合同解除信息
     * @return 保存后信息
     */
    @Override
    public ContractRelieveVO save(ContractRelieveVO saveOrUpdateVO) {
        ContractRelieveEntity entity = BeanMapper.map(saveOrUpdateVO, ContractRelieveEntity.class);
        // 查询合同状态：不是履约中不可以解除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
        if (contractEntity == null
                || !PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())) {
            throw new BusinessException("查询不到合同或合同状态非履约中！");
        }
        if (entity.getId() == null || entity.getId() == 0) {
            String billCodeStr = MATERIAL_BILL_CODE;
            if (contractEntity.getContractType() == 1) {
                billCodeStr = CONCRETE_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam
                    .build(billCodeStr, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
        if (entity.getId() != null) {
            // 当前合同解除id除外，可以做修改
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
        }
        List<ContractRelieveEntity> list = super.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("一个合同只能存在一份合同解除协议！");
        }
        // 此处起草方式与合同不同，互相独立
        // 起草方式 1、上传解除协议，初始化签章状态为；1-未签章
        if (entity.getDraftType() == 1) {
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
        }
        // 合同解除保存前校验
        contractService.checkContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ContractRelieveVO.class);
    }

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param billId  合同解除单据id
     * @param status  签章状态
     * @param refCode 唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(String billId, String status, String refCode) {
        logger.info("更新合同解除单据签章状态和合同状态，入参：id:{}，signatureStatus：{}，refCode：{}", billId, status, refCode);
        Long id = Long.valueOf(billId);
        ContractRelieveEntity contractRelieveEntity = super.selectById(id);
        contractRelieveEntity.setSignatureStatus(status);
        // 合同信息
        ContractEntity contractEntity = contractService.selectById(contractRelieveEntity.getContractId());
        if (contractEntity == null) {
            throw new BusinessException("合同信息为空！");
        }
        logger.info("修改合同信息-----{}", JSONObject.toJSONString(contractEntity));
        // 签章状态：4-已签章，履约中允许解除（冻结及其他状态不能解除）
        if (SignatureStatusEnum.已签章.getCode().equals(status)
                && PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())) {
            // 更新合同解除单据生效时间
            contractRelieveEntity.setEffectiveDate(new Date());
            contractRelieveEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
            contractRelieveEntity.setPerformanceStatus(PerformanceStatusEnum.已解除.getCode());
            // 更新合同状态为已解除
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.已解除.getCode());
            contractService.saveOrUpdate(contractEntity, false);
            // 推送合同池
            contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));

            //todo
            //目标成本推送
            String linkUrl;
            String frontendBaseHost="";
            if(org.apache.commons.lang3.StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = BaseHost;
            }
            if (contractEntity.getContractType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractRelieve/card?id=" + contractRelieveEntity.getId();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractRelieve/card?id=" + contractRelieveEntity.getId();
            }
            if (contractEntity.getPurchaseType().equals("1")) {
                ExecutionVO executionVO = targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class), linkUrl, contractEntity.getContractType());
                logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }

            logger.info("合同已解除！");
        }
        super.saveOrUpdate(contractRelieveEntity, false);
        return CommonResponse.success("合同解除单据签章状态更新成功！");
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl, Integer contractType) {
        List<DetailExecutionVO> detailList = new ArrayList<>();
        // 计算所有过程结算累计结算金额
        LambdaQueryWrapper<SettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettlementEntity::getContractId, contractRelieveVO.getContractId());
        wrapper.eq(SettlementEntity::getSignatureType, 0);
        wrapper.in(SettlementEntity::getBillState, Arrays.asList(1, 3));
        wrapper.eq(SettlementEntity::getDr, 0);
        List<SettlementEntity> list = settlementService.list(wrapper);

        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(SettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(SettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        ContractVO contractVO = contractService.queryDetail(contractRelieveVO.getContractId());
        List<ContractDetailVO> contractDetailList = contractVO.getContractDetailList();

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        if (contractType == 0) {
            totalVO.setBillType("BT220218000000003");
        }
        else {
            totalVO.setBillType("BT220219000000001");
        }
        switch (contractVO.getContractPropertyCode()) {
            case "proMaterial-1":
                totalVO.setBussinessType(BussinessTypeEnum.物资采购合同_大宗材.getCode());
                break;
//            case "proMaterial-2":
//                totalVO.setBussinessType(BussinessTypeEnum.周转材物资采购合同.getCode());
//                break;
            case "proMaterial-3":
                totalVO.setBussinessType(BussinessTypeEnum.物资采购合同_零星材料.getCode());
                break;
            case "contractConcrete-1":
                totalVO.setBussinessType(BussinessTypeEnum.混凝土采购合同.getCode());
                break;
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractRelieveVO.getProjectId());
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractVO.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractVO.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        //获取结算子表进行汇总
        List<Long> settleIdList = list.stream().map(SettlementEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(settleIdList)) {
            //根据结算单查询子表
            LambdaQueryWrapper<SettlementDetailEntity> detailWrapper = new LambdaQueryWrapper<>();
            detailWrapper.in(SettlementDetailEntity::getSettlementId, settleIdList);
            List<SettlementDetailEntity> settleDetailList = settlementDetailService.list(detailWrapper);
            //根据物资Id进行分组
            Map<Long, List<SettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
            Map<Long, List<ContractDetailVO>> contractDetailMap = contractDetailList.stream().collect(Collectors.groupingBy(ContractDetailVO::getMaterialId));

            for (Long materialId : detailMaterialMap.keySet()) {
                List<SettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
                List<ContractDetailVO> contractDetailList1 = contractDetailMap.get(materialId);
                //进行数量，金额汇总
                BigDecimal contractSumNum = contractDetailList1.stream().filter(e -> e.getNum() != null).map(ContractDetailVO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractSumMny = contractDetailList1.stream().filter(e -> e.getMoney() != null).map(ContractDetailVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractSumTaxMny = contractDetailList1.stream().filter(e -> e.getDetailTaxMny() != null).map(ContractDetailVO::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

                BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.getNum() != null).map(SettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(SettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(SettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                SettlementDetailEntity planDetailVO = detailMaterialList.get(0);
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getSettlementId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                //判断是否是分类
                if (planDetailVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                }
                else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }
                else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                detailExecutionVO.setNum(ComputeUtil.safeSub(sumNum, contractSumNum));
                detailExecutionVO.setMoney(ComputeUtil.safeSub(sumMny, contractSumMny));
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub(sumTaxMny, contractSumTaxMny));
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        else {
            if (contractDetailList != null) {
                for (ContractDetailVO planDetailVO : contractVO.getContractDetailList()) {
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
                    detailExecutionVO.setSourceBillId(contractRelieveVO.getId());
                    detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                    //判断是否是分类
                    if (planDetailVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(true);
                        detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                    }
                    else {
                        detailExecutionVO.setCategoryFlag(false);
                        detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(false);
                    //根据分类ID查询物料分类信息
                    MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }
                    else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
                    detailExecutionVO.setName(planDetailVO.getMaterialName());
                    detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                    detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                    detailExecutionVO.setNum(BigDecimal.ZERO.subtract(planDetailVO.getNum()));
                    detailExecutionVO.setMoney(BigDecimal.ZERO.subtract(planDetailVO.getMoney()));
                    detailExecutionVO.setSpec(planDetailVO.getSpec());
                    detailExecutionVO.setTaxMoney(BigDecimal.ZERO.subtract(planDetailVO.getDetailTaxMny()));
                    detailExecutionVO.setPrice(planDetailVO.getPrice());
                    detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                    detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

}
