package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.order.mapper.OrderDetailMapper;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料订单子表
 * 
 * @author generator
 * 
 */
@Service("orderDetailService")
public class OrderDetailServiceImpl extends BaseServiceImpl<OrderDetailMapper, OrderDetailEntity> implements IOrderDetailService{

    @Autowired
    private ISinglePlanDetailService planDetailService;

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<OrderDetailEntity> list = super.queryList(param);
        for(OrderDetailEntity detail : list){
            BigDecimal surplusNums = detail.getSurplusNumsSum();
            detail.setOccupyNumsSum(ComputeUtil.safeAdd(detail.getOccupyNumsSum(), numMap.get(detail.getId())));
            detail.setSurplusNumsSum(ComputeUtil.safeSub(detail.getActualNumsSum(), detail.getOccupyNumsSum()));
            if (ComputeUtil.isLessThan(detail.getSurplusNumsSum(), BigDecimal.ZERO)){
                throw new BusinessException("物资[名称：" + detail.getMaterialName() + "，规格：" + detail.getSpec() + "]，剩余量：" +
                        ComputeUtil.scaleStripTrailingZeros(surplusNums, 4) + "，数量不足!");
            }
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNumsSum()));
        return result;
    }

    @Override
    public Map<Long, BigDecimal> writeBackActualNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<OrderDetailEntity> list = super.queryList(param);
        Map<Long, BigDecimal> planMap = new HashMap<>();
        for(OrderDetailEntity detail : list){
            BigDecimal surplusNums = detail.getSurplusNumsSum();
            detail.setOccupyNumsSum(ComputeUtil.safeAdd(detail.getOccupyNumsSum(), numMap.get(detail.getId())));
            detail.setActualNumsSum(ComputeUtil.safeAdd(detail.getActualNumsSum(), numMap.get(detail.getId())));
            detail.setSurplusNumsSum(ComputeUtil.safeSub(detail.getActualNumsSum(), detail.getOccupyNumsSum()));
            if (ComputeUtil.isLessThan(detail.getSurplusNumsSum(), BigDecimal.ZERO)){
                throw new BusinessException("物资[名称：" + detail.getMaterialName() + "，规格：" + detail.getSpec() + "]，剩余量：" +
                        ComputeUtil.scaleStripTrailingZeros(surplusNums, 4) + "，数量不足!");
            }
            planMap.put(detail.getSourceDetailId(), numMap.get(detail.getId()));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        if(MapUtils.isNotEmpty(planMap)){
            planDetailService.writeBackOccupyNum(planMap);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNumsSum()));
        return result;
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long orderId, List<Long> materialIds, Long projectId) {
        if(CollectionUtils.isEmpty(materialIds)){
            return new ArrayList<>();
        }
        return baseMapper.countDetailTotalNum(orderId, materialIds, projectId);
    }
}
