package com.ejianc.business.promaterial.plan.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.vo.SinglePlanDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 单项采购计划子表
 * 
 * @author generator
 * 
 */
@Mapper
public interface SinglePlanDetailMapper extends BaseCrudMapper<SinglePlanDetailEntity> {

    List<SinglePlanDetailVO> geMaterialDetail(Page<SinglePlanDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<OrderDetailVO> queryMaterialDetail(@Param("projectId") Long projectId, @Param("materialId") Long materialId);

    BigDecimal getSurplusNumsSum(@Param("projectId") Long projectId, @Param("materialId") Long materialId);

    List<Map<String, Object>> countDetailTotalNum(@Param("planId") Long planId, @Param("detailIds") List<Long> detailIds, @Param("projectId") Long projectId);

    List<Map<String, Object>> contractNumCtrl(@Param("planId") Long planId, @Param("detailIds") List<Long> detailIds, @Param("contractId") Long contractId);
}
