package com.ejianc.business.promaterial.plan.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 消耗材-需用计划子表
 * 
 * @author generator
 * 
 */
public interface IPlanDetailService extends IBaseService<PlanDetailEntity> {
    List<PlanDetailVO> geMaterialDetail(Page<PlanDetailVO> page, QueryWrapper queryWrapper);
    List<OrderDetailVO> queryMaterialDetail(Long projectId, Long materialId);
    BigDecimal getSurplusNumsSum(Long projectId, Long materialId);

    List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId);

    List<Map<String, Object>> countDetailTotalNumByMonth(Long planId, List<Long> detailIds, Long projectId);

    List<Map<String, Object>> contractNumCtrl(Long planId, List<Long> detailIds, Long contractId);

    /**
     * 回写占用量
     * @param numMap
     * @return
     */
    Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap);
}
