package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanDetailMapper;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.plan.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.record.PageBreakRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材总计划
 *
 * @author generator
 *
 */
@Service("masterPlanService")
public class MasterPlanServiceImpl extends BaseServiceImpl<MasterPlanMapper, MasterPlanEntity> implements IMasterPlanService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MasterPlanMapper masterPlanMapper;
    @Autowired
    private IMasterPlanChangeService masterPlanChangeService;
    @Autowired
    private MasterPlanDetailMapper masterPlanDetailMapper;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private SessionManager sessionManager;

//    private static final String BILL_CODE = "MASTER_PLAN";
    private static final String BILL_CODE_C = "MASTER_PLAN";//消耗材
    private static final String BILL_CODE_H = "HNTZJH";//混凝土


    @Override
    public MasterPlanVO queryByCode(String planCode,Integer planType) {
        MasterPlanVO resp = null;
        QueryWrapper<MasterPlanEntity> query = new QueryWrapper<>();
        query.eq("plan_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("plan_type", planType);
        MasterPlanEntity entity = masterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MasterPlanVO queryByProjectId(Long projectId,Integer planType) {
        MasterPlanVO resp = null;
        QueryWrapper<MasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("plan_type", planType);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MasterPlanEntity entity = masterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public CommonResponse<MasterPlanVO> saveOrUpdateMasterPlan(MasterPlanVO masterPlanVo, Boolean isControl) {
        if (!isControl){
            if(StringUtils.isNotBlank(masterPlanVo.getPlanCode())) {
                //编码重复校验
                MasterPlanVO voByCode = queryByCode(masterPlanVo.getPlanCode(),masterPlanVo.getPlanType());
                if(null != voByCode && (null == masterPlanVo.getId() || !voByCode.getId().equals(masterPlanVo.getId()))) {
                    return CommonResponse.error("保存失败，编码重复！");
                }
            } else {
                String BILL_CODE = "";
                switch (masterPlanVo.getPlanType()){
                    case 0:BILL_CODE = BILL_CODE_C;break;
                    case 1:BILL_CODE = BILL_CODE_H;break;
                }
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),masterPlanVo);
                CommonResponse<String> codeResp = billCodeApi.generateBillCode(billCodeParam);
                if(!codeResp.isSuccess()) {
                    return CommonResponse.error("保存失败，获取自动编码失败！");
                }
                masterPlanVo.setPlanCode(codeResp.getData());
            }
        }

        //校验项目是否已有总计划
        MasterPlanVO voByProject = queryByProjectId(masterPlanVo.getProjectId(),masterPlanVo.getPlanType());
        if(null != voByProject && (null == masterPlanVo.getId() || !voByProject.getId().equals(masterPlanVo.getId()))) {
            String msg = "";
            switch (masterPlanVo.getPlanType()){
                case 0:msg = "保存失败，该项目下已存在消耗材总计划，请勿重复添加！";break;
                case 1:msg = "保存失败，该项目下已存在混凝土总计划，请勿重复添加！";break;
            }
            throw new BusinessException(msg);
        }
        UserContext userContext = sessionManager.getUserContext();
        MasterPlanEntity saveEntity = null;
        if(null == masterPlanVo.getId()) {
            saveEntity = BeanMapper.map(masterPlanVo, MasterPlanEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = BeanMapper.map(masterPlanVo, MasterPlanEntity.class);
//            saveEntity = getById(masterPlanVo.getId());
//            saveEntity.setPlanDate(masterPlanVo.getPlanDate());
//            saveEntity.setProjectId(masterPlanVo.getProjectId());
//            saveEntity.setProjectName(masterPlanVo.getProjectName());
//            saveEntity.setRemark(masterPlanVo.getRemark());
//            saveEntity.setPlanCode(masterPlanVo.getPlanCode());
//            saveEntity.setTotalPlanAmt(masterPlanVo.getTotalPlanAmt());
//            saveEntity.setModifyUserName(userContext.getUserName());
//
//            saveEntity.setMasterPlanDetailList(BeanMapper.mapList(masterPlanVo.getMasterPlanDetailList(), MasterPlanDetailEntity.class));
        }

        if(null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        if(!isControl){
            super.saveOrUpdate(saveEntity, false);
            List<MasterPlanDetailEntity> changeDetailEntities = saveEntity.getMasterPlanDetailList();
            if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
                Map<String, Long> idMap = new HashMap<>();
                for (MasterPlanDetailEntity cdEntity : changeDetailEntities) {
                    //变更类型
                    cdEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
                    idMap.put(cdEntity.getTid(), cdEntity.getId());
                }
                for (MasterPlanDetailEntity cdEntity : changeDetailEntities) {
                    if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
                List<Map> resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
                List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);

                List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
                List<MasterPlanDetailEntity> saveEntities = new ArrayList<>();
                treeToList(ListCodeDate, saveEntities);
                if (!isControl){
                    masterPlanDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
                }
            }
        }
        MasterPlanVO masterPlanVO = BeanMapper.map(saveEntity, MasterPlanVO.class);
//        if(!isControl){
//            //更新子表信息
//            if(null != saveEntity.getId()) {
//                masterPlanDetailMapper.delByPlanId(saveEntity.getId());
//            }
//            super.saveOrUpdate(saveEntity, false);
//        }else{
//            List<MasterPlanDetailEntity> detailEntityList = saveEntity.getMasterPlanDetailList();
//            List<MasterPlanDetailEntity> detailEntityListNew = new ArrayList<>();
//            if(CollectionUtils.isNotEmpty(detailEntityList)){
//                for(MasterPlanDetailEntity cdEntity : detailEntityList){
//                    if(null == cdEntity.getId()){
//                        cdEntity.setId(IdWorker.getId());
//                    }
//                    if (!"del".equals(cdEntity.getRowState())) {
//                        detailEntityListNew.add(cdEntity);
//                    }
//                }
//                saveEntity.setMasterPlanDetailList(detailEntityListNew);
//            }
//        }
//        List<MasterPlanDetailEntity> entities = new ArrayList<>();
//        List<MasterPlanDetailEntity> detailEntityList = saveEntity.getMasterPlanDetailList();
//        if(CollectionUtils.isNotEmpty(detailEntityList)){
//            Map<String,Long> idMap=new HashMap<>();
//            for(MasterPlanDetailEntity cdEntity : detailEntityList){
//                idMap.put(cdEntity.getTid(),cdEntity.getId());
//            }
//            for(MasterPlanDetailEntity cdEntity : detailEntityList){
//                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
//                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
//                }
//                //变更类型
//                cdEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
//            }
//            // 生成结构码
//            List<Map> resultMapList = BeanMapper.mapList(detailEntityList, Map.class);
//            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
//            List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
//            treeToList(ListCodeDate, entities);
//        }
//        if(!isControl){
//            if(CollectionUtils.isNotEmpty(entities)){
//                masterPlanDetailService.saveOrUpdateBatch(entities, entities.size(), false);
//            }
//            masterPlanVO = queryDetail(saveEntity.getId(), true);
//        }else{
//            masterPlanVO = BeanMapper.map(saveEntity, MasterPlanVO.class);
//            if(CollectionUtils.isNotEmpty(entities)){
//                masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(entities, MasterPlanDetailVO.class));
//            }
//        }

        if(!isControl) {
            String linkUrl;
            String billType;
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = baseHost;
            }

            if (masterPlanVO.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + masterPlanVO.getId();
                billType = BillTypeEnum.消耗材总计划.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + masterPlanVO.getId();
                billType = BillTypeEnum.混凝土总计划.getCode();
            }
            //目标成本推送
            ExecutionVO executionVO = targetCost(masterPlanVO, linkUrl, billType, masterPlanVO.getPlanType());
            logger.info("目标成本推送数据" + JSONObject.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
//            return CommonResponse.error("目标成本推送失败,"+response.getMsg());
            }
            return CommonResponse.success("保存成功！", queryDetail(saveEntity.getId(),true));
        }
        return CommonResponse.success("保存成功！", masterPlanVO);
    }

    @Override
    public MasterPlanVO queryDetail(Long id, boolean detailHasChildren) {
        MasterPlanEntity masterPlanEntity = super.selectById(id);
        MasterPlanVO masterPlanVO =  BeanMapper.map(masterPlanEntity, MasterPlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MasterPlanDetailEntity> detailEntityListDb = masterPlanDetailService.queryList(queryParam, false);
        List<MasterPlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(MasterPlanDetailEntity cdEntity : detailEntityList){
                if(cdEntity.getMaterialId()==null){//如果是分类  tid = 分类id pid = null
                    cdEntity.setTid(cdEntity.getMaterialCategoryId().toString());
                    cdEntity.setTpid("999");
                }else {//如果是物资  tid = 物资id pid = 分类id
                    cdEntity.setTid(cdEntity.getMaterialId().toString());
                    cdEntity.setTpid(cdEntity.getMaterialCategoryId().toString());
                }
                cdEntity.setRowState("edit");
            }
            List<MasterPlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class);
            if(detailHasChildren){
                masterPlanVO.setMasterPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                masterPlanVO.setMasterPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailVO.class));
        }

        if(null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0){
            //masterPlanVO.setRecordList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
            masterPlanVO.setMasterPlanChangeHisList(masterPlanChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }
        return masterPlanVO;
    }

    @Override
    public List<MasterPlanContrastV0> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId) {
        return  masterPlanMapper.getContrastInfo(materialMasterPlanId,oldMaterialMasterPlanId);
    }

    @Override
    public ExecutionVO targetCost(MasterPlanVO masterPlanVO, String linkUrl, String billType, Integer planType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(masterPlanVO.getId());
        totalVO.setTenantId(masterPlanVO.getTenantId());
        totalVO.setBillCode(masterPlanVO.getPlanCode());
//        if (planType==0){
//            totalVO.setBussinessType(BussinessTypeEnum.材料总计划.getCode());
//        }else {
//            totalVO.setBussinessType(BussinessTypeEnum.混凝土总计划.getCode());
//        }
        totalVO.setBillType(billType);
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(masterPlanVO.getProjectId());
        totalVO.setOrgId(masterPlanVO.getOrgId());
        totalVO.setMoney(masterPlanVO.getTotalPlanAmt());
        totalVO.setTaxMoney(masterPlanVO.getTotalPlanAmt());
        totalVO.setLinkUrl(linkUrl);
        totalVO.setBillDate(masterPlanVO.getBillDate()==null?null:masterPlanVO.getBillDate().toString());
        List<MasterPlanDetailVO> masterPlanDetailList = masterPlanVO.getMasterPlanDetailList();;
        if (!(billType.equals(BillTypeEnum.消耗材总计划.getCode()) || billType.equals(BillTypeEnum.混凝土总计划.getCode()))){
            totalVO.setLastSourceId(masterPlanVO.getSourcePlanId());
        }
        List<MasterPlanDetailVO> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(masterPlanDetailList)) {
            masterPlanDetailList.forEach(entity -> {
                if (null == entity.getChangeType() || 2 != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        for (MasterPlanDetailVO planDetailVO : detailEntityList) {
            if (planDetailVO.getRowState() != null && planDetailVO.getRowState().equals("del")){
                continue;
            }
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
            detailExecutionVO.setSourceBillId(masterPlanVO.getId());
            detailExecutionVO.setCategoryId(planDetailVO.getMaterialCategoryId());
            detailExecutionVO.setCategoryName(planDetailVO.getMaterialCategoryName());
            //判断是否是分类
            if (planDetailVO.getMaterialId()==null){
                detailExecutionVO.setCategoryFlag(true);
                detailExecutionVO.setDocId(planDetailVO.getMaterialCategoryId());
            }else {
                detailExecutionVO.setCategoryFlag(false);
                detailExecutionVO.setDocId(planDetailVO.getMaterialId());
            }
            detailExecutionVO.setCode(planDetailVO.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(false);
            //根据分类ID查询物料分类信息
            MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialCategoryId()).getData();
            if (categoryVO==null){
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            }else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
            detailExecutionVO.setName(planDetailVO.getMaterialName());
            detailExecutionVO.setUnitId(planDetailVO.getUnitId());
            detailExecutionVO.setUnitName(planDetailVO.getUnit());
            detailExecutionVO.setNum(planDetailVO.getNum());
            detailExecutionVO.setMoney(planDetailVO.getAmount());
            detailExecutionVO.setSpec(planDetailVO.getSpec());
            detailExecutionVO.setTaxMoney(planDetailVO.getAmount());
            detailExecutionVO.setPrice(planDetailVO.getPrice());
            detailExecutionVO.setTaxPrice(planDetailVO.getPrice());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            // 生成内码
            /*if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }*/

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<MasterPlanDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, MasterPlanDetailEntity.class));
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(MasterPlanVO masterPlanVO) {
        CommonResponse<MasterPlanVO> masterPlanVOCommonResponse = saveOrUpdateMasterPlan(masterPlanVO, true);
        MasterPlanVO planVO = masterPlanVOCommonResponse.getData();
        String linkUrl;
        String billType;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        if (masterPlanVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.消耗材总计划.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.混凝土总计划.getCode();
        }
        //目标成本推送
        ExecutionVO executionVO = targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        logger.info("目标成本控制推送数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        MasterPlanVO planVO = queryDetail(id, true);
        String linkUrl;
        String billType;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        if (planVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.消耗材总计划.getCode();
        } else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
            billType = BillTypeEnum.混凝土总计划.getCode();
        }
        //目标成本推送
        ExecutionVO executionVO = targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        logger.info("目标成本控制推送数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if(CollectionUtils.isEmpty(data.getDataSource())){
            data.setWarnType("none");
        }
        return data;
    }
//同步成本
    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        MasterPlanVO planVO = queryDetail(id, true);
        String linkUrl;
        String billType;
        ExecutionVO executionVO;
        Boolean flag = true;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        QueryWrapper<MasterPlanChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_plan_id", id).eq("dr", 0).orderByDesc("change_version");
        List<MasterPlanChangeEntity> list = masterPlanChangeService.list(wrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size()>0 ) {//是否有变更
            flag =false;
            MasterPlanChangeEntity masterPlanChangeEntity = list.get(0);
            if (masterPlanChangeEntity.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + masterPlanChangeEntity.getId();
                billType = BillTypeEnum.消耗材总计划变更.getCode();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + masterPlanChangeEntity.getId();
                billType = BillTypeEnum.混凝土总计划变更.getCode();
            }
            executionVO = targetCost(BeanMapper.map(masterPlanChangeEntity, MasterPlanVO.class), linkUrl, billType, masterPlanChangeEntity.getPlanType());
        }else {
            flag =true;
            if (planVO.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + planVO.getId();
                billType = BillTypeEnum.消耗材总计划.getCode();
            } else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + planVO.getId();
                billType = BillTypeEnum.混凝土总计划.getCode();
            }
            //目标成本推送
            executionVO = targetCost(planVO, linkUrl, billType, planVO.getPlanType());
        }
        logger.info("目标成本推送数据类型" + (flag ? "原计划" : "变更计划"));
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }
}
