package com.ejianc.business.promaterial.sync.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.sync.bean.SyncRecordsEntity;
import com.ejianc.business.promaterial.sync.handler.HTSyncHandler;
import com.ejianc.business.promaterial.sync.vo.PlanDto;
import com.ejianc.business.promaterial.sync.service.ISyncRecordService;
import com.ejianc.business.promaterial.sync.vo.SyncRecordsVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import com.google.common.base.Stopwatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * 接受并保存推送ERP数据记录
 *
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class DataSyncListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SYNC_RECORD_QUEUE = "sync_record_queue";

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private HTSyncHandler handler;

    @Autowired
    private ISyncRecordService service;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待同步数据记录：{}", JSON.toJSONString(mqMessage.getBody()));
        try {
            Stopwatch start = Stopwatch.createStarted();
            SyncRecordsEntity record = JSONObject.parseObject(JSON.toJSONString(mqMessage.getBody()), SyncRecordsEntity.class);
            boolean flag = false;
            String result = null;
            if(SyncRecordsVO.SYNC_TYPE_PLAN.equals(record.getHandleType())) {
                PlanDto vo = JSONObject.parseObject(record.getData(), PlanDto.class);
                result = handler.syncPlan(vo);
                flag = !"失败".equals(result);
                record.setPushResult("采购计划【"+ vo.getOutPlanNo()+"】推送" + (flag ? "成功" : "失败") + "！");
            }
            Stopwatch stop = start.stop();
            record.setSyncHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            record.setSucFlag(String.valueOf(flag));
            record.setSyncResult(result);
            service.saveOrUpdate(record, false);
        } catch (Exception e) {
            logger.error("数据同步异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{SYNC_RECORD_QUEUE+"_"+profile};
    }
}
