package com.ejianc.business.promaterial.sync.controller;

import com.ejianc.business.promaterial.sync.consumer.ZhHtCommonListener;
import com.ejianc.business.promaterial.sync.handler.HTSyncHandler;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: caojie
 * @CreateTime:2025-03-14 18:04
 * @Version: 1.0
 */
@RestController
@RequestMapping("planSync")
public class PlanSyncController {

    @Autowired
    private HTSyncHandler handler;

    @Autowired
    private ZhHtCommonListener listener;

    @RequestMapping(value = "/getPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getPlan(String outPlanNo) {
        return CommonResponse.success(handler.getPlan(outPlanNo));
    }

    @RequestMapping(value = "/contractCallback", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> contractCallback(@RequestBody String message) {
        listener.receive_cnecht_zh_contractCallback(message);
        return CommonResponse.success("执行成功！");
    }

    @RequestMapping(value = "/orderCallback", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> orderCallback(@RequestBody String message) {
        listener.receive_cnecht_zh_orderCallback(message);
        return CommonResponse.success("执行成功！");
    }

}
