package com.ejianc.business.promaterial.check.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckAdmixtureEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 混凝土-验收主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_concrete_check")
public class ConcreteCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="delivery_id")
    private Long deliveryId; // 发货主键
    @TableField(value="check_state")
    private Integer checkState; // 验收状态（0-未验收，1--已验收）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同code
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商主键
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="checker_name")
    private String checkerName; // 验收人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="check_date")
    private Date checkDate; // 验收日期
    @TableField(value="license_plate")
    private String licensePlate; // 车牌号
    @TableField(value="record_flag")
    private Integer recordFlag; // 是否补录，0-否，1-是
    @TableField(value="record_reson")
    private String recordReson; // 补录原因
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="check_type")
    private String checkType;
    @TableField(value="check_type_name")
    private String checkTypeName;
    @TableField(value="store_type")
    private Integer storeType; // 入库方式，0-收料入库，1-直入直出
    @TableField(value="source_type")
    private Integer sourceType; // 验收来源，0-自制验收,1-发货验收
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="store_id")
    private Long storeId; // 仓库主键
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="instore_date")
    private Date instoreDate; // 入库日期
    @TableField(value="sub_contract_id")
    private Long subContractId; // 分包合同主键
    @TableField(value="sub_contract_name")
    private String subContractName; // 分包合同名称
    @TableField(value="sub_contract_code")
    private String subContractCode; // 分包合同code
    @TableField(value="sub_supplier_id")
    private Long subSupplierId; // 分包合同供应商主键
    @TableField(value="sub_supplier_name")
    private String subSupplierName; // 分包合同供应商名称
    @TableField(value="sub_employee_name")
    private String subEmployeeName; // 分包负责人名称
    @TableField(value="sub_employee_phone")
    private String subEmployeePhone; // 联系电话
    @TableField(value="construction")
    private String construction; // 使用部位
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="ticket_num")
    private BigDecimal ticketNum; // 小票数量
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;

    /**
     * 子表验收金额汇总
     */
    @TableField(value = "check_all_tax_mny")
    private BigDecimal checkAllTaxMny;
    /**
     * 子表验收金额汇总
     */
    @TableField(value = "check_all_mny")
    private BigDecimal checkAllMny;
    /**
     * 计价方式：1-固定单价、2-浮动单价、3-固定总价
     */
    @TableField(value = "pricing_type")
    private BigDecimal pricingType;
    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;

    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String sourceSystemId;
    /***  协同需要字段 START  ***/
    @TableField(value = "sign_status")
    private Integer signStatus; // 签字状态：0-未签字,1-已签字

    /***  协同需要字段 END  ***/
    @TableField(value = "delivery_code")
    private String deliveryCode; // 发货单编号
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value = "attr_flag")
    private Integer attrFlag; // 仓库属性 1-自购材；2-甲供材
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="org_code")
    private String orgCode;
    @TableField(value="sub_out_type")
    private Integer subOutType;//领料方式,1-内部领料,2-分包领料
    @TableField(value="sub_use")
    private String subUse;//用途
    @TableField(value="automatic_weigh")
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    @TableField(value="delivery_type")
    private Integer deliveryType; // 发货单类型 1-自制，2-供方推送（订单）
    @TableField(value="check_weigh_type")
    private Integer checkWeighType; // 是否磅单验收  0-否  1-是


    @SubEntity(serviceName="concreteCheckDetailService",pidName = "checkId")//此处有pid="xxx"，默认值pid="pid"
    @TableField(exist=false)
    private List<ConcreteCheckDetailEntity> concreteCheckDetailList = new ArrayList<>(); // 混凝土-验收明细子表

    @SubEntity(serviceName="concreteCheckAdmixtureService",pidName = "checkId")//此处有pid="xxx"，默认值pid="pid"
    @TableField(exist=false)
    private List<ConcreteCheckAdmixtureEntity> concreteCheckAdmixtureList = new ArrayList<>(); // 混凝土-验收外加剂子表

    @TableField(exist=false)
    @SubEntity(serviceName="concreteCheckWeighService",pidName = "checkId")//此处有pid="xxx"，默认值pid="pid"
    private List<ConcreteCheckWeighEntity> concreteCheckWeighList = new ArrayList<>(); // 混凝土-磅单子表
    @TableField(exist=false)
    @SubEntity(serviceName="concreteCheckImgService",pidName = "pid")
    private List<ConcreteCheckImgEntity> checkImgList = new ArrayList<>(); // 验收单相册表


    public List<ConcreteCheckImgEntity> getCheckImgList() {
        return checkImgList;
    }

    public void setCheckImgList(List<ConcreteCheckImgEntity> checkImgList) {
        this.checkImgList = checkImgList;
    }

    public Integer getCheckWeighType() {
        return checkWeighType;
    }

    public void setCheckWeighType(Integer checkWeighType) {
        this.checkWeighType = checkWeighType;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public List<ConcreteCheckWeighEntity> getConcreteCheckWeighList() {
        return concreteCheckWeighList;
    }

    public void setConcreteCheckWeighList(List<ConcreteCheckWeighEntity> concreteCheckWeighList) {
        this.concreteCheckWeighList = concreteCheckWeighList;
    }

    public Integer getSubOutType() {
        return subOutType;
    }

    public void setSubOutType(Integer subOutType) {
        this.subOutType = subOutType;
    }

    public String getSubUse() {
        return subUse;
    }

    public void setSubUse(String subUse) {
        this.subUse = subUse;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public BigDecimal getCheckAllTaxMny() {
        return checkAllTaxMny;
    }

    public void setCheckAllTaxMny(BigDecimal checkAllTaxMny) {
        this.checkAllTaxMny = checkAllTaxMny;
    }

    public BigDecimal getCheckAllMny() {
        return checkAllMny;
    }

    public void setCheckAllMny(BigDecimal checkAllMny) {
        this.checkAllMny = checkAllMny;
    }

    public BigDecimal getPricingType() {
        return pricingType;
    }

    public void setPricingType(BigDecimal pricingType) {
        this.pricingType = pricingType;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public Integer getCheckState() {
        return checkState;
    }

    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public Integer getRecordFlag() {
        return recordFlag;
    }

    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    public String getRecordReson() {
        return recordReson;
    }

    public void setRecordReson(String recordReson) {
        this.recordReson = recordReson;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getInstoreDate() {
        return instoreDate;
    }

    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }
    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    public String getSubContractCode() {
        return subContractCode;
    }

    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }
    public String getSubSupplierName() {
        return subSupplierName;
    }

    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }
    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }
    public String getSubEmployeePhone() {
        return subEmployeePhone;
    }

    public void setSubEmployeePhone(String subEmployeePhone) {
        this.subEmployeePhone = subEmployeePhone;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public BigDecimal getTicketNum() {
        return ticketNum;
    }

    public void setTicketNum(BigDecimal ticketNum) {
        this.ticketNum = ticketNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getSubContractId() {
        return subContractId;
    }

    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }

    public List<ConcreteCheckDetailEntity> getConcreteCheckDetailList() {
        return concreteCheckDetailList;
    }

    public void setConcreteCheckDetailList(List<ConcreteCheckDetailEntity> concreteCheckDetailList) {
        this.concreteCheckDetailList = concreteCheckDetailList;
    }
    public List<ConcreteCheckAdmixtureEntity> getConcreteCheckAdmixtureList() {
        return concreteCheckAdmixtureList;
    }

    public void setConcreteCheckAdmixtureList(List<ConcreteCheckAdmixtureEntity> concreteCheckAdmixtureList) {
        this.concreteCheckAdmixtureList = concreteCheckAdmixtureList;
    }
}
